/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.core.common.models;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.lighty.core.common.models.YangModuleUtils;
import java.util.Collection;
import java.util.Set;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangModulesTool {
    private static final Logger LOG = LoggerFactory.getLogger(YangModulesTool.class);
    private static final int PREFIX = 2;
    private static final String TOP_LEVEL_MODELS_LIST = "# top-level models list: {}";
    private static final String TOP_LEVEL_MODELS_TREE = "# top-level models tree: {}";
    private static final String UNIQUE_MODELS_LIST = "# unique models list   : {}";

    private YangModulesTool() {
    }

    public static void main(String[] args) {
        Set<YangModuleInfo> allModelsFromClasspath = YangModuleUtils.getAllModelsFromClasspath();
        YangModulesTool.printModelInfo(allModelsFromClasspath);
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="Utility")
    public static void printModelInfo(Set<YangModuleInfo> allModelsFromClasspath) {
        boolean prefixLength = false;
        Set<YangModuleInfo> topLevelModels = YangModuleUtils.filterTopLevelModels(allModelsFromClasspath);
        LOG.info(TOP_LEVEL_MODELS_TREE, (Object)topLevelModels.size());
        for (YangModuleInfo yangModuleInfo : topLevelModels) {
            YangModulesTool.logQNameInfo(yangModuleInfo.getName());
            YangModulesTool.printDependencies(yangModuleInfo.getImportedModules(), 2);
        }
        LOG.info(TOP_LEVEL_MODELS_LIST, (Object)topLevelModels.size());
        for (YangModuleInfo yangModuleInfo : topLevelModels) {
            YangModulesTool.logQNameInfo(yangModuleInfo.getName());
        }
        Set<YangModuleInfo> uniqueModels = YangModuleUtils.filterUniqueModels(allModelsFromClasspath);
        LOG.info(UNIQUE_MODELS_LIST, (Object)uniqueModels.size());
        for (YangModuleInfo yangModuleInfo : uniqueModels) {
            YangModulesTool.logQNameInfo(yangModuleInfo.getName());
        }
    }

    private static void logQNameInfo(QName qname) {
        LOG.info("namespace: {}, localName: {}, revision {}", new Object[]{qname.getNamespace(), qname.getLocalName(), qname.getRevision()});
    }

    public static void printConfiguration(Set<YangModuleInfo> allModelsFromClasspath) {
        Set<YangModuleInfo> topLevelModels = YangModuleUtils.filterTopLevelModels(allModelsFromClasspath);
        LOG.info(TOP_LEVEL_MODELS_LIST, (Object)topLevelModels.size());
        for (YangModuleInfo yangModuleInfo : topLevelModels) {
            QName qname = yangModuleInfo.getName();
            System.out.println("{ \"nameSpace\": \"" + String.valueOf(qname.getNamespace()) + "\", \"name\": \"" + qname.getLocalName() + "\", \"revision\": \"" + String.valueOf(qname.getRevision().orElse(null)) + "\" },");
        }
        LOG.info(TOP_LEVEL_MODELS_LIST, (Object)topLevelModels.size());
        for (YangModuleInfo yangModuleInfo : topLevelModels) {
            System.out.println(yangModuleInfo.getClass().getCanonicalName() + ".getInstance(),");
        }
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="Utility")
    private static void printDependencies(Collection<YangModuleInfo> yangModuleInfos, int prefixLength) {
        for (YangModuleInfo yangModuleInfo : yangModuleInfos) {
            QName qname = yangModuleInfo.getName();
            LOG.info("{}{} {} {}", new Object[]{Strings.repeat((String)" ", (int)prefixLength), qname.getNamespace(), qname.getLocalName(), qname.getRevision()});
            YangModulesTool.printDependencies(yangModuleInfo.getImportedModules(), prefixLength + 2);
        }
    }
}

