/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.MediaPlaylist;
import io.lindstrom.m3u8.model.MediaSegment;
import io.lindstrom.m3u8.model.Playlist;
import io.lindstrom.m3u8.model.PlaylistType;
import io.lindstrom.m3u8.model.PlaylistVariable;
import io.lindstrom.m3u8.model.ServerControl;
import io.lindstrom.m3u8.model.StartTimeOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class MediaPlaylistBuilder {
    private static final long INIT_BIT_TARGET_DURATION = 1L;
    private static final long OPT_BIT_MEDIA_SEQUENCE = 1L;
    private static final long OPT_BIT_DISCONTINUITY_SEQUENCE = 2L;
    private static final long OPT_BIT_ONGOING = 4L;
    private static final long OPT_BIT_I_FRAMES_ONLY = 8L;
    private static final long OPT_BIT_INDEPENDENT_SEGMENTS = 16L;
    private long initBits = 1L;
    private long optBits;
    private int targetDuration;
    private long mediaSequence;
    private long discontinuitySequence;
    private boolean ongoing;
    private Boolean allowCache;
    private PlaylistType playlistType;
    private boolean iFramesOnly;
    private List<MediaSegment> mediaSegments = new ArrayList<MediaSegment>();
    private ServerControl serverControl;
    private Integer version;
    private boolean independentSegments;
    private StartTimeOffset startTimeOffset;
    private List<PlaylistVariable> variables = new ArrayList<PlaylistVariable>();
    private List<String> comments = new ArrayList<String>();

    MediaPlaylistBuilder() {
        if (!(this instanceof MediaPlaylist.Builder)) {
            throw new UnsupportedOperationException("Use: new MediaPlaylist.Builder()");
        }
    }

    public final MediaPlaylist.Builder from(Playlist instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder from(MediaPlaylist instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return (MediaPlaylist.Builder)this;
    }

    private void from(Object object) {
        Playlist instance;
        if (object instanceof Playlist) {
            Optional<Integer> versionOptional;
            instance = (Playlist)object;
            this.addAllVariables(instance.variables());
            this.addAllComments(instance.comments());
            this.independentSegments(instance.independentSegments());
            Optional<StartTimeOffset> startTimeOffsetOptional = instance.startTimeOffset();
            if (startTimeOffsetOptional.isPresent()) {
                this.startTimeOffset(startTimeOffsetOptional);
            }
            if ((versionOptional = instance.version()).isPresent()) {
                this.version(versionOptional);
            }
        }
        if (object instanceof MediaPlaylist) {
            Optional<Boolean> allowCacheOptional;
            instance = (MediaPlaylist)object;
            Optional<ServerControl> serverControlOptional = instance.serverControl();
            if (serverControlOptional.isPresent()) {
                this.serverControl(serverControlOptional);
            }
            this.ongoing(instance.ongoing());
            this.iFramesOnly(instance.iFramesOnly());
            this.addAllMediaSegments(instance.mediaSegments());
            Optional<PlaylistType> playlistTypeOptional = instance.playlistType();
            if (playlistTypeOptional.isPresent()) {
                this.playlistType(playlistTypeOptional);
            }
            if ((allowCacheOptional = instance.allowCache()).isPresent()) {
                this.allowCache(allowCacheOptional);
            }
            this.targetDuration(instance.targetDuration());
            this.mediaSequence(instance.mediaSequence());
            this.discontinuitySequence(instance.discontinuitySequence());
        }
    }

    public final MediaPlaylist.Builder targetDuration(int targetDuration) {
        this.targetDuration = targetDuration;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder mediaSequence(long mediaSequence) {
        this.mediaSequence = mediaSequence;
        this.optBits |= 1L;
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder discontinuitySequence(long discontinuitySequence) {
        this.discontinuitySequence = discontinuitySequence;
        this.optBits |= 2L;
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder ongoing(boolean ongoing) {
        this.ongoing = ongoing;
        this.optBits |= 4L;
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder allowCache(boolean allowCache) {
        this.allowCache = allowCache;
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder allowCache(Optional<Boolean> allowCache) {
        this.allowCache = allowCache.orElse(null);
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder playlistType(PlaylistType playlistType) {
        this.playlistType = Objects.requireNonNull(playlistType, "playlistType");
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder playlistType(Optional<? extends PlaylistType> playlistType) {
        this.playlistType = playlistType.orElse(null);
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder iFramesOnly(boolean iFramesOnly) {
        this.iFramesOnly = iFramesOnly;
        this.optBits |= 8L;
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder addMediaSegments(MediaSegment element) {
        this.mediaSegments.add(Objects.requireNonNull(element, "mediaSegments element"));
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder addMediaSegments(MediaSegment ... elements) {
        for (MediaSegment element : elements) {
            this.mediaSegments.add(Objects.requireNonNull(element, "mediaSegments element"));
        }
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder mediaSegments(Iterable<? extends MediaSegment> elements) {
        this.mediaSegments.clear();
        return this.addAllMediaSegments(elements);
    }

    public final MediaPlaylist.Builder addAllMediaSegments(Iterable<? extends MediaSegment> elements) {
        for (MediaSegment mediaSegment : elements) {
            this.mediaSegments.add(Objects.requireNonNull(mediaSegment, "mediaSegments element"));
        }
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder serverControl(ServerControl serverControl) {
        this.serverControl = Objects.requireNonNull(serverControl, "serverControl");
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder serverControl(Optional<? extends ServerControl> serverControl) {
        this.serverControl = serverControl.orElse(null);
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder version(int version) {
        this.version = version;
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder version(Optional<Integer> version) {
        this.version = version.orElse(null);
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder independentSegments(boolean independentSegments) {
        this.independentSegments = independentSegments;
        this.optBits |= 0x10L;
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder startTimeOffset(StartTimeOffset startTimeOffset) {
        this.startTimeOffset = Objects.requireNonNull(startTimeOffset, "startTimeOffset");
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder startTimeOffset(Optional<? extends StartTimeOffset> startTimeOffset) {
        this.startTimeOffset = startTimeOffset.orElse(null);
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder addVariables(PlaylistVariable element) {
        this.variables.add(Objects.requireNonNull(element, "variables element"));
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder addVariables(PlaylistVariable ... elements) {
        for (PlaylistVariable element : elements) {
            this.variables.add(Objects.requireNonNull(element, "variables element"));
        }
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder variables(Iterable<? extends PlaylistVariable> elements) {
        this.variables.clear();
        return this.addAllVariables(elements);
    }

    public final MediaPlaylist.Builder addAllVariables(Iterable<? extends PlaylistVariable> elements) {
        for (PlaylistVariable playlistVariable : elements) {
            this.variables.add(Objects.requireNonNull(playlistVariable, "variables element"));
        }
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder addComments(String element) {
        this.comments.add(Objects.requireNonNull(element, "comments element"));
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder addComments(String ... elements) {
        for (String element : elements) {
            this.comments.add(Objects.requireNonNull(element, "comments element"));
        }
        return (MediaPlaylist.Builder)this;
    }

    public final MediaPlaylist.Builder comments(Iterable<String> elements) {
        this.comments.clear();
        return this.addAllComments(elements);
    }

    public final MediaPlaylist.Builder addAllComments(Iterable<String> elements) {
        for (String element : elements) {
            this.comments.add(Objects.requireNonNull(element, "comments element"));
        }
        return (MediaPlaylist.Builder)this;
    }

    public MediaPlaylist build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableMediaPlaylist(this);
    }

    private boolean mediaSequenceIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private boolean discontinuitySequenceIsSet() {
        return (this.optBits & 2L) != 0L;
    }

    private boolean ongoingIsSet() {
        return (this.optBits & 4L) != 0L;
    }

    private boolean iFramesOnlyIsSet() {
        return (this.optBits & 8L) != 0L;
    }

    private boolean independentSegmentsIsSet() {
        return (this.optBits & 0x10L) != 0L;
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("targetDuration");
        }
        return "Cannot build MediaPlaylist, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static final class ImmutableMediaPlaylist
    implements MediaPlaylist {
        private final int targetDuration;
        private final long mediaSequence;
        private final long discontinuitySequence;
        private final boolean ongoing;
        private final Boolean allowCache;
        private final PlaylistType playlistType;
        private final boolean iFramesOnly;
        private final List<MediaSegment> mediaSegments;
        private final ServerControl serverControl;
        private final Integer version;
        private final boolean independentSegments;
        private final StartTimeOffset startTimeOffset;
        private final List<PlaylistVariable> variables;
        private final List<String> comments;
        private static final int STAGE_INITIALIZING = -1;
        private static final int STAGE_UNINITIALIZED = 0;
        private static final int STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private ImmutableMediaPlaylist(MediaPlaylistBuilder builder) {
            this.targetDuration = builder.targetDuration;
            this.allowCache = builder.allowCache;
            this.playlistType = builder.playlistType;
            this.mediaSegments = MediaPlaylistBuilder.createUnmodifiableList(true, builder.mediaSegments);
            this.serverControl = builder.serverControl;
            this.version = builder.version;
            this.startTimeOffset = builder.startTimeOffset;
            this.variables = MediaPlaylistBuilder.createUnmodifiableList(true, builder.variables);
            this.comments = MediaPlaylistBuilder.createUnmodifiableList(true, builder.comments);
            if (builder.mediaSequenceIsSet()) {
                this.initShim.mediaSequence(builder.mediaSequence);
            }
            if (builder.discontinuitySequenceIsSet()) {
                this.initShim.discontinuitySequence(builder.discontinuitySequence);
            }
            if (builder.ongoingIsSet()) {
                this.initShim.ongoing(builder.ongoing);
            }
            if (builder.iFramesOnlyIsSet()) {
                this.initShim.iFramesOnly(builder.iFramesOnly);
            }
            if (builder.independentSegmentsIsSet()) {
                this.initShim.independentSegments(builder.independentSegments);
            }
            this.mediaSequence = this.initShim.mediaSequence();
            this.discontinuitySequence = this.initShim.discontinuitySequence();
            this.ongoing = this.initShim.ongoing();
            this.iFramesOnly = this.initShim.iFramesOnly();
            this.independentSegments = this.initShim.independentSegments();
            this.initShim = null;
        }

        private long mediaSequenceInitialize() {
            return MediaPlaylist.super.mediaSequence();
        }

        private long discontinuitySequenceInitialize() {
            return MediaPlaylist.super.discontinuitySequence();
        }

        private boolean ongoingInitialize() {
            return MediaPlaylist.super.ongoing();
        }

        private boolean iFramesOnlyInitialize() {
            return MediaPlaylist.super.iFramesOnly();
        }

        private boolean independentSegmentsInitialize() {
            return MediaPlaylist.super.independentSegments();
        }

        @Override
        public int targetDuration() {
            return this.targetDuration;
        }

        @Override
        public long mediaSequence() {
            InitShim shim = this.initShim;
            return shim != null ? shim.mediaSequence() : this.mediaSequence;
        }

        @Override
        public long discontinuitySequence() {
            InitShim shim = this.initShim;
            return shim != null ? shim.discontinuitySequence() : this.discontinuitySequence;
        }

        @Override
        public boolean ongoing() {
            InitShim shim = this.initShim;
            return shim != null ? shim.ongoing() : this.ongoing;
        }

        @Override
        public Optional<Boolean> allowCache() {
            return Optional.ofNullable(this.allowCache);
        }

        @Override
        public Optional<PlaylistType> playlistType() {
            return Optional.ofNullable(this.playlistType);
        }

        @Override
        public boolean iFramesOnly() {
            InitShim shim = this.initShim;
            return shim != null ? shim.iFramesOnly() : this.iFramesOnly;
        }

        @Override
        public List<MediaSegment> mediaSegments() {
            return this.mediaSegments;
        }

        @Override
        public Optional<ServerControl> serverControl() {
            return Optional.ofNullable(this.serverControl);
        }

        @Override
        public Optional<Integer> version() {
            return Optional.ofNullable(this.version);
        }

        @Override
        public boolean independentSegments() {
            InitShim shim = this.initShim;
            return shim != null ? shim.independentSegments() : this.independentSegments;
        }

        @Override
        public Optional<StartTimeOffset> startTimeOffset() {
            return Optional.ofNullable(this.startTimeOffset);
        }

        @Override
        public List<PlaylistVariable> variables() {
            return this.variables;
        }

        @Override
        public List<String> comments() {
            return this.comments;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableMediaPlaylist && this.equalTo((ImmutableMediaPlaylist)another);
        }

        private boolean equalTo(ImmutableMediaPlaylist another) {
            return this.targetDuration == another.targetDuration && this.mediaSequence == another.mediaSequence && this.discontinuitySequence == another.discontinuitySequence && this.ongoing == another.ongoing && Objects.equals(this.allowCache, another.allowCache) && Objects.equals((Object)this.playlistType, (Object)another.playlistType) && this.iFramesOnly == another.iFramesOnly && this.mediaSegments.equals(another.mediaSegments) && Objects.equals(this.serverControl, another.serverControl) && Objects.equals(this.version, another.version) && this.independentSegments == another.independentSegments && Objects.equals(this.startTimeOffset, another.startTimeOffset) && this.variables.equals(another.variables) && this.comments.equals(another.comments);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.targetDuration;
            h += (h << 5) + Long.hashCode(this.mediaSequence);
            h += (h << 5) + Long.hashCode(this.discontinuitySequence);
            h += (h << 5) + Boolean.hashCode(this.ongoing);
            h += (h << 5) + Objects.hashCode(this.allowCache);
            h += (h << 5) + Objects.hashCode((Object)this.playlistType);
            h += (h << 5) + Boolean.hashCode(this.iFramesOnly);
            h += (h << 5) + this.mediaSegments.hashCode();
            h += (h << 5) + Objects.hashCode(this.serverControl);
            h += (h << 5) + Objects.hashCode(this.version);
            h += (h << 5) + Boolean.hashCode(this.independentSegments);
            h += (h << 5) + Objects.hashCode(this.startTimeOffset);
            h += (h << 5) + this.variables.hashCode();
            h += (h << 5) + this.comments.hashCode();
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MediaPlaylist{");
            builder.append("targetDuration=").append(this.targetDuration);
            builder.append(", ");
            builder.append("mediaSequence=").append(this.mediaSequence);
            builder.append(", ");
            builder.append("discontinuitySequence=").append(this.discontinuitySequence);
            builder.append(", ");
            builder.append("ongoing=").append(this.ongoing);
            if (this.allowCache != null) {
                builder.append(", ");
                builder.append("allowCache=").append(this.allowCache);
            }
            if (this.playlistType != null) {
                builder.append(", ");
                builder.append("playlistType=").append((Object)this.playlistType);
            }
            builder.append(", ");
            builder.append("iFramesOnly=").append(this.iFramesOnly);
            builder.append(", ");
            builder.append("mediaSegments=").append(this.mediaSegments);
            if (this.serverControl != null) {
                builder.append(", ");
                builder.append("serverControl=").append(this.serverControl);
            }
            if (this.version != null) {
                builder.append(", ");
                builder.append("version=").append(this.version);
            }
            builder.append(", ");
            builder.append("independentSegments=").append(this.independentSegments);
            if (this.startTimeOffset != null) {
                builder.append(", ");
                builder.append("startTimeOffset=").append(this.startTimeOffset);
            }
            builder.append(", ");
            builder.append("variables=").append(this.variables);
            builder.append(", ");
            builder.append("comments=").append(this.comments);
            return builder.append("}").toString();
        }

        private final class InitShim {
            private long mediaSequence;
            private int mediaSequenceBuildStage;
            private long discontinuitySequence;
            private int discontinuitySequenceBuildStage;
            private boolean ongoing;
            private int ongoingBuildStage;
            private boolean iFramesOnly;
            private int iFramesOnlyBuildStage;
            private boolean independentSegments;
            private int independentSegmentsBuildStage;

            private InitShim() {
            }

            long mediaSequence() {
                if (this.mediaSequenceBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.mediaSequenceBuildStage == 0) {
                    this.mediaSequenceBuildStage = -1;
                    this.mediaSequence = ImmutableMediaPlaylist.this.mediaSequenceInitialize();
                    this.mediaSequenceBuildStage = 1;
                }
                return this.mediaSequence;
            }

            void mediaSequence(long mediaSequence) {
                this.mediaSequence = mediaSequence;
                this.mediaSequenceBuildStage = 1;
            }

            long discontinuitySequence() {
                if (this.discontinuitySequenceBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.discontinuitySequenceBuildStage == 0) {
                    this.discontinuitySequenceBuildStage = -1;
                    this.discontinuitySequence = ImmutableMediaPlaylist.this.discontinuitySequenceInitialize();
                    this.discontinuitySequenceBuildStage = 1;
                }
                return this.discontinuitySequence;
            }

            void discontinuitySequence(long discontinuitySequence) {
                this.discontinuitySequence = discontinuitySequence;
                this.discontinuitySequenceBuildStage = 1;
            }

            boolean ongoing() {
                if (this.ongoingBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.ongoingBuildStage == 0) {
                    this.ongoingBuildStage = -1;
                    this.ongoing = ImmutableMediaPlaylist.this.ongoingInitialize();
                    this.ongoingBuildStage = 1;
                }
                return this.ongoing;
            }

            void ongoing(boolean ongoing) {
                this.ongoing = ongoing;
                this.ongoingBuildStage = 1;
            }

            boolean iFramesOnly() {
                if (this.iFramesOnlyBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.iFramesOnlyBuildStage == 0) {
                    this.iFramesOnlyBuildStage = -1;
                    this.iFramesOnly = ImmutableMediaPlaylist.this.iFramesOnlyInitialize();
                    this.iFramesOnlyBuildStage = 1;
                }
                return this.iFramesOnly;
            }

            void iFramesOnly(boolean iFramesOnly) {
                this.iFramesOnly = iFramesOnly;
                this.iFramesOnlyBuildStage = 1;
            }

            boolean independentSegments() {
                if (this.independentSegmentsBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.independentSegmentsBuildStage == 0) {
                    this.independentSegmentsBuildStage = -1;
                    this.independentSegments = ImmutableMediaPlaylist.this.independentSegmentsInitialize();
                    this.independentSegmentsBuildStage = 1;
                }
                return this.independentSegments;
            }

            void independentSegments(boolean independentSegments) {
                this.independentSegments = independentSegments;
                this.independentSegmentsBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.mediaSequenceBuildStage == -1) {
                    attributes.add("mediaSequence");
                }
                if (this.discontinuitySequenceBuildStage == -1) {
                    attributes.add("discontinuitySequence");
                }
                if (this.ongoingBuildStage == -1) {
                    attributes.add("ongoing");
                }
                if (this.iFramesOnlyBuildStage == -1) {
                    attributes.add("iFramesOnly");
                }
                if (this.independentSegmentsBuildStage == -1) {
                    attributes.add("independentSegments");
                }
                return "Cannot build MediaPlaylist, attribute initializers form cycle" + attributes;
            }
        }
    }
}

