/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.IFrameVariant;
import io.lindstrom.m3u8.parser.Attribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Map;

enum IFrameVariantAttribute implements Attribute<IFrameVariant, IFrameVariant.Builder>
{
    URI{

        @Override
        public void read(IFrameVariant.Builder builder, String value) {
            builder.uri(value);
        }

        @Override
        public void write(IFrameVariant value, TextBuilder textBuilder) {
            textBuilder.addQuoted(this.name(), value.uri());
        }
    }
    ,
    BANDWIDTH{

        @Override
        public void read(IFrameVariant.Builder builder, String value) {
            builder.bandwidth(Long.parseLong(value));
        }

        @Override
        public void write(IFrameVariant value, TextBuilder textBuilder) {
            textBuilder.add(this.name(), String.valueOf(value.bandwidth()));
        }
    }
    ,
    AVERAGE_BANDWIDTH{

        @Override
        public void read(IFrameVariant.Builder builder, String value) {
            builder.averageBandwidth(Long.parseLong(value));
        }

        @Override
        public void write(IFrameVariant value, TextBuilder textBuilder) {
            value.averageBandwidth().ifPresent(v -> textBuilder.add(this.key(), String.valueOf(v)));
        }
    }
    ,
    CODECS{

        @Override
        public void read(IFrameVariant.Builder builder, String value) {
            builder.codecs(ParserUtils.split(value, ","));
        }

        @Override
        public void write(IFrameVariant value, TextBuilder textBuilder) {
            if (!value.codecs().isEmpty()) {
                textBuilder.addQuoted(this.name(), String.join((CharSequence)",", value.codecs()));
            }
        }
    }
    ,
    RESOLUTION{

        @Override
        public void read(IFrameVariant.Builder builder, String value) throws PlaylistParserException {
            builder.resolution(ParserUtils.parseResolution(value));
        }

        @Override
        public void write(IFrameVariant value, TextBuilder textBuilder) {
            value.resolution().ifPresent(v -> textBuilder.add(this.key(), ParserUtils.writeResolution(v)));
        }
    }
    ,
    HDCP_LEVEL{

        @Override
        public void read(IFrameVariant.Builder builder, String value) {
            builder.hdcpLevel(value);
        }

        @Override
        public void write(IFrameVariant value, TextBuilder textBuilder) {
            value.hdcpLevel().ifPresent(v -> textBuilder.add(this.key(), (String)v));
        }
    }
    ,
    VIDEO{

        @Override
        public void read(IFrameVariant.Builder builder, String value) {
            builder.video(value);
        }

        @Override
        public void write(IFrameVariant value, TextBuilder textBuilder) {
            value.video().ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    }
    ,
    PROGRAM_ID{

        @Override
        public void read(IFrameVariant.Builder builder, String value) {
            builder.programId(Integer.parseInt(value));
        }

        @Override
        public void write(IFrameVariant value, TextBuilder textBuilder) {
            value.programId().ifPresent(v -> textBuilder.add(this.key(), Integer.toString(v)));
        }
    }
    ,
    VIDEO_RANGE{

        @Override
        public void read(IFrameVariant.Builder builder, String value) {
            builder.videoRange(value);
        }

        @Override
        public void write(IFrameVariant value, TextBuilder textBuilder) {
            value.videoRange().ifPresent(v -> textBuilder.add(this.key(), (Enum<?>)v));
        }
    };

    static final Map<String, IFrameVariantAttribute> attributeMap;

    static IFrameVariant parse(String attributes, ParsingMode parsingMode) throws PlaylistParserException {
        IFrameVariant.Builder builder = IFrameVariant.builder();
        ParserUtils.readAttributes(attributeMap, attributes, builder, parsingMode);
        return builder.build();
    }

    static {
        attributeMap = ParserUtils.toMap(IFrameVariantAttribute.values(), Attribute::key);
    }
}

