/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.MediaPlaylist;
import io.lindstrom.m3u8.model.MediaSegment;
import io.lindstrom.m3u8.parser.AbstractPlaylistParser;
import io.lindstrom.m3u8.parser.MediaPlaylistTag;
import io.lindstrom.m3u8.parser.MediaSegmentTag;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Iterator;

public class MediaPlaylistParser
extends AbstractPlaylistParser<MediaPlaylist, Builder> {
    private final ParsingMode parsingMode;

    public MediaPlaylistParser() {
        this(ParsingMode.STRICT);
    }

    public MediaPlaylistParser(ParsingMode parsingMode) {
        this.parsingMode = parsingMode;
    }

    @Override
    Builder newBuilder() {
        return new Builder();
    }

    @Override
    void onTag(Builder builderWrapper, String name, String attributes, Iterator<String> lineIterator) throws PlaylistParserException {
        if (MediaPlaylistTag.tags.containsKey(name)) {
            MediaPlaylistTag.tags.get(name).read(builderWrapper.playlistBuilder, attributes, this.parsingMode);
        } else if (MediaSegmentTag.tags.containsKey(name)) {
            MediaSegmentTag.tags.get(name).read(builderWrapper.segmentBuilder, attributes, this.parsingMode);
        } else if (this.parsingMode.failOnUnknownTags()) {
            throw new PlaylistParserException("Tag not implemented: " + name);
        }
    }

    @Override
    void onComment(Builder builder, String value) {
        builder.playlistBuilder.addComments(value);
    }

    @Override
    void onURI(Builder builderWrapper, String uri) {
        builderWrapper.segmentBuilder.uri(uri);
        builderWrapper.playlistBuilder.addMediaSegments(builderWrapper.segmentBuilder.build());
        builderWrapper.segmentBuilder = MediaSegment.builder();
    }

    @Override
    MediaPlaylist build(Builder builderWrapper) {
        return builderWrapper.playlistBuilder.build();
    }

    @Override
    void write(MediaPlaylist playlist, TextBuilder textBuilder) {
        for (MediaPlaylistTag tag : MediaPlaylistTag.tags.values()) {
            tag.write(playlist, textBuilder);
        }
        playlist.mediaSegments().forEach(mediaSegment -> {
            for (MediaSegmentTag tag : MediaSegmentTag.tags.values()) {
                tag.write(mediaSegment, textBuilder);
            }
            textBuilder.add(mediaSegment.uri()).add('\n');
        });
        if (!playlist.ongoing()) {
            textBuilder.addTag(MediaPlaylistTag.EXT_X_ENDLIST.tag());
        }
    }

    static class Builder {
        private final MediaPlaylist.Builder playlistBuilder = MediaPlaylist.builder();
        private MediaSegment.Builder segmentBuilder = MediaSegment.builder();

        Builder() {
        }
    }
}

