package io.lindstrom.m3u8.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;

/**
 * Builds instances of type {@link MapInfo MapInfo}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code MapInfoBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "MapInfo"})
class MapInfoBuilder {
  private static final long INIT_BIT_URI = 0x1L;
  private long initBits = 0x1L;

  private String uri;
  private ByteRange byteRange;

  /**
   * Creates a builder for {@link MapInfo MapInfo} instances.
   */
  MapInfoBuilder() {
    if (!(this instanceof MapInfo.Builder)) {
      throw new UnsupportedOperationException("Use: new MapInfo.Builder()");
    }
  }

  /**
   * Fill a builder with attribute values from the provided {@code MapInfo} instance.
   * Regular attribute values will be replaced with those from the given instance.
   * Absent optional values will not replace present values.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  public final MapInfo.Builder from(MapInfo instance) {
    Objects.requireNonNull(instance, "instance");
    uri(instance.uri());
    Optional<ByteRange> byteRangeOptional = instance.byteRange();
    if (byteRangeOptional.isPresent()) {
      byteRange(byteRangeOptional);
    }
    return (MapInfo.Builder) this;
  }

  /**
   * Initializes the value for the {@link MapInfo#uri() uri} attribute.
   * @param uri The value for uri 
   * @return {@code this} builder for use in a chained invocation
   */
  public final MapInfo.Builder uri(String uri) {
    this.uri = Objects.requireNonNull(uri, "uri");
    initBits &= ~INIT_BIT_URI;
    return (MapInfo.Builder) this;
  }

  /**
   * Initializes the optional value {@link MapInfo#byteRange() byteRange} to byteRange.
   * @param byteRange The value for byteRange
   * @return {@code this} builder for chained invocation
   */
  public final MapInfo.Builder byteRange(ByteRange byteRange) {
    this.byteRange = Objects.requireNonNull(byteRange, "byteRange");
    return (MapInfo.Builder) this;
  }

  /**
   * Initializes the optional value {@link MapInfo#byteRange() byteRange} to byteRange.
   * @param byteRange The value for byteRange
   * @return {@code this} builder for use in a chained invocation
   */
  public final MapInfo.Builder byteRange(Optional<? extends ByteRange> byteRange) {
    this.byteRange = byteRange.orElse(null);
    return (MapInfo.Builder) this;
  }

  /**
   * Builds a new {@link MapInfo MapInfo}.
   * @return An immutable instance of MapInfo
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public MapInfo build() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
    return new MapInfoBuilder.ImmutableMapInfo(this);
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<String>();
    if ((initBits & INIT_BIT_URI) != 0) attributes.add("uri");
    return "Cannot build MapInfo, some of required attributes are not set " + attributes;
  }

  /**
   * Immutable implementation of {@link MapInfo}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new MapInfo.Builder()}.
   */
  private static final class ImmutableMapInfo implements MapInfo {
    private final String uri;
    private final ByteRange byteRange;

    private ImmutableMapInfo(MapInfoBuilder builder) {
      this.uri = builder.uri;
      this.byteRange = builder.byteRange;
    }

    /**
     * @return The value of the {@code uri} attribute
     */
    @Override
    public String uri() {
      return uri;
    }

    /**
     * @return The value of the {@code byteRange} attribute
     */
    @Override
    public Optional<ByteRange> byteRange() {
      return Optional.ofNullable(byteRange);
    }

    /**
     * This instance is equal to all instances of {@code ImmutableMapInfo} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof MapInfoBuilder.ImmutableMapInfo
          && equalTo((MapInfoBuilder.ImmutableMapInfo) another);
    }

    private boolean equalTo(MapInfoBuilder.ImmutableMapInfo another) {
      return uri.equals(another.uri)
          && Objects.equals(byteRange, another.byteRange);
    }

    /**
     * Computes a hash code from attributes: {@code uri}, {@code byteRange}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + uri.hashCode();
      h += (h << 5) + Objects.hashCode(byteRange);
      return h;
    }

    /**
     * Prints the immutable value {@code MapInfo} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder("MapInfo{");
      builder.append("uri=").append(uri);
      if (byteRange != null) {
        builder.append(", ");
        builder.append("byteRange=").append(byteRange);
      }
      return builder.append("}").toString();
    }
  }
}
