/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.IFrameVariant;
import io.lindstrom.m3u8.model.Resolution;
import io.lindstrom.m3u8.model.VideoRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class IFrameVariantBuilder {
    private static final long INIT_BIT_URI = 1L;
    private static final long INIT_BIT_BANDWIDTH = 2L;
    private long initBits = 3L;
    private String uri;
    private long bandwidth;
    private Long averageBandwidth;
    private List<String> codecs = new ArrayList<String>();
    private Resolution resolution;
    private String hdcpLevel;
    private String video;
    private Integer programId;
    private VideoRange videoRange;

    IFrameVariantBuilder() {
        if (!(this instanceof IFrameVariant.Builder)) {
            throw new UnsupportedOperationException("Use: new IFrameVariant.Builder()");
        }
    }

    public final IFrameVariant.Builder from(IFrameVariant instance) {
        Optional<VideoRange> videoRangeOptional;
        Optional<Integer> programIdOptional;
        Optional<String> videoOptional;
        Optional<String> hdcpLevelOptional;
        Objects.requireNonNull(instance, "instance");
        this.uri(instance.uri());
        this.bandwidth(instance.bandwidth());
        Optional<Long> averageBandwidthOptional = instance.averageBandwidth();
        if (averageBandwidthOptional.isPresent()) {
            this.averageBandwidth(averageBandwidthOptional);
        }
        this.addAllCodecs(instance.codecs());
        Optional<Resolution> resolutionOptional = instance.resolution();
        if (resolutionOptional.isPresent()) {
            this.resolution(resolutionOptional);
        }
        if ((hdcpLevelOptional = instance.hdcpLevel()).isPresent()) {
            this.hdcpLevel(hdcpLevelOptional);
        }
        if ((videoOptional = instance.video()).isPresent()) {
            this.video(videoOptional);
        }
        if ((programIdOptional = instance.programId()).isPresent()) {
            this.programId(programIdOptional);
        }
        if ((videoRangeOptional = instance.videoRange()).isPresent()) {
            this.videoRange(videoRangeOptional);
        }
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder bandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder averageBandwidth(long averageBandwidth) {
        this.averageBandwidth = averageBandwidth;
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder averageBandwidth(Optional<Long> averageBandwidth) {
        this.averageBandwidth = averageBandwidth.orElse(null);
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder addCodecs(String element) {
        this.codecs.add(Objects.requireNonNull(element, "codecs element"));
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder addCodecs(String ... elements) {
        for (String element : elements) {
            this.codecs.add(Objects.requireNonNull(element, "codecs element"));
        }
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder codecs(Iterable<String> elements) {
        this.codecs.clear();
        return this.addAllCodecs(elements);
    }

    public final IFrameVariant.Builder addAllCodecs(Iterable<String> elements) {
        for (String element : elements) {
            this.codecs.add(Objects.requireNonNull(element, "codecs element"));
        }
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder resolution(Resolution resolution) {
        this.resolution = Objects.requireNonNull(resolution, "resolution");
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder resolution(Optional<? extends Resolution> resolution) {
        this.resolution = resolution.orElse(null);
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder hdcpLevel(String hdcpLevel) {
        this.hdcpLevel = Objects.requireNonNull(hdcpLevel, "hdcpLevel");
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder hdcpLevel(Optional<String> hdcpLevel) {
        this.hdcpLevel = hdcpLevel.orElse(null);
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder video(String video) {
        this.video = Objects.requireNonNull(video, "video");
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder video(Optional<String> video) {
        this.video = video.orElse(null);
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder programId(int programId) {
        this.programId = programId;
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder programId(Optional<Integer> programId) {
        this.programId = programId.orElse(null);
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder videoRange(VideoRange videoRange) {
        this.videoRange = Objects.requireNonNull(videoRange, "videoRange");
        return (IFrameVariant.Builder)this;
    }

    public final IFrameVariant.Builder videoRange(Optional<? extends VideoRange> videoRange) {
        this.videoRange = videoRange.orElse(null);
        return (IFrameVariant.Builder)this;
    }

    public IFrameVariant build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableIFrameVariant(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("uri");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("bandwidth");
        }
        return "Cannot build IFrameVariant, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static final class ImmutableIFrameVariant
    implements IFrameVariant {
        private final String uri;
        private final long bandwidth;
        private final Long averageBandwidth;
        private final List<String> codecs;
        private final Resolution resolution;
        private final String hdcpLevel;
        private final String video;
        private final Integer programId;
        private final VideoRange videoRange;

        private ImmutableIFrameVariant(IFrameVariantBuilder builder) {
            this.uri = builder.uri;
            this.bandwidth = builder.bandwidth;
            this.averageBandwidth = builder.averageBandwidth;
            this.codecs = IFrameVariantBuilder.createUnmodifiableList(true, builder.codecs);
            this.resolution = builder.resolution;
            this.hdcpLevel = builder.hdcpLevel;
            this.video = builder.video;
            this.programId = builder.programId;
            this.videoRange = builder.videoRange;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public long bandwidth() {
            return this.bandwidth;
        }

        @Override
        public Optional<Long> averageBandwidth() {
            return Optional.ofNullable(this.averageBandwidth);
        }

        @Override
        public List<String> codecs() {
            return this.codecs;
        }

        @Override
        public Optional<Resolution> resolution() {
            return Optional.ofNullable(this.resolution);
        }

        @Override
        public Optional<String> hdcpLevel() {
            return Optional.ofNullable(this.hdcpLevel);
        }

        @Override
        public Optional<String> video() {
            return Optional.ofNullable(this.video);
        }

        @Override
        public Optional<Integer> programId() {
            return Optional.ofNullable(this.programId);
        }

        @Override
        public Optional<VideoRange> videoRange() {
            return Optional.ofNullable(this.videoRange);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableIFrameVariant && this.equalTo((ImmutableIFrameVariant)another);
        }

        private boolean equalTo(ImmutableIFrameVariant another) {
            return this.uri.equals(another.uri) && this.bandwidth == another.bandwidth && Objects.equals(this.averageBandwidth, another.averageBandwidth) && this.codecs.equals(another.codecs) && Objects.equals(this.resolution, another.resolution) && Objects.equals(this.hdcpLevel, another.hdcpLevel) && Objects.equals(this.video, another.video) && Objects.equals(this.programId, another.programId) && Objects.equals((Object)this.videoRange, (Object)another.videoRange);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Long.hashCode(this.bandwidth);
            h += (h << 5) + Objects.hashCode(this.averageBandwidth);
            h += (h << 5) + this.codecs.hashCode();
            h += (h << 5) + Objects.hashCode(this.resolution);
            h += (h << 5) + Objects.hashCode(this.hdcpLevel);
            h += (h << 5) + Objects.hashCode(this.video);
            h += (h << 5) + Objects.hashCode(this.programId);
            h += (h << 5) + Objects.hashCode((Object)this.videoRange);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("IFrameVariant{");
            builder.append("uri=").append(this.uri);
            builder.append(", ");
            builder.append("bandwidth=").append(this.bandwidth);
            if (this.averageBandwidth != null) {
                builder.append(", ");
                builder.append("averageBandwidth=").append(this.averageBandwidth);
            }
            builder.append(", ");
            builder.append("codecs=").append(this.codecs);
            if (this.resolution != null) {
                builder.append(", ");
                builder.append("resolution=").append(this.resolution);
            }
            if (this.hdcpLevel != null) {
                builder.append(", ");
                builder.append("hdcpLevel=").append(this.hdcpLevel);
            }
            if (this.video != null) {
                builder.append(", ");
                builder.append("video=").append(this.video);
            }
            if (this.programId != null) {
                builder.append(", ");
                builder.append("programId=").append(this.programId);
            }
            if (this.videoRange != null) {
                builder.append(", ");
                builder.append("videoRange=").append((Object)this.videoRange);
            }
            return builder.append("}").toString();
        }
    }
}

