/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.ByteRange;
import io.lindstrom.m3u8.model.DateRange;
import io.lindstrom.m3u8.model.MediaSegment;
import io.lindstrom.m3u8.model.SegmentKey;
import io.lindstrom.m3u8.model.SegmentMap;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

class MediaSegmentBuilder {
    private static final long INIT_BIT_DURATION = 1L;
    private static final long INIT_BIT_URI = 2L;
    private static final long OPT_BIT_DISCONTINUITY = 1L;
    private static final long OPT_BIT_CUE_IN = 2L;
    private static final long OPT_BIT_GAP = 4L;
    private long initBits = 3L;
    private long optBits;
    private double duration;
    private String title;
    private String uri;
    private ByteRange byteRange;
    private OffsetDateTime programDateTime;
    private DateRange dateRange;
    private SegmentMap segmentMap;
    private SegmentKey segmentKey;
    private boolean discontinuity;
    private Double cueOut;
    private boolean cueIn;
    private boolean gap;
    private Long bitrate;

    MediaSegmentBuilder() {
        if (!(this instanceof MediaSegment.Builder)) {
            throw new UnsupportedOperationException("Use: new MediaSegment.Builder()");
        }
    }

    public final MediaSegment.Builder from(MediaSegment instance) {
        Optional<SegmentKey> segmentKeyOptional;
        Optional<SegmentMap> segmentMapOptional;
        Optional<DateRange> dateRangeOptional;
        Optional<OffsetDateTime> programDateTimeOptional;
        Objects.requireNonNull(instance, "instance");
        this.duration(instance.duration());
        Optional<String> titleOptional = instance.title();
        if (titleOptional.isPresent()) {
            this.title(titleOptional);
        }
        this.uri(instance.uri());
        Optional<ByteRange> byteRangeOptional = instance.byteRange();
        if (byteRangeOptional.isPresent()) {
            this.byteRange(byteRangeOptional);
        }
        if ((programDateTimeOptional = instance.programDateTime()).isPresent()) {
            this.programDateTime(programDateTimeOptional);
        }
        if ((dateRangeOptional = instance.dateRange()).isPresent()) {
            this.dateRange(dateRangeOptional);
        }
        if ((segmentMapOptional = instance.segmentMap()).isPresent()) {
            this.segmentMap(segmentMapOptional);
        }
        if ((segmentKeyOptional = instance.segmentKey()).isPresent()) {
            this.segmentKey(segmentKeyOptional);
        }
        this.discontinuity(instance.discontinuity());
        Optional<Double> cueOutOptional = instance.cueOut();
        if (cueOutOptional.isPresent()) {
            this.cueOut(cueOutOptional);
        }
        this.cueIn(instance.cueIn());
        this.gap(instance.gap());
        Optional<Long> bitrateOptional = instance.bitrate();
        if (bitrateOptional.isPresent()) {
            this.bitrate(bitrateOptional);
        }
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder duration(double duration) {
        this.duration = duration;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder title(String title) {
        this.title = Objects.requireNonNull(title, "title");
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder title(Optional<String> title) {
        this.title = title.orElse(null);
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder byteRange(ByteRange byteRange) {
        this.byteRange = Objects.requireNonNull(byteRange, "byteRange");
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder byteRange(Optional<? extends ByteRange> byteRange) {
        this.byteRange = byteRange.orElse(null);
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder programDateTime(OffsetDateTime programDateTime) {
        this.programDateTime = Objects.requireNonNull(programDateTime, "programDateTime");
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder programDateTime(Optional<? extends OffsetDateTime> programDateTime) {
        this.programDateTime = programDateTime.orElse(null);
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder dateRange(DateRange dateRange) {
        this.dateRange = Objects.requireNonNull(dateRange, "dateRange");
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder dateRange(Optional<? extends DateRange> dateRange) {
        this.dateRange = dateRange.orElse(null);
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder segmentMap(SegmentMap segmentMap) {
        this.segmentMap = Objects.requireNonNull(segmentMap, "segmentMap");
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder segmentMap(Optional<? extends SegmentMap> segmentMap) {
        this.segmentMap = segmentMap.orElse(null);
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder segmentKey(SegmentKey segmentKey) {
        this.segmentKey = Objects.requireNonNull(segmentKey, "segmentKey");
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder segmentKey(Optional<? extends SegmentKey> segmentKey) {
        this.segmentKey = segmentKey.orElse(null);
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder discontinuity(boolean discontinuity) {
        this.discontinuity = discontinuity;
        this.optBits |= 1L;
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder cueOut(double cueOut) {
        this.cueOut = cueOut;
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder cueOut(Optional<Double> cueOut) {
        this.cueOut = cueOut.orElse(null);
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder cueIn(boolean cueIn) {
        this.cueIn = cueIn;
        this.optBits |= 2L;
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder gap(boolean gap) {
        this.gap = gap;
        this.optBits |= 4L;
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder bitrate(long bitrate) {
        this.bitrate = bitrate;
        return (MediaSegment.Builder)this;
    }

    public final MediaSegment.Builder bitrate(Optional<Long> bitrate) {
        this.bitrate = bitrate.orElse(null);
        return (MediaSegment.Builder)this;
    }

    public MediaSegment build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableMediaSegment(this);
    }

    private boolean discontinuityIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private boolean cueInIsSet() {
        return (this.optBits & 2L) != 0L;
    }

    private boolean gapIsSet() {
        return (this.optBits & 4L) != 0L;
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("duration");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("uri");
        }
        return "Cannot build MediaSegment, some of required attributes are not set " + attributes;
    }

    private static final class ImmutableMediaSegment
    implements MediaSegment {
        private final double duration;
        private final String title;
        private final String uri;
        private final ByteRange byteRange;
        private final OffsetDateTime programDateTime;
        private final DateRange dateRange;
        private final SegmentMap segmentMap;
        private final SegmentKey segmentKey;
        private final boolean discontinuity;
        private final Double cueOut;
        private final boolean cueIn;
        private final boolean gap;
        private final Long bitrate;
        private static final int STAGE_INITIALIZING = -1;
        private static final int STAGE_UNINITIALIZED = 0;
        private static final int STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private ImmutableMediaSegment(MediaSegmentBuilder builder) {
            this.duration = builder.duration;
            this.title = builder.title;
            this.uri = builder.uri;
            this.byteRange = builder.byteRange;
            this.programDateTime = builder.programDateTime;
            this.dateRange = builder.dateRange;
            this.segmentMap = builder.segmentMap;
            this.segmentKey = builder.segmentKey;
            this.cueOut = builder.cueOut;
            this.bitrate = builder.bitrate;
            if (builder.discontinuityIsSet()) {
                this.initShim.discontinuity(builder.discontinuity);
            }
            if (builder.cueInIsSet()) {
                this.initShim.cueIn(builder.cueIn);
            }
            if (builder.gapIsSet()) {
                this.initShim.gap(builder.gap);
            }
            this.discontinuity = this.initShim.discontinuity();
            this.cueIn = this.initShim.cueIn();
            this.gap = this.initShim.gap();
            this.initShim = null;
        }

        private boolean discontinuityInitialize() {
            return MediaSegment.super.discontinuity();
        }

        private boolean cueInInitialize() {
            return MediaSegment.super.cueIn();
        }

        private boolean gapInitialize() {
            return MediaSegment.super.gap();
        }

        @Override
        public double duration() {
            return this.duration;
        }

        @Override
        public Optional<String> title() {
            return Optional.ofNullable(this.title);
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public Optional<ByteRange> byteRange() {
            return Optional.ofNullable(this.byteRange);
        }

        @Override
        public Optional<OffsetDateTime> programDateTime() {
            return Optional.ofNullable(this.programDateTime);
        }

        @Override
        public Optional<DateRange> dateRange() {
            return Optional.ofNullable(this.dateRange);
        }

        @Override
        public Optional<SegmentMap> segmentMap() {
            return Optional.ofNullable(this.segmentMap);
        }

        @Override
        public Optional<SegmentKey> segmentKey() {
            return Optional.ofNullable(this.segmentKey);
        }

        @Override
        public boolean discontinuity() {
            InitShim shim = this.initShim;
            return shim != null ? shim.discontinuity() : this.discontinuity;
        }

        @Override
        public Optional<Double> cueOut() {
            return Optional.ofNullable(this.cueOut);
        }

        @Override
        public boolean cueIn() {
            InitShim shim = this.initShim;
            return shim != null ? shim.cueIn() : this.cueIn;
        }

        @Override
        public boolean gap() {
            InitShim shim = this.initShim;
            return shim != null ? shim.gap() : this.gap;
        }

        @Override
        public Optional<Long> bitrate() {
            return Optional.ofNullable(this.bitrate);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableMediaSegment && this.equalTo((ImmutableMediaSegment)another);
        }

        private boolean equalTo(ImmutableMediaSegment another) {
            return Double.doubleToLongBits(this.duration) == Double.doubleToLongBits(another.duration) && Objects.equals(this.title, another.title) && this.uri.equals(another.uri) && Objects.equals(this.byteRange, another.byteRange) && Objects.equals(this.programDateTime, another.programDateTime) && Objects.equals(this.dateRange, another.dateRange) && Objects.equals(this.segmentMap, another.segmentMap) && Objects.equals(this.segmentKey, another.segmentKey) && this.discontinuity == another.discontinuity && Objects.equals(this.cueOut, another.cueOut) && this.cueIn == another.cueIn && this.gap == another.gap && Objects.equals(this.bitrate, another.bitrate);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Double.hashCode(this.duration);
            h += (h << 5) + Objects.hashCode(this.title);
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Objects.hashCode(this.byteRange);
            h += (h << 5) + Objects.hashCode(this.programDateTime);
            h += (h << 5) + Objects.hashCode(this.dateRange);
            h += (h << 5) + Objects.hashCode(this.segmentMap);
            h += (h << 5) + Objects.hashCode(this.segmentKey);
            h += (h << 5) + Boolean.hashCode(this.discontinuity);
            h += (h << 5) + Objects.hashCode(this.cueOut);
            h += (h << 5) + Boolean.hashCode(this.cueIn);
            h += (h << 5) + Boolean.hashCode(this.gap);
            h += (h << 5) + Objects.hashCode(this.bitrate);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MediaSegment{");
            builder.append("duration=").append(this.duration);
            if (this.title != null) {
                builder.append(", ");
                builder.append("title=").append(this.title);
            }
            builder.append(", ");
            builder.append("uri=").append(this.uri);
            if (this.byteRange != null) {
                builder.append(", ");
                builder.append("byteRange=").append(this.byteRange);
            }
            if (this.programDateTime != null) {
                builder.append(", ");
                builder.append("programDateTime=").append(this.programDateTime);
            }
            if (this.dateRange != null) {
                builder.append(", ");
                builder.append("dateRange=").append(this.dateRange);
            }
            if (this.segmentMap != null) {
                builder.append(", ");
                builder.append("segmentMap=").append(this.segmentMap);
            }
            if (this.segmentKey != null) {
                builder.append(", ");
                builder.append("segmentKey=").append(this.segmentKey);
            }
            builder.append(", ");
            builder.append("discontinuity=").append(this.discontinuity);
            if (this.cueOut != null) {
                builder.append(", ");
                builder.append("cueOut=").append(this.cueOut);
            }
            builder.append(", ");
            builder.append("cueIn=").append(this.cueIn);
            builder.append(", ");
            builder.append("gap=").append(this.gap);
            if (this.bitrate != null) {
                builder.append(", ");
                builder.append("bitrate=").append(this.bitrate);
            }
            return builder.append("}").toString();
        }

        private final class InitShim {
            private boolean discontinuity;
            private int discontinuityBuildStage;
            private boolean cueIn;
            private int cueInBuildStage;
            private boolean gap;
            private int gapBuildStage;

            private InitShim() {
            }

            boolean discontinuity() {
                if (this.discontinuityBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.discontinuityBuildStage == 0) {
                    this.discontinuityBuildStage = -1;
                    this.discontinuity = ImmutableMediaSegment.this.discontinuityInitialize();
                    this.discontinuityBuildStage = 1;
                }
                return this.discontinuity;
            }

            void discontinuity(boolean discontinuity) {
                this.discontinuity = discontinuity;
                this.discontinuityBuildStage = 1;
            }

            boolean cueIn() {
                if (this.cueInBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.cueInBuildStage == 0) {
                    this.cueInBuildStage = -1;
                    this.cueIn = ImmutableMediaSegment.this.cueInInitialize();
                    this.cueInBuildStage = 1;
                }
                return this.cueIn;
            }

            void cueIn(boolean cueIn) {
                this.cueIn = cueIn;
                this.cueInBuildStage = 1;
            }

            boolean gap() {
                if (this.gapBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.gapBuildStage == 0) {
                    this.gapBuildStage = -1;
                    this.gap = ImmutableMediaSegment.this.gapInitialize();
                    this.gapBuildStage = 1;
                }
                return this.gap;
            }

            void gap(boolean gap) {
                this.gap = gap;
                this.gapBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.discontinuityBuildStage == -1) {
                    attributes.add("discontinuity");
                }
                if (this.cueInBuildStage == -1) {
                    attributes.add("cueIn");
                }
                if (this.gapBuildStage == -1) {
                    attributes.add("gap");
                }
                return "Cannot build MediaSegment, attribute initializers form cycle" + attributes;
            }
        }
    }
}

