/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.ServerControl;
import io.lindstrom.m3u8.parser.Attribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Map;

public enum ServerControlAttribute implements Attribute<ServerControl, ServerControl.Builder>
{
    CAN_SKIP_UNTIL{

        @Override
        public void read(ServerControl.Builder builder, String value) {
            builder.canSkipUntil(Double.parseDouble(value));
        }

        @Override
        public void write(ServerControl value, TextBuilder textBuilder) {
            value.canSkipUntil().ifPresent(v -> textBuilder.add(this.key(), (double)v));
        }
    }
    ,
    CAN_SKIP_DATERANGES{

        @Override
        public void read(ServerControl.Builder builder, String value) throws PlaylistParserException {
            builder.canSkipDateRanges(ParserUtils.yesOrNo(value));
        }

        @Override
        public void write(ServerControl value, TextBuilder textBuilder) {
            value.canSkipDateRanges().ifPresent(v -> textBuilder.add(this.key(), (boolean)v));
        }
    }
    ,
    HOLD_BACK{

        @Override
        public void read(ServerControl.Builder builder, String value) {
            builder.holdBack(Double.parseDouble(value));
        }

        @Override
        public void write(ServerControl value, TextBuilder textBuilder) {
            value.holdBack().ifPresent(v -> textBuilder.add(this.key(), (double)v));
        }
    }
    ,
    PART_HOLD_BACK{

        @Override
        public void read(ServerControl.Builder builder, String value) {
            builder.partHoldBack(Double.parseDouble(value));
        }

        @Override
        public void write(ServerControl value, TextBuilder textBuilder) {
            value.partHoldBack().ifPresent(v -> textBuilder.add(this.key(), (double)v));
        }
    }
    ,
    CAN_BLOCK_RELOAD{

        @Override
        public void read(ServerControl.Builder builder, String value) throws PlaylistParserException {
            builder.canBlockReload(ParserUtils.yesOrNo(value));
        }

        @Override
        public void write(ServerControl value, TextBuilder textBuilder) {
            if (value.canBlockReload()) {
                textBuilder.add(this.key(), "YES");
            }
        }
    };

    static final Map<String, ServerControlAttribute> attributeMap;

    static ServerControl parse(String attributes, ParsingMode parsingMode) throws PlaylistParserException {
        ServerControl.Builder builder = ServerControl.builder();
        ParserUtils.readAttributes(attributeMap, attributes, builder, parsingMode);
        return builder.build();
    }

    static {
        attributeMap = ParserUtils.toMap(ServerControlAttribute.values(), Attribute::key);
    }
}

