/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.IFrameVariantBuilder;
import io.lindstrom.m3u8.model.Resolution;
import io.lindstrom.m3u8.model.VideoRange;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface IFrameVariant {
    public String uri();

    public long bandwidth();

    public Optional<Long> averageBandwidth();

    public Optional<Double> score();

    public List<String> codecs();

    public Optional<Resolution> resolution();

    public Optional<String> hdcpLevel();

    public List<String> allowedCpc();

    public Optional<String> stableVariantId();

    public Optional<String> video();

    public Optional<Integer> programId();

    public Optional<VideoRange> videoRange();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends IFrameVariantBuilder {
        public Builder videoRange(String value) {
            return this.videoRange(VideoRange.valueOf(value));
        }
    }
}

