/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.ByteRange;
import io.lindstrom.m3u8.model.DateRange;
import io.lindstrom.m3u8.model.MediaSegmentBuilder;
import io.lindstrom.m3u8.model.PartialSegment;
import io.lindstrom.m3u8.model.SegmentKey;
import io.lindstrom.m3u8.model.SegmentMap;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface MediaSegment {
    public double duration();

    public Optional<String> title();

    public String uri();

    public Optional<ByteRange> byteRange();

    public Optional<OffsetDateTime> programDateTime();

    public Optional<DateRange> dateRange();

    public Optional<SegmentMap> segmentMap();

    public Optional<SegmentKey> segmentKey();

    @Value.Default
    default public boolean discontinuity() {
        return false;
    }

    public Optional<Double> cueOut();

    @Value.Default
    default public boolean cueIn() {
        return false;
    }

    @Value.Default
    default public boolean gap() {
        return false;
    }

    public Optional<Long> bitrate();

    public List<PartialSegment> partialSegments();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends MediaSegmentBuilder {
    }
}

