/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.Resolution;
import io.lindstrom.m3u8.model.Variant;
import io.lindstrom.m3u8.model.VideoRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class VariantBuilder {
    private static final long INIT_BIT_BANDWIDTH = 1L;
    private static final long INIT_BIT_URI = 2L;
    private long initBits = 3L;
    private long bandwidth;
    private Long averageBandwidth;
    private Double score;
    private List<String> codecs = new ArrayList<String>();
    private Resolution resolution;
    private Double frameRate;
    private String hdcpLevel;
    private List<String> allowedCpc = new ArrayList<String>();
    private String stableVariantId;
    private String audio;
    private String video;
    private String subtitles;
    private String closedCaptions;
    private Boolean closedCaptionsNone;
    private String uri;
    private Integer programId;
    private VideoRange videoRange;

    VariantBuilder() {
        if (!(this instanceof Variant.Builder)) {
            throw new UnsupportedOperationException("Use: new Variant.Builder()");
        }
    }

    public final Variant.Builder from(Variant instance) {
        Optional<VideoRange> videoRangeOptional;
        Optional<Boolean> closedCaptionsNoneOptional;
        Optional<String> closedCaptionsOptional;
        Optional<String> subtitlesOptional;
        Optional<String> videoOptional;
        Optional<String> audioOptional;
        Optional<String> hdcpLevelOptional;
        Optional<Double> frameRateOptional;
        Optional<Double> scoreOptional;
        Objects.requireNonNull(instance, "instance");
        this.bandwidth(instance.bandwidth());
        Optional<Long> averageBandwidthOptional = instance.averageBandwidth();
        if (averageBandwidthOptional.isPresent()) {
            this.averageBandwidth(averageBandwidthOptional);
        }
        if ((scoreOptional = instance.score()).isPresent()) {
            this.score(scoreOptional);
        }
        this.addAllCodecs(instance.codecs());
        Optional<Resolution> resolutionOptional = instance.resolution();
        if (resolutionOptional.isPresent()) {
            this.resolution(resolutionOptional);
        }
        if ((frameRateOptional = instance.frameRate()).isPresent()) {
            this.frameRate(frameRateOptional);
        }
        if ((hdcpLevelOptional = instance.hdcpLevel()).isPresent()) {
            this.hdcpLevel(hdcpLevelOptional);
        }
        this.addAllAllowedCpc(instance.allowedCpc());
        Optional<String> stableVariantIdOptional = instance.stableVariantId();
        if (stableVariantIdOptional.isPresent()) {
            this.stableVariantId(stableVariantIdOptional);
        }
        if ((audioOptional = instance.audio()).isPresent()) {
            this.audio(audioOptional);
        }
        if ((videoOptional = instance.video()).isPresent()) {
            this.video(videoOptional);
        }
        if ((subtitlesOptional = instance.subtitles()).isPresent()) {
            this.subtitles(subtitlesOptional);
        }
        if ((closedCaptionsOptional = instance.closedCaptions()).isPresent()) {
            this.closedCaptions(closedCaptionsOptional);
        }
        if ((closedCaptionsNoneOptional = instance.closedCaptionsNone()).isPresent()) {
            this.closedCaptionsNone(closedCaptionsNoneOptional);
        }
        this.uri(instance.uri());
        Optional<Integer> programIdOptional = instance.programId();
        if (programIdOptional.isPresent()) {
            this.programId(programIdOptional);
        }
        if ((videoRangeOptional = instance.videoRange()).isPresent()) {
            this.videoRange(videoRangeOptional);
        }
        return (Variant.Builder)this;
    }

    public final Variant.Builder bandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (Variant.Builder)this;
    }

    public final Variant.Builder averageBandwidth(long averageBandwidth) {
        this.averageBandwidth = averageBandwidth;
        return (Variant.Builder)this;
    }

    public final Variant.Builder averageBandwidth(Optional<Long> averageBandwidth) {
        this.averageBandwidth = averageBandwidth.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder score(double score) {
        this.score = score;
        return (Variant.Builder)this;
    }

    public final Variant.Builder score(Optional<Double> score) {
        this.score = score.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder addCodecs(String element) {
        this.codecs.add(Objects.requireNonNull(element, "codecs element"));
        return (Variant.Builder)this;
    }

    public final Variant.Builder addCodecs(String ... elements) {
        for (String element : elements) {
            this.codecs.add(Objects.requireNonNull(element, "codecs element"));
        }
        return (Variant.Builder)this;
    }

    public final Variant.Builder codecs(Iterable<String> elements) {
        this.codecs.clear();
        return this.addAllCodecs(elements);
    }

    public final Variant.Builder addAllCodecs(Iterable<String> elements) {
        for (String element : elements) {
            this.codecs.add(Objects.requireNonNull(element, "codecs element"));
        }
        return (Variant.Builder)this;
    }

    public final Variant.Builder resolution(Resolution resolution) {
        this.resolution = Objects.requireNonNull(resolution, "resolution");
        return (Variant.Builder)this;
    }

    public final Variant.Builder resolution(Optional<? extends Resolution> resolution) {
        this.resolution = resolution.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder frameRate(double frameRate) {
        this.frameRate = frameRate;
        return (Variant.Builder)this;
    }

    public final Variant.Builder frameRate(Optional<Double> frameRate) {
        this.frameRate = frameRate.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder hdcpLevel(String hdcpLevel) {
        this.hdcpLevel = Objects.requireNonNull(hdcpLevel, "hdcpLevel");
        return (Variant.Builder)this;
    }

    public final Variant.Builder hdcpLevel(Optional<String> hdcpLevel) {
        this.hdcpLevel = hdcpLevel.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder addAllowedCpc(String element) {
        this.allowedCpc.add(Objects.requireNonNull(element, "allowedCpc element"));
        return (Variant.Builder)this;
    }

    public final Variant.Builder addAllowedCpc(String ... elements) {
        for (String element : elements) {
            this.allowedCpc.add(Objects.requireNonNull(element, "allowedCpc element"));
        }
        return (Variant.Builder)this;
    }

    public final Variant.Builder allowedCpc(Iterable<String> elements) {
        this.allowedCpc.clear();
        return this.addAllAllowedCpc(elements);
    }

    public final Variant.Builder addAllAllowedCpc(Iterable<String> elements) {
        for (String element : elements) {
            this.allowedCpc.add(Objects.requireNonNull(element, "allowedCpc element"));
        }
        return (Variant.Builder)this;
    }

    public final Variant.Builder stableVariantId(String stableVariantId) {
        this.stableVariantId = Objects.requireNonNull(stableVariantId, "stableVariantId");
        return (Variant.Builder)this;
    }

    public final Variant.Builder stableVariantId(Optional<String> stableVariantId) {
        this.stableVariantId = stableVariantId.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder audio(String audio) {
        this.audio = Objects.requireNonNull(audio, "audio");
        return (Variant.Builder)this;
    }

    public final Variant.Builder audio(Optional<String> audio) {
        this.audio = audio.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder video(String video) {
        this.video = Objects.requireNonNull(video, "video");
        return (Variant.Builder)this;
    }

    public final Variant.Builder video(Optional<String> video) {
        this.video = video.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder subtitles(String subtitles) {
        this.subtitles = Objects.requireNonNull(subtitles, "subtitles");
        return (Variant.Builder)this;
    }

    public final Variant.Builder subtitles(Optional<String> subtitles) {
        this.subtitles = subtitles.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder closedCaptions(String closedCaptions) {
        this.closedCaptions = Objects.requireNonNull(closedCaptions, "closedCaptions");
        return (Variant.Builder)this;
    }

    public final Variant.Builder closedCaptions(Optional<String> closedCaptions) {
        this.closedCaptions = closedCaptions.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder closedCaptionsNone(boolean closedCaptionsNone) {
        this.closedCaptionsNone = closedCaptionsNone;
        return (Variant.Builder)this;
    }

    public final Variant.Builder closedCaptionsNone(Optional<Boolean> closedCaptionsNone) {
        this.closedCaptionsNone = closedCaptionsNone.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return (Variant.Builder)this;
    }

    public final Variant.Builder programId(int programId) {
        this.programId = programId;
        return (Variant.Builder)this;
    }

    public final Variant.Builder programId(Optional<Integer> programId) {
        this.programId = programId.orElse(null);
        return (Variant.Builder)this;
    }

    public final Variant.Builder videoRange(VideoRange videoRange) {
        this.videoRange = Objects.requireNonNull(videoRange, "videoRange");
        return (Variant.Builder)this;
    }

    public final Variant.Builder videoRange(Optional<? extends VideoRange> videoRange) {
        this.videoRange = videoRange.orElse(null);
        return (Variant.Builder)this;
    }

    public Variant build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableVariant(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("bandwidth");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("uri");
        }
        return "Cannot build Variant, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static final class ImmutableVariant
    implements Variant {
        private final long bandwidth;
        private final Long averageBandwidth;
        private final Double score;
        private final List<String> codecs;
        private final Resolution resolution;
        private final Double frameRate;
        private final String hdcpLevel;
        private final List<String> allowedCpc;
        private final String stableVariantId;
        private final String audio;
        private final String video;
        private final String subtitles;
        private final String closedCaptions;
        private final Boolean closedCaptionsNone;
        private final String uri;
        private final Integer programId;
        private final VideoRange videoRange;

        private ImmutableVariant(VariantBuilder builder) {
            this.bandwidth = builder.bandwidth;
            this.averageBandwidth = builder.averageBandwidth;
            this.score = builder.score;
            this.codecs = VariantBuilder.createUnmodifiableList(true, builder.codecs);
            this.resolution = builder.resolution;
            this.frameRate = builder.frameRate;
            this.hdcpLevel = builder.hdcpLevel;
            this.allowedCpc = VariantBuilder.createUnmodifiableList(true, builder.allowedCpc);
            this.stableVariantId = builder.stableVariantId;
            this.audio = builder.audio;
            this.video = builder.video;
            this.subtitles = builder.subtitles;
            this.closedCaptions = builder.closedCaptions;
            this.closedCaptionsNone = builder.closedCaptionsNone;
            this.uri = builder.uri;
            this.programId = builder.programId;
            this.videoRange = builder.videoRange;
        }

        @Override
        public long bandwidth() {
            return this.bandwidth;
        }

        @Override
        public Optional<Long> averageBandwidth() {
            return Optional.ofNullable(this.averageBandwidth);
        }

        @Override
        public Optional<Double> score() {
            return Optional.ofNullable(this.score);
        }

        @Override
        public List<String> codecs() {
            return this.codecs;
        }

        @Override
        public Optional<Resolution> resolution() {
            return Optional.ofNullable(this.resolution);
        }

        @Override
        public Optional<Double> frameRate() {
            return Optional.ofNullable(this.frameRate);
        }

        @Override
        public Optional<String> hdcpLevel() {
            return Optional.ofNullable(this.hdcpLevel);
        }

        @Override
        public List<String> allowedCpc() {
            return this.allowedCpc;
        }

        @Override
        public Optional<String> stableVariantId() {
            return Optional.ofNullable(this.stableVariantId);
        }

        @Override
        public Optional<String> audio() {
            return Optional.ofNullable(this.audio);
        }

        @Override
        public Optional<String> video() {
            return Optional.ofNullable(this.video);
        }

        @Override
        public Optional<String> subtitles() {
            return Optional.ofNullable(this.subtitles);
        }

        @Override
        public Optional<String> closedCaptions() {
            return Optional.ofNullable(this.closedCaptions);
        }

        @Override
        public Optional<Boolean> closedCaptionsNone() {
            return Optional.ofNullable(this.closedCaptionsNone);
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public Optional<Integer> programId() {
            return Optional.ofNullable(this.programId);
        }

        @Override
        public Optional<VideoRange> videoRange() {
            return Optional.ofNullable(this.videoRange);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableVariant && this.equalTo((ImmutableVariant)another);
        }

        private boolean equalTo(ImmutableVariant another) {
            return this.bandwidth == another.bandwidth && Objects.equals(this.averageBandwidth, another.averageBandwidth) && Objects.equals(this.score, another.score) && this.codecs.equals(another.codecs) && Objects.equals(this.resolution, another.resolution) && Objects.equals(this.frameRate, another.frameRate) && Objects.equals(this.hdcpLevel, another.hdcpLevel) && this.allowedCpc.equals(another.allowedCpc) && Objects.equals(this.stableVariantId, another.stableVariantId) && Objects.equals(this.audio, another.audio) && Objects.equals(this.video, another.video) && Objects.equals(this.subtitles, another.subtitles) && Objects.equals(this.closedCaptions, another.closedCaptions) && Objects.equals(this.closedCaptionsNone, another.closedCaptionsNone) && this.uri.equals(another.uri) && Objects.equals(this.programId, another.programId) && Objects.equals((Object)this.videoRange, (Object)another.videoRange);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Long.hashCode(this.bandwidth);
            h += (h << 5) + Objects.hashCode(this.averageBandwidth);
            h += (h << 5) + Objects.hashCode(this.score);
            h += (h << 5) + this.codecs.hashCode();
            h += (h << 5) + Objects.hashCode(this.resolution);
            h += (h << 5) + Objects.hashCode(this.frameRate);
            h += (h << 5) + Objects.hashCode(this.hdcpLevel);
            h += (h << 5) + this.allowedCpc.hashCode();
            h += (h << 5) + Objects.hashCode(this.stableVariantId);
            h += (h << 5) + Objects.hashCode(this.audio);
            h += (h << 5) + Objects.hashCode(this.video);
            h += (h << 5) + Objects.hashCode(this.subtitles);
            h += (h << 5) + Objects.hashCode(this.closedCaptions);
            h += (h << 5) + Objects.hashCode(this.closedCaptionsNone);
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Objects.hashCode(this.programId);
            h += (h << 5) + Objects.hashCode((Object)this.videoRange);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Variant{");
            builder.append("bandwidth=").append(this.bandwidth);
            if (this.averageBandwidth != null) {
                builder.append(", ");
                builder.append("averageBandwidth=").append(this.averageBandwidth);
            }
            if (this.score != null) {
                builder.append(", ");
                builder.append("score=").append(this.score);
            }
            builder.append(", ");
            builder.append("codecs=").append(this.codecs);
            if (this.resolution != null) {
                builder.append(", ");
                builder.append("resolution=").append(this.resolution);
            }
            if (this.frameRate != null) {
                builder.append(", ");
                builder.append("frameRate=").append(this.frameRate);
            }
            if (this.hdcpLevel != null) {
                builder.append(", ");
                builder.append("hdcpLevel=").append(this.hdcpLevel);
            }
            builder.append(", ");
            builder.append("allowedCpc=").append(this.allowedCpc);
            if (this.stableVariantId != null) {
                builder.append(", ");
                builder.append("stableVariantId=").append(this.stableVariantId);
            }
            if (this.audio != null) {
                builder.append(", ");
                builder.append("audio=").append(this.audio);
            }
            if (this.video != null) {
                builder.append(", ");
                builder.append("video=").append(this.video);
            }
            if (this.subtitles != null) {
                builder.append(", ");
                builder.append("subtitles=").append(this.subtitles);
            }
            if (this.closedCaptions != null) {
                builder.append(", ");
                builder.append("closedCaptions=").append(this.closedCaptions);
            }
            if (this.closedCaptionsNone != null) {
                builder.append(", ");
                builder.append("closedCaptionsNone=").append(this.closedCaptionsNone);
            }
            builder.append(", ");
            builder.append("uri=").append(this.uri);
            if (this.programId != null) {
                builder.append(", ");
                builder.append("programId=").append(this.programId);
            }
            if (this.videoRange != null) {
                builder.append(", ");
                builder.append("videoRange=").append((Object)this.videoRange);
            }
            return builder.append("}").toString();
        }
    }
}

