/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.DateRange;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class DateRangeBuilder {
    private static final long INIT_BIT_ID = 1L;
    private static final long INIT_BIT_START_DATE = 2L;
    private static final long OPT_BIT_END_ON_NEXT = 1L;
    private long initBits = 3L;
    private long optBits;
    private String id;
    private String classAttribute;
    private OffsetDateTime startDate;
    private OffsetDateTime endDate;
    private Double duration;
    private Double plannedDuration;
    private Map<String, String> clientAttributes = new LinkedHashMap<String, String>();
    private String scte35Cmd;
    private String scte35Out;
    private String scte35In;
    private boolean endOnNext;

    DateRangeBuilder() {
        if (!(this instanceof DateRange.Builder)) {
            throw new UnsupportedOperationException("Use: new DateRange.Builder()");
        }
    }

    public final DateRange.Builder from(DateRange instance) {
        Optional<String> scte35InOptional;
        Optional<String> scte35OutOptional;
        Optional<Double> plannedDurationOptional;
        Optional<Double> durationOptional;
        Objects.requireNonNull(instance, "instance");
        this.id(instance.id());
        Optional<String> classAttributeOptional = instance.classAttribute();
        if (classAttributeOptional.isPresent()) {
            this.classAttribute(classAttributeOptional);
        }
        this.startDate(instance.startDate());
        Optional<OffsetDateTime> endDateOptional = instance.endDate();
        if (endDateOptional.isPresent()) {
            this.endDate(endDateOptional);
        }
        if ((durationOptional = instance.duration()).isPresent()) {
            this.duration(durationOptional);
        }
        if ((plannedDurationOptional = instance.plannedDuration()).isPresent()) {
            this.plannedDuration(plannedDurationOptional);
        }
        this.putAllClientAttributes(instance.clientAttributes());
        Optional<String> scte35CmdOptional = instance.scte35Cmd();
        if (scte35CmdOptional.isPresent()) {
            this.scte35Cmd(scte35CmdOptional);
        }
        if ((scte35OutOptional = instance.scte35Out()).isPresent()) {
            this.scte35Out(scte35OutOptional);
        }
        if ((scte35InOptional = instance.scte35In()).isPresent()) {
            this.scte35In(scte35InOptional);
        }
        this.endOnNext(instance.endOnNext());
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder id(String id) {
        this.id = Objects.requireNonNull(id, "id");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder classAttribute(String classAttribute) {
        this.classAttribute = Objects.requireNonNull(classAttribute, "classAttribute");
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder classAttribute(Optional<String> classAttribute) {
        this.classAttribute = classAttribute.orElse(null);
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder startDate(OffsetDateTime startDate) {
        this.startDate = Objects.requireNonNull(startDate, "startDate");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder endDate(OffsetDateTime endDate) {
        this.endDate = Objects.requireNonNull(endDate, "endDate");
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder endDate(Optional<? extends OffsetDateTime> endDate) {
        this.endDate = endDate.orElse(null);
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder duration(double duration) {
        this.duration = duration;
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder duration(Optional<Double> duration) {
        this.duration = duration.orElse(null);
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder plannedDuration(double plannedDuration) {
        this.plannedDuration = plannedDuration;
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder plannedDuration(Optional<Double> plannedDuration) {
        this.plannedDuration = plannedDuration.orElse(null);
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder putClientAttributes(String key, String value) {
        this.clientAttributes.put(Objects.requireNonNull(key, "clientAttributes key"), Objects.requireNonNull(value, "clientAttributes value"));
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder putClientAttributes(Map.Entry<String, ? extends String> entry) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.clientAttributes.put(Objects.requireNonNull(k, "clientAttributes key"), Objects.requireNonNull(v, "clientAttributes value"));
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder clientAttributes(Map<String, ? extends String> clientAttributes) {
        this.clientAttributes.clear();
        return this.putAllClientAttributes(clientAttributes);
    }

    public final DateRange.Builder putAllClientAttributes(Map<String, ? extends String> clientAttributes) {
        for (Map.Entry<String, ? extends String> entry : clientAttributes.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.clientAttributes.put(Objects.requireNonNull(k, "clientAttributes key"), Objects.requireNonNull(v, "clientAttributes value"));
        }
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder scte35Cmd(String scte35Cmd) {
        this.scte35Cmd = Objects.requireNonNull(scte35Cmd, "scte35Cmd");
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder scte35Cmd(Optional<String> scte35Cmd) {
        this.scte35Cmd = scte35Cmd.orElse(null);
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder scte35Out(String scte35Out) {
        this.scte35Out = Objects.requireNonNull(scte35Out, "scte35Out");
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder scte35Out(Optional<String> scte35Out) {
        this.scte35Out = scte35Out.orElse(null);
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder scte35In(String scte35In) {
        this.scte35In = Objects.requireNonNull(scte35In, "scte35In");
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder scte35In(Optional<String> scte35In) {
        this.scte35In = scte35In.orElse(null);
        return (DateRange.Builder)this;
    }

    public final DateRange.Builder endOnNext(boolean endOnNext) {
        this.endOnNext = endOnNext;
        this.optBits |= 1L;
        return (DateRange.Builder)this;
    }

    public DateRange build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableDateRange(this);
    }

    private boolean endOnNextIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("id");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("startDate");
        }
        return "Cannot build DateRange, some of required attributes are not set " + attributes;
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    private static final class ImmutableDateRange
    implements DateRange {
        private final String id;
        private final String classAttribute;
        private final OffsetDateTime startDate;
        private final OffsetDateTime endDate;
        private final Double duration;
        private final Double plannedDuration;
        private final Map<String, String> clientAttributes;
        private final String scte35Cmd;
        private final String scte35Out;
        private final String scte35In;
        private final boolean endOnNext;

        private ImmutableDateRange(DateRangeBuilder builder) {
            this.id = builder.id;
            this.classAttribute = builder.classAttribute;
            this.startDate = builder.startDate;
            this.endDate = builder.endDate;
            this.duration = builder.duration;
            this.plannedDuration = builder.plannedDuration;
            this.clientAttributes = DateRangeBuilder.createUnmodifiableMap(false, false, builder.clientAttributes);
            this.scte35Cmd = builder.scte35Cmd;
            this.scte35Out = builder.scte35Out;
            this.scte35In = builder.scte35In;
            this.endOnNext = builder.endOnNextIsSet() ? builder.endOnNext : DateRange.super.endOnNext();
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Optional<String> classAttribute() {
            return Optional.ofNullable(this.classAttribute);
        }

        @Override
        public OffsetDateTime startDate() {
            return this.startDate;
        }

        @Override
        public Optional<OffsetDateTime> endDate() {
            return Optional.ofNullable(this.endDate);
        }

        @Override
        public Optional<Double> duration() {
            return Optional.ofNullable(this.duration);
        }

        @Override
        public Optional<Double> plannedDuration() {
            return Optional.ofNullable(this.plannedDuration);
        }

        @Override
        public Map<String, String> clientAttributes() {
            return this.clientAttributes;
        }

        @Override
        public Optional<String> scte35Cmd() {
            return Optional.ofNullable(this.scte35Cmd);
        }

        @Override
        public Optional<String> scte35Out() {
            return Optional.ofNullable(this.scte35Out);
        }

        @Override
        public Optional<String> scte35In() {
            return Optional.ofNullable(this.scte35In);
        }

        @Override
        public boolean endOnNext() {
            return this.endOnNext;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableDateRange && this.equalTo((ImmutableDateRange)another);
        }

        private boolean equalTo(ImmutableDateRange another) {
            return this.id.equals(another.id) && Objects.equals(this.classAttribute, another.classAttribute) && this.startDate.equals(another.startDate) && Objects.equals(this.endDate, another.endDate) && Objects.equals(this.duration, another.duration) && Objects.equals(this.plannedDuration, another.plannedDuration) && this.clientAttributes.equals(another.clientAttributes) && Objects.equals(this.scte35Cmd, another.scte35Cmd) && Objects.equals(this.scte35Out, another.scte35Out) && Objects.equals(this.scte35In, another.scte35In) && this.endOnNext == another.endOnNext;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.id.hashCode();
            h += (h << 5) + Objects.hashCode(this.classAttribute);
            h += (h << 5) + this.startDate.hashCode();
            h += (h << 5) + Objects.hashCode(this.endDate);
            h += (h << 5) + Objects.hashCode(this.duration);
            h += (h << 5) + Objects.hashCode(this.plannedDuration);
            h += (h << 5) + this.clientAttributes.hashCode();
            h += (h << 5) + Objects.hashCode(this.scte35Cmd);
            h += (h << 5) + Objects.hashCode(this.scte35Out);
            h += (h << 5) + Objects.hashCode(this.scte35In);
            h += (h << 5) + Boolean.hashCode(this.endOnNext);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("DateRange{");
            builder.append("id=").append(this.id);
            if (this.classAttribute != null) {
                builder.append(", ");
                builder.append("classAttribute=").append(this.classAttribute);
            }
            builder.append(", ");
            builder.append("startDate=").append(this.startDate);
            if (this.endDate != null) {
                builder.append(", ");
                builder.append("endDate=").append(this.endDate);
            }
            if (this.duration != null) {
                builder.append(", ");
                builder.append("duration=").append(this.duration);
            }
            if (this.plannedDuration != null) {
                builder.append(", ");
                builder.append("plannedDuration=").append(this.plannedDuration);
            }
            builder.append(", ");
            builder.append("clientAttributes=").append(this.clientAttributes);
            if (this.scte35Cmd != null) {
                builder.append(", ");
                builder.append("scte35Cmd=").append(this.scte35Cmd);
            }
            if (this.scte35Out != null) {
                builder.append(", ");
                builder.append("scte35Out=").append(this.scte35Out);
            }
            if (this.scte35In != null) {
                builder.append(", ");
                builder.append("scte35In=").append(this.scte35In);
            }
            builder.append(", ");
            builder.append("endOnNext=").append(this.endOnNext);
            return builder.append("}").toString();
        }
    }
}

