/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.Variant;
import io.lindstrom.m3u8.parser.Attribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Map;

enum VariantAttribute implements Attribute<Variant, Variant.Builder>
{
    BANDWIDTH{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.bandwidth(Long.parseLong(value));
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            textBuilder.add(this.name(), String.valueOf(value.bandwidth()));
        }
    }
    ,
    AVERAGE_BANDWIDTH{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.averageBandwidth(Long.parseLong(value));
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.averageBandwidth().ifPresent(v -> textBuilder.add(this.key(), String.valueOf(v)));
        }
    }
    ,
    SCORE{

        @Override
        public void read(Variant.Builder builder, String value) throws PlaylistParserException {
            builder.score(Double.parseDouble(value));
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.score().ifPresent(v -> textBuilder.add(this.key(), (double)v));
        }
    }
    ,
    CODECS{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.codecs(ParserUtils.split(value, ","));
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            if (!value.codecs().isEmpty()) {
                textBuilder.addQuoted(this.name(), String.join((CharSequence)",", value.codecs()));
            }
        }
    }
    ,
    RESOLUTION{

        @Override
        public void read(Variant.Builder builder, String value) throws PlaylistParserException {
            builder.resolution(ParserUtils.parseResolution(value));
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.resolution().ifPresent(v -> textBuilder.add(this.name(), ParserUtils.writeResolution(v)));
        }
    }
    ,
    FRAME_RATE{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.frameRate(Double.parseDouble(value));
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.frameRate().ifPresent(v -> textBuilder.add(this.key(), Double.toString(v)));
        }
    }
    ,
    HDCP_LEVEL{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.hdcpLevel(value);
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.hdcpLevel().ifPresent(v -> textBuilder.add(this.key(), (String)v));
        }
    }
    ,
    ALLOWED_CPC{

        @Override
        public void read(Variant.Builder builder, String value) throws PlaylistParserException {
            builder.allowedCpc(ParserUtils.split(value, ","));
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            if (!value.allowedCpc().isEmpty()) {
                textBuilder.addQuoted(this.key(), String.join((CharSequence)",", value.allowedCpc()));
            }
        }
    }
    ,
    STABLE_VARIANT_ID{

        @Override
        public void read(Variant.Builder builder, String value) throws PlaylistParserException {
            builder.stableVariantId(value);
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.stableVariantId().ifPresent(v -> textBuilder.addQuoted(this.key(), (String)v));
        }
    }
    ,
    AUDIO{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.audio(value);
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.audio().ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    }
    ,
    VIDEO{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.video(value);
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.video().ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    }
    ,
    SUBTITLES{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.subtitles(value);
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.subtitles().ifPresent(v -> textBuilder.addQuoted(this.name(), (String)v));
        }
    }
    ,
    CLOSED_CAPTIONS{
        private static final String NONE = "NONE";

        @Override
        public void read(Variant.Builder builder, String value) {
            if (value.equals(NONE)) {
                builder.closedCaptionsNone(true);
            } else {
                builder.closedCaptions(value);
            }
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            if (value.closedCaptionsNone().orElse(false).booleanValue()) {
                textBuilder.add(this.key(), NONE);
            } else {
                value.closedCaptions().ifPresent(v -> textBuilder.addQuoted(this.key(), (String)v));
            }
        }
    }
    ,
    PROGRAM_ID{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.programId(Integer.parseInt(value));
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.programId().ifPresent(v -> textBuilder.add(this.key(), Integer.toString(v)));
        }
    }
    ,
    VIDEO_RANGE{

        @Override
        public void read(Variant.Builder builder, String value) {
            builder.videoRange(value);
        }

        @Override
        public void write(Variant value, TextBuilder textBuilder) {
            value.videoRange().ifPresent(v -> textBuilder.add(this.key(), (Enum<?>)v));
        }
    };

    static final Map<String, VariantAttribute> attributeMap;

    static Variant parse(String attributes, String uri, ParsingMode parsingMode) throws PlaylistParserException {
        Variant.Builder builder = Variant.builder();
        ParserUtils.readAttributes(attributeMap, attributes, builder, parsingMode);
        builder.uri(uri);
        return builder.build();
    }

    static {
        attributeMap = ParserUtils.toMap(VariantAttribute.values(), Attribute::key);
    }
}

