/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.PlaylistVariable;
import java.util.Objects;
import java.util.Optional;

class PlaylistVariableBuilder {
    private String name;
    private String value;
    private String importAttribute;

    PlaylistVariableBuilder() {
        if (!(this instanceof PlaylistVariable.Builder)) {
            throw new UnsupportedOperationException("Use: new PlaylistVariable.Builder()");
        }
    }

    public final PlaylistVariable.Builder from(PlaylistVariable instance) {
        Optional<String> importAttributeOptional;
        Optional<String> valueOptional;
        Objects.requireNonNull(instance, "instance");
        Optional<String> nameOptional = instance.name();
        if (nameOptional.isPresent()) {
            this.name(nameOptional);
        }
        if ((valueOptional = instance.value()).isPresent()) {
            this.value(valueOptional);
        }
        if ((importAttributeOptional = instance.importAttribute()).isPresent()) {
            this.importAttribute(importAttributeOptional);
        }
        return (PlaylistVariable.Builder)this;
    }

    public final PlaylistVariable.Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        return (PlaylistVariable.Builder)this;
    }

    public final PlaylistVariable.Builder name(Optional<String> name) {
        this.name = name.orElse(null);
        return (PlaylistVariable.Builder)this;
    }

    public final PlaylistVariable.Builder value(String value) {
        this.value = Objects.requireNonNull(value, "value");
        return (PlaylistVariable.Builder)this;
    }

    public final PlaylistVariable.Builder value(Optional<String> value) {
        this.value = value.orElse(null);
        return (PlaylistVariable.Builder)this;
    }

    public final PlaylistVariable.Builder importAttribute(String importAttribute) {
        this.importAttribute = Objects.requireNonNull(importAttribute, "importAttribute");
        return (PlaylistVariable.Builder)this;
    }

    public final PlaylistVariable.Builder importAttribute(Optional<String> importAttribute) {
        this.importAttribute = importAttribute.orElse(null);
        return (PlaylistVariable.Builder)this;
    }

    public PlaylistVariable build() {
        return new ImmutablePlaylistVariable(this);
    }

    private static final class ImmutablePlaylistVariable
    implements PlaylistVariable {
        private final String name;
        private final String value;
        private final String importAttribute;

        private ImmutablePlaylistVariable(PlaylistVariableBuilder builder) {
            this.name = builder.name;
            this.value = builder.value;
            this.importAttribute = builder.importAttribute;
        }

        @Override
        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        @Override
        public Optional<String> value() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public Optional<String> importAttribute() {
            return Optional.ofNullable(this.importAttribute);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutablePlaylistVariable && this.equalTo((ImmutablePlaylistVariable)another);
        }

        private boolean equalTo(ImmutablePlaylistVariable another) {
            return Objects.equals(this.name, another.name) && Objects.equals(this.value, another.value) && Objects.equals(this.importAttribute, another.importAttribute);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.name);
            h += (h << 5) + Objects.hashCode(this.value);
            h += (h << 5) + Objects.hashCode(this.importAttribute);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PlaylistVariable{");
            if (this.name != null) {
                builder.append("name=").append(this.name);
            }
            if (this.value != null) {
                if (builder.length() > 17) {
                    builder.append(", ");
                }
                builder.append("value=").append(this.value);
            }
            if (this.importAttribute != null) {
                if (builder.length() > 17) {
                    builder.append(", ");
                }
                builder.append("importAttribute=").append(this.importAttribute);
            }
            return builder.append("}").toString();
        }
    }
}

