package io.lindstrom.m3u8.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Builds instances of type {@link MasterPlaylist MasterPlaylist}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code MasterPlaylistBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "MasterPlaylist"})
class MasterPlaylistBuilder {
  private static final long INIT_BIT_VERSION = 0x1L;
  private static final long OPT_BIT_INDEPENDENT_SEGMENTS = 0x1L;
  private long initBits = 0x1L;
  private long optBits;

  private List<AlternativeRendition> alternativeRenditions = new ArrayList<AlternativeRendition>();
  private List<VariantStream> variantStreams = new ArrayList<VariantStream>();
  private List<IFramePlaylist> iFramePlaylists = new ArrayList<IFramePlaylist>();
  private int version;
  private boolean independentSegments;

  /**
   * Creates a builder for {@link MasterPlaylist MasterPlaylist} instances.
   */
  MasterPlaylistBuilder() {
    if (!(this instanceof MasterPlaylist.Builder)) {
      throw new UnsupportedOperationException("Use: new MasterPlaylist.Builder()");
    }
  }

  /**
   * Fill a builder with attribute values from the provided {@code io.lindstrom.m3u8.model.Playlist} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder from(Playlist instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Fill a builder with attribute values from the provided {@code io.lindstrom.m3u8.model.MasterPlaylist} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder from(MasterPlaylist instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return (MasterPlaylist.Builder) this;
  }

  private void from(Object object) {
    if (object instanceof Playlist) {
      Playlist instance = (Playlist) object;
      independentSegments(instance.independentSegments());
      version(instance.version());
    }
    if (object instanceof MasterPlaylist) {
      MasterPlaylist instance = (MasterPlaylist) object;
      addAllVariantStreams(instance.variantStreams());
      addAllAlternativeRenditions(instance.alternativeRenditions());
      addAllIFramePlaylists(instance.iFramePlaylists());
    }
  }

  /**
   * Adds one element to {@link MasterPlaylist#alternativeRenditions() alternativeRenditions} list.
   * @param element A alternativeRenditions element
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder addAlternativeRenditions(AlternativeRendition element) {
    this.alternativeRenditions.add(Objects.requireNonNull(element, "alternativeRenditions element"));
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Adds elements to {@link MasterPlaylist#alternativeRenditions() alternativeRenditions} list.
   * @param elements An array of alternativeRenditions elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder addAlternativeRenditions(AlternativeRendition... elements) {
    for (AlternativeRendition element : elements) {
      this.alternativeRenditions.add(Objects.requireNonNull(element, "alternativeRenditions element"));
    }
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Sets or replaces all elements for {@link MasterPlaylist#alternativeRenditions() alternativeRenditions} list.
   * @param elements An iterable of alternativeRenditions elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder alternativeRenditions(Iterable<? extends AlternativeRendition> elements) {
    this.alternativeRenditions.clear();
    return addAllAlternativeRenditions(elements);
  }

  /**
   * Adds elements to {@link MasterPlaylist#alternativeRenditions() alternativeRenditions} list.
   * @param elements An iterable of alternativeRenditions elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder addAllAlternativeRenditions(Iterable<? extends AlternativeRendition> elements) {
    for (AlternativeRendition element : elements) {
      this.alternativeRenditions.add(Objects.requireNonNull(element, "alternativeRenditions element"));
    }
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Adds one element to {@link MasterPlaylist#variantStreams() variantStreams} list.
   * @param element A variantStreams element
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder addVariantStreams(VariantStream element) {
    this.variantStreams.add(Objects.requireNonNull(element, "variantStreams element"));
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Adds elements to {@link MasterPlaylist#variantStreams() variantStreams} list.
   * @param elements An array of variantStreams elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder addVariantStreams(VariantStream... elements) {
    for (VariantStream element : elements) {
      this.variantStreams.add(Objects.requireNonNull(element, "variantStreams element"));
    }
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Sets or replaces all elements for {@link MasterPlaylist#variantStreams() variantStreams} list.
   * @param elements An iterable of variantStreams elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder variantStreams(Iterable<? extends VariantStream> elements) {
    this.variantStreams.clear();
    return addAllVariantStreams(elements);
  }

  /**
   * Adds elements to {@link MasterPlaylist#variantStreams() variantStreams} list.
   * @param elements An iterable of variantStreams elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder addAllVariantStreams(Iterable<? extends VariantStream> elements) {
    for (VariantStream element : elements) {
      this.variantStreams.add(Objects.requireNonNull(element, "variantStreams element"));
    }
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Adds one element to {@link MasterPlaylist#iFramePlaylists() iFramePlaylists} list.
   * @param element A iFramePlaylists element
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder addIFramePlaylists(IFramePlaylist element) {
    this.iFramePlaylists.add(Objects.requireNonNull(element, "iFramePlaylists element"));
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Adds elements to {@link MasterPlaylist#iFramePlaylists() iFramePlaylists} list.
   * @param elements An array of iFramePlaylists elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder addIFramePlaylists(IFramePlaylist... elements) {
    for (IFramePlaylist element : elements) {
      this.iFramePlaylists.add(Objects.requireNonNull(element, "iFramePlaylists element"));
    }
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Sets or replaces all elements for {@link MasterPlaylist#iFramePlaylists() iFramePlaylists} list.
   * @param elements An iterable of iFramePlaylists elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder iFramePlaylists(Iterable<? extends IFramePlaylist> elements) {
    this.iFramePlaylists.clear();
    return addAllIFramePlaylists(elements);
  }

  /**
   * Adds elements to {@link MasterPlaylist#iFramePlaylists() iFramePlaylists} list.
   * @param elements An iterable of iFramePlaylists elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder addAllIFramePlaylists(Iterable<? extends IFramePlaylist> elements) {
    for (IFramePlaylist element : elements) {
      this.iFramePlaylists.add(Objects.requireNonNull(element, "iFramePlaylists element"));
    }
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Initializes the value for the {@link MasterPlaylist#version() version} attribute.
   * @param version The value for version 
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder version(int version) {
    this.version = version;
    initBits &= ~INIT_BIT_VERSION;
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Initializes the value for the {@link MasterPlaylist#independentSegments() independentSegments} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MasterPlaylist#independentSegments() independentSegments}.</em>
   * @param independentSegments The value for independentSegments 
   * @return {@code this} builder for use in a chained invocation
   */
  public final MasterPlaylist.Builder independentSegments(boolean independentSegments) {
    this.independentSegments = independentSegments;
    optBits |= OPT_BIT_INDEPENDENT_SEGMENTS;
    return (MasterPlaylist.Builder) this;
  }

  /**
   * Builds a new {@link MasterPlaylist MasterPlaylist}.
   * @return An immutable instance of MasterPlaylist
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public MasterPlaylist build() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
    return new MasterPlaylistBuilder.ImmutableMasterPlaylist(this);
  }

  private boolean independentSegmentsIsSet() {
    return (optBits & OPT_BIT_INDEPENDENT_SEGMENTS) != 0;
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<String>();
    if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
    return "Cannot build MasterPlaylist, some of required attributes are not set " + attributes;
  }

  /**
   * Immutable implementation of {@link MasterPlaylist}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new MasterPlaylist.Builder()}.
   */
  private static final class ImmutableMasterPlaylist implements MasterPlaylist {
    private final List<AlternativeRendition> alternativeRenditions;
    private final List<VariantStream> variantStreams;
    private final List<IFramePlaylist> iFramePlaylists;
    private final int version;
    private final boolean independentSegments;

    private ImmutableMasterPlaylist(MasterPlaylistBuilder builder) {
      this.alternativeRenditions = createUnmodifiableList(true, builder.alternativeRenditions);
      this.variantStreams = createUnmodifiableList(true, builder.variantStreams);
      this.iFramePlaylists = createUnmodifiableList(true, builder.iFramePlaylists);
      this.version = builder.version;
      this.independentSegments = builder.independentSegmentsIsSet()
          ? builder.independentSegments
          : MasterPlaylist.super.independentSegments();
    }

    /**
     * @return The value of the {@code alternativeRenditions} attribute
     */
    @Override
    public List<AlternativeRendition> alternativeRenditions() {
      return alternativeRenditions;
    }

    /**
     * @return The value of the {@code variantStreams} attribute
     */
    @Override
    public List<VariantStream> variantStreams() {
      return variantStreams;
    }

    /**
     * @return The value of the {@code iFramePlaylists} attribute
     */
    @Override
    public List<IFramePlaylist> iFramePlaylists() {
      return iFramePlaylists;
    }

    /**
     * @return The value of the {@code version} attribute
     */
    @Override
    public int version() {
      return version;
    }

    /**
     * @return The value of the {@code independentSegments} attribute
     */
    @Override
    public boolean independentSegments() {
      return independentSegments;
    }

    /**
     * This instance is equal to all instances of {@code ImmutableMasterPlaylist} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof MasterPlaylistBuilder.ImmutableMasterPlaylist
          && equalTo((MasterPlaylistBuilder.ImmutableMasterPlaylist) another);
    }

    private boolean equalTo(MasterPlaylistBuilder.ImmutableMasterPlaylist another) {
      return alternativeRenditions.equals(another.alternativeRenditions)
          && variantStreams.equals(another.variantStreams)
          && iFramePlaylists.equals(another.iFramePlaylists)
          && version == another.version
          && independentSegments == another.independentSegments;
    }

    /**
     * Computes a hash code from attributes: {@code alternativeRenditions}, {@code variantStreams}, {@code iFramePlaylists}, {@code version}, {@code independentSegments}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + alternativeRenditions.hashCode();
      h += (h << 5) + variantStreams.hashCode();
      h += (h << 5) + iFramePlaylists.hashCode();
      h += (h << 5) + version;
      h += (h << 5) + Boolean.hashCode(independentSegments);
      return h;
    }

    /**
     * Prints the immutable value {@code MasterPlaylist} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "MasterPlaylist{"
          + "alternativeRenditions=" + alternativeRenditions
          + ", variantStreams=" + variantStreams
          + ", iFramePlaylists=" + iFramePlaylists
          + ", version=" + version
          + ", independentSegments=" + independentSegments
          + "}";
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
