/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.lindstrom.mpd.data.BaseURL;
import io.lindstrom.mpd.data.EventStream;
import io.lindstrom.mpd.data.FrameRate;
import io.lindstrom.mpd.data.Ratio;
import io.lindstrom.mpd.data.RepresentationBase;
import io.lindstrom.mpd.data.SegmentBase;
import io.lindstrom.mpd.data.SegmentList;
import io.lindstrom.mpd.data.SegmentTemplate;
import io.lindstrom.mpd.data.SubRepresentation;
import io.lindstrom.mpd.data.VideoScanType;
import io.lindstrom.mpd.data.descriptor.Descriptor;
import io.lindstrom.mpd.support.Utils;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "bandwidth", "width", "height", "codecs", "framePackings", "audioChannelConfigurations", "contentProtections", "essentialProperties", "supplementalProperties", "inbandEventStreams", "baseURLs", "SubRepresentation", "segmentBase", "segmentList", "segmentTemplate"})
public class Representation
extends RepresentationBase {
    @JacksonXmlProperty(localName="BaseURL", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<BaseURL> baseURLs;
    @JacksonXmlProperty(localName="SubRepresentation", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<SubRepresentation> subRepresentations;
    @JacksonXmlProperty(localName="SegmentBase", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final SegmentBase segmentBase;
    @JacksonXmlProperty(localName="SegmentList", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final SegmentList segmentList;
    @JacksonXmlProperty(localName="SegmentTemplate", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final SegmentTemplate segmentTemplate;
    @JacksonXmlProperty(isAttribute=true)
    private final String id;
    @JacksonXmlProperty(isAttribute=true)
    private final long bandwidth;
    @JacksonXmlProperty(isAttribute=true)
    private final Long qualityRanking;
    @JacksonXmlProperty(isAttribute=true)
    private final String dependencyId;
    @JacksonXmlProperty(isAttribute=true)
    private final String mediaStreamStructureId;

    private Representation(List<Descriptor> framePackings, List<Descriptor> audioChannelConfigurations, List<Descriptor> contentProtections, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties, List<EventStream> inbandEventStreams, String profiles, Long width, Long height, Ratio sar, FrameRate frameRate, String audioSamplingRate, String mimeType, String segmentProfiles, String codecs, Double maximumSAPPeriod, Long startWithSAP, Double maxPlayoutRate, Boolean codingDependency, VideoScanType scanType, List<BaseURL> baseURLs, List<SubRepresentation> subRepresentations, SegmentBase segmentBase, SegmentList segmentList, SegmentTemplate segmentTemplate, String id, long bandwidth, Long qualityRanking, String dependencyId, String mediaStreamStructureId) {
        super(framePackings, audioChannelConfigurations, contentProtections, essentialProperties, supplementalProperties, inbandEventStreams, profiles, width, height, sar, frameRate, audioSamplingRate, mimeType, segmentProfiles, codecs, maximumSAPPeriod, startWithSAP, maxPlayoutRate, codingDependency, scanType);
        this.baseURLs = baseURLs;
        this.subRepresentations = subRepresentations;
        this.segmentBase = segmentBase;
        this.segmentList = segmentList;
        this.segmentTemplate = segmentTemplate;
        this.id = id;
        this.bandwidth = bandwidth;
        this.qualityRanking = qualityRanking;
        this.dependencyId = dependencyId;
        this.mediaStreamStructureId = mediaStreamStructureId;
    }

    private Representation() {
        this.baseURLs = null;
        this.subRepresentations = null;
        this.segmentBase = null;
        this.segmentList = null;
        this.segmentTemplate = null;
        this.id = null;
        this.bandwidth = 0L;
        this.qualityRanking = null;
        this.dependencyId = null;
        this.mediaStreamStructureId = null;
    }

    public List<BaseURL> getBaseURLs() {
        return Utils.unmodifiableList(this.baseURLs);
    }

    public List<SubRepresentation> getSubRepresentations() {
        return Utils.unmodifiableList(this.subRepresentations);
    }

    public SegmentBase getSegmentBase() {
        return this.segmentBase;
    }

    public SegmentList getSegmentList() {
        return this.segmentList;
    }

    public SegmentTemplate getSegmentTemplate() {
        return this.segmentTemplate;
    }

    public String getId() {
        return this.id;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public Long getQualityRanking() {
        return this.qualityRanking;
    }

    public String getDependencyId() {
        return this.dependencyId;
    }

    public String getMediaStreamStructureId() {
        return this.mediaStreamStructureId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Representation that = (Representation)o;
        return this.bandwidth == that.bandwidth && Objects.equals(this.baseURLs, that.baseURLs) && Objects.equals(this.subRepresentations, that.subRepresentations) && Objects.equals(this.segmentBase, that.segmentBase) && Objects.equals(this.segmentList, that.segmentList) && Objects.equals(this.segmentTemplate, that.segmentTemplate) && Objects.equals(this.id, that.id) && Objects.equals(this.qualityRanking, that.qualityRanking) && Objects.equals(this.dependencyId, that.dependencyId) && Objects.equals(this.mediaStreamStructureId, that.mediaStreamStructureId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.baseURLs, this.subRepresentations, this.segmentBase, this.segmentList, this.segmentTemplate, this.id, this.bandwidth, this.qualityRanking, this.dependencyId, this.mediaStreamStructureId);
    }

    @Override
    public String toString() {
        return "Representation{super=" + super.toString() + ", baseURLs=" + this.baseURLs + ", subRepresentations=" + this.subRepresentations + ", segmentBase=" + this.segmentBase + ", segmentList=" + this.segmentList + ", segmentTemplate=" + this.segmentTemplate + ", id='" + this.id + "', bandwidth=" + this.bandwidth + ", qualityRanking=" + this.qualityRanking + ", dependencyId=" + this.dependencyId + ", mediaStreamStructureId=" + this.mediaStreamStructureId + "}";
    }

    public Builder buildUpon() {
        return this.buildUpon(new Builder().withBaseURLs(this.baseURLs).withSubRepresentations(this.subRepresentations).withSegmentBase(this.segmentBase).withSegmentList(this.segmentList).withSegmentTemplate(this.segmentTemplate).withId(this.id).withBandwidth(this.bandwidth).withQualityRanking(this.qualityRanking).withDependencyId(this.dependencyId).withMediaStreamStructureId(this.mediaStreamStructureId));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends RepresentationBase.AbstractBuilder<Builder> {
        private List<BaseURL> baseURLs;
        private List<SubRepresentation> subRepresentations;
        private SegmentBase segmentBase;
        private SegmentList segmentList;
        private SegmentTemplate segmentTemplate;
        private String id;
        private long bandwidth;
        private Long qualityRanking;
        private String dependencyId;
        private String mediaStreamStructureId;

        @Override
        Builder getThis() {
            return this;
        }

        public Builder withBaseURLs(List<BaseURL> baseURLs) {
            this.baseURLs = baseURLs;
            return this;
        }

        public Builder withSubRepresentations(List<SubRepresentation> subRepresentations) {
            this.subRepresentations = subRepresentations;
            return this;
        }

        public Builder withSegmentBase(SegmentBase segmentBase) {
            this.segmentBase = segmentBase;
            return this;
        }

        public Builder withSegmentList(SegmentList segmentList) {
            this.segmentList = segmentList;
            return this;
        }

        public Builder withSegmentTemplate(SegmentTemplate segmentTemplate) {
            this.segmentTemplate = segmentTemplate;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withBandwidth(long bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public Builder withQualityRanking(Long qualityRanking) {
            this.qualityRanking = qualityRanking;
            return this;
        }

        public Builder withDependencyId(String dependencyIds) {
            this.dependencyId = dependencyIds;
            return this;
        }

        public Builder withMediaStreamStructureId(String mediaStreamStructureId) {
            this.mediaStreamStructureId = mediaStreamStructureId;
            return this;
        }

        public Representation build() {
            return new Representation(this.framePackings, this.audioChannelConfigurations, this.contentProtections, this.essentialProperties, this.supplementalProperties, this.inbandEventStreams, this.profiles, this.width, this.height, this.sar, this.frameRate, this.audioSamplingRate, this.mimeType, this.segmentProfiles, this.codecs, this.maximumSAPPeriod, this.startWithSAP, this.maxPlayoutRate, this.codingDependency, this.scanType, this.baseURLs, this.subRepresentations, this.segmentBase, this.segmentList, this.segmentTemplate, this.id, this.bandwidth, this.qualityRanking, this.dependencyId, this.mediaStreamStructureId);
        }
    }
}

