/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data.descriptor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.lindstrom.mpd.data.descriptor.GenericDescriptor;
import io.lindstrom.mpd.data.descriptor.Role;
import io.lindstrom.mpd.data.descriptor.protection.Mp4Protection;
import io.lindstrom.mpd.data.descriptor.protection.PlayReadyContentProtection;
import io.lindstrom.mpd.data.descriptor.protection.WidewineProtection;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="schemeIdUri", include=JsonTypeInfo.As.EXISTING_PROPERTY, visible=true, defaultImpl=GenericDescriptor.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Role.class, name="urn:mpeg:dash:role:2011"), @JsonSubTypes.Type(value=Mp4Protection.class, name="urn:mpeg:dash:mp4protection:2011"), @JsonSubTypes.Type(value=PlayReadyContentProtection.class, name="urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95"), @JsonSubTypes.Type(value=WidewineProtection.class, name="urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed")})
public abstract class Descriptor {
    @JacksonXmlProperty(isAttribute=true)
    protected final String schemeIdUri;
    @JacksonXmlProperty(isAttribute=true)
    protected final String id;

    protected Descriptor(String schemeIdUri, String id) {
        this.schemeIdUri = schemeIdUri;
        this.id = id;
    }

    public String getSchemeIdUri() {
        return this.schemeIdUri;
    }

    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public abstract String getValue();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return Objects.equals(this.schemeIdUri, that.schemeIdUri) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemeIdUri, this.id);
    }
}

