/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data.descriptor;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.lindstrom.mpd.data.descriptor.Descriptor;
import java.util.Locale;
import java.util.Objects;

public class Role
extends Descriptor {
    static final String SCHEME_ID_URI = "urn:mpeg:dash:role:2011";
    @JacksonXmlProperty(localName="value", isAttribute=true)
    private final Type type;

    public Role(Type value) {
        super(SCHEME_ID_URI, null);
        this.type = value;
    }

    public Role(Type value, String id) {
        super(SCHEME_ID_URI, id);
        this.type = value;
    }

    private Role() {
        super(null, null);
        this.type = null;
    }

    @Override
    public String getValue() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString().toLowerCase(Locale.US);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Role role = (Role)o;
        return this.type == role.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type});
    }

    public String toString() {
        return "Role{type=" + this.type + ", schemeIdUri='" + this.schemeIdUri + "', id='" + this.id + "'}";
    }

    public Builder buildUpon() {
        return new Builder().withId(this.id).withType(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Type type;
        private String id;

        public Builder withType(Type type) {
            this.type = type;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Role build() {
            return new Role(this.type, this.id);
        }
    }

    public static enum Type {
        CAPTION,
        SUBTITLE,
        MAIN,
        ALTERNATE,
        SUPPLEMENTARY,
        COMMENTARY,
        DUB,
        DESCRIPTION,
        ENHANCED_AUDIO_INTELLIGIBILITY,
        EMERGENCY,
        SIGN,
        UNKNOWN;

    }
}

