/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.lindstrom.mpd.data.Ratio;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RatioDeserializer
extends JsonDeserializer<Ratio> {
    private static final Pattern RATIO_PATTERN = Pattern.compile("^([0-9]*):([0-9]*)$");

    public Ratio deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String text = p.getText();
        Matcher matcher = RATIO_PATTERN.matcher(text);
        if (matcher.matches()) {
            String a = matcher.group(1);
            String b = matcher.group(2);
            return new Ratio(a.isEmpty() ? null : Long.valueOf(Long.parseLong(a)), b.isEmpty() ? null : Long.valueOf(Long.parseLong(b)));
        }
        ctxt.reportWrongTokenException((JsonDeserializer)this, p.currentToken(), "Invalid ratio", new Object[0]);
        return null;
    }
}

