/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

public class CompressionSupport {
    public static final MediaType JSON = MediaType.get((String)"application/json");
    public static final MediaType PROTOBUF = MediaType.get((String)"application/protobuf");

    public static RequestBody compress(String content) {
        return CompressionSupport.compress(RequestBody.create((String)content, (MediaType)JSON));
    }

    public static RequestBody compress(RequestBody body) {
        return CompressionSupport.forceContentLength(CompressionSupport.gzip(body));
    }

    private static RequestBody gzip(final RequestBody body) {
        return new RequestBody(){

            public MediaType contentType() {
                return body.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                body.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }

    private static RequestBody forceContentLength(final RequestBody requestBody) {
        try {
            final Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            return new RequestBody(){

                public MediaType contentType() {
                    return requestBody.contentType();
                }

                public long contentLength() {
                    return buffer.size();
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    sink.write(buffer.snapshot());
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to determine content length", e);
        }
    }
}

