/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client;

import io.lionweb.LionWebVersion;
import io.lionweb.client.Protocol;
import io.lionweb.client.api.BulkAPIClient;
import io.lionweb.client.api.ChunkLevelBulkAPIClient;
import io.lionweb.client.api.ClassifierKey;
import io.lionweb.client.api.ClassifierResult;
import io.lionweb.client.api.DBAdminAPIClient;
import io.lionweb.client.api.HistoryAPIClient;
import io.lionweb.client.api.InspectionAPIClient;
import io.lionweb.client.api.JSONLevelBulkAPIClient;
import io.lionweb.client.api.RepositoryConfiguration;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.client.impl.ClientConfiguration;
import io.lionweb.client.impl.ClientForBulkAPIs;
import io.lionweb.client.impl.ClientForChunkLevelBulkAPIs;
import io.lionweb.client.impl.ClientForDBAdminAPIs;
import io.lionweb.client.impl.ClientForHistoryAPIs;
import io.lionweb.client.impl.ClientForInspectionAPIs;
import io.lionweb.client.impl.ClientForJSONLevelBulkAPIs;
import io.lionweb.model.Node;
import io.lionweb.serialization.JsonSerialization;
import io.lionweb.serialization.SerializationProvider;
import io.lionweb.serialization.UnavailableNodePolicy;
import io.lionweb.serialization.data.SerializedClassifierInstance;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LionWebClient
implements JSONLevelBulkAPIClient,
ChunkLevelBulkAPIClient,
BulkAPIClient,
DBAdminAPIClient,
InspectionAPIClient,
HistoryAPIClient {
    protected static final MediaType JSON = MediaType.get((String)"application/json");
    protected final Protocol protocol = Protocol.HTTP;
    protected final String hostname;
    protected final int port;
    protected final String authorizationToken;
    protected final String clientID;
    protected final String repository;
    protected final OkHttpClient httpClient;
    protected final JsonSerialization jsonSerialization;
    private final ClientForInspectionAPIs inspectionAPIs;
    private final ClientForDBAdminAPIs dbAdminAPIs;
    private final ClientForBulkAPIs bulkAPIs;
    private final ClientForChunkLevelBulkAPIs chunkLevelBulkAPIs;
    private final ClientForJSONLevelBulkAPIs jsonLevelBulkAPIs;
    private final ClientForHistoryAPIs historyAPIs;

    public LionWebClient(@NotNull LionWebVersion lionWebVersion, String hostname, int port, String repository) {
        this(lionWebVersion, hostname, port, null, "GenericJavaBasedLionWebClient", repository, 60L, 60L);
    }

    public LionWebClient(@NotNull LionWebVersion lionWebVersion, @NotNull String hostname, int port, @Nullable String authorizationToken, @NotNull String clientID, @NotNull String repository, long connectTimeoutInSeconds, long callTimeoutInSeconds) {
        this.hostname = hostname;
        this.port = port;
        this.authorizationToken = authorizationToken;
        this.clientID = clientID;
        this.repository = repository;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(connectTimeoutInSeconds, TimeUnit.SECONDS).readTimeout(callTimeoutInSeconds, TimeUnit.SECONDS).writeTimeout(callTimeoutInSeconds, TimeUnit.SECONDS).callTimeout(callTimeoutInSeconds, TimeUnit.SECONDS).build();
        this.jsonSerialization = SerializationProvider.getStandardJsonSerialization((LionWebVersion)lionWebVersion);
        this.jsonSerialization.enableDynamicNodes();
        this.jsonSerialization.setUnavailableChildrenPolicy(UnavailableNodePolicy.PROXY_NODES);
        this.jsonSerialization.setUnavailableParentPolicy(UnavailableNodePolicy.PROXY_NODES);
        this.jsonSerialization.setUnavailableReferenceTargetPolicy(UnavailableNodePolicy.PROXY_NODES);
        ClientConfiguration conf = this.buildRepositoryConfiguration();
        this.inspectionAPIs = new ClientForInspectionAPIs(conf);
        this.dbAdminAPIs = new ClientForDBAdminAPIs(conf);
        this.jsonLevelBulkAPIs = new ClientForJSONLevelBulkAPIs(conf);
        this.chunkLevelBulkAPIs = new ClientForChunkLevelBulkAPIs(conf);
        this.bulkAPIs = new ClientForBulkAPIs(conf);
        this.historyAPIs = new ClientForHistoryAPIs(conf);
    }

    protected ClientConfiguration buildRepositoryConfiguration() {
        return new ClientConfiguration(this.protocol, this.hostname, this.port, this.authorizationToken, this.clientID, this.repository, this.httpClient, this.jsonSerialization);
    }

    @NotNull
    public JsonSerialization getJsonSerialization() {
        return this.jsonSerialization;
    }

    @Override
    @Nullable
    public RepositoryVersionToken rawCreatePartitions(@NotNull String data) throws IOException {
        return this.jsonLevelBulkAPIs.rawCreatePartitions(data);
    }

    @Override
    @Nullable
    public RepositoryVersionToken rawStore(@NotNull String nodes) throws IOException {
        return this.jsonLevelBulkAPIs.rawStore(nodes);
    }

    @Override
    @NotNull
    public String rawRetrieve(@NotNull List<String> nodeIds, int limit) throws IOException {
        return this.jsonLevelBulkAPIs.rawRetrieve(nodeIds, limit);
    }

    @Override
    @NotNull
    public String rawRetrieve(@Nullable List<String> nodeIds) throws IOException {
        return JSONLevelBulkAPIClient.super.rawRetrieve(nodeIds);
    }

    @Override
    @Nullable
    public RepositoryVersionToken createPartitions(List<Node> partitions) throws IOException {
        return this.bulkAPIs.createPartitions(partitions);
    }

    @Nullable
    public RepositoryVersionToken createPartition(@NotNull Node partition) throws IOException {
        return this.createPartitions(Collections.singletonList(partition));
    }

    @Override
    @Nullable
    public RepositoryVersionToken deletePartitions(List<String> ids) throws IOException {
        return this.bulkAPIs.deletePartitions(ids);
    }

    @Override
    public List<Node> listPartitions() throws IOException {
        return this.bulkAPIs.listPartitions();
    }

    @Override
    public List<String> listPartitionsIDs() throws IOException {
        return this.listPartitions().stream().map(Node::getID).collect(Collectors.toList());
    }

    @Override
    public List<String> ids(int count) throws IOException {
        return this.bulkAPIs.ids(count);
    }

    @Override
    @Nullable
    public RepositoryVersionToken store(List<Node> nodes) throws IOException {
        return this.bulkAPIs.store(nodes);
    }

    @Nullable
    public RepositoryVersionToken store(@NotNull Node node) throws IOException {
        return this.store(Collections.singletonList(node));
    }

    @Override
    public List<Node> retrieve(List<String> nodeIds) throws IOException {
        return this.retrieve(nodeIds, Integer.MAX_VALUE);
    }

    @NotNull
    public Node retrieve(@NotNull String nodeId) throws IOException {
        Objects.requireNonNull(nodeId, "nodeId should not be null");
        List<Node> nodes = this.retrieve(Collections.singletonList(nodeId), Integer.MAX_VALUE);
        List matchingNodes = nodes.stream().filter(n -> nodeId.equals(n.getID())).collect(Collectors.toList());
        if (matchingNodes.size() != 1) {
            throw new IllegalArgumentException("Node not found: " + nodeId);
        }
        return (Node)matchingNodes.get(0);
    }

    @Override
    public List<Node> retrieve(List<String> nodeIds, int limit) throws IOException {
        return this.bulkAPIs.retrieve(nodeIds, limit);
    }

    @Override
    @NotNull
    public LionWebVersion getLionWebVersion() {
        return this.buildRepositoryConfiguration().getJsonSerialization().getLionWebVersion();
    }

    @Override
    @Nullable
    public RepositoryVersionToken createPartitionsFromChunk(@NotNull List<SerializedClassifierInstance> data) throws IOException {
        return this.chunkLevelBulkAPIs.createPartitionsFromChunk(data);
    }

    @Override
    @Nullable
    public RepositoryVersionToken storeChunk(@NotNull List<SerializedClassifierInstance> nodes) throws IOException {
        return this.chunkLevelBulkAPIs.storeChunk(nodes);
    }

    @Override
    @NotNull
    public List<SerializedClassifierInstance> retrieveAsChunk(@Nullable List<String> nodeIds, int limit) throws IOException {
        return this.chunkLevelBulkAPIs.retrieveAsChunk(nodeIds, limit);
    }

    @Override
    @NotNull
    public List<SerializedClassifierInstance> retrieveAsChunk(@Nullable List<String> nodeIds) throws IOException {
        return this.chunkLevelBulkAPIs.retrieveAsChunk(nodeIds);
    }

    @Override
    public void createRepository(@NotNull RepositoryConfiguration repositoryConfiguration) throws IOException {
        this.dbAdminAPIs.createRepository(repositoryConfiguration);
    }

    @Override
    public void deleteRepository(@NotNull String repositoryName) throws IOException {
        this.dbAdminAPIs.deleteRepository(repositoryName);
    }

    @Override
    public void createDatabase() throws IOException {
        this.dbAdminAPIs.createDatabase();
    }

    @Override
    @NotNull
    public Set<RepositoryConfiguration> listRepositories() throws IOException {
        return this.dbAdminAPIs.listRepositories();
    }

    @Override
    public Map<ClassifierKey, ClassifierResult> nodesByClassifier(@Nullable Integer limit) throws IOException {
        return this.inspectionAPIs.nodesByClassifier(limit);
    }

    @Override
    public Map<String, ClassifierResult> nodesByLanguage(@Nullable Integer limit) throws IOException {
        return this.inspectionAPIs.nodesByLanguage(limit);
    }

    @Override
    public List<Node> listPartitions(RepositoryVersionToken repoVersion) throws IOException {
        return this.historyAPIs.listPartitions(repoVersion);
    }

    @Override
    public List<Node> retrieve(RepositoryVersionToken repoVersion, List<String> nodeIds, int limit) throws IOException {
        return this.historyAPIs.retrieve(repoVersion, nodeIds, limit);
    }

    public class Builder {
        protected LionWebVersion lionWebVersion = LionWebVersion.currentVersion;
        protected String hostname = "localhost";
        protected int port = 3005;
        protected String authorizationToken = null;
        protected String clientID = "GenericJavaBasedLionWebClient";
        protected String repository = "default";
        protected long connectTimeoutInSeconds = 60L;
        protected long callTimeoutInSeconds = 60L;

        public Builder withVersion(LionWebVersion version) {
            this.lionWebVersion = version;
            return this;
        }

        public Builder withHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withAuthorizationToken(String token) {
            this.authorizationToken = token;
            return this;
        }

        public Builder withClientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        public Builder withRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder withConnectTimeout(long seconds) {
            this.connectTimeoutInSeconds = seconds;
            return this;
        }

        public Builder withCallTimeout(long seconds) {
            this.callTimeoutInSeconds = seconds;
            return this;
        }

        public LionWebClient build() {
            return new LionWebClient(this.lionWebVersion, this.hostname, this.port, this.authorizationToken, this.clientID, this.repository, this.connectTimeoutInSeconds, this.callTimeoutInSeconds);
        }
    }
}

