/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.api;

import io.lionweb.LionWebVersion;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.serialization.data.SerializationChunk;
import io.lionweb.serialization.data.SerializedClassifierInstance;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ChunkLevelBulkAPIClient {
    @NotNull
    public LionWebVersion getLionWebVersion();

    @NotNull
    public List<String> ids(int var1) throws IOException;

    @NotNull
    public List<String> listPartitionsIDs() throws IOException;

    @Nullable
    public RepositoryVersionToken createPartitionsFromChunk(@NotNull List<SerializedClassifierInstance> var1) throws IOException;

    @Nullable
    default public RepositoryVersionToken createPartitionsFromChunk(@NotNull Stream<SerializedClassifierInstance> data) throws IOException {
        return this.createPartitionsFromChunk(data.collect(Collectors.toList()));
    }

    @Nullable
    default public RepositoryVersionToken createPartitionsFromChunk(@NotNull SerializationChunk chunk) throws IOException {
        Objects.requireNonNull(chunk, "chunk should not be null");
        return this.createPartitionsFromChunk(chunk.getClassifierInstances());
    }

    @Nullable
    public RepositoryVersionToken deletePartitions(List<String> var1) throws IOException;

    @Nullable
    public RepositoryVersionToken storeChunk(@NotNull List<SerializedClassifierInstance> var1) throws IOException;

    @Nullable
    default public RepositoryVersionToken storeChunk(@NotNull Stream<SerializedClassifierInstance> nodes) throws IOException {
        return this.storeChunk(StreamSupport.stream(nodes.spliterator(), false).collect(Collectors.toList()));
    }

    @Nullable
    default public RepositoryVersionToken storeChunk(@NotNull SerializationChunk chunk) throws IOException {
        Objects.requireNonNull(chunk, "chunk should not be null");
        return this.storeChunk(chunk.getClassifierInstances());
    }

    @NotNull
    public List<SerializedClassifierInstance> retrieveAsChunk(@NotNull List<String> var1, int var2) throws IOException;

    @NotNull
    default public Stream<SerializedClassifierInstance> retrieveAsStreamChunk(@NotNull Stream<String> nodeIds, int limit) throws IOException {
        Objects.requireNonNull(nodeIds);
        return this.retrieveAsChunk(nodeIds.collect(Collectors.toList()), limit).stream();
    }

    @NotNull
    default public List<SerializedClassifierInstance> retrieveAsChunk(@NotNull List<String> nodeIds) throws IOException {
        return this.retrieveAsChunk(nodeIds, Integer.MAX_VALUE);
    }

    @NotNull
    default public Stream<SerializedClassifierInstance> retrieveAsStreamChunk(@NotNull Stream<String> nodeIds) throws IOException {
        return this.retrieveAsStreamChunk(nodeIds, Integer.MAX_VALUE);
    }
}

