/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.lionweb.client.RequestFailureException;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.client.impl.ClientConfiguration;
import io.lionweb.client.impl.LionWebClientImplHelper;
import io.lionweb.serialization.LowLevelJsonSerialization;
import io.lionweb.serialization.data.SerializationChunk;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.Nullable;

abstract class BulkAPIsLionWebClientImplHelper
extends LionWebClientImplHelper {
    BulkAPIsLionWebClientImplHelper(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
    }

    public List<String> ids(int count) throws IOException {
        if (count < 0) {
            throw new IllegalArgumentException("Count should be greater or equal to zero");
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("count", Integer.toString(count));
        Request.Builder rq = this.buildRequest("/bulk/ids", true, true, true, params);
        Request request = rq.post(RequestBody.create((byte[])new byte[0])).build();
        return this.performCall(request, (response, responseBody) -> {
            JsonObject responseData = JsonParser.parseString((String)responseBody).getAsJsonObject();
            boolean success = responseData.get("success").getAsBoolean();
            if (!success) {
                throw new RequestFailureException(request.url().toString(), response.code(), responseBody);
            }
            return responseData.get("ids").getAsJsonArray().asList().stream().map(je -> je.getAsString()).collect(Collectors.toList());
        });
    }

    List<String> listPartitionsIDs() throws IOException {
        Request.Builder rq = this.buildRequest("/bulk/listPartitions");
        Request request = rq.addHeader("Accept-Encoding", "gzip").post(RequestBody.create((byte[])new byte[0], null)).build();
        return this.performCall(request, (response, responseBody) -> {
            JsonObject responseData = JsonParser.parseString((String)responseBody).getAsJsonObject();
            boolean success = responseData.get("success").getAsBoolean();
            if (!success) {
                throw new RequestFailureException(request.url().toString(), response.code(), responseBody);
            }
            SerializationChunk serializationBlock = new LowLevelJsonSerialization().deserializeSerializationBlock(responseData.get("chunk"));
            return serializationBlock.getClassifierInstances().stream().filter(n -> n.getParentNodeID() == null).map(n -> n.getID()).collect(Collectors.toList());
        });
    }

    @Nullable
    RepositoryVersionToken deletePartitions(List<String> ids) throws IOException {
        JsonArray ja = new JsonArray();
        for (String id : ids) {
            ja.add(id);
        }
        String bodyJson = this.gson.toJson((JsonElement)ja);
        RequestBody body = RequestBody.create((String)bodyJson, (MediaType)JSON);
        Request.Builder rq = this.buildRequest("/bulk/deletePartitions");
        Request request = rq.post(body).build();
        return this.performCall(request, (response, responseBody) -> this.getRepoVersionFromResponse(responseBody));
    }
}

