/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.lionweb.LionWebVersion;
import io.lionweb.client.RequestFailureException;
import io.lionweb.client.api.BulkAPIClient;
import io.lionweb.client.api.JSONLevelBulkAPIClient;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.client.impl.BulkAPIsLionWebClientImplHelper;
import io.lionweb.client.impl.ClientConfiguration;
import io.lionweb.client.impl.ClientForJSONLevelBulkAPIs;
import io.lionweb.model.ClassifierInstance;
import io.lionweb.model.Node;
import io.lionweb.model.impl.ProxyNode;
import io.lionweb.utils.CommonChecks;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientForBulkAPIs
extends BulkAPIsLionWebClientImplHelper
implements BulkAPIClient {
    private final JSONLevelBulkAPIClient jsonLevelClient;

    public ClientForBulkAPIs(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.jsonLevelClient = new ClientForJSONLevelBulkAPIs(clientConfiguration);
    }

    @Override
    @NotNull
    public LionWebVersion getLionWebVersion() {
        return this.conf.getJsonSerialization().getLionWebVersion();
    }

    @Override
    @Nullable
    public RepositoryVersionToken createPartitions(List<Node> partitions) throws IOException {
        return this.jsonLevelClient.rawCreatePartitions(this.conf.getJsonSerialization().serializeTreesToJsonString(partitions.toArray(new ClassifierInstance[0])));
    }

    @Override
    @Nullable
    public RepositoryVersionToken deletePartitions(List<String> ids) throws IOException {
        return super.deletePartitions(ids);
    }

    @Override
    public List<String> listPartitionsIDs() throws IOException {
        return this.listPartitions().stream().map(n -> n.getID()).collect(Collectors.toList());
    }

    @Override
    public List<Node> listPartitions() throws IOException {
        Request.Builder rq = this.buildRequest("/bulk/listPartitions");
        Request request = rq.addHeader("Accept-Encoding", "gzip").post(RequestBody.create((byte[])new byte[0], null)).build();
        return this.performCall(request, (response, responseBody) -> {
            JsonObject responseData = JsonParser.parseString((String)responseBody).getAsJsonObject();
            boolean success = responseData.get("success").getAsBoolean();
            if (!success) {
                throw new RequestFailureException(request.url().toString(), response.code(), responseBody);
            }
            return this.conf.getJsonSerialization().deserializeToNodes(responseData.get("chunk"));
        });
    }

    @Override
    @Nullable
    public RepositoryVersionToken store(List<Node> nodes) throws IOException {
        if (nodes.isEmpty()) {
            return null;
        }
        String json = this.conf.getJsonSerialization().serializeTreesToJsonString(nodes.toArray(new ClassifierInstance[0]));
        return this.jsonLevelClient.rawStore(json);
    }

    @Override
    public List<Node> retrieve(List<String> nodeIds, int limit) throws IOException {
        if (nodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        List invalidIDs = nodeIds.stream().filter(id -> !CommonChecks.isValidID((String)id)).collect(Collectors.toList());
        if (!invalidIDs.isEmpty()) {
            throw new IllegalArgumentException("IDs must all be valid. Invalid IDs found: " + invalidIDs);
        }
        String bodyJson = "{\"ids\":[" + String.join((CharSequence)", ", (CharSequence[])nodeIds.stream().map(id -> "\"" + id + "\"").toArray(String[]::new)) + "]}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("depthLimit", String.valueOf(limit));
        Request.Builder rq = this.buildRequest("/bulk/retrieve", true, true, true, params);
        Request request = rq.post(RequestBody.create((String)bodyJson, (MediaType)JSON)).build();
        return this.performCall(request, (response, responseBody) -> {
            JsonObject responseData = JsonParser.parseString((String)responseBody).getAsJsonObject();
            boolean success = responseData.get("success").getAsBoolean();
            if (!success) {
                throw new RequestFailureException(request.url().toString(), response.code(), responseBody);
            }
            List allNodes = this.conf.getJsonSerialization().deserializeToNodes(responseData.get("chunk"));
            Set idsReturned = allNodes.stream().filter(n -> !(n instanceof ProxyNode)).map(n -> n.getID()).collect(Collectors.toSet());
            return allNodes.stream().filter(n -> !(n instanceof ProxyNode) && (n.getParent() == null || !idsReturned.contains(n.getParent().getID()))).collect(Collectors.toList());
        });
    }
}

