/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.impl;

import io.lionweb.LionWebVersion;
import io.lionweb.client.api.ChunkLevelBulkAPIClient;
import io.lionweb.client.api.JSONLevelBulkAPIClient;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.client.impl.BulkAPIsLionWebClientImplHelper;
import io.lionweb.client.impl.ClientConfiguration;
import io.lionweb.client.impl.ClientForJSONLevelBulkAPIs;
import io.lionweb.serialization.JsonSerialization;
import io.lionweb.serialization.LowLevelJsonSerialization;
import io.lionweb.serialization.SerializationProvider;
import io.lionweb.serialization.data.SerializationChunk;
import io.lionweb.serialization.data.SerializedClassifierInstance;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientForChunkLevelBulkAPIs
extends BulkAPIsLionWebClientImplHelper
implements ChunkLevelBulkAPIClient {
    private final JSONLevelBulkAPIClient jsonLevelClient;

    public ClientForChunkLevelBulkAPIs(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.jsonLevelClient = new ClientForJSONLevelBulkAPIs(clientConfiguration);
    }

    @Override
    @NotNull
    public LionWebVersion getLionWebVersion() {
        return this.conf.getJsonSerialization().getLionWebVersion();
    }

    @Override
    @NotNull
    public List<String> listPartitionsIDs() throws IOException {
        return super.listPartitionsIDs();
    }

    @Override
    @Nullable
    public RepositoryVersionToken createPartitionsFromChunk(@NotNull List<SerializedClassifierInstance> data) throws IOException {
        JsonSerialization serialization = SerializationProvider.getStandardJsonSerialization((LionWebVersion)this.getLionWebVersion());
        String json = serialization.serializeToJsonString(SerializationChunk.fromNodes((LionWebVersion)this.getLionWebVersion(), data));
        return this.jsonLevelClient.rawCreatePartitions(json);
    }

    @Override
    @Nullable
    public RepositoryVersionToken deletePartitions(List<String> ids) throws IOException {
        return super.deletePartitions(ids);
    }

    @Override
    @Nullable
    public RepositoryVersionToken storeChunk(@NotNull List<SerializedClassifierInstance> nodes) throws IOException {
        JsonSerialization serialization = SerializationProvider.getStandardJsonSerialization((LionWebVersion)this.getLionWebVersion());
        String json = serialization.serializeToJsonString(SerializationChunk.fromNodes((LionWebVersion)this.getLionWebVersion(), nodes));
        return this.jsonLevelClient.rawStore(json);
    }

    @Override
    @NotNull
    public List<SerializedClassifierInstance> retrieveAsChunk(@Nullable List<String> nodeIds, int limit) throws IOException {
        String json = this.jsonLevelClient.rawRetrieve(nodeIds, limit);
        return new LowLevelJsonSerialization().deserializeSerializationBlock(json).getClassifierInstances();
    }

    @Override
    @NotNull
    public List<SerializedClassifierInstance> retrieveAsChunk(@Nullable List<String> nodeIds) throws IOException {
        String json = this.jsonLevelClient.rawRetrieve(nodeIds);
        return new LowLevelJsonSerialization().deserializeSerializationBlock(json).getClassifierInstances();
    }
}

