/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.lionweb.client.api.ClassifierKey;
import io.lionweb.client.api.ClassifierResult;
import io.lionweb.client.api.InspectionAPIClient;
import io.lionweb.client.impl.ClientConfiguration;
import io.lionweb.client.impl.LionWebClientImplHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import okhttp3.Request;
import org.jetbrains.annotations.Nullable;

public class ClientForInspectionAPIs
extends LionWebClientImplHelper
implements InspectionAPIClient {
    public ClientForInspectionAPIs(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
    }

    @Override
    public Map<ClassifierKey, ClassifierResult> nodesByClassifier(@Nullable Integer limit) throws IOException {
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        if (limit != null) {
            additionalParams.put("limit", limit.toString());
        }
        Request.Builder rq = this.buildRequest("/inspection/nodesByClassifier", true, true, true, additionalParams);
        Request request = rq.get().build();
        return this.performCall(request, (response, requestBody) -> {
            JsonArray responseData = JsonParser.parseString((String)requestBody).getAsJsonArray();
            HashMap result = new HashMap();
            responseData.forEach(entry -> {
                JsonObject entryJO = entry.getAsJsonObject();
                String language = entryJO.get("language").getAsString();
                String classifier = entryJO.get("classifier").getAsString();
                ClassifierKey classifierKey = new ClassifierKey(language, classifier);
                HashSet<String> ids = new HashSet<String>();
                entryJO.get("ids").getAsJsonArray().forEach(el -> ids.add(el.getAsString()));
                int size = entryJO.get("size").getAsInt();
                ClassifierResult classifierResult = new ClassifierResult(ids, size);
                result.put(classifierKey, classifierResult);
            });
            return result;
        });
    }

    @Override
    public Map<String, ClassifierResult> nodesByLanguage(@Nullable Integer limit) throws IOException {
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        if (limit != null) {
            additionalParams.put("limit", limit.toString());
        }
        Request.Builder rq = this.buildRequest("/inspection/nodesByLanguage", true, true, true, additionalParams);
        Request request = rq.get().build();
        return this.performCall(request, (response, requestBody) -> {
            JsonArray responseData = JsonParser.parseString((String)requestBody).getAsJsonArray();
            HashMap result = new HashMap();
            responseData.forEach(entry -> {
                JsonObject entryJO = entry.getAsJsonObject();
                String language = entryJO.get("language").getAsString();
                HashSet<String> ids = new HashSet<String>();
                entryJO.get("ids").getAsJsonArray().forEach(el -> ids.add(el.getAsString()));
                int size = entryJO.get("size").getAsInt();
                ClassifierResult classifierResult = new ClassifierResult(ids, size);
                result.put(language, classifierResult);
            });
            return result;
        });
    }
}

