/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.lionweb.LionWebVersion;
import io.lionweb.client.CompressionSupport;
import io.lionweb.client.RequestFailureException;
import io.lionweb.client.api.JSONLevelBulkAPIClient;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.client.impl.BulkAPIsLionWebClientImplHelper;
import io.lionweb.client.impl.ClientConfiguration;
import io.lionweb.utils.CommonChecks;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientForJSONLevelBulkAPIs
extends BulkAPIsLionWebClientImplHelper
implements JSONLevelBulkAPIClient {
    public ClientForJSONLevelBulkAPIs(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
    }

    @Override
    @NotNull
    public LionWebVersion getLionWebVersion() {
        return this.conf.getJsonSerialization().getLionWebVersion();
    }

    @Override
    @NotNull
    public List<String> listPartitionsIDs() throws IOException {
        return super.listPartitionsIDs();
    }

    @Override
    @Nullable
    public RepositoryVersionToken rawCreatePartitions(@NotNull String data) throws IOException {
        return this.nodesStoringOperation(data, "createPartitions");
    }

    @Override
    @Nullable
    public RepositoryVersionToken deletePartitions(List<String> ids) throws IOException {
        return super.deletePartitions(ids);
    }

    @Override
    @Nullable
    public RepositoryVersionToken rawStore(@NotNull String json) throws IOException {
        Request.Builder rq = this.buildRequest("/bulk/store");
        rq = this.addGZipCompressionHeader(rq);
        RequestBody uncompressedBody = RequestBody.create((String)json, (MediaType)JSON);
        Request request = rq.post(this.gzipCompress(uncompressedBody)).build();
        return this.performCall(request, (response, responseBody) -> {
            JsonObject responseData = JsonParser.parseString((String)responseBody).getAsJsonObject();
            boolean success = responseData.get("success").getAsBoolean();
            if (!success) {
                throw new RequestFailureException(request.url().toString(), response.code(), responseBody);
            }
            return this.getRepoVersionFromResponse(responseBody);
        });
    }

    @Override
    public String rawRetrieve(@NotNull List<String> nodeIds, int limit) throws IOException {
        List invalidIDs = nodeIds.stream().filter(id -> !CommonChecks.isValidID((String)id)).collect(Collectors.toList());
        if (!invalidIDs.isEmpty()) {
            throw new IllegalArgumentException("IDs must all be valid. Invalid IDs found: " + invalidIDs);
        }
        String bodyJson = "{\"ids\":[" + String.join((CharSequence)", ", (CharSequence[])nodeIds.stream().map(id -> "\"" + id + "\"").toArray(String[]::new)) + "]}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("depthLimit", String.valueOf(limit));
        Request.Builder rq = this.buildRequest("/bulk/retrieve", true, true, true, params);
        Request request = rq.post(RequestBody.create((String)bodyJson, (MediaType)JSON)).build();
        return this.performCall(request, (response, responseBody) -> {
            JsonObject responseData = JsonParser.parseString((String)responseBody).getAsJsonObject();
            boolean success = responseData.get("success").getAsBoolean();
            if (!success) {
                throw new RequestFailureException(request.url().toString(), response.code(), responseBody);
            }
            JsonElement chunkAsJson = responseData.get("chunk");
            return this.gson.toJson(chunkAsJson);
        });
    }

    @Nullable
    private RepositoryVersionToken nodesStoringOperation(String json, String operation) {
        RepositoryVersionToken repositoryVersionToken;
        block10: {
            Request.Builder rb = this.buildRequest("/bulk/" + operation);
            rb = this.addGZipCompressionHeader(rb);
            RequestBody body = CompressionSupport.compress(json);
            Request request = rb.post(body).build();
            String url = request.url().toString();
            Response response = this.conf.getHttpClient().newCall(request).execute();
            try {
                String responseBody;
                String string = responseBody = response.body() != null ? response.body().string() : null;
                if (response.code() != 200) {
                    throw new RequestFailureException(url, response.code(), responseBody);
                }
                repositoryVersionToken = this.getRepoVersionFromResponse(responseBody);
                if (response == null) break block10;
            }
            catch (Throwable responseBody) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            responseBody.addSuppressed(throwable);
                        }
                    }
                    throw responseBody;
                }
                catch (ConnectException e) {
                    String jsonExcerpt = json.length() > 10000 ? json.substring(0, 1000) + "..." : json;
                    throw new RuntimeException("Cannot get answer from the client when contacting at URL " + url + ". Body: " + jsonExcerpt, e);
                }
                catch (IOException e) {
                    throw new RuntimeException("IO error while contacting URL " + url, e);
                }
            }
            response.close();
        }
        return repositoryVersionToken;
    }

    private RequestBody gzipCompress(final RequestBody original) throws IOException {
        final Buffer buffer = new Buffer();
        original.writeTo((BufferedSink)buffer);
        RequestBody gzippedBody = new RequestBody(){

            public MediaType contentType() {
                return original.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                GzipSink gzipSink = new GzipSink((Sink)sink);
                BufferedSink compressedSink = Okio.buffer((Sink)gzipSink);
                buffer.copyTo(compressedSink.buffer(), 0L, buffer.size());
                compressedSink.close();
            }
        };
        return gzippedBody;
    }
}

