/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.lionweb.client.RequestFailureException;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.client.impl.ClientConfiguration;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.Nullable;

abstract class LionWebClientImplHelper {
    protected static final MediaType JSON = MediaType.get((String)"application/json");
    protected final ClientConfiguration conf;
    protected final Gson gson = new GsonBuilder().serializeNulls().create();

    public LionWebClientImplHelper(ClientConfiguration clientConfiguration) {
        this.conf = clientConfiguration;
    }

    protected HttpUrl.Builder buildURL(String api) {
        return this.buildURL(api, true, true);
    }

    protected HttpUrl.Builder buildURL(String api, boolean specifyingClientID, boolean specifyingRepository) {
        if (!api.startsWith("/") || api.length() < 2) {
            throw new IllegalArgumentException("api path expected to start with a slash and be at least two characters long");
        }
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(this.conf.getProtocol().value).host(this.conf.getHostname()).port(this.conf.getPort()).addPathSegments(api.substring(1));
        if (specifyingClientID) {
            urlBuilder.addQueryParameter("clientId", this.conf.getClientID());
        }
        if (specifyingRepository) {
            urlBuilder.addQueryParameter("repository", this.conf.getRepository());
        }
        return urlBuilder;
    }

    protected Request.Builder buildRequest(String api) {
        return this.buildRequest(api, true, true, true, Collections.emptyMap());
    }

    protected Request.Builder buildRequest(String api, boolean specifyingClientID, boolean specifyingRepository, boolean considerAuthenticationToken, Map<String, String> additionalParams) {
        HttpUrl.Builder urlBuilder = this.buildURL(api, specifyingClientID, specifyingRepository);
        additionalParams.entrySet().forEach(entry -> urlBuilder.addQueryParameter((String)entry.getKey(), (String)entry.getValue()));
        Request.Builder rq = new Request.Builder().url(urlBuilder.build());
        if (considerAuthenticationToken) {
            rq = this.considerAuthenticationToken(rq);
        }
        return rq;
    }

    protected <R> R performCall(Request request, ResponseHandler<R> responseHandler) throws IOException {
        try (Response response = this.conf.getHttpClient().newCall(request).execute();){
            String body = Objects.requireNonNull(response.body()).string();
            if (response.code() == 200) {
                R r = responseHandler.handleResponse(response, body);
                return r;
            }
            throw new RequestFailureException(request.url().toString(), response.code(), body);
        }
    }

    protected Request.Builder considerAuthenticationToken(Request.Builder builder) {
        return this.conf.getAuthorizationToken() == null ? builder : builder.addHeader("Authorization", this.conf.getAuthorizationToken());
    }

    protected Request.Builder addGZipCompressionHeader(Request.Builder builder) {
        return builder.addHeader("Content-Encoding", "gzip");
    }

    @Nullable
    protected RepositoryVersionToken getRepoVersionFromResponse(String responseBody) {
        JsonArray data = JsonParser.parseString((String)responseBody).getAsJsonObject().get("messages").getAsJsonArray();
        Optional<JsonElement> repoVersionMessage = data.asList().stream().filter(e -> e.getAsJsonObject().get("kind").getAsString().equals("RepoVersion")).findFirst();
        if (!repoVersionMessage.isPresent()) {
            return null;
        }
        long version = repoVersionMessage.get().getAsJsonObject().get("data").getAsJsonObject().get("version").getAsLong();
        return new RepositoryVersionToken(Long.toString(version));
    }

    public static interface ResponseHandler<R> {
        public R handleResponse(Response var1, String var2);
    }
}

