/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.inmemory;

import io.lionweb.LionWebVersion;
import io.lionweb.client.api.ChunkLevelBulkAPIClient;
import io.lionweb.client.api.ClassifierKey;
import io.lionweb.client.api.ClassifierResult;
import io.lionweb.client.api.DBAdminAPIClient;
import io.lionweb.client.api.InspectionAPIClient;
import io.lionweb.client.api.RepositoryConfiguration;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.client.inmemory.InMemoryServer;
import io.lionweb.serialization.data.SerializedClassifierInstance;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkLevelInMemoryServerClient
implements ChunkLevelBulkAPIClient,
DBAdminAPIClient,
InspectionAPIClient {
    @NotNull
    private final InMemoryServer inMemoryServer;
    @Nullable
    private String repositoryName;

    public ChunkLevelInMemoryServerClient(@NotNull InMemoryServer inMemoryServer) {
        this.inMemoryServer = inMemoryServer;
    }

    public ChunkLevelInMemoryServerClient(@NotNull InMemoryServer inMemoryServer, @Nullable String repositoryName) {
        this.inMemoryServer = inMemoryServer;
        this.repositoryName = repositoryName;
    }

    @Override
    @NotNull
    public List<String> ids(int count) {
        this.requireRepository();
        return this.inMemoryServer.ids(this.repositoryName, count);
    }

    @Override
    public void createRepository(@NotNull RepositoryConfiguration repositoryConfiguration) {
        Objects.requireNonNull(repositoryConfiguration);
        this.inMemoryServer.createRepository(repositoryConfiguration);
    }

    @Override
    public void deleteRepository(@NotNull String repositoryName) {
        this.inMemoryServer.deleteRepository(repositoryName);
    }

    @Override
    @NotNull
    public Set<RepositoryConfiguration> listRepositories() {
        return this.inMemoryServer.listRepositories();
    }

    @Override
    @NotNull
    public List<String> listPartitionsIDs() {
        this.requireRepository();
        return this.inMemoryServer.listPartitionIDs(this.repositoryName);
    }

    @Nullable
    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(@Nullable String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    @NotNull
    public LionWebVersion getLionWebVersion() {
        this.requireRepository();
        return this.inMemoryServer.getRepositoryConfiguration(this.repositoryName).getLionWebVersion();
    }

    @Override
    @Nullable
    public RepositoryVersionToken createPartitionsFromChunk(@NotNull List<SerializedClassifierInstance> data) {
        this.requireRepository();
        return this.inMemoryServer.createPartitionFromChunk(this.repositoryName, data);
    }

    @Override
    @Nullable
    public RepositoryVersionToken deletePartitions(List<String> ids) {
        this.requireRepository();
        return this.inMemoryServer.deletePartitions(this.repositoryName, ids);
    }

    @Override
    @Nullable
    public RepositoryVersionToken storeChunk(@NotNull List<SerializedClassifierInstance> nodes) {
        this.requireRepository();
        return this.inMemoryServer.store(this.repositoryName, nodes);
    }

    @Override
    @NotNull
    public List<SerializedClassifierInstance> retrieveAsChunk(@Nullable List<String> nodeIds, int limit) {
        this.requireRepository();
        return this.inMemoryServer.retrieve(this.repositoryName, nodeIds, limit);
    }

    @Override
    public void createDatabase() {
    }

    @Override
    public Map<ClassifierKey, ClassifierResult> nodesByClassifier() {
        this.requireRepository();
        return this.inMemoryServer.nodesByClassifier(this.repositoryName);
    }

    @Override
    public Map<ClassifierKey, ClassifierResult> nodesByClassifier(@Nullable Integer limit) {
        this.requireRepository();
        return this.inMemoryServer.nodesByClassifier(this.repositoryName, limit);
    }

    @Override
    public Map<String, ClassifierResult> nodesByLanguage() {
        this.requireRepository();
        return this.inMemoryServer.nodesByLanguage(this.repositoryName);
    }

    @Override
    public Map<String, ClassifierResult> nodesByLanguage(@Nullable Integer limit) {
        this.requireRepository();
        return this.inMemoryServer.nodesByLanguage(this.repositoryName, limit);
    }

    private void requireRepository() {
        if (this.repositoryName == null) {
            throw new IllegalStateException("This API requires the repositoryName to be set");
        }
    }
}

