/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.inmemory;

import io.lionweb.client.api.ClassifierKey;
import io.lionweb.client.api.ClassifierResult;
import io.lionweb.client.api.HistorySupport;
import io.lionweb.client.api.RepositoryConfiguration;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.client.inmemory.RepositoryData;
import io.lionweb.serialization.data.MetaPointer;
import io.lionweb.serialization.data.SerializedClassifierInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryServer {
    private final Map<String, RepositoryData> repositories = new LinkedHashMap<String, RepositoryData>();

    @NotNull
    public RepositoryConfiguration getRepositoryConfiguration(@NotNull String repositoryName) {
        return this.getRepository((String)repositoryName).configuration;
    }

    @NotNull
    public List<String> ids(@NotNull String repositoryName, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("One can ask for zero or more ids");
        }
        RepositoryData repositoryData = this.getRepository(repositoryName);
        return repositoryData.ids(count);
    }

    @NotNull
    public Set<RepositoryConfiguration> listRepositories() {
        return this.repositories.values().stream().map(r -> r.configuration).collect(Collectors.toSet());
    }

    public void createRepository(@NotNull RepositoryConfiguration repositoryConfiguration) {
        Objects.requireNonNull(repositoryConfiguration);
        if (repositoryConfiguration.getHistorySupport() == HistorySupport.ENABLED) {
            throw new IllegalArgumentException("The InMemoryServer does not support History for the time being");
        }
        this.repositories.put(repositoryConfiguration.getName(), new RepositoryData(repositoryConfiguration));
    }

    public void deleteRepository(@NotNull String repositoryName) {
        Objects.requireNonNull(repositoryName);
        if (!this.repositories.containsKey(repositoryName)) {
            throw new IllegalArgumentException();
        }
        this.repositories.remove(repositoryName);
    }

    @NotNull
    public List<String> listPartitionIDs(@NotNull String repositoryName) {
        Objects.requireNonNull(repositoryName, "RepositoryName should not be null");
        RepositoryData repositoryData = this.repositories.get(repositoryName);
        return repositoryData.partitionIDs;
    }

    @NotNull
    public RepositoryVersionToken createPartitionFromChunk(@NotNull String repositoryName, @NotNull List<SerializedClassifierInstance> partitions) {
        Objects.requireNonNull(partitions);
        RepositoryData repositoryData = this.getRepository(repositoryName);
        repositoryData.partitionIDs.addAll(partitions.stream().filter(n -> n.getParentNodeID() == null).map(SerializedClassifierInstance::getID).filter(id -> !repositoryData.partitionIDs.contains(id)).collect(Collectors.toList()));
        repositoryData.store(partitions);
        return repositoryData.bumpVersion();
    }

    @NotNull
    public RepositoryVersionToken deletePartitions(@NotNull String repositoryName, @NotNull List<String> partitionIds) {
        Objects.requireNonNull(partitionIds);
        RepositoryData repositoryData = this.getRepository(repositoryName);
        repositoryData.partitionIDs.removeIf(partitionIds::contains);
        partitionIds.forEach(repositoryData::deleteNodeAndDescendant);
        return repositoryData.bumpVersion();
    }

    public List<SerializedClassifierInstance> retrieve(@NotNull String repositoryName, List<String> nodeIds, int limit) {
        Objects.requireNonNull(repositoryName, "RepositoryName should not be null");
        RepositoryData repositoryData = this.repositories.get(repositoryName);
        ArrayList<SerializedClassifierInstance> retrieved = new ArrayList<SerializedClassifierInstance>();
        nodeIds.forEach(n -> repositoryData.retrieve((String)n, limit, (List<SerializedClassifierInstance>)retrieved));
        return retrieved;
    }

    public RepositoryVersionToken store(@NotNull String repositoryName, @NotNull List<SerializedClassifierInstance> nodes) {
        Objects.requireNonNull(repositoryName, "RepositoryName should not be null");
        RepositoryData repositoryData = this.repositories.get(repositoryName);
        repositoryData.store(nodes);
        return repositoryData.bumpVersion();
    }

    public Map<ClassifierKey, ClassifierResult> nodesByClassifier(@NotNull String repositoryName) {
        return this.nodesByClassifier(repositoryName, Integer.MAX_VALUE);
    }

    public Map<ClassifierKey, ClassifierResult> nodesByClassifier(@NotNull String repositoryName, @Nullable Integer limit) {
        RepositoryData repositoryData = this.getRepository(repositoryName);
        Map<MetaPointer, List<SerializedClassifierInstance>> byMetapointer = repositoryData.nodesByID.values().stream().collect(Collectors.groupingBy(n -> n.getClassifier()));
        HashMap<ClassifierKey, ClassifierResult> res = new HashMap<ClassifierKey, ClassifierResult>();
        for (Map.Entry<MetaPointer, List<SerializedClassifierInstance>> entry : byMetapointer.entrySet()) {
            ClassifierKey key = new ClassifierKey(entry.getKey().getLanguage(), entry.getKey().getKey());
            ClassifierResult cr = new ClassifierResult(entry.getValue().stream().limit(limit.intValue()).map(n -> n.getID()).collect(Collectors.toSet()), entry.getValue().size());
            res.put(key, cr);
        }
        return res;
    }

    public Map<String, ClassifierResult> nodesByLanguage(@NotNull String repositoryName) {
        return this.nodesByLanguage(repositoryName, Integer.MAX_VALUE);
    }

    public Map<String, ClassifierResult> nodesByLanguage(@NotNull String repositoryName, @Nullable Integer limit) {
        RepositoryData repositoryData = this.getRepository(repositoryName);
        Map<String, List<SerializedClassifierInstance>> byMetapointer = repositoryData.nodesByID.values().stream().collect(Collectors.groupingBy(n -> n.getClassifier().getLanguage()));
        HashMap<String, ClassifierResult> res = new HashMap<String, ClassifierResult>();
        for (Map.Entry<String, List<SerializedClassifierInstance>> entry : byMetapointer.entrySet()) {
            ClassifierResult cr = new ClassifierResult(entry.getValue().stream().limit(limit.intValue()).map(n -> n.getID()).collect(Collectors.toSet()), entry.getValue().size());
            res.put(entry.getKey(), cr);
        }
        return res;
    }

    @NotNull
    private RepositoryData getRepository(@NotNull String repositoryName) {
        Objects.requireNonNull(repositoryName, "RepositoryName should not be null");
        RepositoryData repositoryData = this.repositories.get(repositoryName);
        if (repositoryData == null) {
            throw new IllegalArgumentException("Cannot find repository named " + repositoryName);
        }
        return repositoryData;
    }
}

