/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.inmemory;

import io.lionweb.LionWebVersion;
import io.lionweb.client.api.BulkAPIClient;
import io.lionweb.client.api.ClassifierKey;
import io.lionweb.client.api.ClassifierResult;
import io.lionweb.client.api.DBAdminAPIClient;
import io.lionweb.client.api.InspectionAPIClient;
import io.lionweb.client.api.RepositoryConfiguration;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.client.inmemory.ChunkLevelInMemoryServerClient;
import io.lionweb.client.inmemory.InMemoryServer;
import io.lionweb.model.ClassifierInstance;
import io.lionweb.model.Node;
import io.lionweb.serialization.AbstractSerialization;
import io.lionweb.serialization.SerializationProvider;
import io.lionweb.serialization.UnavailableNodePolicy;
import io.lionweb.serialization.data.SerializationChunk;
import io.lionweb.serialization.data.SerializedClassifierInstance;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodesLevelInMemoryServerClient
implements BulkAPIClient,
DBAdminAPIClient,
InspectionAPIClient {
    @NotNull
    private final ChunkLevelInMemoryServerClient chunkLevel;
    @Nullable
    private AbstractSerialization serialization;

    public NodesLevelInMemoryServerClient(@NotNull InMemoryServer inMemoryServer) {
        this.chunkLevel = new ChunkLevelInMemoryServerClient(inMemoryServer);
    }

    public NodesLevelInMemoryServerClient(@NotNull InMemoryServer inMemoryServer, @NotNull String repositoryName) {
        Objects.requireNonNull(repositoryName);
        this.chunkLevel = new ChunkLevelInMemoryServerClient(inMemoryServer, repositoryName);
    }

    @Nullable
    public String getRepositoryName() {
        return this.chunkLevel.getRepositoryName();
    }

    @Override
    public void createDatabase() {
    }

    @Override
    public List<String> ids(int count) {
        return this.chunkLevel.ids(count);
    }

    @Override
    public void createRepository(@NotNull RepositoryConfiguration repositoryConfiguration) {
        this.chunkLevel.createRepository(repositoryConfiguration);
    }

    @Override
    public void deleteRepository(@NotNull String repositoryName) {
        this.chunkLevel.deleteRepository(repositoryName);
    }

    @Override
    @NotNull
    public Set<RepositoryConfiguration> listRepositories() {
        return this.chunkLevel.listRepositories();
    }

    @Override
    @NotNull
    public LionWebVersion getLionWebVersion() {
        return this.chunkLevel.getLionWebVersion();
    }

    @Override
    public List<Node> listPartitions() {
        try {
            List<SerializedClassifierInstance> serializedNodes = this.chunkLevel.retrieveAsChunk(this.chunkLevel.listPartitionsIDs());
            return this.deserializeNodes(serializedNodes).stream().filter(n -> n.getParent() == null).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public RepositoryVersionToken createPartitions(List<Node> partitions) {
        AbstractSerialization serialization = this.getSerialization();
        return this.chunkLevel.createPartitionsFromChunk(serialization.serializeTreesToSerializationChunk(partitions).getClassifierInstances());
    }

    @Override
    @Nullable
    public RepositoryVersionToken deletePartitions(List<String> ids) {
        return this.chunkLevel.deletePartitions(ids);
    }

    @Override
    public List<String> listPartitionsIDs() {
        return this.chunkLevel.listPartitionsIDs();
    }

    @Override
    public List<Node> retrieve(List<String> nodeIds) {
        List<SerializedClassifierInstance> serializedClassifierInstances = null;
        try {
            serializedClassifierInstances = this.chunkLevel.retrieveAsChunk(nodeIds);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.deserializeNodes(serializedClassifierInstances);
    }

    private List<? extends ClassifierInstance<?>> deserialize(List<SerializedClassifierInstance> serializedNodes) {
        SerializationChunk chunk = new SerializationChunk();
        chunk.setSerializationFormatVersion(this.getLionWebVersion().getVersionString());
        serializedNodes.forEach(arg_0 -> ((SerializationChunk)chunk).addClassifierInstance(arg_0));
        chunk.populateUsedLanguages();
        return this.getSerialization().deserializeSerializationChunk(chunk);
    }

    @Override
    @Nullable
    public RepositoryVersionToken store(List<Node> nodes) {
        return this.chunkLevel.storeChunk(this.getSerialization().serializeTreesToSerializationChunk(nodes).getClassifierInstances());
    }

    @Override
    public List<Node> retrieve(List<String> nodeIds, int limit) {
        List<SerializedClassifierInstance> serializedClassifierInstances = this.chunkLevel.retrieveAsChunk(nodeIds, limit);
        return this.deserializeNodes(serializedClassifierInstances).stream().filter(node -> nodeIds.contains(node.getID())).collect(Collectors.toList());
    }

    @Override
    public Map<ClassifierKey, ClassifierResult> nodesByClassifier() {
        return this.chunkLevel.nodesByClassifier();
    }

    @Override
    public Map<ClassifierKey, ClassifierResult> nodesByClassifier(@Nullable Integer limit) {
        return this.chunkLevel.nodesByClassifier(limit);
    }

    @Override
    public Map<String, ClassifierResult> nodesByLanguage() {
        return this.chunkLevel.nodesByLanguage();
    }

    @Override
    public Map<String, ClassifierResult> nodesByLanguage(@Nullable Integer limit) {
        return this.chunkLevel.nodesByLanguage(limit);
    }

    private AbstractSerialization getSerialization() {
        if (this.serialization == null) {
            if (this.getRepositoryName() == null) {
                throw new IllegalStateException();
            }
            this.serialization = SerializationProvider.getStandardJsonSerialization((LionWebVersion)this.chunkLevel.getLionWebVersion());
            this.serialization.enableDynamicNodes();
            this.serialization.setAllUnavailabilityPolicies(UnavailableNodePolicy.PROXY_NODES);
        }
        return this.serialization;
    }

    private List<Node> deserializeNodes(List<SerializedClassifierInstance> serializedNodes) {
        return this.deserialize(serializedNodes).stream().filter(n -> n instanceof Node).map(n -> (Node)n).collect(Collectors.toList());
    }
}

