/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.inmemory;

import io.lionweb.client.api.RepositoryConfiguration;
import io.lionweb.client.api.RepositoryVersionToken;
import io.lionweb.serialization.data.SerializedClassifierInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class RepositoryData {
    @NotNull
    RepositoryConfiguration configuration;
    final List<String> partitionIDs = new ArrayList<String>();
    final Map<String, SerializedClassifierInstance> nodesByID = new HashMap<String, SerializedClassifierInstance>();
    private int currentVersion = 0;
    private int nextId = 1;

    void deleteNodeAndDescendant(String nodeId) {
        SerializedClassifierInstance curr = this.nodesByID.get(nodeId);
        if (curr == null) {
            throw new IllegalArgumentException("Node " + nodeId + " does not exist");
        }
        this.nodesByID.remove(nodeId);
        curr.getChildren().forEach(this::deleteNodeAndDescendant);
    }

    RepositoryData(@NotNull RepositoryConfiguration configuration) {
        this.configuration = configuration;
    }

    RepositoryVersionToken bumpVersion() {
        return new RepositoryVersionToken("v-" + ++this.currentVersion);
    }

    List<String> ids(int count) {
        ArrayList<String> res = new ArrayList<String>(count);
        while (res.size() < count) {
            String candidate = "id-" + this.nextId++;
            if (this.nodesByID.containsKey(candidate)) continue;
            res.add(candidate);
        }
        return res;
    }

    void store(List<SerializedClassifierInstance> newNodes) {
        newNodes.stream().filter(n -> n.getParentNodeID() == null).forEach(n -> {
            if (!this.partitionIDs.contains(n.getID())) {
                throw new IllegalArgumentException("Node " + n + " should be registered as a partition");
            }
        });
        new ChangeCalculator().store(newNodes);
    }

    List<SerializedClassifierInstance> retrieveTrees(List<String> ids) {
        ArrayList<SerializedClassifierInstance> nodes = new ArrayList<SerializedClassifierInstance>();
        ids.forEach(n -> this.retrieveTree((String)n, (List<SerializedClassifierInstance>)nodes));
        return nodes;
    }

    private void retrieveTree(String id, List<SerializedClassifierInstance> nodes) {
        SerializedClassifierInstance n = this.nodesByID.get(id);
        nodes.add(n);
        n.getChildren().forEach(c -> this.retrieveTree((String)c, nodes));
    }

    void retrieve(String nodeId, int limit, List<SerializedClassifierInstance> retrieved) {
        SerializedClassifierInstance node = this.nodesByID.get(nodeId);
        if (node == null) {
            throw new IllegalArgumentException("Node with id " + nodeId + " cannot be found");
        }
        retrieved.add(node);
        if (limit > 0) {
            node.getChildren().forEach(c -> this.retrieve((String)c, limit - 1, retrieved));
            node.getAnnotations().forEach(a -> this.retrieve((String)a, limit - 1, retrieved));
        }
    }

    private class ChangeCalculator {
        private final Map<String, SerializedClassifierInstance> addedNodes = new HashMap<String, SerializedClassifierInstance>();
        private final Set<String> removedNodes = new HashSet<String>();

        private ChangeCalculator() {
        }

        private void calculateNodeListDifferences(Map<String, SerializedClassifierInstance> updatedNodesAsMap, List<String> oldState, List<String> newState, String role) {
            newState.stream().filter(n -> !oldState.contains(n)).forEach(n -> this.addedNodes.put((String)n, (SerializedClassifierInstance)updatedNodesAsMap.get(n)));
            List unknownNodes = newState.stream().filter(c -> !updatedNodesAsMap.containsKey(c) && !RepositoryData.this.nodesByID.containsKey(c)).collect(Collectors.toList());
            if (!unknownNodes.isEmpty()) {
                throw new IllegalArgumentException("We got unknown nodes as " + role + ": " + unknownNodes);
            }
            this.removedNodes.addAll(oldState.stream().filter(n -> !newState.contains(n)).collect(Collectors.toList()));
        }

        void store(List<SerializedClassifierInstance> updatedNodes) {
            HashMap<String, SerializedClassifierInstance> updatedNodesAsMap = new HashMap<String, SerializedClassifierInstance>();
            updatedNodes.forEach(n -> updatedNodesAsMap.put(n.getID(), (SerializedClassifierInstance)n));
            for (SerializedClassifierInstance updatedNode : updatedNodes) {
                if (!RepositoryData.this.nodesByID.containsKey(updatedNode.getID())) continue;
                this.calculateNodeListDifferences(updatedNodesAsMap, RepositoryData.this.nodesByID.get(updatedNode.getID()).getChildren(), updatedNode.getChildren(), "children");
                this.calculateNodeListDifferences(updatedNodesAsMap, RepositoryData.this.nodesByID.get(updatedNode.getID()).getAnnotations(), updatedNode.getAnnotations(), "annotations");
            }
            this.removedNodes.removeAll(this.addedNodes.keySet());
            RepositoryData.this.nodesByID.putAll(updatedNodesAsMap);
            this.removedNodes.forEach(this::removeNode);
        }

        private void removeNode(String removeNodeId) {
            SerializedClassifierInstance serializedClassifierInstance = RepositoryData.this.nodesByID.get(removeNodeId);
            for (String child : serializedClassifierInstance.getChildren()) {
                if (this.addedNodes.containsKey(child)) continue;
                this.removeNode(child);
            }
            RepositoryData.this.nodesByID.remove(removeNodeId);
        }
    }
}

