/*
 * Decompiled with CFR 0.152.
 */
package io.lionweb.client.kotlin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.lionweb.LionWebVersion;
import io.lionweb.client.kotlin.ClassifierKey;
import io.lionweb.client.kotlin.ClassifierResult;
import io.lionweb.client.kotlin.CompressionKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001Bc\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001c\u0010#\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%2\u0006\u0010&\u001a\u00020\u0005J#\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010+J\f\u0010.\u001a\u00020/*\u00020/H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/lionweb/client/kotlin/LowLevelRepoClient;", "", "hostname", "", "port", "", "authorizationToken", "clientID", "repository", "connectTimeOutInSeconds", "", "callTimeoutInSeconds", "debug", "", "lionWebVersion", "Lio/lionweb/LionWebVersion;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;JJZLio/lionweb/LionWebVersion;)V", "getHostname", "()Ljava/lang/String;", "getPort", "()I", "getAuthorizationToken", "getClientID", "setClientID", "(Ljava/lang/String;)V", "getRepository", "setRepository", "getConnectTimeOutInSeconds", "()J", "getCallTimeoutInSeconds", "getDebug", "()Z", "getLionWebVersion", "()Lio/lionweb/LionWebVersion;", "retrieve", "rootIds", "", "limit", "nodesByClassifier", "", "Lio/lionweb/client/kotlin/ClassifierKey;", "Lio/lionweb/client/kotlin/ClassifierResult;", "(Ljava/lang/Integer;)Ljava/util/Map;", "httpClient", "Lokhttp3/OkHttpClient;", "considerAuthenticationToken", "Lokhttp3/Request$Builder;", "client"})
@SourceDebugExtension(value={"SMAP\nLowLevelRepoClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LowLevelRepoClient.kt\nio/lionweb/client/kotlin/LowLevelRepoClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1734#2,3:110\n1557#2:113\n1628#2,3:114\n1863#2:117\n1557#2:118\n1628#2,3:119\n1864#2:122\n*S KotlinDebug\n*F\n+ 1 LowLevelRepoClient.kt\nio/lionweb/client/kotlin/LowLevelRepoClient\n*L\n33#1:110,3\n82#1:113\n82#1:114,3\n82#1:117\n84#1:118\n84#1:119,3\n82#1:122\n*E\n"})
public final class LowLevelRepoClient {
    @NotNull
    private final String hostname;
    private final int port;
    @Nullable
    private final String authorizationToken;
    @NotNull
    private String clientID;
    @NotNull
    private String repository;
    private final long connectTimeOutInSeconds;
    private final long callTimeoutInSeconds;
    private final boolean debug;
    @NotNull
    private final LionWebVersion lionWebVersion;
    @NotNull
    private OkHttpClient httpClient;

    public LowLevelRepoClient(@NotNull String hostname, int port, @Nullable String authorizationToken, @NotNull String clientID, @NotNull String repository, long connectTimeOutInSeconds, long callTimeoutInSeconds, boolean debug, @NotNull LionWebVersion lionWebVersion) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)clientID, (String)"clientID");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)lionWebVersion, (String)"lionWebVersion");
        this.hostname = hostname;
        this.port = port;
        this.authorizationToken = authorizationToken;
        this.clientID = clientID;
        this.repository = repository;
        this.connectTimeOutInSeconds = connectTimeOutInSeconds;
        this.callTimeoutInSeconds = callTimeoutInSeconds;
        this.debug = debug;
        this.lionWebVersion = lionWebVersion;
        this.httpClient = new OkHttpClient.Builder().callTimeout(this.callTimeoutInSeconds, TimeUnit.SECONDS).readTimeout(this.callTimeoutInSeconds, TimeUnit.SECONDS).writeTimeout(this.callTimeoutInSeconds, TimeUnit.SECONDS).connectTimeout(this.connectTimeOutInSeconds, TimeUnit.SECONDS).build();
    }

    public /* synthetic */ LowLevelRepoClient(String string, int n, String string2, String string3, String string4, long l, long l2, boolean bl, LionWebVersion lionWebVersion, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "localhost";
        }
        if ((n2 & 2) != 0) {
            n = 3005;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = "GenericKotlinBasedLionWebClient";
        }
        if ((n2 & 0x10) != 0) {
            string4 = "default";
        }
        if ((n2 & 0x20) != 0) {
            l = 60L;
        }
        if ((n2 & 0x40) != 0) {
            l2 = 60L;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            lionWebVersion = LionWebVersion.currentVersion;
        }
        this(string, n, string2, string3, string4, l, l2, bl, lionWebVersion);
    }

    @NotNull
    public final String getHostname() {
        return this.hostname;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final String getAuthorizationToken() {
        return this.authorizationToken;
    }

    @NotNull
    public final String getClientID() {
        return this.clientID;
    }

    public final void setClientID(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.clientID = string;
    }

    @NotNull
    public final String getRepository() {
        return this.repository;
    }

    public final void setRepository(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.repository = string;
    }

    public final long getConnectTimeOutInSeconds() {
        return this.connectTimeOutInSeconds;
    }

    public final long getCallTimeoutInSeconds() {
        return this.callTimeoutInSeconds;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    @NotNull
    public final LionWebVersion getLionWebVersion() {
        return this.lionWebVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String retrieve(@NotNull List<String> rootIds, int limit) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter(rootIds, (String)"rootIds");
            if (!(!((Collection)rootIds).isEmpty())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Iterable $this$all$iv = rootIds;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)it)) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (!bl) {
            String $i$f$all = "Failed requirement.";
            throw new IllegalArgumentException($i$f$all.toString());
        }
        RequestBody body = RequestBody.Companion.create("{\"ids\":[" + CollectionsKt.joinToString$default((Iterable)rootIds, (CharSequence)", ", null, null, (int)0, null, LowLevelRepoClient::retrieve$lambda$1, (int)30, null) + "] }", CompressionKt.getJSON());
        String url = "http://" + this.hostname + ':' + this.port + "/bulk/retrieve";
        HttpUrl httpUrl = HttpUrl.Companion.parse(url);
        Intrinsics.checkNotNull((Object)httpUrl);
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        urlBuilder.addQueryParameter("depthLimit", String.valueOf(limit));
        urlBuilder.addQueryParameter("clientId", this.clientID);
        urlBuilder.addQueryParameter("repository", this.repository);
        Request request = this.considerAuthenticationToken(new Request.Builder().url(urlBuilder.build())).post(body).build();
        Closeable closeable = (Closeable)this.httpClient.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl3 = false;
            if (response.code() == 200) {
                String data;
                ResponseBody responseBody = response.body();
                if (responseBody == null) {
                    throw new IllegalStateException("Response without body when querying " + url);
                }
                String string = data = responseBody.string();
                return string;
            }
            try {
                ResponseBody responseBody = response.body();
                throw new RuntimeException("Something went wrong while querying " + url + ": http code " + response.code() + ", body: " + (responseBody != null ? responseBody.string() : null));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ClassifierKey, ClassifierResult> nodesByClassifier(@Nullable Integer limit) {
        String url = "http://" + this.hostname + ':' + this.port + "/inspection/nodesByClassifier";
        HttpUrl httpUrl = HttpUrl.Companion.parse(url);
        Intrinsics.checkNotNull((Object)httpUrl);
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        urlBuilder.addQueryParameter("clientId", this.clientID);
        urlBuilder.addQueryParameter("repository", this.repository);
        if (limit != null) {
            urlBuilder.addQueryParameter("limit", limit.toString());
        }
        Request request = this.considerAuthenticationToken(new Request.Builder().url(urlBuilder.build())).get().build();
        Closeable closeable = (Closeable)this.httpClient.newCall(request).execute();
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            String body;
            Response response = (Response)closeable;
            boolean bl = false;
            ResponseBody responseBody = response.body();
            String string = body = responseBody != null ? responseBody.string() : null;
            if (response.code() != 200) {
                throw new RuntimeException("DB initialization failed, HTTP " + response.code() + ": " + body);
            }
            JsonElement data = JsonParser.parseString((String)body);
            Map result = new LinkedHashMap();
            JsonArray jsonArray = data.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$map$iv = (Iterable)jsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getAsJsonObject());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv2;
                JsonObject entry = (JsonObject)element$iv;
                boolean bl3 = false;
                String string2 = entry.get("language").getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
                String string3 = entry.get("classifier").getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAsString(...)");
                ClassifierKey classifierKey = new ClassifierKey(string2, string3);
                JsonArray jsonArray2 = entry.get("ids").getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray2, (String)"getAsJsonArray(...)");
                Iterable $this$map$iv2 = (Iterable)jsonArray2;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    JsonElement jsonElement = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(it.getAsString());
                }
                Set ids = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                result.put(classifierKey, new ClassifierResult(ids, entry.get("size").getAsInt()));
            }
            Map map = result;
            return map;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Map nodesByClassifier$default(LowLevelRepoClient lowLevelRepoClient, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return lowLevelRepoClient.nodesByClassifier(n);
    }

    private final Request.Builder considerAuthenticationToken(Request.Builder $this$considerAuthenticationToken) {
        return this.authorizationToken == null ? $this$considerAuthenticationToken : $this$considerAuthenticationToken.addHeader("Authorization", this.authorizationToken);
    }

    private static final CharSequence retrieve$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return '\"' + it + '\"';
    }

    public LowLevelRepoClient() {
        this(null, 0, null, null, null, 0L, 0L, false, null, 511, null);
    }
}

