/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.common.config;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.CompositeCallCredentials;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import io.littlehorse.sdk.common.auth.OAuthClient;
import io.littlehorse.sdk.common.auth.OAuthConfig;
import io.littlehorse.sdk.common.auth.OAuthCredentialsProvider;
import io.littlehorse.sdk.common.auth.TenantMetadataProvider;
import io.littlehorse.sdk.common.config.ConfigBase;
import io.littlehorse.sdk.common.exception.LHMisconfigurationException;
import io.littlehorse.sdk.common.proto.LittleHorseGrpc;
import io.littlehorse.sdk.common.proto.TaskDef;
import io.littlehorse.sdk.common.proto.TaskDefId;
import io.littlehorse.sdk.common.proto.TenantId;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHConfig
extends ConfigBase {
    private static final Logger log = LoggerFactory.getLogger(LHConfig.class);
    public static final String API_HOST_KEY = "LHC_API_HOST";
    public static final String API_PORT_KEY = "LHC_API_PORT";
    public static final String API_PROTOCOL_KEY = "LHC_API_PROTOCOL";
    public static final String TASK_WORKER_ID_KEY = "LHW_TASK_WORKER_ID";
    public static final String TENANT_ID_KEY = "LHC_TENANT_ID";
    public static final String CLIENT_CERT_KEY = "LHC_CLIENT_CERT";
    public static final String CLIENT_KEY_KEY = "LHC_CLIENT_KEY";
    public static final String CA_CERT_KEY = "LHC_CA_CERT";
    public static final String OAUTH_CLIENT_ID_KEY = "LHC_OAUTH_CLIENT_ID";
    public static final String OAUTH_CLIENT_SECRET_KEY = "LHC_OAUTH_CLIENT_SECRET";
    public static final String OAUTH_ACCESS_TOKEN_URL = "LHC_OAUTH_ACCESS_TOKEN_URL";
    public static final String NUM_WORKER_THREADS_KEY = "LHW_NUM_WORKER_THREADS";
    public static final String GRPC_KEEPALIVE_TIME_MS_KEY = "LHC_GRPC_KEEPALIVE_TIME_MS";
    public static final String GRPC_KEEPALIVE_TIMEOUT_MS_KEY = "LHC_GRPC_KEEPALIVE_TIMEOUT_MS";
    public static final String TASK_WORKER_VERSION_KEY = "LHW_TASK_WORKER_VERSION";
    public static final String DEFAULT_PUBLIC_LISTENER = "PLAIN";
    public static final String DEFAULT_PROTOCOL = "PLAINTEXT";
    public static final String INFLIGHT_TASKS_KEY = "INFLIGHT_TASKS";
    private static final Set<String> configNames = Set.of("LHC_API_HOST", "LHC_API_PORT", "LHC_API_PROTOCOL", "LHW_TASK_WORKER_ID", "LHC_CLIENT_CERT", "LHC_CLIENT_KEY", "LHC_CA_CERT", "LHC_OAUTH_ACCESS_TOKEN_URL", "LHC_OAUTH_CLIENT_ID", "LHC_OAUTH_CLIENT_SECRET", "LHW_NUM_WORKER_THREADS", "LHW_TASK_WORKER_VERSION", "INFLIGHT_TASKS");
    private Map<String, Channel> createdChannels = new HashMap<String, Channel>();
    private OAuthClient oauthClient;
    private OAuthConfig oauthConfig;
    private OAuthCredentialsProvider oauthCredentialsProvider;

    public static Set<String> configNames() {
        return configNames;
    }

    public LHConfig() {
    }

    public LHConfig(Properties props) {
        super(props);
    }

    public LHConfig(Path propLocation) {
        super(propLocation.toString());
    }

    public LHConfig(String propLocation) {
        super(propLocation);
    }

    public LHConfig(Map<String, Object> configs) {
        super(configs);
    }

    public LittleHorseGrpc.LittleHorseBlockingStub getBlockingStub() {
        return this.getBlockingStub(this.getApiBootstrapHost(), this.getApiBootstrapPort());
    }

    public LittleHorseGrpc.LittleHorseFutureStub getFutureStub() {
        return this.getBaseFutureStub(this.getApiBootstrapHost(), this.getApiBootstrapPort());
    }

    public LittleHorseGrpc.LittleHorseStub getAsyncStub() {
        return this.getAsyncStub(this.getApiBootstrapHost(), this.getApiBootstrapPort());
    }

    public TaskDef getTaskDef(String taskDefName) {
        return this.getBlockingStub().getTaskDef(TaskDefId.newBuilder().setName(taskDefName).build());
    }

    public String getTaskWorkerVersion() {
        return this.getOrSetDefault(TASK_WORKER_VERSION_KEY, "");
    }

    public LittleHorseGrpc.LittleHorseStub getAsyncStub(String host, int port) {
        return (LittleHorseGrpc.LittleHorseStub)this.getBaseAsyncStub(host, port).withCallCredentials(this.getCredentials());
    }

    public LittleHorseGrpc.LittleHorseStub getAsyncStub(String host, int port, TenantId tenantId) {
        return (LittleHorseGrpc.LittleHorseStub)this.getBaseAsyncStub(host, port).withCallCredentials(this.getCredentials(tenantId));
    }

    public LittleHorseGrpc.LittleHorseBlockingStub getBlockingStub(String host, int port) {
        return (LittleHorseGrpc.LittleHorseBlockingStub)this.getBaseBlockingStub(host, port).withCallCredentials(this.getCredentials());
    }

    public LittleHorseGrpc.LittleHorseBlockingStub getBlockingStub(String host, int port, TenantId tenantId) {
        return (LittleHorseGrpc.LittleHorseBlockingStub)this.getBaseBlockingStub(host, port).withCallCredentials(this.getCredentials(tenantId));
    }

    public LittleHorseGrpc.LittleHorseFutureStub getFutureStub(String host, int port) {
        return (LittleHorseGrpc.LittleHorseFutureStub)this.getBaseFutureStub(host, port).withCallCredentials(this.getCredentials());
    }

    public LittleHorseGrpc.LittleHorseFutureStub getFutureStub(String host, int port, TenantId tenantId) {
        return (LittleHorseGrpc.LittleHorseFutureStub)this.getBaseFutureStub(host, port).withCallCredentials(this.getCredentials(tenantId));
    }

    private CallCredentials getCredentials(TenantId tenantId) {
        boolean isOAuth = this.isOauth();
        if (isOAuth) {
            return new CompositeCallCredentials((CallCredentials)this.oauthCredentialsProvider, (CallCredentials)new TenantMetadataProvider(tenantId));
        }
        return new TenantMetadataProvider(this.getTenantId());
    }

    private CallCredentials getCredentials() {
        boolean isOAuth = this.isOauth();
        TenantId tenantId = this.getTenantId();
        if (isOAuth) {
            return new CompositeCallCredentials((CallCredentials)this.oauthCredentialsProvider, (CallCredentials)new TenantMetadataProvider(tenantId));
        }
        return new TenantMetadataProvider(this.getTenantId());
    }

    private Channel getChannel(String host, int port) {
        ManagedChannelBuilder builder;
        String hostKey = host + ":" + port;
        if (this.createdChannels.containsKey(hostKey)) {
            return this.createdChannels.get(hostKey);
        }
        String caCertFile = this.getOrSetDefault(CA_CERT_KEY, null);
        String clientCertFile = this.getOrSetDefault(CLIENT_CERT_KEY, null);
        String clientKeyFile = this.getOrSetDefault(CLIENT_KEY_KEY, null);
        if (DEFAULT_PROTOCOL.equals(this.getApiProtocol())) {
            log.warn("Using insecure channel!");
            builder = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext();
        } else {
            log.info("Using secure connection!");
            TlsChannelCredentials.Builder tlsBuilder = TlsChannelCredentials.newBuilder();
            if (caCertFile != null) {
                try {
                    tlsBuilder.trustManager(new File(caCertFile));
                }
                catch (IOException e) {
                    throw new LHMisconfigurationException("Error accessing to certificate", e);
                }
            }
            if (clientCertFile != null && clientKeyFile != null) {
                log.info("Using mtls!");
                try {
                    tlsBuilder.keyManager(new File(clientCertFile), new File(clientKeyFile));
                }
                catch (IOException e) {
                    throw new LHMisconfigurationException("Error accessing to certificate", e);
                }
            }
            builder = Grpc.newChannelBuilderForAddress((String)host, (int)port, (ChannelCredentials)tlsBuilder.build());
        }
        builder = builder.keepAliveTime(this.getKeepaliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(this.getKeepaliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(true);
        ManagedChannel out = builder.build();
        this.createdChannels.put(hostKey, (Channel)out);
        return out;
    }

    private LittleHorseGrpc.LittleHorseBlockingStub getBaseBlockingStub(String host, int port) {
        return LittleHorseGrpc.newBlockingStub(this.getChannel(host, port));
    }

    private LittleHorseGrpc.LittleHorseFutureStub getBaseFutureStub(String host, int port) {
        return LittleHorseGrpc.newFutureStub(this.getChannel(host, port));
    }

    private LittleHorseGrpc.LittleHorseStub getBaseAsyncStub(String host, int port) {
        return LittleHorseGrpc.newStub(this.getChannel(host, port));
    }

    public long getKeepaliveTimeMs() {
        return Long.valueOf(this.getOrSetDefault(GRPC_KEEPALIVE_TIME_MS_KEY, "45000"));
    }

    public long getKeepaliveTimeoutMs() {
        return Long.valueOf(this.getOrSetDefault(GRPC_KEEPALIVE_TIMEOUT_MS_KEY, "5000"));
    }

    public String getApiBootstrapHost() {
        return this.getOrSetDefault(API_HOST_KEY, "localhost");
    }

    public int getApiBootstrapPort() {
        return Integer.valueOf(this.getOrSetDefault(API_PORT_KEY, "2023"));
    }

    public String getApiProtocol() {
        String protocol = this.getOrSetDefault(API_PROTOCOL_KEY, DEFAULT_PROTOCOL);
        if (!protocol.equals(DEFAULT_PROTOCOL) && !protocol.equals("TLS")) {
            throw new IllegalArgumentException("Invalid protocol: " + protocol);
        }
        return protocol;
    }

    public String getTaskWorkerId() {
        return this.getOrSetDefault(TASK_WORKER_ID_KEY, "worker-" + UUID.randomUUID().toString().replaceAll("-", ""));
    }

    public TenantId getTenantId() {
        String tenantId = this.getOrSetDefault(TENANT_ID_KEY, "default");
        return TenantId.newBuilder().setId(tenantId).build();
    }

    public Integer getInflightTasks() {
        return Integer.valueOf(this.getOrSetDefault(INFLIGHT_TASKS_KEY, "1"));
    }

    public boolean isOauth() {
        String clientId = this.getOrSetDefault(OAUTH_CLIENT_ID_KEY, null);
        String clientSecret = this.getOrSetDefault(OAUTH_CLIENT_SECRET_KEY, null);
        String tokenEndpointUrl = this.getOrSetDefault(OAUTH_ACCESS_TOKEN_URL, null);
        if (clientId == null && clientSecret == null && tokenEndpointUrl == null) {
            log.warn("OAuth is disable");
            return false;
        }
        if (clientId == null || clientSecret == null || tokenEndpointUrl == null) {
            throw new IllegalArgumentException("OAuth Configuration is Missing");
        }
        log.info("OAuth is enable");
        if (this.oauthConfig == null) {
            this.oauthConfig = OAuthConfig.builder().tokenEndpointURI(URI.create(tokenEndpointUrl)).clientId(clientId).clientSecret(clientSecret).build();
        }
        if (this.oauthClient == null) {
            this.oauthClient = new OAuthClient(this.oauthConfig);
        }
        if (this.oauthCredentialsProvider == null) {
            this.oauthCredentialsProvider = new OAuthCredentialsProvider(this.oauthClient);
        }
        return true;
    }

    @Override
    protected String[] getEnvKeyPrefixes() {
        return new String[]{"LHC_", "LHW_"};
    }

    public int getWorkerThreads() {
        return Integer.valueOf(this.getOrSetDefault(NUM_WORKER_THREADS_KEY, "2"));
    }
}

