/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal;

import com.google.protobuf.Message;
import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.exception.LHSerdeError;
import io.littlehorse.sdk.common.exception.TaskSchemaMismatchError;
import io.littlehorse.sdk.common.proto.Comparator;
import io.littlehorse.sdk.common.proto.Edge;
import io.littlehorse.sdk.common.proto.EdgeCondition;
import io.littlehorse.sdk.common.proto.EntrypointNode;
import io.littlehorse.sdk.common.proto.ExitNode;
import io.littlehorse.sdk.common.proto.ExponentialBackoffRetryPolicy;
import io.littlehorse.sdk.common.proto.ExternalEventDefId;
import io.littlehorse.sdk.common.proto.ExternalEventNode;
import io.littlehorse.sdk.common.proto.FailureDef;
import io.littlehorse.sdk.common.proto.FailureHandlerDef;
import io.littlehorse.sdk.common.proto.InterruptDef;
import io.littlehorse.sdk.common.proto.LHErrorType;
import io.littlehorse.sdk.common.proto.Node;
import io.littlehorse.sdk.common.proto.NopNode;
import io.littlehorse.sdk.common.proto.SleepNode;
import io.littlehorse.sdk.common.proto.StartMultipleThreadsNode;
import io.littlehorse.sdk.common.proto.StartThreadNode;
import io.littlehorse.sdk.common.proto.TaskDefId;
import io.littlehorse.sdk.common.proto.TaskNode;
import io.littlehorse.sdk.common.proto.ThreadRetentionPolicy;
import io.littlehorse.sdk.common.proto.ThreadSpec;
import io.littlehorse.sdk.common.proto.ThrowEventNode;
import io.littlehorse.sdk.common.proto.UTActionTrigger;
import io.littlehorse.sdk.common.proto.UserTaskNode;
import io.littlehorse.sdk.common.proto.VariableAssignment;
import io.littlehorse.sdk.common.proto.VariableDef;
import io.littlehorse.sdk.common.proto.VariableMutation;
import io.littlehorse.sdk.common.proto.VariableMutationType;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.common.proto.VariableValue;
import io.littlehorse.sdk.common.proto.WaitForThreadsNode;
import io.littlehorse.sdk.common.proto.WorkflowEventDefId;
import io.littlehorse.sdk.wfsdk.IfElseBody;
import io.littlehorse.sdk.wfsdk.LHFormatString;
import io.littlehorse.sdk.wfsdk.NodeOutput;
import io.littlehorse.sdk.wfsdk.SpawnedThreads;
import io.littlehorse.sdk.wfsdk.ThreadFunc;
import io.littlehorse.sdk.wfsdk.UserTaskOutput;
import io.littlehorse.sdk.wfsdk.WaitForThreadsNodeOutput;
import io.littlehorse.sdk.wfsdk.WfRunVariable;
import io.littlehorse.sdk.wfsdk.WorkflowCondition;
import io.littlehorse.sdk.wfsdk.WorkflowThread;
import io.littlehorse.sdk.wfsdk.internal.BuilderUtil;
import io.littlehorse.sdk.wfsdk.internal.LHFormatStringImpl;
import io.littlehorse.sdk.wfsdk.internal.NodeOutputImpl;
import io.littlehorse.sdk.wfsdk.internal.SpawnedThreadImpl;
import io.littlehorse.sdk.wfsdk.internal.SpawnedThreadsIterator;
import io.littlehorse.sdk.wfsdk.internal.TaskNodeOutputImpl;
import io.littlehorse.sdk.wfsdk.internal.UserTaskOutputImpl;
import io.littlehorse.sdk.wfsdk.internal.WaitForThreadsNodeOutputImpl;
import io.littlehorse.sdk.wfsdk.internal.WfRunVariableImpl;
import io.littlehorse.sdk.wfsdk.internal.WorkflowConditionImpl;
import io.littlehorse.sdk.wfsdk.internal.WorkflowImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkflowThreadImpl
implements WorkflowThread {
    private static final Logger log = LoggerFactory.getLogger(WorkflowThreadImpl.class);
    private WorkflowImpl parent;
    private ThreadSpec.Builder spec;
    private List<WfRunVariableImpl> wfRunVariables = new ArrayList<WfRunVariableImpl>();
    public String lastNodeName;
    public String name;
    private EdgeCondition lastNodeCondition;
    private boolean isActive;
    private ThreadRetentionPolicy retentionPolicy;
    private Queue<VariableMutation> variableMutations;

    public WorkflowThreadImpl(String name, WorkflowImpl parent, ThreadFunc func) {
        String entrypointNodeName;
        this.parent = parent;
        this.spec = ThreadSpec.newBuilder();
        this.name = name;
        this.variableMutations = new LinkedList<VariableMutation>();
        Node entrypointNode = Node.newBuilder().setEntrypoint(EntrypointNode.newBuilder()).build();
        this.lastNodeName = entrypointNodeName = "0-entrypoint-ENTRYPOINT";
        this.spec.putNodes(entrypointNodeName, entrypointNode);
        this.isActive = true;
        func.threadFunction(this);
        Node node = this.spec.getNodesOrThrow(this.lastNodeName);
        if (node.getNodeCase() != Node.NodeCase.EXIT) {
            this.addNode("exit", Node.NodeCase.EXIT, (Message)ExitNode.newBuilder().build());
        }
        this.isActive = false;
        if (this.getRetentionPolicy() != null) {
            this.spec.setRetentionPolicy(this.getRetentionPolicy());
        }
    }

    public ThreadSpec.Builder getSpec() {
        this.spec.clearVariableDefs();
        for (WfRunVariableImpl wfRunVariable : this.wfRunVariables) {
            this.spec.addVariableDefs(wfRunVariable.getSpec());
        }
        return this.spec;
    }

    @Override
    public void withRetentionPolicy(ThreadRetentionPolicy policy) {
        this.retentionPolicy = policy;
    }

    private ThreadRetentionPolicy getRetentionPolicy() {
        if (this.retentionPolicy != null) {
            return this.retentionPolicy;
        }
        return this.getParent().getDefaultThreadRetentionPolicy();
    }

    @Override
    public void releaseToGroupOnDeadline(UserTaskOutput userTaskOutput, Object deadlineSeconds) {
        this.checkIfIsActive();
        Node.Builder curNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        UserTaskOutputImpl utImpl = (UserTaskOutputImpl)userTaskOutput;
        if (!this.lastNodeName.equals(utImpl.nodeName)) {
            throw new IllegalStateException("Tried to edit a stale User Task node!");
        }
        if (!curNode.getUserTask().hasUserId()) {
            throw new IllegalStateException("The User Task is not assigned to any user");
        }
        if (!curNode.getUserTask().hasUserGroup()) {
            throw new IllegalStateException("The User Task is assigned to a user without a group.");
        }
        VariableAssignment userGroup = curNode.getUserTask().getUserGroup();
        this.reassignToGroupOnDeadline(userGroup, curNode, deadlineSeconds);
    }

    private void reassignToGroupOnDeadline(VariableAssignment userGroup, Node.Builder currentNode, Object deadlineSeconds) {
        UTActionTrigger.UTAReassign reassignPb = UTActionTrigger.UTAReassign.newBuilder().setUserGroup(userGroup).build();
        UTActionTrigger actionTrigger = UTActionTrigger.newBuilder().setReassign(reassignPb).setHook(UTActionTrigger.UTHook.ON_TASK_ASSIGNED).setDelaySeconds(this.assignVariable(deadlineSeconds)).build();
        currentNode.getUserTaskBuilder().addActions(actionTrigger);
        this.spec.putNodes(this.lastNodeName, currentNode.build());
    }

    @Override
    public void reassignUserTask(UserTaskOutput userTask, Object userId, Object userGroup, Object deadlineSeconds) {
        this.checkIfIsActive();
        Node.Builder curNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        UserTaskOutputImpl utImpl = (UserTaskOutputImpl)userTask;
        if (!this.lastNodeName.equals(utImpl.nodeName)) {
            throw new IllegalStateException("Tried to edit a stale User Task node!");
        }
        UTActionTrigger.UTAReassign.Builder reassignment = UTActionTrigger.UTAReassign.newBuilder().setUserId(this.assignVariable(userId));
        if (userGroup != null) {
            reassignment.setUserGroup(this.assignVariable(userGroup));
        }
        if (userId != null) {
            reassignment.setUserId(this.assignVariable(userId));
        }
        UTActionTrigger actionTrigger = UTActionTrigger.newBuilder().setReassign(reassignment).setHook(UTActionTrigger.UTHook.ON_TASK_ASSIGNED).setDelaySeconds(this.assignVariable(deadlineSeconds)).build();
        curNode.getUserTaskBuilder().addActions(actionTrigger);
        this.spec.putNodes(this.lastNodeName, curNode.build());
    }

    @Override
    public UserTaskOutputImpl assignUserTask(String userTaskDefName, Object userId, Object userGroup) {
        this.checkIfIsActive();
        UserTaskNode.Builder utNode = UserTaskNode.newBuilder().setUserTaskDefName(userTaskDefName);
        if (userId != null) {
            VariableAssignment userIdAssn = this.assignVariable(userId);
            utNode.setUserId(userIdAssn);
        }
        if (userGroup != null) {
            VariableAssignment userGroupAssn = this.assignVariable(userGroup);
            utNode.setUserGroup(userGroupAssn);
        }
        String nodeName = this.addNode(userTaskDefName, Node.NodeCase.USER_TASK, (Message)utNode.build());
        return new UserTaskOutputImpl(nodeName, this);
    }

    @Override
    public void scheduleReminderTask(UserTaskOutput ut, WfRunVariable delaySeconds, String taskDefName, Serializable ... args) {
        this.scheduleTaskAfterHelper(ut, delaySeconds, taskDefName, UTActionTrigger.UTHook.ON_ARRIVAL, args);
    }

    @Override
    public void scheduleReminderTask(UserTaskOutput ut, int delaySeconds, String taskDefName, Serializable ... args) {
        this.scheduleTaskAfterHelper(ut, Integer.valueOf(delaySeconds), taskDefName, UTActionTrigger.UTHook.ON_ARRIVAL, args);
    }

    @Override
    public void scheduleReminderTaskOnAssignment(UserTaskOutput ut, int delaySeconds, String taskDefName, Serializable ... args) {
        this.scheduleTaskAfterHelper(ut, Integer.valueOf(delaySeconds), taskDefName, UTActionTrigger.UTHook.ON_TASK_ASSIGNED, args);
    }

    @Override
    public void scheduleReminderTaskOnAssignment(UserTaskOutput ut, WfRunVariable delaySeconds, String taskDefName, Serializable ... args) {
        this.scheduleTaskAfterHelper(ut, delaySeconds, taskDefName, UTActionTrigger.UTHook.ON_TASK_ASSIGNED, args);
    }

    public void scheduleTaskAfterHelper(UserTaskOutput ut, Serializable delaySeconds, String taskDefName, UTActionTrigger.UTHook utHook, Serializable ... args) {
        this.checkIfIsActive();
        VariableAssignment assn = this.assignVariable(delaySeconds);
        TaskNode taskNode = this.createTaskNode(TaskNode.newBuilder().setTaskDefId(TaskDefId.newBuilder().setName(taskDefName)), args);
        this.parent.addTaskDefName(taskDefName);
        UTActionTrigger.UTATask utaTask = UTActionTrigger.UTATask.newBuilder().setTask(taskNode).build();
        UserTaskOutputImpl utImpl = (UserTaskOutputImpl)ut;
        if (!this.lastNodeName.equals(utImpl.nodeName)) {
            throw new RuntimeException("Tried to edit a stale User Task node!");
        }
        Node.Builder curNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        UTActionTrigger.Builder newUtActionBuilder = UTActionTrigger.newBuilder().setTask(utaTask).setHook(utHook).setDelaySeconds(assn);
        curNode.getUserTaskBuilder().addActions(newUtActionBuilder);
        this.spec.putNodes(this.lastNodeName, curNode.build());
    }

    @Override
    public void cancelUserTaskRunAfter(UserTaskOutput userTask, Serializable delaySeconds) {
        this.checkIfIsActive();
        this.scheduleUserTaskCancellationAfterDeadline(userTask, delaySeconds, UTActionTrigger.UTHook.ON_ARRIVAL);
    }

    @Override
    public void cancelUserTaskRunAfterAssignment(UserTaskOutput userTask, Serializable delaySeconds) {
        this.checkIfIsActive();
        this.scheduleUserTaskCancellationAfterDeadline(userTask, delaySeconds, UTActionTrigger.UTHook.ON_TASK_ASSIGNED);
    }

    private void scheduleUserTaskCancellationAfterDeadline(UserTaskOutput userTask, Serializable delaySeconds, UTActionTrigger.UTHook hook) {
        VariableAssignment assn = this.assignVariable(delaySeconds);
        UTActionTrigger.UTACancel utaCancel = UTActionTrigger.UTACancel.newBuilder().build();
        UserTaskOutputImpl utImpl = (UserTaskOutputImpl)userTask;
        if (!this.lastNodeName.equals(utImpl.nodeName)) {
            throw new RuntimeException("Tried to edit a stale User Task node!");
        }
        Node.Builder curNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        UTActionTrigger.Builder newUtActionBuilder = UTActionTrigger.newBuilder().setCancel(utaCancel).setHook(hook).setDelaySeconds(assn);
        curNode.getUserTaskBuilder().addActions(newUtActionBuilder);
        this.spec.putNodes(this.lastNodeName, curNode.build());
    }

    @Override
    public LHFormatStringImpl format(String format, WfRunVariable ... args) {
        return new LHFormatStringImpl(this, format, args);
    }

    @Override
    public TaskNodeOutputImpl execute(String taskName, Serializable ... args) {
        this.checkIfIsActive();
        this.parent.addTaskDefName(taskName);
        TaskNode taskNode = this.createTaskNode(TaskNode.newBuilder().setTaskDefId(TaskDefId.newBuilder().setName(taskName)), args);
        String nodeName = this.addNode(taskName, Node.NodeCase.TASK, (Message)taskNode);
        return new TaskNodeOutputImpl(nodeName, this);
    }

    @Override
    public TaskNodeOutputImpl execute(WfRunVariable taskName, Serializable ... args) {
        this.checkIfIsActive();
        TaskNode taskNode = this.createTaskNode(TaskNode.newBuilder().setDynamicTask(this.assignVariable(taskName)), args);
        String nodeName = this.addNode(((WfRunVariableImpl)taskName).getName(), Node.NodeCase.TASK, (Message)taskNode);
        return new TaskNodeOutputImpl(nodeName, this);
    }

    @Override
    public TaskNodeOutputImpl execute(LHFormatString taskName, Serializable ... args) {
        this.checkIfIsActive();
        TaskNode taskNode = this.createTaskNode(TaskNode.newBuilder().setDynamicTask(this.assignVariable(taskName)), args);
        String nodeName = this.addNode(((LHFormatStringImpl)taskName).getFormat(), Node.NodeCase.TASK, (Message)taskNode);
        return new TaskNodeOutputImpl(nodeName, this);
    }

    private TaskNode createTaskNode(TaskNode.Builder taskNode, Serializable ... args) {
        for (Serializable var : args) {
            taskNode.addVariables(this.assignVariable(var));
        }
        if (this.parent.getDefaultTaskTimeout() != null) {
            taskNode.setTimeoutSeconds(this.parent.getDefaultTaskTimeout());
        }
        taskNode.setRetries(this.parent.getDefaultSimpleRetries());
        if (this.parent.getDefaultExponentialBackoffRetryPolicy().isPresent()) {
            taskNode.setExponentialBackoff(this.parent.getDefaultExponentialBackoffRetryPolicy().get());
        }
        return taskNode.build();
    }

    public void checkArgsVsTaskDef(List<VariableDef> taskDefInputVars, String taskDefName, Object ... args) throws TaskSchemaMismatchError {
        if (args.length != taskDefInputVars.size()) {
            throw new TaskSchemaMismatchError("Mismatched number of arguments!");
        }
        for (int i = 0; i < args.length; ++i) {
            VariableType argType;
            Object arg = args[i];
            if (WfRunVariableImpl.class.isAssignableFrom(arg.getClass())) {
                WfRunVariableImpl wfVar = (WfRunVariableImpl)arg;
                if ((wfVar.type == VariableType.JSON_ARR || wfVar.type == VariableType.JSON_OBJ) && wfVar.jsonPath != null) {
                    log.info("There is a jsonpath, so not checking value because Json schema isn't yet implemented");
                    continue;
                }
                argType = wfVar.type;
            } else {
                argType = LHLibUtil.javaClassToLHVarType(arg.getClass());
            }
            if (argType.equals((Object)taskDefInputVars.get(i).getType())) continue;
            throw new TaskSchemaMismatchError("Mismatch var type for param " + i + "on taskdef " + taskDefName + ": " + argType + " not compatible with " + taskDefInputVars.get(i).getType());
        }
    }

    @Override
    public WfRunVariableImpl addVariable(String name, Object typeOrDefaultVal) {
        this.checkIfIsActive();
        WfRunVariableImpl wfRunVariable = new WfRunVariableImpl(name, typeOrDefaultVal);
        this.wfRunVariables.add(wfRunVariable);
        return wfRunVariable;
    }

    @Override
    public void doIf(WorkflowCondition condition, IfElseBody ifBody) {
        this.checkIfIsActive();
        WorkflowConditionImpl cond = (WorkflowConditionImpl)condition;
        this.addNopNode();
        String treeRootNodeName = this.lastNodeName;
        this.lastNodeCondition = cond.getSpec();
        ifBody.body(this);
        this.addNopNode();
        Node.Builder treeRoot = this.spec.getNodesOrThrow(treeRootNodeName).toBuilder();
        treeRoot.addOutgoingEdges(Edge.newBuilder().setSinkNodeName(this.lastNodeName).setCondition(cond.getReverse()).build());
        this.spec.putNodes(treeRootNodeName, treeRoot.build());
    }

    private void addNopNode() {
        this.checkIfIsActive();
        this.addNode("nop", Node.NodeCase.NOP, (Message)NopNode.newBuilder().build());
    }

    @Override
    public void doIfElse(WorkflowCondition condition, IfElseBody ifBody, IfElseBody elseBody) {
        this.checkIfIsActive();
        WorkflowConditionImpl cond = (WorkflowConditionImpl)condition;
        this.addNopNode();
        String treeRootNodeName = this.lastNodeName;
        this.lastNodeCondition = cond.getSpec();
        ifBody.body(this);
        EdgeCondition lastConditionFromIfBlock = this.lastNodeCondition;
        String lastNodeFromIfBlockName = this.lastNodeName;
        List<VariableMutation> variablesFromIfBlock = this.collectVariableMutations();
        this.lastNodeName = treeRootNodeName;
        this.lastNodeCondition = cond.getReverse();
        elseBody.body(this);
        this.addNopNode();
        Node.Builder lastNodeFromIfBlock = this.spec.getNodesOrThrow(lastNodeFromIfBlockName).toBuilder();
        Edge.Builder ifBlockEdge = Edge.newBuilder().setSinkNodeName(this.lastNodeName);
        if (Objects.equals(treeRootNodeName, lastNodeFromIfBlockName)) {
            ifBlockEdge.setCondition(lastConditionFromIfBlock);
        }
        variablesFromIfBlock.forEach(ifBlockEdge::addVariableMutations);
        lastNodeFromIfBlock.addOutgoingEdges(ifBlockEdge.build());
        this.spec.putNodes(lastNodeFromIfBlockName, lastNodeFromIfBlock.build());
    }

    private List<VariableMutation> collectVariableMutations() {
        ArrayList<VariableMutation> variablesFromIfBlock = new ArrayList<VariableMutation>(this.variableMutations.size());
        while (!this.variableMutations.isEmpty()) {
            variablesFromIfBlock.add(this.variableMutations.poll());
        }
        return variablesFromIfBlock;
    }

    @Override
    public void doWhile(WorkflowCondition condition, ThreadFunc whileBody) {
        this.checkIfIsActive();
        WorkflowConditionImpl cond = (WorkflowConditionImpl)condition;
        this.addNopNode();
        String treeRootNodeName = this.lastNodeName;
        this.lastNodeCondition = cond.getSpec();
        whileBody.threadFunction(this);
        this.addNopNode();
        String treeLastNodeName = this.lastNodeName;
        Node.Builder treeRoot = this.spec.getNodesOrThrow(treeRootNodeName).toBuilder();
        treeRoot.addOutgoingEdges(Edge.newBuilder().setSinkNodeName(treeLastNodeName).setCondition(cond.getReverse()).build());
        this.spec.putNodes(treeRootNodeName, treeRoot.build());
        Node.Builder treeLast = this.spec.getNodesOrThrow(treeLastNodeName).toBuilder();
        treeLast.addOutgoingEdges(Edge.newBuilder().setSinkNodeName(treeRootNodeName).setCondition(cond.getSpec()).build());
        this.spec.putNodes(treeLastNodeName, treeLast.build());
    }

    @Override
    public SpawnedThreads spawnThreadForEach(WfRunVariable wfRunVariable, String threadName, ThreadFunc threadFunc) {
        return this.spawnThreadForEach(wfRunVariable, threadName, threadFunc, Map.of());
    }

    @Override
    public SpawnedThreads spawnThreadForEach(WfRunVariable wfRunVariable, String threadName, ThreadFunc threadFunc, Map<String, Object> inputVars) {
        this.checkIfIsActive();
        String finalThreadName = this.parent.addSubThread(threadName, threadFunc);
        StartMultipleThreadsNode.Builder startMultiplesThreadNode = StartMultipleThreadsNode.newBuilder().setThreadSpecName(finalThreadName).setIterable(this.assignVariable(wfRunVariable));
        for (Map.Entry<String, Object> inputVar : inputVars.entrySet()) {
            startMultiplesThreadNode.putVariables(inputVar.getKey(), this.assignVariable(inputVar.getValue()));
        }
        String nodeName = this.addNode(threadName, Node.NodeCase.START_MULTIPLE_THREADS, (Message)startMultiplesThreadNode.build());
        WfRunVariableImpl internalStartedThreadVar = this.addVariable(nodeName, (Object)VariableType.JSON_ARR);
        this.mutate(internalStartedThreadVar, VariableMutationType.ASSIGN, new NodeOutputImpl(nodeName, this));
        return new SpawnedThreadsIterator(internalStartedThreadVar);
    }

    @Override
    public void sleepSeconds(Object secondsToSleep) {
        this.checkIfIsActive();
        SleepNode.Builder n = SleepNode.newBuilder().setRawSeconds(this.assignVariable(secondsToSleep));
        this.addNode("sleep", Node.NodeCase.SLEEP, (Message)n.build());
    }

    @Override
    public void sleepUntil(WfRunVariable timestamp) {
        this.checkIfIsActive();
        SleepNode.Builder n = SleepNode.newBuilder().setTimestamp(this.assignVariable(timestamp));
        this.addNode("sleep", Node.NodeCase.SLEEP, (Message)n.build());
    }

    @Override
    public SpawnedThreadImpl spawnThread(ThreadFunc threadFunc, String threadName, Map<String, Object> inputVars) {
        this.checkIfIsActive();
        if (inputVars == null) {
            inputVars = new HashMap<String, Object>();
        }
        threadName = this.parent.addSubThread(threadName, threadFunc);
        HashMap<String, VariableAssignment> varAssigns = new HashMap<String, VariableAssignment>();
        for (Map.Entry<String, Object> var : inputVars.entrySet()) {
            varAssigns.put(var.getKey(), this.assignVariable(var.getValue()));
        }
        StartThreadNode startThread = StartThreadNode.newBuilder().setThreadSpecName(threadName).putAllVariables(varAssigns).build();
        String nodeName = this.addNode(threadName, Node.NodeCase.START_THREAD, (Message)startThread);
        WfRunVariableImpl internalStartedThreadVar = this.addVariable(nodeName, (Object)VariableType.INT);
        this.mutate(internalStartedThreadVar, VariableMutationType.ASSIGN, new NodeOutputImpl(nodeName, this));
        return new SpawnedThreadImpl(this, threadName, internalStartedThreadVar);
    }

    public void overrideTaskRetries(TaskNodeOutputImpl node, int retries) {
        this.checkIfIsActive();
        Node.Builder nb = this.spec.getNodesOrThrow(node.nodeName).toBuilder();
        if (nb.getNodeCase() != Node.NodeCase.TASK) {
            throw new IllegalStateException("Impossible to not have task node here");
        }
        TaskNode.Builder taskBuilder = nb.getTaskBuilder();
        taskBuilder.setRetries(retries);
        nb.setTask(taskBuilder);
        this.spec.putNodes(node.nodeName, nb.build());
    }

    public void overrideTaskExponentialBackoffPolicy(TaskNodeOutputImpl node, ExponentialBackoffRetryPolicy policy) {
        this.checkIfIsActive();
        Node.Builder nb = this.spec.getNodesOrThrow(node.nodeName).toBuilder();
        if (nb.getNodeCase() != Node.NodeCase.TASK) {
            throw new IllegalStateException("Impossible to not have task node here");
        }
        TaskNode.Builder taskBuilder = nb.getTaskBuilder();
        taskBuilder.setExponentialBackoff(policy);
        nb.setTask(taskBuilder);
        this.spec.putNodes(node.nodeName, nb.build());
    }

    public void addTimeoutToExtEvt(NodeOutputImpl node, int timeoutSeconds) {
        this.checkIfIsActive();
        Node.Builder n = this.spec.getNodesOrThrow(node.nodeName).toBuilder();
        VariableAssignment timeoutValue = VariableAssignment.newBuilder().setLiteralValue(VariableValue.newBuilder().setInt(timeoutSeconds)).build();
        if (n.getNodeCase() == Node.NodeCase.TASK) {
            TaskNode.Builder task = n.getTaskBuilder();
            task.setTimeoutSeconds(timeoutSeconds);
            n.setTask(task);
        } else if (n.getNodeCase() == Node.NodeCase.EXTERNAL_EVENT) {
            ExternalEventNode.Builder evt = n.getExternalEventBuilder();
            evt.setTimeoutSeconds(timeoutValue);
            n.setExternalEvent(evt);
        } else {
            throw new RuntimeException("Timeouts are only supported on ExternalEvent and Task nodes.");
        }
        this.spec.putNodes(node.nodeName, n.build());
    }

    public void addFailureHandlerOnWaitForThreadsNode(WaitForThreadsNodeOutputImpl node, FailureHandlerDef handler) {
        this.checkIfIsActive();
        Node.Builder n = this.spec.getNodesOrThrow(node.nodeName).toBuilder();
        if (n.getNodeCase() != Node.NodeCase.WAIT_FOR_THREADS) {
            throw new IllegalStateException("orzdash this should only be a WAIT_FOR_THREADS node");
        }
        WaitForThreadsNode.Builder subBuilder = n.getWaitForThreadsBuilder();
        subBuilder.addPerThreadFailureHandlers(handler);
        n.setWaitForThreads(subBuilder);
        this.spec.putNodes(node.nodeName, n.build());
    }

    @Override
    public void mutate(WfRunVariable lhsVar, VariableMutationType type, Object rhs) {
        this.checkIfIsActive();
        WfRunVariableImpl lhs = (WfRunVariableImpl)lhsVar;
        VariableMutation.Builder mutation = VariableMutation.newBuilder().setLhsName(lhs.name).setOperation(type);
        if (lhs.jsonPath != null) {
            mutation.setLhsJsonPath(lhs.jsonPath);
        }
        if (NodeOutputImpl.class.isAssignableFrom(rhs.getClass())) {
            NodeOutputImpl no = (NodeOutputImpl)rhs;
            if (!no.nodeName.equals(this.lastNodeName)) {
                log.debug("Mutating {} {} {}", new Object[]{no.nodeName, this.lastNodeName, this.name});
                throw new RuntimeException("Cannot use an old NodeOutput from node " + no.nodeName);
            }
            VariableMutation.NodeOutputSource.Builder nodeOutputSource = VariableMutation.NodeOutputSource.newBuilder();
            if (no.jsonPath != null) {
                nodeOutputSource.setJsonpath(no.jsonPath);
            }
            mutation.setNodeOutput(nodeOutputSource);
        } else if (WfRunVariableImpl.class.isAssignableFrom(rhs.getClass())) {
            WfRunVariableImpl var = (WfRunVariableImpl)rhs;
            VariableAssignment.Builder varBuilder = VariableAssignment.newBuilder();
            if (var.jsonPath != null) {
                varBuilder.setJsonPath(var.jsonPath);
            }
            varBuilder.setVariableName(var.name);
            mutation.setSourceVariable(varBuilder);
        } else {
            VariableValue rhsVal;
            try {
                rhsVal = LHLibUtil.objToVarVal(rhs);
            }
            catch (LHSerdeError exn) {
                throw new RuntimeException(exn);
            }
            mutation.setLiteralValue(rhsVal);
        }
        this.variableMutations.add(mutation.build());
    }

    @Override
    public WaitForThreadsNodeOutput waitForThreads(SpawnedThreads threads) {
        this.checkIfIsActive();
        WaitForThreadsNode waitNode = threads.buildNode();
        String nodeName = this.addNode("threads", Node.NodeCase.WAIT_FOR_THREADS, (Message)waitNode);
        return new WaitForThreadsNodeOutputImpl(nodeName, this, this.spec);
    }

    @Override
    public void throwEvent(String workflowEventDefName, Serializable content) {
        this.checkIfIsActive();
        ThrowEventNode node = ThrowEventNode.newBuilder().setEventDefId(WorkflowEventDefId.newBuilder().setName(workflowEventDefName).build()).setContent(this.assignVariable(content)).build();
        this.addNode("throw-" + workflowEventDefName, Node.NodeCase.THROW_EVENT, (Message)node);
    }

    @Override
    public NodeOutputImpl waitForEvent(String externalEventDefName) {
        this.checkIfIsActive();
        ExternalEventNode waitNode = ExternalEventNode.newBuilder().setExternalEventDefId(ExternalEventDefId.newBuilder().setName(externalEventDefName)).build();
        this.parent.addExternalEventDefName(externalEventDefName);
        return new NodeOutputImpl(this.addNode(externalEventDefName, Node.NodeCase.EXTERNAL_EVENT, (Message)waitNode), this);
    }

    @Override
    public void complete() {
        this.checkIfIsActive();
        ExitNode exitNode = ExitNode.newBuilder().build();
        this.addNode("complete", Node.NodeCase.EXIT, (Message)exitNode);
    }

    @Override
    public void fail(String failureName, String message) {
        this.fail(null, failureName, message);
    }

    @Override
    public void fail(Object output, String failureName, String message) {
        this.checkIfIsActive();
        FailureDef.Builder failureBuilder = FailureDef.newBuilder();
        if (output != null) {
            failureBuilder.setContent(this.assignVariable(output));
        }
        if (message != null) {
            failureBuilder.setMessage(message);
        }
        failureBuilder.setFailureName(failureName);
        ExitNode exitNode = ExitNode.newBuilder().setFailureDef(failureBuilder).build();
        this.addNode(failureName, Node.NodeCase.EXIT, (Message)exitNode);
    }

    @Override
    public void registerInterruptHandler(String interruptName, ThreadFunc handler) {
        this.checkIfIsActive();
        Object threadName = "interrupt-" + interruptName;
        threadName = this.parent.addSubThread((String)threadName, handler);
        this.parent.addExternalEventDefName(interruptName);
        this.spec.addInterruptDefs(InterruptDef.newBuilder().setExternalEventDefId(ExternalEventDefId.newBuilder().setName(interruptName)).setHandlerSpecName((String)threadName).build());
    }

    @Override
    public void handleException(NodeOutput nodeOutput, String exceptionName, ThreadFunc handler) {
        this.addExceptionHandler(nodeOutput, exceptionName, handler);
    }

    @Override
    public void handleException(NodeOutput node, ThreadFunc handler) {
        this.addExceptionHandler(node, null, handler);
    }

    @Override
    public void handleError(NodeOutput node, LHErrorType error, ThreadFunc handler) {
        this.addErrorHandler(node, error, handler);
    }

    @Override
    public void handleError(NodeOutput node, ThreadFunc handler) {
        this.addErrorHandler(node, null, handler);
    }

    @Override
    public void handleAnyFailure(NodeOutput nodeOutput, ThreadFunc handler) {
        this.checkIfIsActive();
        NodeOutputImpl node = (NodeOutputImpl)nodeOutput;
        Object threadName = "exn-handler-" + node.nodeName + "-any-failure";
        threadName = this.parent.addSubThread((String)threadName, handler);
        FailureHandlerDef.Builder handlerDef = FailureHandlerDef.newBuilder().setHandlerSpecName((String)threadName);
        this.addFailureHandlerDef(handlerDef.build(), node);
    }

    private void addFailureHandlerDef(FailureHandlerDef handlerDef, NodeOutputImpl node) {
        Node.Builder lastNodeBuilder = this.spec.getNodesOrThrow(node.nodeName).toBuilder();
        lastNodeBuilder.addFailureHandlers(handlerDef);
        this.spec.putNodes(node.nodeName, lastNodeBuilder.build());
    }

    private void addExceptionHandler(NodeOutput nodeOutput, String exceptionName, ThreadFunc handler) {
        this.checkIfIsActive();
        NodeOutputImpl node = (NodeOutputImpl)nodeOutput;
        Object threadName = "exn-handler-" + node.nodeName + "-" + exceptionName;
        threadName = this.parent.addSubThread((String)threadName, handler);
        FailureHandlerDef.Builder handlerDef = FailureHandlerDef.newBuilder().setHandlerSpecName((String)threadName);
        if (exceptionName != null) {
            handlerDef.setSpecificFailure(exceptionName);
        } else {
            handlerDef.setAnyFailureOfType(FailureHandlerDef.LHFailureType.FAILURE_TYPE_EXCEPTION);
        }
        this.addFailureHandlerDef(handlerDef.build(), node);
    }

    private void addErrorHandler(NodeOutput nodeOutput, LHErrorType errorType, ThreadFunc handler) {
        this.checkIfIsActive();
        NodeOutputImpl node = (NodeOutputImpl)nodeOutput;
        Object threadName = "exn-handler-" + node.nodeName + "-" + (Serializable)(errorType != null ? errorType.name() : FailureHandlerDef.LHFailureType.FAILURE_TYPE_ERROR);
        threadName = this.parent.addSubThread((String)threadName, handler);
        FailureHandlerDef.Builder handlerDef = FailureHandlerDef.newBuilder().setHandlerSpecName((String)threadName);
        if (errorType != null) {
            handlerDef.setSpecificFailure(errorType.name());
        } else {
            handlerDef.setAnyFailureOfType(FailureHandlerDef.LHFailureType.FAILURE_TYPE_ERROR);
        }
        this.addFailureHandlerDef(handlerDef.build(), node);
    }

    @Override
    public WorkflowConditionImpl condition(Object lhs, Comparator comparator, Object rhs) {
        EdgeCondition.Builder edge = EdgeCondition.newBuilder().setComparator(comparator).setLeft(this.assignVariable(lhs)).setRight(this.assignVariable(rhs));
        return new WorkflowConditionImpl(edge.build());
    }

    private String addNode(String name, Node.NodeCase type, Message subNode) {
        this.checkIfIsActive();
        String nextNodeName = this.getNodeName(name, type);
        if (this.lastNodeName == null) {
            throw new IllegalStateException("Not possible to have null last node here");
        }
        Node.Builder feederNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        Edge.Builder edge = Edge.newBuilder().setSinkNodeName(nextNodeName);
        edge.addAllVariableMutations(this.collectVariableMutations());
        if (this.lastNodeCondition != null) {
            edge.setCondition(this.lastNodeCondition);
            this.lastNodeCondition = null;
        }
        if (feederNode.getNodeCase() != Node.NodeCase.EXIT) {
            feederNode.addOutgoingEdges(edge);
            this.spec.putNodes(this.lastNodeName, feederNode.build());
        }
        Node.Builder node = Node.newBuilder();
        switch (type) {
            case TASK: {
                node.setTask((TaskNode)subNode);
                break;
            }
            case ENTRYPOINT: {
                node.setEntrypoint((EntrypointNode)subNode);
                break;
            }
            case EXIT: {
                node.setExit((ExitNode)subNode);
                break;
            }
            case EXTERNAL_EVENT: {
                node.setExternalEvent((ExternalEventNode)subNode);
                break;
            }
            case SLEEP: {
                node.setSleep((SleepNode)subNode);
                break;
            }
            case START_THREAD: {
                node.setStartThread((StartThreadNode)subNode);
                break;
            }
            case WAIT_FOR_THREADS: {
                node.setWaitForThreads((WaitForThreadsNode)subNode);
                break;
            }
            case NOP: {
                node.setNop((NopNode)subNode);
                break;
            }
            case USER_TASK: {
                node.setUserTask((UserTaskNode)subNode);
                break;
            }
            case START_MULTIPLE_THREADS: {
                node.setStartMultipleThreads((StartMultipleThreadsNode)subNode);
                break;
            }
            case THROW_EVENT: {
                node.setThrowEvent((ThrowEventNode)subNode);
                break;
            }
            case NODE_NOT_SET: {
                throw new RuntimeException("Not possible");
            }
        }
        this.spec.putNodes(nextNodeName, node.build());
        this.lastNodeName = nextNodeName;
        return nextNodeName;
    }

    private String getNodeName(String name, Node.NodeCase type) {
        return this.spec.getNodesCount() + "-" + name + "-" + type;
    }

    public VariableAssignment assignVariable(Object variable) {
        this.checkIfIsActive();
        return BuilderUtil.assignVariable(variable);
    }

    private void checkIfIsActive() {
        if (!this.isActive) {
            throw new RuntimeException("Using a inactive thread");
        }
    }

    public WorkflowImpl getParent() {
        return this.parent;
    }

    public List<WfRunVariableImpl> getWfRunVariables() {
        return this.wfRunVariables;
    }

    public String getLastNodeName() {
        return this.lastNodeName;
    }

    public String getName() {
        return this.name;
    }

    public EdgeCondition getLastNodeCondition() {
        return this.lastNodeCondition;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Queue<VariableMutation> getVariableMutations() {
        return this.variableMutations;
    }

    public void setParent(WorkflowImpl parent) {
        this.parent = parent;
    }

    public void setSpec(ThreadSpec.Builder spec) {
        this.spec = spec;
    }

    public void setWfRunVariables(List<WfRunVariableImpl> wfRunVariables) {
        this.wfRunVariables = wfRunVariables;
    }

    public void setLastNodeName(String lastNodeName) {
        this.lastNodeName = lastNodeName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastNodeCondition(EdgeCondition lastNodeCondition) {
        this.lastNodeCondition = lastNodeCondition;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void setRetentionPolicy(ThreadRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public void setVariableMutations(Queue<VariableMutation> variableMutations) {
        this.variableMutations = variableMutations;
    }
}

