/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal.taskdefutil;

import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.exception.TaskSchemaMismatchError;
import io.littlehorse.sdk.common.proto.TaskDefOutputSchema;
import io.littlehorse.sdk.common.proto.VariableDef;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.worker.LHTaskMethod;
import io.littlehorse.sdk.worker.LHType;
import io.littlehorse.sdk.worker.WorkerContext;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHTaskSignature {
    private static final Logger log = LoggerFactory.getLogger(LHTaskSignature.class);
    List<VariableType> paramTypes = new ArrayList<VariableType>();
    List<String> varNames = new ArrayList<String>();
    List<Boolean> maskedParams = new ArrayList<Boolean>();
    Method taskMethod;
    boolean hasWorkerContextAtEnd = false;
    String taskDefName;
    String lhTaskMethodAnnotationValue;
    Object executable;
    TaskDefOutputSchema outputSchema;

    public LHTaskSignature(String taskDefName, Object executable, String lhTaskMethodAnnotationValue) throws TaskSchemaMismatchError {
        this.taskDefName = taskDefName;
        this.executable = executable;
        this.lhTaskMethodAnnotationValue = lhTaskMethodAnnotationValue;
        for (Method method : executable.getClass().getMethods()) {
            String taskDefForThisMethod;
            if (!method.isAnnotationPresent(LHTaskMethod.class) || !(taskDefForThisMethod = method.getAnnotation(LHTaskMethod.class).value()).equals(lhTaskMethodAnnotationValue)) continue;
            if (this.taskMethod != null) {
                throw new TaskSchemaMismatchError("Found two annotated task methods!");
            }
            this.taskMethod = method;
        }
        if (this.taskMethod == null) {
            throw new TaskSchemaMismatchError("Couldn't find annotated @LHTaskMethod for taskDef " + taskDefName + " on " + executable.getClass());
        }
        VariableType returnType = LHLibUtil.javaClassToLHVarType(this.taskMethod.getReturnType());
        boolean maskedValue = false;
        String outputSchemaVarName = "output";
        if (this.taskMethod.isAnnotationPresent(LHType.class)) {
            LHType type = this.taskMethod.getAnnotation(LHType.class);
            maskedValue = type.masked();
            if (!type.name().isEmpty() || !type.name().isBlank()) {
                outputSchemaVarName = type.name();
            }
        }
        this.outputSchema = TaskDefOutputSchema.newBuilder().setValueDef(VariableDef.newBuilder().setType(returnType).setName(outputSchemaVarName).setMaskedValue(maskedValue).build()).build();
        for (int i = 0; i < this.taskMethod.getParameterCount(); ++i) {
            Parameter param = this.taskMethod.getParameters()[i];
            if (param.getType().equals(WorkerContext.class)) {
                if (i + 1 != this.taskMethod.getParameterCount()) {
                    throw new TaskSchemaMismatchError("Can only have WorkerContext as the last parameter.");
                }
                this.hasWorkerContextAtEnd = true;
                continue;
            }
            VariableType paramLHType = LHLibUtil.javaClassToLHVarType(param.getType());
            this.paramTypes.add(paramLHType);
            if (param.isAnnotationPresent(LHType.class)) {
                LHType type = param.getAnnotation(LHType.class);
                this.maskedParams.add(type.masked());
                if (!type.name().isEmpty() && !type.name().isBlank()) {
                    this.varNames.add(type.name());
                    continue;
                }
                this.varNames.add(this.varNameFromParameterName(param));
                continue;
            }
            this.maskedParams.add(false);
            this.varNames.add(this.varNameFromParameterName(param));
        }
    }

    private String varNameFromParameterName(Parameter param) {
        if (!param.isNamePresent()) {
            log.warn("Unable to inspect parameter names using reflection; please either compile with `javac -parameters` to enable this, or specify a name via the LHType annotation. Using the parameter position as its name, which makes the resulting TaskDef harder to understand.");
        }
        return param.getName();
    }

    public boolean getHasWorkerContextAtEnd() {
        return this.hasWorkerContextAtEnd;
    }

    public List<VariableType> getParamTypes() {
        return this.paramTypes;
    }

    public List<Boolean> getMaskedParams() {
        return this.maskedParams;
    }

    public String getTaskDefName() {
        return this.taskDefName;
    }

    public Object getExecutable() {
        return this.executable;
    }

    public Method getTaskMethod() {
        return this.taskMethod;
    }

    public List<String> getVarNames() {
        return this.varNames;
    }

    public TaskDefOutputSchema getOutputSchema() {
        return this.outputSchema;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LHTaskSignature)) {
            return false;
        }
        LHTaskSignature o = (LHTaskSignature)other;
        List<VariableType> otherTypes = o.getParamTypes();
        if (otherTypes.size() != this.paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < otherTypes.size(); ++i) {
            if (otherTypes.get(i).equals((Object)this.paramTypes.get(i))) continue;
            return false;
        }
        return true;
    }
}

