/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.config.LHConfig;
import io.littlehorse.sdk.common.exception.TaskSchemaMismatchError;
import io.littlehorse.sdk.common.proto.LittleHorseGrpc;
import io.littlehorse.sdk.common.proto.TaskDef;
import io.littlehorse.sdk.common.proto.TaskDefId;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.wfsdk.internal.taskdefutil.LHTaskSignature;
import io.littlehorse.sdk.wfsdk.internal.taskdefutil.TaskDefBuilder;
import io.littlehorse.sdk.worker.LHTaskWorkerHealth;
import io.littlehorse.sdk.worker.WorkerContext;
import io.littlehorse.sdk.worker.internal.LHLivenessController;
import io.littlehorse.sdk.worker.internal.LHServerConnectionManager;
import io.littlehorse.sdk.worker.internal.util.VariableMapping;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHTaskWorker
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(LHTaskWorker.class);
    public static HashMap<Class<?>, VariableType> javaTypeToLHType = new HashMap<Class<?>, VariableType>(){
        {
            this.put(Integer.class, VariableType.INT);
            this.put(Long.class, VariableType.INT);
            this.put(Boolean.class, VariableType.BOOL);
            this.put(Double.class, VariableType.DOUBLE);
            this.put(byte[].class, VariableType.BYTES);
            this.put(String.class, VariableType.STR);
        }
    };
    private Object executable;
    private LHConfig config;
    private TaskDef taskDef;
    private Method taskMethod;
    private List<VariableMapping> mappings;
    private LHServerConnectionManager manager;
    private String taskDefName;
    private String lhTaskMethodAnnotationValue;
    private LittleHorseGrpc.LittleHorseBlockingStub grpcClient;

    public LHTaskWorker(Object executable, String taskDefName, LHConfig config) {
        this.config = config;
        this.executable = executable;
        this.mappings = new ArrayList<VariableMapping>();
        this.taskDefName = taskDefName;
        this.lhTaskMethodAnnotationValue = taskDefName;
        this.grpcClient = config.getBlockingStub();
    }

    public LHTaskWorker(Object executable, String taskDefNameTemplate, LHConfig config, Map<String, String> valuesForPlaceholders) {
        this.config = config;
        this.executable = executable;
        this.mappings = new ArrayList<VariableMapping>();
        this.taskDefName = LHTaskWorker.replacePlaceholdersInTaskDefName(taskDefNameTemplate, valuesForPlaceholders);
        this.lhTaskMethodAnnotationValue = taskDefNameTemplate;
        this.grpcClient = config.getBlockingStub();
    }

    public LHTaskWorker(Object executable, String taskDefName, Map<String, String> valuesForPlaceHolders, LHConfig config, LHServerConnectionManager manager) {
        this(executable, taskDefName, config, valuesForPlaceHolders);
        this.manager = manager;
    }

    public String getTaskDefName() {
        return this.taskDefName;
    }

    private void createManager() {
        this.validateTaskDefAndExecutable();
        if (this.manager == null) {
            this.manager = new LHServerConnectionManager(this.taskDef, this.config.getAsyncStub(), this.config.getTaskWorkerId(), new LHLivenessController(), this.taskMethod, this.mappings, this.executable, this.config);
        }
    }

    public boolean doesTaskDefExist() {
        try {
            this.grpcClient.getTaskDef(TaskDefId.newBuilder().setName(this.taskDefName).build());
            return true;
        }
        catch (StatusRuntimeException exn) {
            if (exn.getStatus().getCode() == Status.Code.NOT_FOUND) {
                return false;
            }
            throw exn;
        }
    }

    public void registerTaskDef() {
        TaskDefBuilder tdb = new TaskDefBuilder(this.executable, this.taskDefName, this.lhTaskMethodAnnotationValue);
        TaskDef result = this.grpcClient.putTaskDef(tdb.toPutTaskDefRequest());
        log.info("Created TaskDef:\n{}", (Object)LHLibUtil.protoToJson(result));
    }

    private void validateTaskDefAndExecutable() throws TaskSchemaMismatchError {
        if (this.taskDef == null) {
            Awaitility.await().atMost(Duration.ofSeconds(2L)).ignoreExceptionsMatching(exn -> exn instanceof StatusRuntimeException && ((StatusRuntimeException)((Object)exn)).getStatus().getCode().equals((Object)Status.Code.NOT_FOUND)).until(() -> {
                this.taskDef = this.grpcClient.getTaskDef(TaskDefId.newBuilder().setName(this.taskDefName).build());
                return true;
            });
        }
        LHTaskSignature signature = new LHTaskSignature(this.taskDef.getId().getName(), this.executable, this.lhTaskMethodAnnotationValue);
        this.taskMethod = signature.getTaskMethod();
        int numTaskMethodParams = this.taskMethod.getParameterCount();
        int numTaskDefParams = this.taskDef.getInputVarsCount();
        boolean wrongNumParams = false;
        if (signature.getHasWorkerContextAtEnd()) {
            if (numTaskMethodParams - 1 != numTaskDefParams) {
                wrongNumParams = true;
            }
        } else if (numTaskDefParams != numTaskMethodParams) {
            wrongNumParams = true;
        }
        if (wrongNumParams) {
            throw new TaskSchemaMismatchError("Number of task method params doesn't match number of taskdef params!");
        }
        for (int i = 0; i < numTaskDefParams; ++i) {
            Parameter param = this.taskMethod.getParameters()[i];
            String javaParamName = param.getName();
            Class<?> paramClass = param.getType();
            if (paramClass.equals(WorkerContext.class)) {
                throw new TaskSchemaMismatchError("Can only have WorkerContext after all required taskDef params.");
            }
            VariableMapping mapping = new VariableMapping(this.taskDef, i, paramClass, javaParamName);
            this.mappings.add(mapping);
        }
        if (signature.getHasWorkerContextAtEnd()) {
            this.mappings.add(new VariableMapping(this.taskDef, numTaskMethodParams - 1, WorkerContext.class, null));
        }
    }

    public void start() {
        this.createManager();
        this.manager.start();
    }

    @Override
    public void close() {
        if (this.manager != null) {
            this.manager.close();
        }
    }

    public LHTaskWorkerHealth healthStatus() {
        return this.manager.healthStatus();
    }

    private static String replacePlaceholdersInTaskDefName(String template, Map<String, String> values) {
        StringBuilder resultingText = new StringBuilder();
        Pattern placeholderPattern = Pattern.compile("\\$\\{(.*?)\\}", 32);
        Matcher matcher = placeholderPattern.matcher(template);
        while (matcher.find()) {
            String placeholderKey = matcher.group(1);
            String replacement = values.get(placeholderKey);
            if (replacement == null) {
                throw new IllegalArgumentException("No value has been provided for the placeholder with key: " + placeholderKey);
            }
            matcher.appendReplacement(resultingText, replacement);
        }
        matcher.appendTail(resultingText);
        return resultingText.toString();
    }
}

