/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker.internal;

import io.littlehorse.sdk.common.proto.RegisterTaskWorkerResponse;
import io.littlehorse.sdk.worker.LHTaskWorkerHealth;
import io.littlehorse.sdk.worker.LHTaskWorkerHealthReason;

public class LHLivenessController {
    private boolean isWorkerHealthy = true;
    private boolean isClusterHealthy = true;
    private boolean isRunning = true;

    public boolean keepWorkerRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isClusterHealthy() {
        return this.isClusterHealthy;
    }

    public boolean isWorkerHealthy() {
        return this.isWorkerHealthy;
    }

    public void notifyWorkerFailure() {
        this.isWorkerHealthy = false;
    }

    public void notifySuccessCall(RegisterTaskWorkerResponse response) {
        this.isClusterHealthy = response.hasIsClusterHealthy() ? response.getIsClusterHealthy() : true;
        this.isWorkerHealthy = true;
    }

    public LHTaskWorkerHealth healthStatus() {
        if (!this.isClusterHealthy) {
            return LHTaskWorkerHealth.builder().isHealthy(false).reason(LHTaskWorkerHealthReason.SERVER_REBALANCING).build();
        }
        if (!this.isWorkerHealthy) {
            return LHTaskWorkerHealth.builder().isHealthy(false).reason(LHTaskWorkerHealthReason.UNHEALTHY).build();
        }
        return LHTaskWorkerHealth.builder().isHealthy(true).reason(LHTaskWorkerHealthReason.HEALTHY).build();
    }
}

