/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker.internal;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.littlehorse.sdk.common.proto.LittleHorseGrpc;
import io.littlehorse.sdk.common.proto.PollTaskRequest;
import io.littlehorse.sdk.common.proto.PollTaskResponse;
import io.littlehorse.sdk.common.proto.TaskDefId;
import io.littlehorse.sdk.worker.internal.ScheduledTaskExecutor;
import io.littlehorse.sdk.worker.internal.util.VariableMapping;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PollTaskStub {
    private static final Logger log = LoggerFactory.getLogger(PollTaskStub.class);
    private final ServerResponseObserver responseObserver;
    private final Semaphore semaphore;
    private final ScheduledTaskExecutor taskExecutor;
    private final AtomicBoolean ready = new AtomicBoolean(true);
    private final StreamObserver<PollTaskRequest> observer;
    private final String taskWorkerId;
    private final TaskDefId taskDefId;
    private final String taskWorkerVersion;
    private final List<VariableMapping> mappings;
    private final Object executable;
    private final Method taskMethod;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public PollTaskStub(LittleHorseGrpc.LittleHorseStub bootstrapStub, LittleHorseGrpc.LittleHorseStub specificStub, Semaphore semaphore, ScheduledTaskExecutor taskExecutor, String taskWorkerId, TaskDefId taskDefId, String taskWorkerVersion, List<VariableMapping> mappings, Object executable, Method taskMethod) {
        this.responseObserver = new ServerResponseObserver(bootstrapStub);
        this.semaphore = semaphore;
        this.taskExecutor = taskExecutor;
        this.taskWorkerId = taskWorkerId;
        this.taskDefId = taskDefId;
        this.taskWorkerVersion = taskWorkerVersion;
        this.mappings = mappings;
        this.executable = executable;
        this.taskMethod = taskMethod;
        this.observer = specificStub.pollTask(this.responseObserver);
    }

    public boolean isReady() {
        return this.ready.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void doNext() throws InterruptedException {
        this.semaphore.acquire();
        this.ready.set(false);
        this.observer.onNext((Object)PollTaskRequest.newBuilder().setClientId(this.taskWorkerId).setTaskDefId(this.taskDefId).setTaskWorkerVersion(this.taskWorkerVersion).build());
    }

    public void acquireNextPermit() throws InterruptedException {
        this.semaphore.acquire();
    }

    private final class ServerResponseObserver
    implements StreamObserver<PollTaskResponse> {
        private final LittleHorseGrpc.LittleHorseStub bootstrapStub;

        private ServerResponseObserver(LittleHorseGrpc.LittleHorseStub bootstrapStub) {
            this.bootstrapStub = bootstrapStub;
        }

        public void onNext(PollTaskResponse value) {
            if (value.hasResult()) {
                PollTaskStub.this.taskExecutor.doTask(value.getResult(), this.bootstrapStub, PollTaskStub.this.mappings, PollTaskStub.this.executable, PollTaskStub.this.taskMethod);
            } else {
                log.info("Didn't successfully claim a task");
            }
            PollTaskStub.this.semaphore.release();
            PollTaskStub.this.ready.set(true);
        }

        public void onError(Throwable t) {
            if (t instanceof StatusRuntimeException && ((StatusRuntimeException)t).getStatus().getCode().equals((Object)Status.CANCELLED.getCode())) {
                log.debug("Connection closed");
            } else {
                log.error("Unexpected error from server", t);
            }
            PollTaskStub.this.closed.set(true);
        }

        public void onCompleted() {
            log.error("Unexpected call to onCompleted() in the Server Connection.");
            PollTaskStub.this.closed.set(true);
        }
    }
}

