/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker.internal;

import com.google.common.collect.Iterators;
import io.littlehorse.sdk.worker.internal.PollTaskStub;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollThread
extends Thread
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(PollThread.class);
    private final Iterator<PollTaskStub> activePollClientsIterator;
    private boolean stillRunning = true;
    private final boolean requireConcurrency;
    private final List<PollTaskStub> pollClients;

    PollThread(String threadName, int inflightRequests, List<PollTaskStub> pollClients) {
        super(threadName);
        this.requireConcurrency = inflightRequests > 1;
        this.pollClients = pollClients;
        this.activePollClientsIterator = Iterators.cycle(pollClients);
    }

    @Override
    public void run() {
        try {
            while (this.stillRunning) {
                PollTaskStub pollClient = this.activePollClientsIterator.next();
                if (!this.requireConcurrency || pollClient.isReady()) {
                    pollClient.doNext();
                } else {
                    pollClient.acquireNextPermit();
                }
                if (!pollClient.isClosed()) continue;
                this.stillRunning = false;
            }
        }
        catch (InterruptedException ex) {
            try {
                log.debug("Thread interrupted");
            }
            catch (Throwable throwable) {
                log.debug(String.format("Thread %s stopped", this.getName()));
                throw throwable;
            }
            log.debug(String.format("Thread %s stopped", this.getName()));
        }
        log.debug(String.format("Thread %s stopped", this.getName()));
    }

    @Override
    public void close() {
        this.stillRunning = false;
    }

    public boolean isRunning() {
        this.checkRunningStubs();
        return this.stillRunning;
    }

    private void checkRunningStubs() {
        if (!this.stillRunning) {
            return;
        }
        boolean oneStubFailed = this.pollClients.stream().anyMatch(PollTaskStub::isClosed);
        if (oneStubFailed) {
            this.close();
        }
    }
}

