/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker.internal.util;

import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.exception.InputVarSubstitutionError;
import io.littlehorse.sdk.common.exception.LHJsonProcessingException;
import io.littlehorse.sdk.common.exception.TaskSchemaMismatchError;
import io.littlehorse.sdk.common.proto.ScheduledTask;
import io.littlehorse.sdk.common.proto.TaskDef;
import io.littlehorse.sdk.common.proto.VarNameAndVal;
import io.littlehorse.sdk.common.proto.VariableDef;
import io.littlehorse.sdk.common.proto.VariableValue;
import io.littlehorse.sdk.worker.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableMapping {
    private static final Logger log = LoggerFactory.getLogger(VariableMapping.class);
    private String name;
    private Class<?> type;
    private int position;

    public VariableMapping(TaskDef taskDef, int position, Class<?> type, String javaParamName) throws TaskSchemaMismatchError {
        this.type = type;
        if (type.equals(WorkerContext.class)) {
            return;
        }
        this.position = position;
        if (position >= taskDef.getInputVarsCount()) {
            throw new TaskSchemaMismatchError("Provided Java function has more parameters than the TaskDef.");
        }
        this.name = javaParamName;
        VariableDef input = taskDef.getInputVars(position);
        String msg = null;
        switch (input.getType()) {
            case INT: {
                if (LHLibUtil.isINT(type)) break;
                msg = "TaskDef provides INT, func accepts " + type.getName();
                break;
            }
            case DOUBLE: {
                if (LHLibUtil.isDOUBLE(type)) break;
                msg = "TaskDef provides a DOUBLE, func accepts " + type.getName();
                break;
            }
            case STR: {
                if (LHLibUtil.isSTR(type)) break;
                msg = "TaskDef provides a STRING, func accepts " + type.getName();
                break;
            }
            case BOOL: {
                if (LHLibUtil.isBOOL(type)) break;
                msg = "TaskDef provides a BOOL, func accepts " + type.getName();
                break;
            }
            case BYTES: {
                if (LHLibUtil.isBYTES(type)) break;
                msg = "TaskDef provides BYTES, func accepts " + type.getName();
                break;
            }
            case JSON_ARR: 
            case JSON_OBJ: {
                log.info("Info: Will use Jackson to deserialize Json into {}", (Object)type.getName());
                break;
            }
            case UNRECOGNIZED: {
                throw new RuntimeException("Not possible");
            }
        }
        if (msg != null) {
            throw new TaskSchemaMismatchError("Invalid assignment for var " + this.name + ": " + msg);
        }
    }

    public Object assign(ScheduledTask taskInstance, WorkerContext context) throws InputVarSubstitutionError {
        if (this.type.equals(WorkerContext.class)) {
            return context;
        }
        VarNameAndVal assignment = taskInstance.getVariables(this.position);
        String taskDefParamName = assignment.getVarName();
        VariableValue val = assignment.getValue();
        String jsonStr = null;
        switch (val.getValueCase()) {
            case INT: {
                if (this.type == Long.class || this.type == Long.TYPE) {
                    return val.getInt();
                }
                return (int)val.getInt();
            }
            case DOUBLE: {
                if (this.type == Double.class || this.type == Double.TYPE) {
                    return val.getDouble();
                }
                return Float.valueOf((float)val.getDouble());
            }
            case STR: {
                return val.getStr();
            }
            case BYTES: {
                return val.getBytes().toByteArray();
            }
            case BOOL: {
                return val.getBool();
            }
            case JSON_ARR: {
                jsonStr = val.getJsonArr();
                break;
            }
            case JSON_OBJ: {
                jsonStr = val.getJsonObj();
                break;
            }
            case VALUE_NOT_SET: {
                return null;
            }
        }
        try {
            return LHLibUtil.deserializeFromjson(jsonStr, this.type);
        }
        catch (LHJsonProcessingException exn) {
            throw new InputVarSubstitutionError("Failed deserializing the Java object for variable " + taskDefParamName, exn);
        }
    }
}

