/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.container;

import com.github.dockerjava.api.model.RestartPolicy;
import io.littlehorse.container.LittleHorseContainer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.kafka.KafkaContainer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class LittleHorseCluster
extends GenericContainer<LittleHorseCluster> {
    protected static final String LHC_API_HOST = "LHC_API_HOST";
    protected static final String LHC_API_PORT = "LHC_API_PORT";
    private static final String KAFKA_HOSTNAME = "kafka";
    private static final String LH_HOSTNAME = "littlehorse";
    private static final String KAFKA_BOOTSTRAP_SERVERS = "kafka:19092";
    private static final long DEFAULT_KAFKA_MEMORY = 0x40000000L;
    private static final int DEFAULT_ADVERTISED_PORT = 32023;
    private final KafkaContainer kafka;
    private final List<LittleHorseContainer> clusterInstances;

    private LittleHorseCluster(DockerImageName kafkaImage, DockerImageName littlehorseImage, int instances, Network network) {
        super(DockerImageName.parse((String)"ghcr.io/littlehorse-enterprises/littlehorse/lhctl").withTag(littlehorseImage.getVersionPart()));
        if (instances <= 0) {
            throw new IllegalArgumentException("Instances should be greater than 0");
        }
        this.kafka = (KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(kafkaImage).withNetwork(network)).withNetworkAliases(new String[]{KAFKA_HOSTNAME})).withListener(KAFKA_BOOTSTRAP_SERVERS).withCreateContainerCmdModifier(cmd -> Objects.requireNonNull(cmd.getHostConfig()).withMemory(Long.valueOf(0x40000000L)));
        this.clusterInstances = IntStream.range(32023, 32023 + instances).mapToObj(port -> (LittleHorseContainer)((LittleHorseContainer)new LittleHorseContainer(littlehorseImage).withKafkaBootstrapServers(KAFKA_BOOTSTRAP_SERVERS).withAdvertisedPort(port).withInstanceId(port).withInternalAdvertisedHost(String.format("%s%d", LH_HOSTNAME, port)).withNetwork(network)).dependsOn(new Startable[]{this.kafka})).collect(Collectors.toList());
        ((LittleHorseCluster)((LittleHorseCluster)((LittleHorseCluster)((LittleHorseCluster)((LittleHorseCluster)((LittleHorseCluster)((LittleHorseCluster)this.withNetwork(network)).withCommand("version")).withEnv(LHC_API_HOST, this.clusterInstances.get(0).getInternalApiHost())).withEnv(LHC_API_PORT, String.valueOf(this.clusterInstances.get(0).getInternalApiPort()))).withCreateContainerCmdModifier(cmd -> Objects.requireNonNull(cmd.getHostConfig()).withRestartPolicy(RestartPolicy.onFailureRestart((int)5)))).withStartupCheckStrategy((StartupCheckStrategy)new OneShotStartupCheckStrategy())).dependsOn(new Startable[]{this.kafka})).dependsOn(this.clusterInstances);
    }

    public static LittleHorseClusterBuilder newBuilder() {
        return new LittleHorseClusterBuilder();
    }

    public Properties getClientProperties() {
        return this.clusterInstances.get(0).getClientProperties();
    }

    public Map<String, String> getClientConfig() {
        return this.clusterInstances.get(0).getClientConfig();
    }

    public String getKafkaBootstrapServers() {
        return KAFKA_BOOTSTRAP_SERVERS;
    }

    public static class LittleHorseClusterBuilder {
        private String kafkaImage = "apache/kafka-native:latest";
        private String littlehorseImage = "ghcr.io/littlehorse-enterprises/littlehorse/lh-server:latest";
        private int instances = 1;
        private Network network = Network.newNetwork();

        public LittleHorseCluster build() {
            return new LittleHorseCluster(DockerImageName.parse((String)this.kafkaImage), DockerImageName.parse((String)this.littlehorseImage), this.instances, this.network);
        }

        public LittleHorseClusterBuilder withKafkaImage(String kafkaImage) {
            this.kafkaImage = kafkaImage;
            return this;
        }

        public LittleHorseClusterBuilder withLittlehorseImage(String littlehorseImage) {
            this.littlehorseImage = littlehorseImage;
            return this;
        }

        public LittleHorseClusterBuilder withInstances(int instances) {
            if (instances <= 0) {
                throw new IllegalArgumentException("Instances should be greater than 0");
            }
            this.instances = instances;
            return this;
        }

        public LittleHorseClusterBuilder withNetwork(Network network) {
            if (network == null) {
                throw new NullPointerException("Network shouldn't be null");
            }
            this.network = network;
            return this;
        }
    }
}

