/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.container;

import com.github.dockerjava.api.model.PortBinding;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class LittleHorseContainer
extends GenericContainer<LittleHorseContainer> {
    private static final String LHS_INTERNAL_ADVERTISED_HOST = "LHS_INTERNAL_ADVERTISED_HOST";
    private static final String LHS_INSTANCE_ID = "LHS_INSTANCE_ID";
    private static final String LHS_CORE_STREAM_THREADS = "LHS_CORE_STREAM_THREADS";
    private static final String LHS_KAFKA_BOOTSTRAP_SERVERS = "LHS_KAFKA_BOOTSTRAP_SERVERS";
    private static final String LOG_REGEX = ".*New state for (core|timer) topology: RUNNING.*";
    private static final long DEFAULT_LH_MEMORY = 0x40000000L;
    private static final String LHS_ADVERTISED_LISTENERS = "LHS_ADVERTISED_LISTENERS";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"ghcr.io/littlehorse-enterprises/littlehorse/lh-server");
    private static final int DEFAULT_INTERNAL_PORT = 2023;
    private static final int DEFAULT_ADVERTISED_PORT = 32023;
    private static final String DEFAULT_KAFKA_BOOTSTRAP_SERVERS = "kafka:19092";

    public LittleHorseContainer(String littlehorseImage) {
        this(DockerImageName.parse((String)littlehorseImage));
    }

    public LittleHorseContainer(DockerImageName littlehorseImage) {
        super(littlehorseImage);
        littlehorseImage.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        ((LittleHorseContainer)((LittleHorseContainer)((LittleHorseContainer)this.withExposedPorts(new Integer[]{2023})).withKafkaBootstrapServers(DEFAULT_KAFKA_BOOTSTRAP_SERVERS).withAdvertisedPort(32023).withInstanceId(1).withEnv(LHS_CORE_STREAM_THREADS, "2")).withCreateContainerCmdModifier(cmd -> Objects.requireNonNull(cmd.getHostConfig()).withMemory(Long.valueOf(0x40000000L)))).waitingFor((WaitStrategy)Wait.forLogMessage((String)LOG_REGEX, (int)2));
    }

    public LittleHorseContainer withKafkaBootstrapServers(String bootstrapServers) {
        return (LittleHorseContainer)this.withEnv(LHS_KAFKA_BOOTSTRAP_SERVERS, bootstrapServers);
    }

    public LittleHorseContainer withAdvertisedPort(int port) {
        return (LittleHorseContainer)((LittleHorseContainer)this.withEnv(LHS_ADVERTISED_LISTENERS, String.format("PLAIN://localhost:%d", port))).withCreateContainerCmdModifier(cmd -> Objects.requireNonNull(cmd.getHostConfig()).withPortBindings(new PortBinding[]{PortBinding.parse((String)String.format("%d:%d", port, 2023))}));
    }

    public LittleHorseContainer withInstanceId(int id) {
        return (LittleHorseContainer)this.withEnv(LHS_INSTANCE_ID, String.valueOf(id));
    }

    public LittleHorseContainer withInternalAdvertisedHost(String hostname) {
        return (LittleHorseContainer)((LittleHorseContainer)this.withEnv(LHS_INTERNAL_ADVERTISED_HOST, hostname)).withNetworkAliases(new String[]{hostname});
    }

    public String getApiHost() {
        return this.getHost();
    }

    public String getInternalApiHost() {
        if (this.getNetworkAliases().isEmpty()) {
            return this.getApiHost();
        }
        return (String)this.getNetworkAliases().get(0);
    }

    public int getInternalApiPort() {
        return 2023;
    }

    public int getApiPort() {
        return this.getMappedPort(2023);
    }

    public Properties getClientProperties() {
        Properties properties = new Properties();
        properties.putAll(this.getClientConfig());
        return properties;
    }

    public Map<String, String> getClientConfig() {
        return Map.of("LHC_API_HOST", this.getApiHost(), "LHC_API_PORT", String.valueOf(this.getApiPort()));
    }
}

