/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.dagger;

import android.content.Context;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import dagger.Module;
import dagger.Provides;
import io.livekit.android.LiveKit;
import io.livekit.android.memory.CloseableManager;
import io.livekit.android.util.LKLog;
import io.livekit.android.util.LoggingLevel;
import io.livekit.android.webrtc.SimulcastVideoEncoderFactoryWrapper;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Module
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0003\u001a\u00020\u00042\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u00042%\b\u0001\u0010\u0006\u001a\u001f\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J&\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001bH\u0007J&\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u0019H\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0007\u00a8\u0006 "}, d2={"Lio/livekit/android/dagger/RTCModule;", "", "()V", "audioModule", "Lorg/webrtc/audio/AudioDeviceModule;", "audioDeviceModuleOverride", "moduleCustomizer", "Lkotlin/Function1;", "Lorg/webrtc/audio/JavaAudioDeviceModule$Builder;", "Lkotlin/ParameterName;", "name", "builder", "", "appContext", "Landroid/content/Context;", "eglBase", "Lorg/webrtc/EglBase;", "memoryManager", "Lio/livekit/android/memory/CloseableManager;", "eglContext", "Lorg/webrtc/EglBase$Context;", "peerConnectionFactory", "Lorg/webrtc/PeerConnectionFactory;", "audioDeviceModule", "videoEncoderFactory", "Lorg/webrtc/VideoEncoderFactory;", "videoDecoderFactory", "Lorg/webrtc/VideoDecoderFactory;", "videoHwAccel", "", "videoDecoderFactoryOverride", "videoEncoderFactoryOverride", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public final class RTCModule {
    @NotNull
    public static final RTCModule INSTANCE = new RTCModule();
    public static final int $stable;

    private RTCModule() {
    }

    @Provides
    @Singleton
    @JvmSuppressWildcards
    @NotNull
    public final AudioDeviceModule audioModule(@Named(value="override_audio_device_module") @androidx.annotation.Nullable @Nullable AudioDeviceModule audioDeviceModuleOverride, @Named(value="override_java_audio_device_module_customizer") @androidx.annotation.Nullable @Nullable Function1<JavaAudioDeviceModule.Builder, Unit> moduleCustomizer, @NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        if (audioDeviceModuleOverride != null) {
            return audioDeviceModuleOverride;
        }
        JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback2 = new JavaAudioDeviceModule.AudioRecordErrorCallback(){

            public void onWebRtcAudioRecordInitError(@Nullable String errorMessage) {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$e = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.ERROR;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.e(throwable, (String)("onWebRtcAudioRecordInitError: " + errorMessage), (Object[])new Object[0]);
                }
            }

            public void onWebRtcAudioRecordStartError(@Nullable JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, @Nullable String errorMessage) {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$e = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.ERROR;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.e(throwable, (String)("onWebRtcAudioRecordStartError: " + errorCode + ". " + errorMessage), (Object[])new Object[0]);
                }
            }

            public void onWebRtcAudioRecordError(@Nullable String errorMessage) {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$e = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.ERROR;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.e(throwable, (String)("onWebRtcAudioRecordError: " + errorMessage), (Object[])new Object[0]);
                }
            }
        };
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback2 = new JavaAudioDeviceModule.AudioTrackErrorCallback(){

            public void onWebRtcAudioTrackInitError(@Nullable String errorMessage) {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$e = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.ERROR;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.e(throwable, (String)("onWebRtcAudioTrackInitError: " + errorMessage), (Object[])new Object[0]);
                }
            }

            public void onWebRtcAudioTrackStartError(@Nullable JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, @Nullable String errorMessage) {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$e = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.ERROR;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.e(throwable, (String)("onWebRtcAudioTrackStartError: " + errorCode + ". " + errorMessage), (Object[])new Object[0]);
                }
            }

            public void onWebRtcAudioTrackError(@Nullable String errorMessage) {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$e = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.ERROR;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.e(throwable, (String)("onWebRtcAudioTrackError: " + errorMessage), (Object[])new Object[0]);
                }
            }
        };
        JavaAudioDeviceModule.AudioRecordStateCallback audioRecordStateCallback2 = new JavaAudioDeviceModule.AudioRecordStateCallback(){

            public void onWebRtcAudioRecordStart() {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$v = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.v(throwable, (String)"Audio recording starts", (Object[])new Object[0]);
                }
            }

            public void onWebRtcAudioRecordStop() {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$v = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.v(throwable, (String)"Audio recording stops", (Object[])new Object[0]);
                }
            }
        };
        JavaAudioDeviceModule.AudioTrackStateCallback audioTrackStateCallback2 = new JavaAudioDeviceModule.AudioTrackStateCallback(){

            public void onWebRtcAudioTrackStart() {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$v = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.v(throwable, (String)"Audio playout starts", (Object[])new Object[0]);
                }
            }

            public void onWebRtcAudioTrackStop() {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$v = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.v(throwable, (String)"Audio playout stops", (Object[])new Object[0]);
                }
            }
        };
        boolean useHardwareAudioProcessing = Build.VERSION.SDK_INT >= 29;
        JavaAudioDeviceModule.Builder builder = JavaAudioDeviceModule.builder((Context)appContext).setUseHardwareAcousticEchoCanceler(useHardwareAudioProcessing).setUseHardwareNoiseSuppressor(useHardwareAudioProcessing).setAudioRecordErrorCallback(audioRecordErrorCallback2).setAudioTrackErrorCallback(audioTrackErrorCallback2).setAudioRecordStateCallback(audioRecordStateCallback2).setAudioTrackStateCallback(audioTrackStateCallback2);
        Function1<JavaAudioDeviceModule.Builder, Unit> function1 = moduleCustomizer;
        if (function1 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            function1.invoke((Object)builder);
        }
        JavaAudioDeviceModule javaAudioDeviceModule = builder.createAudioDeviceModule();
        Intrinsics.checkNotNullExpressionValue((Object)javaAudioDeviceModule, (String)"builder.createAudioDeviceModule()");
        return (AudioDeviceModule)javaAudioDeviceModule;
    }

    @Provides
    @Singleton
    @NotNull
    public final EglBase eglBase(@Singleton @NotNull CloseableManager memoryManager) {
        Intrinsics.checkNotNullParameter((Object)memoryManager, (String)"memoryManager");
        EglBase eglBase = EglBase.create();
        Intrinsics.checkNotNullExpressionValue((Object)eglBase, (String)"eglBase");
        memoryManager.registerResource(eglBase, () -> RTCModule.eglBase$lambda-0(eglBase));
        return eglBase;
    }

    @Provides
    @NotNull
    public final EglBase.Context eglContext(@NotNull EglBase eglBase) {
        Intrinsics.checkNotNullParameter((Object)eglBase, (String)"eglBase");
        EglBase.Context context = eglBase.getEglBaseContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"eglBase.eglBaseContext");
        return context;
    }

    @Provides
    @NotNull
    public final VideoEncoderFactory videoEncoderFactory(@Named(value="options_video_hw_accel") boolean videoHwAccel, @NotNull EglBase.Context eglContext, @Named(value="override_video_encoder_factory") @androidx.annotation.Nullable @Nullable VideoEncoderFactory videoEncoderFactoryOverride) {
        Intrinsics.checkNotNullParameter((Object)eglContext, (String)"eglContext");
        VideoEncoderFactory videoEncoderFactory = videoEncoderFactoryOverride;
        if (videoEncoderFactory == null) {
            videoEncoderFactory = videoHwAccel ? (VideoEncoderFactory)new SimulcastVideoEncoderFactoryWrapper(eglContext, true, false) : (VideoEncoderFactory)new SoftwareVideoEncoderFactory();
        }
        return videoEncoderFactory;
    }

    @Provides
    @NotNull
    public final VideoDecoderFactory videoDecoderFactory(@Named(value="options_video_hw_accel") boolean videoHwAccel, @NotNull EglBase.Context eglContext, @Named(value="override_video_decoder_factory") @androidx.annotation.Nullable @Nullable VideoDecoderFactory videoDecoderFactoryOverride) {
        Intrinsics.checkNotNullParameter((Object)eglContext, (String)"eglContext");
        VideoDecoderFactory videoDecoderFactory = videoDecoderFactoryOverride;
        if (videoDecoderFactory == null) {
            videoDecoderFactory = videoHwAccel ? (VideoDecoderFactory)new DefaultVideoDecoderFactory(eglContext) : (VideoDecoderFactory)new SoftwareVideoDecoderFactory();
        }
        return videoDecoderFactory;
    }

    @Provides
    @Singleton
    @NotNull
    public final PeerConnectionFactory peerConnectionFactory(@NotNull Context appContext, @NotNull AudioDeviceModule audioDeviceModule, @NotNull VideoEncoderFactory videoEncoderFactory, @NotNull VideoDecoderFactory videoDecoderFactory) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)audioDeviceModule, (String)"audioDeviceModule");
        Intrinsics.checkNotNullParameter((Object)videoEncoderFactory, (String)"videoEncoderFactory");
        Intrinsics.checkNotNullParameter((Object)videoDecoderFactory, (String)"videoDecoderFactory");
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder((Context)appContext).setInjectableLogger(RTCModule::peerConnectionFactory$lambda-2, Logging.Severity.LS_VERBOSE).createInitializationOptions());
        PeerConnectionFactory peerConnectionFactory = PeerConnectionFactory.builder().setAudioDeviceModule(audioDeviceModule).setVideoEncoderFactory(videoEncoderFactory).setVideoDecoderFactory(videoDecoderFactory).createPeerConnectionFactory();
        Intrinsics.checkNotNullExpressionValue((Object)peerConnectionFactory, (String)"builder()\n            .s\u2026tePeerConnectionFactory()");
        return peerConnectionFactory;
    }

    @Provides
    @Named(value="options_video_hw_accel")
    public final boolean videoHwAccel() {
        return true;
    }

    private static final void eglBase$lambda-0(EglBase $eglBase) {
        $eglBase.release();
    }

    private static final void peerConnectionFactory$lambda-2(String s, Logging.Severity severity, String s2) {
        LoggingLevel loggingLevel;
        if (!LiveKit.Companion.getEnableWebRTCLogging()) {
            return;
        }
        Logging.Severity severity2 = severity;
        switch (severity2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[severity2.ordinal()]) {
            case 1: {
                loggingLevel = LoggingLevel.VERBOSE;
                break;
            }
            case 2: {
                loggingLevel = LoggingLevel.INFO;
                break;
            }
            case 3: {
                loggingLevel = LoggingLevel.WARN;
                break;
            }
            case 4: {
                loggingLevel = LoggingLevel.ERROR;
                break;
            }
            default: {
                loggingLevel = LoggingLevel.OFF;
            }
        }
        LoggingLevel loggingLevel2 = loggingLevel;
        LKLog.Companion this_$iv = LKLog.Companion;
        boolean $i$f$log$livekit_android_sdk_release = false;
        if (loggingLevel2.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
            boolean bl = false;
            Timber.log((int)loggingLevel2.toAndroidLogPriority(), (String)(s2 + ": " + s), (Object[])new Object[0]);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Logging.Severity.values().length];
            nArray[Logging.Severity.LS_VERBOSE.ordinal()] = 1;
            nArray[Logging.Severity.LS_INFO.ordinal()] = 2;
            nArray[Logging.Severity.LS_WARNING.ordinal()] = 3;
            nArray[Logging.Severity.LS_ERROR.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

