/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.dagger;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import dagger.Module;
import dagger.Provides;
import dagger.Reusable;
import io.livekit.android.stats.AndroidNetworkInfo;
import io.livekit.android.stats.NetworkInfo;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\f"}, d2={"Lio/livekit/android/dagger/WebModule;", "", "()V", "networkInfo", "Lio/livekit/android/stats/NetworkInfo;", "context", "Landroid/content/Context;", "okHttpClient", "Lokhttp3/OkHttpClient;", "okHttpClientOverride", "websocketFactory", "Lokhttp3/WebSocket$Factory;", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public final class WebModule {
    @NotNull
    public static final WebModule INSTANCE = new WebModule();
    public static final int $stable;

    private WebModule() {
    }

    @Provides
    @Singleton
    @NotNull
    public final OkHttpClient okHttpClient(@Named(value="override_okhttp") @androidx.annotation.Nullable @Nullable OkHttpClient okHttpClientOverride) {
        new OkHttpClient.Builder().pingInterval(20L, TimeUnit.SECONDS).build();
        OkHttpClient okHttpClient = okHttpClientOverride;
        if (okHttpClient == null) {
            okHttpClient = new OkHttpClient();
        }
        return okHttpClient;
    }

    @Provides
    @NotNull
    public final WebSocket.Factory websocketFactory(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        return (WebSocket.Factory)okHttpClient;
    }

    @Provides
    @Reusable
    @NotNull
    public final NetworkInfo networkInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new AndroidNetworkInfo(context);
    }
}

