/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.renderer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import androidx.compose.runtime.internal.StabilityInferred;
import io.livekit.android.room.track.video.ViewVisibility;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.GlRectDrawer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceEglRenderer;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 l2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001lB\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&J\"\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(J\u0018\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u0015H\u0002J\u0006\u0010,\u001a\u00020\"J\u0006\u0010-\u001a\u00020\"J\b\u0010.\u001a\u00020\u0013H\u0002J4\u0010/\u001a\u00020\"2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u00102\u001a\u0004\u0018\u0001032\n\b\u0002\u00104\u001a\u0004\u0018\u00010(H\u0007J\u0010\u00105\u001a\u00020\"2\u0006\u00106\u001a\u00020\u0013H\u0002J\b\u00107\u001a\u00020\"H\u0016J\u0010\u00108\u001a\u00020\"2\u0006\u00109\u001a\u00020:H\u0016J \u0010;\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0015H\u0016J0\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020\u00102\u0006\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u0015H\u0014J\u0018\u0010C\u001a\u00020\"2\u0006\u0010D\u001a\u00020\u00152\u0006\u0010E\u001a\u00020\u0015H\u0014J \u0010F\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u0015H\u0016J\u0010\u0010K\u001a\u00020\u00102\u0006\u0010G\u001a\u00020HH\u0016J \u0010L\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\u0006\u0010M\u001a\u00020\u00152\u0006\u0010N\u001a\u00020\u0015H\u0016J\u0010\u0010O\u001a\u00020\"2\u0006\u0010G\u001a\u00020HH\u0016J\u0018\u0010P\u001a\u00020\"2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0015H\u0014J\u0006\u0010T\u001a\u00020\"J\u0010\u0010U\u001a\u00020\"2\u0006\u0010V\u001a\u00020WH\u0002J\u0006\u0010X\u001a\u00020\"J\u0010\u0010Y\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010Z\u001a\u00020\"2\u0006\u0010[\u001a\u00020\u0010J\u000e\u0010\\\u001a\u00020\"2\u0006\u0010]\u001a\u00020&J\u000e\u0010^\u001a\u00020\"2\u0006\u0010_\u001a\u00020\u0010J\u0010\u0010`\u001a\u00020\"2\b\u0010a\u001a\u0004\u0018\u00010bJ\u001a\u0010`\u001a\u00020\"2\b\u0010c\u001a\u0004\u0018\u00010b2\b\u0010d\u001a\u0004\u0018\u00010bJ(\u0010e\u001a\u00020\"2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u00152\u0006\u0010N\u001a\u00020\u0015H\u0016J\u0010\u0010i\u001a\u00020\"2\u0006\u0010f\u001a\u00020gH\u0016J\u0010\u0010j\u001a\u00020\"2\u0006\u0010f\u001a\u00020gH\u0016J\b\u0010k\u001a\u00020\"H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006m"}, d2={"Lio/livekit/android/renderer/TextureViewRenderer;", "Landroid/view/TextureView;", "Landroid/view/SurfaceHolder$Callback;", "Landroid/view/TextureView$SurfaceTextureListener;", "Lorg/webrtc/VideoSink;", "Lorg/webrtc/RendererCommon$RendererEvents;", "Lio/livekit/android/room/track/video/ViewVisibility$Notifier;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "eglRenderer", "Lorg/webrtc/SurfaceEglRenderer;", "enableFixedSize", "", "rendererEvents", "resourceName", "", "rotatedFrameHeight", "", "rotatedFrameWidth", "surfaceHeight", "surfaceWidth", "videoLayoutMeasure", "Lorg/webrtc/RendererCommon$VideoLayoutMeasure;", "viewVisibility", "Lio/livekit/android/room/track/video/ViewVisibility;", "getViewVisibility", "()Lio/livekit/android/room/track/video/ViewVisibility;", "setViewVisibility", "(Lio/livekit/android/room/track/video/ViewVisibility;)V", "addFrameListener", "", "listener", "Lorg/webrtc/EglRenderer$FrameListener;", "scale", "", "drawerParam", "Lorg/webrtc/RendererCommon$GlDrawer;", "adjustAspectRatio", "videoWidth", "videoHeight", "clearImage", "disableFpsReduction", "getResourceName", "init", "sharedContext", "Lorg/webrtc/EglBase$Context;", "configAttributes", "", "drawer", "logD", "string", "onFirstFrameRendered", "onFrame", "frame", "Lorg/webrtc/VideoFrame;", "onFrameResolutionChanged", "rotation", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthSpec", "heightSpec", "onSurfaceTextureAvailable", "surface", "Landroid/graphics/SurfaceTexture;", "i", "i1", "onSurfaceTextureDestroyed", "onSurfaceTextureSizeChanged", "width", "height", "onSurfaceTextureUpdated", "onVisibilityChanged", "changedView", "Landroid/view/View;", "visibility", "pauseVideo", "postOrRun", "r", "Ljava/lang/Runnable;", "release", "removeFrameListener", "setEnableHardwareScaler", "enabled", "setFpsReduction", "fps", "setMirror", "mirror", "setScalingType", "scalingType", "Lorg/webrtc/RendererCommon$ScalingType;", "scalingTypeMatchOrientation", "scalingTypeMismatchOrientation", "surfaceChanged", "holder", "Landroid/view/SurfaceHolder;", "format", "surfaceCreated", "surfaceDestroyed", "updateSurfaceSize", "Companion", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public class TextureViewRenderer
extends TextureView
implements SurfaceHolder.Callback,
TextureView.SurfaceTextureListener,
VideoSink,
RendererCommon.RendererEvents,
ViewVisibility.Notifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String resourceName;
    @NotNull
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure;
    @NotNull
    private final SurfaceEglRenderer eglRenderer;
    @Nullable
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private boolean enableFixedSize;
    private int surfaceWidth;
    private int surfaceHeight;
    @Nullable
    private ViewVisibility viewVisibility;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "SurfaceViewRenderer";

    public TextureViewRenderer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.setSurfaceTextureListener(this);
    }

    public TextureViewRenderer(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.setSurfaceTextureListener(this);
    }

    @JvmOverloads
    public final void init(@Nullable EglBase.Context sharedContext, @Nullable RendererCommon.RendererEvents rendererEvents, @Nullable int[] configAttributes, @Nullable RendererCommon.GlDrawer drawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(sharedContext, (RendererCommon.RendererEvents)this, configAttributes, drawer);
    }

    public static /* synthetic */ void init$default(TextureViewRenderer textureViewRenderer, EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 4) != 0) {
            nArray = EglBase.CONFIG_PLAIN;
        }
        if ((n & 8) != 0) {
            glDrawer = (RendererCommon.GlDrawer)new GlRectDrawer();
        }
        textureViewRenderer.init(context, rendererEvents, nArray, glDrawer);
    }

    public final void release() {
        this.eglRenderer.release();
    }

    public final void addFrameListener(@Nullable EglRenderer.FrameListener listener, float scale, @Nullable RendererCommon.GlDrawer drawerParam) {
        this.eglRenderer.addFrameListener(listener, scale, drawerParam);
    }

    public final void addFrameListener(@Nullable EglRenderer.FrameListener listener, float scale) {
        this.eglRenderer.addFrameListener(listener, scale);
    }

    public final void removeFrameListener(@Nullable EglRenderer.FrameListener listener) {
        this.eglRenderer.removeFrameListener(listener);
    }

    public final void setEnableHardwareScaler(boolean enabled) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = enabled;
        this.updateSurfaceSize();
    }

    public final void setMirror(boolean mirror) {
        this.eglRenderer.setMirror(mirror);
    }

    public final void setScalingType(@Nullable RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType);
        this.requestLayout();
    }

    public final void setScalingType(@Nullable RendererCommon.ScalingType scalingTypeMatchOrientation, @Nullable RendererCommon.ScalingType scalingTypeMismatchOrientation) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingTypeMatchOrientation, scalingTypeMismatchOrientation);
        this.requestLayout();
    }

    public final void setFpsReduction(float fps) {
        this.eglRenderer.setFpsReduction(fps);
    }

    public final void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public final void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    public void onFrame(@NotNull VideoFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.eglRenderer.onFrame(frame);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        ThreadUtils.checkIsOnMainThread();
        Point size = this.videoLayoutMeasure.measure(widthSpec, heightSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.setMeasuredDimension(size.x, size.y);
        this.logD("onMeasure(). New size: " + size.x + 'x' + size.y);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
        this.updateSurfaceSize();
    }

    private final void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            float layoutAspectRatio = (float)this.getWidth() / (float)this.getHeight();
            float frameAspectRatio = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
            int drawnFrameWidth = 0;
            int drawnFrameHeight = 0;
            if (frameAspectRatio > layoutAspectRatio) {
                drawnFrameWidth = (int)((float)this.rotatedFrameHeight * layoutAspectRatio);
                drawnFrameHeight = this.rotatedFrameHeight;
            } else {
                drawnFrameWidth = this.rotatedFrameWidth;
                drawnFrameHeight = (int)((float)this.rotatedFrameWidth / layoutAspectRatio);
            }
            int width = Math.min(this.getWidth(), drawnFrameWidth);
            int height = Math.min(this.getHeight(), drawnFrameHeight);
            this.logD("updateSurfaceSize. Layout size: " + this.getWidth() + 'x' + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + 'x' + this.rotatedFrameHeight + ", requested surface size: " + width + 'x' + height + ", old surface size: " + this.surfaceWidth + 'x' + this.surfaceHeight);
            if (width != this.surfaceWidth || height != this.surfaceHeight) {
                this.surfaceWidth = width;
                this.surfaceHeight = height;
                this.adjustAspectRatio(this.surfaceWidth, this.surfaceHeight);
            }
        } else {
            this.surfaceWidth = this.surfaceHeight = 0;
        }
    }

    private final void adjustAspectRatio(int videoWidth, int videoHeight) {
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        double aspectRatio = (double)videoHeight / (double)videoWidth;
        int newWidth = 0;
        int newHeight = 0;
        if (viewHeight > (int)((double)viewWidth * aspectRatio)) {
            newWidth = viewWidth;
            newHeight = (int)((double)viewWidth * aspectRatio);
        } else {
            newWidth = (int)((double)viewHeight / aspectRatio);
            newHeight = viewHeight;
        }
        int xoff = (viewWidth - newWidth) / 2;
        int yoff = (viewHeight - newHeight) / 2;
        this.logD("video=" + videoWidth + 'x' + videoHeight + " view=" + viewWidth + 'x' + viewHeight + " newView=" + newWidth + 'x' + newHeight + " off=" + xoff + ',' + yoff);
        Matrix txform = new Matrix();
        this.getTransform(txform);
        txform.setScale((float)newWidth / (float)viewWidth, (float)newHeight / (float)viewHeight);
        txform.postTranslate((float)xoff, (float)yoff);
        this.setTransform(txform);
    }

    public void surfaceCreated(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        ThreadUtils.checkIsOnMainThread();
        this.surfaceWidth = this.surfaceHeight = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surface, int i, int i1) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(this.getSurfaceTexture());
        this.surfaceWidth = this.surfaceHeight = 0;
        this.updateSurfaceSize();
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        ThreadUtils.checkIsOnMainThread();
        this.logD("surfaceChanged: size: " + width + 'x' + height);
    }

    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch completionLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(() -> TextureViewRenderer.onSurfaceTextureDestroyed$lambda-0(completionLatch));
        ThreadUtils.awaitUninterruptibly((CountDownLatch)completionLatch);
        return true;
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
    }

    private final String getResourceName() {
        String string;
        try {
            String string2 = this.getResources().getResourceEntryName(this.getId());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            resources.\u2026ceEntryName(id)\n        }");
            string = string2;
        }
        catch (Resources.NotFoundException e) {
            string = "";
        }
        return string;
    }

    public final void clearImage() {
        this.eglRenderer.clearImage();
    }

    public void onFirstFrameRendered() {
        if (this.rendererEvents != null) {
            RendererCommon.RendererEvents rendererEvents = this.rendererEvents;
            Intrinsics.checkNotNull((Object)rendererEvents);
            rendererEvents.onFirstFrameRendered();
        }
    }

    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        int n;
        int n2;
        if (this.rendererEvents != null) {
            RendererCommon.RendererEvents rendererEvents = this.rendererEvents;
            Intrinsics.checkNotNull((Object)rendererEvents);
            rendererEvents.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
        }
        switch (rotation) {
            case 0: 
            case 180: {
                n2 = videoWidth;
                break;
            }
            default: {
                n2 = videoHeight;
            }
        }
        int rotatedWidth = n2;
        switch (rotation) {
            case 0: 
            case 180: {
                n = videoHeight;
                break;
            }
            default: {
                n = videoWidth;
            }
        }
        int rotatedHeight = n;
        this.postOrRun(() -> TextureViewRenderer.onFrameResolutionChanged$lambda-1(this, rotatedWidth, rotatedHeight));
    }

    private final void postOrRun(Runnable r) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            r.run();
        } else {
            this.post(r);
        }
    }

    private final void logD(String string) {
        Logging.d((String)TAG, (String)(this.resourceName + ": " + string));
    }

    @Override
    @Nullable
    public ViewVisibility getViewVisibility() {
        return this.viewVisibility;
    }

    @Override
    public void setViewVisibility(@Nullable ViewVisibility viewVisibility) {
        this.viewVisibility = viewVisibility;
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
            super.onVisibilityChanged(changedView, visibility);
            ViewVisibility viewVisibility = this.getViewVisibility();
            if (viewVisibility == null) break block0;
            viewVisibility.recalculate();
        }
    }

    @JvmOverloads
    public final void init(@Nullable EglBase.Context sharedContext, @Nullable RendererCommon.RendererEvents rendererEvents, @Nullable int[] configAttributes) {
        TextureViewRenderer.init$default(this, sharedContext, rendererEvents, configAttributes, null, 8, null);
    }

    @JvmOverloads
    public final void init(@Nullable EglBase.Context sharedContext, @Nullable RendererCommon.RendererEvents rendererEvents) {
        TextureViewRenderer.init$default(this, sharedContext, rendererEvents, null, null, 12, null);
    }

    private static final void onSurfaceTextureDestroyed$lambda-0(CountDownLatch $completionLatch) {
        Intrinsics.checkNotNullParameter((Object)$completionLatch, (String)"$completionLatch");
        $completionLatch.countDown();
    }

    private static final void onFrameResolutionChanged$lambda-1(TextureViewRenderer this$0, int $rotatedWidth, int $rotatedHeight) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rotatedFrameWidth = $rotatedWidth;
        this$0.rotatedFrameHeight = $rotatedHeight;
        this$0.updateSurfaceSize();
        this$0.requestLayout();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/livekit/android/renderer/TextureViewRenderer$Companion;", "", "()V", "TAG", "", "livekit-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

