/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.room;

import android.os.SystemClock;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.protobuf.ByteString;
import io.livekit.android.ConnectOptions;
import io.livekit.android.RoomOptions;
import io.livekit.android.events.DisconnectReason;
import io.livekit.android.events.RoomEventKt;
import io.livekit.android.room.ConnectionState;
import io.livekit.android.room.PeerConnectionTransport;
import io.livekit.android.room.PublisherTransportObserver;
import io.livekit.android.room.RTCEngine;
import io.livekit.android.room.RTCEngineKt;
import io.livekit.android.room.ReconnectType;
import io.livekit.android.room.RoomException;
import io.livekit.android.room.SignalClient;
import io.livekit.android.room.SubscriberTransportObserver;
import io.livekit.android.room.participant.ParticipantTrackPermission;
import io.livekit.android.room.track.TrackException;
import io.livekit.android.room.util.CoroutineSdpObserverKt;
import io.livekit.android.util.CloseableCoroutineScope;
import io.livekit.android.util.Either;
import io.livekit.android.util.LKLog;
import io.livekit.android.util.LoggingLevel;
import io.livekit.android.webrtc.PeerConnectionExtKt;
import io.livekit.android.webrtc.SessionDescriptionExtKt;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import livekit.LivekitModels;
import livekit.LivekitRtc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnection;
import org.webrtc.RTCStatsCollectorCallback;
import org.webrtc.RTCStatsReport;
import org.webrtc.SessionDescription;
import timber.log.Timber;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00fe\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00b7\u00012\u00020\u00012\u00020\u0002:\u0004\u00b7\u0001\u00b8\u0001B!\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ3\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020+2\u0006\u0010I\u001a\u00020+2\u0006\u0010J\u001a\u00020K2\b\b\u0002\u0010L\u001a\u00020MH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ\u0010\u0010O\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020+J\u0010\u0010R\u001a\u00020P2\u0006\u0010Q\u001a\u00020+H\u0002J\u0018\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020U2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010V\u001a\u0004\u0018\u00010(2\u0006\u0010J\u001a\u00020WH\u0002J\u0019\u0010X\u001a\u00020P2\u0006\u0010J\u001a\u00020WH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010YJ\b\u0010Z\u001a\u00020[H\u0002J\u000e\u0010\\\u001a\u00020P2\u0006\u0010]\u001a\u00020^J\u000e\u0010_\u001a\u00020P2\u0006\u0010]\u001a\u00020^J1\u0010`\u001a\u00020U2\u0006\u0010a\u001a\u00020+2\u0006\u0010b\u001a\u00020+2\u0006\u0010c\u001a\u00020\u00102\u0006\u0010d\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010eJ1\u0010f\u001a\u00020U2\u0006\u0010a\u001a\u00020+2\u0006\u0010b\u001a\u00020+2\u0006\u0010c\u001a\u00020\u00102\u0006\u0010d\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010eJ$\u0010g\u001a\u00020h2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020U\u0012\u0004\u0012\u00020k0j2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\r\u0010l\u001a\u00020PH\u0000\u00a2\u0006\u0002\bmJ\u0010\u0010n\u001a\u00020P2\u0006\u0010o\u001a\u00020pH\u0016J\u0010\u0010q\u001a\u00020P2\u0006\u0010r\u001a\u00020sH\u0016J\u0018\u0010t\u001a\u00020P2\u0006\u0010Q\u001a\u00020+2\u0006\u0010u\u001a\u00020vH\u0016J\u0016\u0010w\u001a\u00020P2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020z0yH\u0016J\u0010\u0010{\u001a\u00020P2\u0006\u0010|\u001a\u00020}H\u0016J\u0011\u0010~\u001a\u00020P2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0016J\u0013\u0010\u0081\u0001\u001a\u00020P2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0016J\u0013\u0010\u0084\u0001\u001a\u00020P2\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001H\u0016J\u0015\u0010\u0087\u0001\u001a\u00020P2\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u0001H\u0016J\u0011\u0010\u008a\u0001\u001a\u00020P2\u0006\u0010o\u001a\u00020pH\u0016J\u0018\u0010\u008b\u0001\u001a\u00020P2\r\u0010x\u001a\t\u0012\u0005\u0012\u00030\u008c\u00010yH\u0016J\u0011\u0010\u008d\u0001\u001a\u00020P2\u0006\u0010b\u001a\u00020+H\u0016J\u001b\u0010\u008e\u0001\u001a\u00020P2\u0007\u0010\u008f\u0001\u001a\u00020+2\u0007\u0010\u0090\u0001\u001a\u00020\u001bH\u0016J\u0013\u0010\u0091\u0001\u001a\u00020P2\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0016J\u0019\u0010\u0094\u0001\u001a\u00020P2\u000e\u0010\u0095\u0001\u001a\t\u0012\u0005\u0012\u00030\u0096\u00010yH\u0016J\t\u0010\u0097\u0001\u001a\u00020PH\u0016J\u0019\u0010\u0098\u0001\u001a\u00020P2\u000e\u0010\u0099\u0001\u001a\t\u0012\u0005\u0012\u00030\u009a\u00010yH\u0016J\u0013\u0010\u009b\u0001\u001a\u00020P2\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0016J\u0013\u0010\u009e\u0001\u001a\u00020P2\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0016J\u001d\u0010\u00a1\u0001\u001a\u00020P2\b\u0010\u00a2\u0001\u001a\u00030\u00a3\u00012\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001H\u0016J\u000f\u0010\u00a6\u0001\u001a\u00020PH\u0000\u00a2\u0006\u0003\b\u00a7\u0001J \u0010\u00a8\u0001\u001a\u00020P2\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00ab\u0001\u0010\u00ac\u0001J!\u0010\u00ad\u0001\u001a\u00020P2\b\u0010\u00ae\u0001\u001a\u00030\u00af\u00012\u000e\u0010\u00b0\u0001\u001a\t\u0012\u0005\u0012\u00030\u0083\u00010yJ\u0019\u0010\u00b1\u0001\u001a\u00020P2\u0007\u0010\u00b2\u0001\u001a\u00020+2\u0007\u0010\u0090\u0001\u001a\u00020\u001bJ \u0010\u00b3\u0001\u001a\u00020P2\u0007\u0010\u00b4\u0001\u001a\u00020\u001b2\u000e\u0010\u00b5\u0001\u001a\t\u0012\u0005\u0012\u00030\u00b6\u00010yR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010,\u001a\u0014\u0012\u0004\u0012\u00020+\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000206X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u00102R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u00b9\u0001"}, d2={"Lio/livekit/android/room/RTCEngine;", "Lio/livekit/android/room/SignalClient$Listener;", "Lorg/webrtc/DataChannel$Observer;", "client", "Lio/livekit/android/room/SignalClient;", "pctFactory", "Lio/livekit/android/room/PeerConnectionTransport$Factory;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/livekit/android/room/SignalClient;Lio/livekit/android/room/PeerConnectionTransport$Factory;Lkotlinx/coroutines/CoroutineDispatcher;)V", "_publisher", "Lio/livekit/android/room/PeerConnectionTransport;", "_subscriber", "getClient", "()Lio/livekit/android/room/SignalClient;", "connectOptions", "Lio/livekit/android/ConnectOptions;", "value", "Lio/livekit/android/room/ConnectionState;", "connectionState", "getConnectionState$livekit_android_sdk_release", "()Lio/livekit/android/room/ConnectionState;", "setConnectionState$livekit_android_sdk_release", "(Lio/livekit/android/room/ConnectionState;)V", "coroutineScope", "Lio/livekit/android/util/CloseableCoroutineScope;", "fullReconnectOnNext", "", "hasPublished", "isClosed", "isSubscriberPrimary", "lastRoomOptions", "Lio/livekit/android/RoomOptions;", "listener", "Lio/livekit/android/room/RTCEngine$Listener;", "getListener$livekit_android_sdk_release", "()Lio/livekit/android/room/RTCEngine$Listener;", "setListener$livekit_android_sdk_release", "(Lio/livekit/android/room/RTCEngine$Listener;)V", "lossyDataChannel", "Lorg/webrtc/DataChannel;", "lossyDataChannelSub", "participantSid", "", "pendingTrackResolvers", "", "Lkotlin/coroutines/Continuation;", "Llivekit/LivekitModels$TrackInfo;", "publisher", "getPublisher$livekit_android_sdk_release", "()Lio/livekit/android/room/PeerConnectionTransport;", "publisherObserver", "Lio/livekit/android/room/PublisherTransportObserver;", "reconnectType", "Lio/livekit/android/room/ReconnectType;", "getReconnectType$livekit_android_sdk_release", "()Lio/livekit/android/room/ReconnectType;", "setReconnectType$livekit_android_sdk_release", "(Lio/livekit/android/room/ReconnectType;)V", "reconnectingJob", "Lkotlinx/coroutines/Job;", "reconnectingLock", "Lkotlinx/coroutines/sync/Mutex;", "reliableDataChannel", "reliableDataChannelSub", "sessionToken", "sessionUrl", "subscriber", "getSubscriber$livekit_android_sdk_release", "subscriberObserver", "Lio/livekit/android/room/SubscriberTransportObserver;", "addTrack", "cid", "name", "kind", "Llivekit/LivekitModels$TrackType;", "builder", "Llivekit/LivekitRtc$AddTrackRequest$Builder;", "(Ljava/lang/String;Ljava/lang/String;Llivekit/LivekitModels$TrackType;Llivekit/LivekitRtc$AddTrackRequest$Builder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "", "reason", "closeResources", "configure", "joinResponse", "Llivekit/LivekitRtc$JoinResponse;", "dataChannelForKind", "Llivekit/LivekitModels$DataPacket$Kind;", "ensurePublisherConnected", "(Llivekit/LivekitModels$DataPacket$Kind;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPublisherOfferConstraints", "Lorg/webrtc/MediaConstraints;", "getPublisherRTCStats", "callback", "Lorg/webrtc/RTCStatsCollectorCallback;", "getSubscriberRTCStats", "join", "url", "token", "options", "roomOptions", "(Ljava/lang/String;Ljava/lang/String;Lio/livekit/android/ConnectOptions;Lio/livekit/android/RoomOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "joinImpl", "makeRTCConfig", "Lorg/webrtc/PeerConnection$RTCConfiguration;", "serverResponse", "Lio/livekit/android/util/Either;", "Llivekit/LivekitRtc$ReconnectResponse;", "negotiatePublisher", "negotiatePublisher$livekit_android_sdk_release", "onAnswer", "sessionDescription", "Lorg/webrtc/SessionDescription;", "onBufferedAmountChange", "previousAmount", "", "onClose", "code", "", "onConnectionQuality", "updates", "", "Llivekit/LivekitRtc$ConnectionQualityInfo;", "onError", "error", "", "onLeave", "leave", "Llivekit/LivekitRtc$LeaveRequest;", "onLocalTrackPublished", "response", "Llivekit/LivekitRtc$TrackPublishedResponse;", "onLocalTrackUnpublished", "trackUnpublished", "Llivekit/LivekitRtc$TrackUnpublishedResponse;", "onMessage", "buffer", "Lorg/webrtc/DataChannel$Buffer;", "onOffer", "onParticipantUpdate", "Llivekit/LivekitModels$ParticipantInfo;", "onRefreshToken", "onRemoteMuteChanged", "trackSid", "muted", "onRoomUpdate", "update", "Llivekit/LivekitModels$Room;", "onSpeakersChanged", "speakers", "Llivekit/LivekitModels$SpeakerInfo;", "onStateChange", "onStreamStateUpdate", "streamStates", "Llivekit/LivekitRtc$StreamStateInfo;", "onSubscribedQualityUpdate", "subscribedQualityUpdate", "Llivekit/LivekitRtc$SubscribedQualityUpdate;", "onSubscriptionPermissionUpdate", "subscriptionPermissionUpdate", "Llivekit/LivekitRtc$SubscriptionPermissionUpdate;", "onTrickle", "candidate", "Lorg/webrtc/IceCandidate;", "target", "Llivekit/LivekitRtc$SignalTarget;", "reconnect", "reconnect$livekit_android_sdk_release", "sendData", "dataPacket", "Llivekit/LivekitModels$DataPacket;", "sendData$livekit_android_sdk_release", "(Llivekit/LivekitModels$DataPacket;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendSyncState", "subscription", "Llivekit/LivekitRtc$UpdateSubscription;", "publishedTracks", "updateMuteStatus", "sid", "updateSubscriptionPermissions", "allParticipants", "participantTrackPermissions", "Lio/livekit/android/room/participant/ParticipantTrackPermission;", "Companion", "Listener", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public final class RTCEngine
implements SignalClient.Listener,
DataChannel.Observer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SignalClient client;
    @NotNull
    private final PeerConnectionTransport.Factory pctFactory;
    @NotNull
    private final CoroutineDispatcher ioDispatcher;
    @Nullable
    private Listener listener;
    @NotNull
    private ConnectionState connectionState;
    @NotNull
    private ReconnectType reconnectType;
    @Nullable
    private Job reconnectingJob;
    @NotNull
    private final Mutex reconnectingLock;
    private boolean fullReconnectOnNext;
    @NotNull
    private final Map<String, Continuation<LivekitModels.TrackInfo>> pendingTrackResolvers;
    @Nullable
    private String sessionUrl;
    @Nullable
    private String sessionToken;
    @Nullable
    private ConnectOptions connectOptions;
    @Nullable
    private RoomOptions lastRoomOptions;
    @Nullable
    private String participantSid;
    @NotNull
    private final PublisherTransportObserver publisherObserver;
    @NotNull
    private final SubscriberTransportObserver subscriberObserver;
    @Nullable
    private PeerConnectionTransport _publisher;
    @Nullable
    private PeerConnectionTransport _subscriber;
    @Nullable
    private DataChannel reliableDataChannel;
    @Nullable
    private DataChannel reliableDataChannelSub;
    @Nullable
    private DataChannel lossyDataChannel;
    @Nullable
    private DataChannel lossyDataChannelSub;
    private boolean isSubscriberPrimary;
    private boolean isClosed;
    private boolean hasPublished;
    @NotNull
    private CloseableCoroutineScope coroutineScope;
    public static final int $stable;
    @NotNull
    private static final String RELIABLE_DATA_CHANNEL_LABEL = "_reliable";
    @NotNull
    private static final String LOSSY_DATA_CHANNEL_LABEL = "_lossy";
    public static final int MAX_DATA_PACKET_SIZE = 15000;
    private static final int MAX_RECONNECT_RETRIES = 10;
    private static final int MAX_RECONNECT_TIMEOUT = 60000;
    private static final int MAX_ICE_CONNECT_TIMEOUT_MS = 20000;
    @NotNull
    private static final MediaConstraints CONN_CONSTRAINTS;

    @Inject
    public RTCEngine(@NotNull SignalClient client, @NotNull PeerConnectionTransport.Factory pctFactory, @Named(value="dispatcher_io") @NotNull CoroutineDispatcher ioDispatcher) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)pctFactory, (String)"pctFactory");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        this.client = client;
        this.pctFactory = pctFactory;
        this.ioDispatcher = ioDispatcher;
        this.connectionState = ConnectionState.DISCONNECTED;
        this.reconnectType = ReconnectType.DEFAULT;
        this.reconnectingLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.pendingTrackResolvers = new LinkedHashMap();
        this.publisherObserver = new PublisherTransportObserver(this, this.client);
        this.subscriberObserver = new SubscriberTransportObserver(this, this.client);
        this.isClosed = true;
        this.coroutineScope = new CloseableCoroutineScope(SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)this.ioDispatcher));
        this.client.setListener(this);
    }

    @NotNull
    public final SignalClient getClient() {
        return this.client;
    }

    @Nullable
    public final Listener getListener$livekit_android_sdk_release() {
        return this.listener;
    }

    public final void setListener$livekit_android_sdk_release(@Nullable Listener listener) {
        this.listener = listener;
    }

    @NotNull
    public final ConnectionState getConnectionState$livekit_android_sdk_release() {
        return this.connectionState;
    }

    public final void setConnectionState$livekit_android_sdk_release(@NotNull ConnectionState value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        ConnectionState oldVal = this.connectionState;
        this.connectionState = value;
        if (value == oldVal) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[value.ordinal()]) {
            case 1: {
                if (oldVal == ConnectionState.DISCONNECTED) {
                    LKLog.Companion $this$iv = LKLog.Companion;
                    Throwable t$iv = null;
                    boolean $i$f$d = false;
                    LKLog.Companion companion = $this$iv;
                    LoggingLevel loggingLevel$iv$iv = LoggingLevel.DEBUG;
                    boolean $i$f$log$livekit_android_sdk_release = false;
                    if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                        boolean bl = false;
                        Throwable throwable = t$iv;
                        boolean bl2 = false;
                        Timber.d(throwable, (String)"primary ICE connected", (Object[])new Object[0]);
                    }
                    Listener listener = this.listener;
                    if (listener != null) {
                        listener.onEngineConnected();
                    }
                } else {
                    if (oldVal != ConnectionState.RECONNECTING) break;
                    LKLog.Companion $this$iv = LKLog.Companion;
                    Throwable t$iv = null;
                    boolean $i$f$d = false;
                    LKLog.Companion this_$iv$iv = $this$iv;
                    LoggingLevel loggingLevel$iv$iv = LoggingLevel.DEBUG;
                    boolean $i$f$log$livekit_android_sdk_release = false;
                    if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                        boolean bl = false;
                        Throwable throwable = t$iv;
                        boolean bl3 = false;
                        Timber.d(throwable, (String)"primary ICE reconnected", (Object[])new Object[0]);
                    }
                    Listener listener = this.listener;
                    if (listener != null) {
                        listener.onEngineReconnected();
                    }
                }
                break;
            }
            case 2: {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$d = false;
                LKLog.Companion this_$iv$iv = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.DEBUG;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl4 = false;
                    Timber.d(throwable, (String)"primary ICE disconnected", (Object[])new Object[0]);
                }
                if (oldVal != ConnectionState.CONNECTED) break;
                this.reconnect$livekit_android_sdk_release();
            }
        }
    }

    @NotNull
    public final ReconnectType getReconnectType$livekit_android_sdk_release() {
        return this.reconnectType;
    }

    public final void setReconnectType$livekit_android_sdk_release(@NotNull ReconnectType reconnectType) {
        Intrinsics.checkNotNullParameter((Object)((Object)reconnectType), (String)"<set-?>");
        this.reconnectType = reconnectType;
    }

    @NotNull
    public final PeerConnectionTransport getPublisher$livekit_android_sdk_release() {
        PeerConnectionTransport peerConnectionTransport = this._publisher;
        if (peerConnectionTransport == null) {
            throw new UninitializedPropertyAccessException("publisher has not been initialized yet.");
        }
        return peerConnectionTransport;
    }

    @NotNull
    public final PeerConnectionTransport getSubscriber$livekit_android_sdk_release() {
        PeerConnectionTransport peerConnectionTransport = this._subscriber;
        if (peerConnectionTransport == null) {
            throw new UninitializedPropertyAccessException("subscriber has not been initialized yet.");
        }
        return peerConnectionTransport;
    }

    @Nullable
    public final Object join(@NotNull String url, @NotNull String token, @NotNull ConnectOptions options, @NotNull RoomOptions roomOptions, @NotNull Continuation<? super LivekitRtc.JoinResponse> $completion) {
        this.coroutineScope.close();
        this.coroutineScope = new CloseableCoroutineScope(SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)this.ioDispatcher));
        this.sessionUrl = url;
        this.sessionToken = token;
        this.connectOptions = options;
        this.lastRoomOptions = roomOptions;
        return this.joinImpl(url, token, options, roomOptions, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object joinImpl(@NotNull String var1_1, @NotNull String var2_2, @NotNull ConnectOptions var3_3, @NotNull RoomOptions var4_4, @NotNull Continuation<? super LivekitRtc.JoinResponse> var5_5) {
        if (!(var5_5 instanceof joinImpl.1)) ** GOTO lbl-1000
        var8_6 = var5_5;
        if ((var8_6.label & -2147483648) != 0) {
            var8_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RTCEngine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.joinImpl(null, null, null, null, (Continuation<? super LivekitRtc.JoinResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = options;
                $continuation.label = 1;
                v0 = this.client.join((String)url, (String)token, options, (RoomOptions)roomOptions, (Continuation<? super LivekitRtc.JoinResponse>)$continuation);
                if (v0 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl24
            }
            case 1: {
                options = (ConnectOptions)$continuation.L$1;
                this = (RTCEngine)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                joinResponse = (LivekitRtc.JoinResponse)v0;
                v1 = this.listener;
                if (v1 != null) {
                    v1.onJoinResponse(joinResponse);
                }
                this.isClosed = false;
                v2 = this.listener;
                if (v2 != null) {
                    v2.onSignalConnected(false);
                }
                this.isSubscriberPrimary = joinResponse.getSubscriberPrimary();
                this.configure(joinResponse, options);
                if (!this.isSubscriberPrimary) {
                    this.negotiatePublisher$livekit_android_sdk_release();
                }
                this.client.onReadyForResponses();
                return joinResponse;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void configure(LivekitRtc.JoinResponse joinResponse, ConnectOptions connectOptions) {
        if (this._publisher != null && this._subscriber != null) {
            return;
        }
        this.participantSid = joinResponse.hasParticipant() ? joinResponse.getParticipant().getSid() : (String)null;
        PeerConnection.RTCConfiguration rtcConfig = this.makeRTCConfig((Either<LivekitRtc.JoinResponse, LivekitRtc.ReconnectResponse>)new Either.Left<LivekitRtc.JoinResponse>(joinResponse), connectOptions);
        PeerConnectionTransport peerConnectionTransport = this._publisher;
        if (peerConnectionTransport != null) {
            peerConnectionTransport.close();
        }
        this._publisher = this.pctFactory.create(rtcConfig, this.publisherObserver, this.publisherObserver);
        PeerConnectionTransport peerConnectionTransport2 = this._subscriber;
        if (peerConnectionTransport2 != null) {
            peerConnectionTransport2.close();
        }
        this._subscriber = this.pctFactory.create(rtcConfig, this.subscriberObserver, null);
        Function1 connectionStateListener2 = (Function1)new Function1<PeerConnection.PeerConnectionState, Unit>(this){
            final /* synthetic */ RTCEngine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull PeerConnection.PeerConnectionState newState) {
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$v = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.v(throwable, (String)("onIceConnection new state: " + newState), (Object[])new Object[0]);
                }
                if (PeerConnectionExtKt.isConnected(newState)) {
                    this.this$0.setConnectionState$livekit_android_sdk_release(ConnectionState.CONNECTED);
                } else if (PeerConnectionExtKt.isDisconnected(newState)) {
                    this.this$0.setConnectionState$livekit_android_sdk_release(ConnectionState.DISCONNECTED);
                }
            }
        };
        if (joinResponse.getSubscriberPrimary()) {
            this.subscriberObserver.setDataChannelListener((Function1<? super DataChannel, Unit>)((Function1)new Function1<DataChannel, Unit>(this){
                final /* synthetic */ RTCEngine this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull DataChannel dataChannel) {
                    Intrinsics.checkNotNullParameter((Object)dataChannel, (String)"dataChannel");
                    String string = dataChannel.label();
                    if (Intrinsics.areEqual((Object)string, (Object)"_reliable")) {
                        RTCEngine.access$setReliableDataChannelSub$p(this.this$0, dataChannel);
                    } else if (Intrinsics.areEqual((Object)string, (Object)"_lossy")) {
                        RTCEngine.access$setLossyDataChannelSub$p(this.this$0, dataChannel);
                    } else {
                        return;
                    }
                    dataChannel.registerObserver((DataChannel.Observer)this.this$0);
                }
            }));
            this.subscriberObserver.setConnectionChangeListener((Function1<? super PeerConnection.PeerConnectionState, Unit>)connectionStateListener2);
            this.publisherObserver.setConnectionChangeListener((Function1<? super PeerConnection.PeerConnectionState, Unit>)((Function1)new Function1<PeerConnection.PeerConnectionState, Unit>(this){
                final /* synthetic */ RTCEngine this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull PeerConnection.PeerConnectionState newState) {
                    Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                    if (PeerConnectionExtKt.isDisconnected(newState)) {
                        this.this$0.reconnect$livekit_android_sdk_release();
                    }
                }
            }));
        } else {
            this.publisherObserver.setConnectionChangeListener((Function1<? super PeerConnection.PeerConnectionState, Unit>)connectionStateListener2);
        }
        DataChannel.Init reliableInit = new DataChannel.Init();
        reliableInit.ordered = true;
        DataChannel dataChannel = this.reliableDataChannel = this.getPublisher$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release().createDataChannel(RELIABLE_DATA_CHANNEL_LABEL, reliableInit);
        Intrinsics.checkNotNull((Object)dataChannel);
        dataChannel.registerObserver((DataChannel.Observer)this);
        DataChannel.Init lossyInit = new DataChannel.Init();
        lossyInit.ordered = true;
        lossyInit.maxRetransmits = 0;
        DataChannel dataChannel2 = this.lossyDataChannel = this.getPublisher$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release().createDataChannel(LOSSY_DATA_CHANNEL_LABEL, lossyInit);
        Intrinsics.checkNotNull((Object)dataChannel2);
        dataChannel2.registerObserver((DataChannel.Observer)this);
    }

    @Nullable
    public final Object addTrack(@NotNull String cid, @NotNull String name, @NotNull LivekitModels.TrackType kind, @NotNull LivekitRtc.AddTrackRequest.Builder builder, @NotNull Continuation<? super LivekitModels.TrackInfo> $completion) {
        if (this.pendingTrackResolvers.get(cid) != null) {
            throw new TrackException.DuplicateTrackException("Track with same ID " + cid + " has already been published!", null, 2, null);
        }
        Continuation<? super LivekitModels.TrackInfo> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl = false;
        this.pendingTrackResolvers.put(cid, (Continuation<LivekitModels.TrackInfo>)cont);
        this.client.sendAddTrack(cid, name, kind, builder);
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public static /* synthetic */ Object addTrack$default(RTCEngine rTCEngine, String string, String string2, LivekitModels.TrackType trackType, LivekitRtc.AddTrackRequest.Builder builder, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            LivekitRtc.AddTrackRequest.Builder builder2 = LivekitRtc.AddTrackRequest.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()");
            builder = builder2;
        }
        return rTCEngine.addTrack(string, string2, trackType, builder, (Continuation<? super LivekitModels.TrackInfo>)continuation);
    }

    public final void updateSubscriptionPermissions(boolean allParticipants, @NotNull List<ParticipantTrackPermission> participantTrackPermissions) {
        Intrinsics.checkNotNullParameter(participantTrackPermissions, (String)"participantTrackPermissions");
        this.client.sendUpdateSubscriptionPermissions(allParticipants, participantTrackPermissions);
    }

    public final void updateMuteStatus(@NotNull String sid, boolean muted) {
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        this.client.sendMuteTrack(sid, muted);
    }

    public final void close(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.hasPublished = false;
        this.sessionUrl = null;
        this.sessionToken = null;
        this.connectOptions = null;
        this.lastRoomOptions = null;
        this.participantSid = null;
        Job job2 = this.reconnectingJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.reconnectingJob = null;
        this.coroutineScope.close();
        this.closeResources(reason);
        this.setConnectionState$livekit_android_sdk_release(ConnectionState.DISCONNECTED);
    }

    public static /* synthetic */ void close$default(RTCEngine rTCEngine, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Normal Closure";
        }
        rTCEngine.close(string);
    }

    private final void closeResources(String reason) {
        this.publisherObserver.setConnectionChangeListener(null);
        this.subscriberObserver.setConnectionChangeListener(null);
        PeerConnectionTransport peerConnectionTransport = this._publisher;
        if (peerConnectionTransport != null) {
            peerConnectionTransport.close();
        }
        this._publisher = null;
        PeerConnectionTransport peerConnectionTransport2 = this._subscriber;
        if (peerConnectionTransport2 != null) {
            peerConnectionTransport2.close();
        }
        this._subscriber = null;
        DataChannel dataChannel = this.reliableDataChannel;
        if (dataChannel != null) {
            dataChannel.close();
        }
        this.reliableDataChannel = null;
        DataChannel dataChannel2 = this.reliableDataChannelSub;
        if (dataChannel2 != null) {
            dataChannel2.close();
        }
        this.reliableDataChannelSub = null;
        DataChannel dataChannel3 = this.lossyDataChannel;
        if (dataChannel3 != null) {
            dataChannel3.close();
        }
        this.lossyDataChannel = null;
        DataChannel dataChannel4 = this.lossyDataChannelSub;
        if (dataChannel4 != null) {
            dataChannel4.close();
        }
        this.lossyDataChannelSub = null;
        this.isSubscriberPrimary = false;
        SignalClient.close$default(this.client, 0, reason, 1, null);
    }

    public final void reconnect$livekit_android_sdk_release() {
        Job job2;
        boolean didLock = Mutex.DefaultImpls.tryLock$default((Mutex)this.reconnectingLock, null, (int)1, null);
        if (!didLock) {
            return;
        }
        if (this.isClosed) {
            return;
        }
        String url = this.sessionUrl;
        String token = this.sessionToken;
        if (url == null || token == null) {
            LKLog.Companion $this$iv = LKLog.Companion;
            Throwable t$iv = null;
            boolean $i$f$w = false;
            LKLog.Companion companion = $this$iv;
            LoggingLevel loggingLevel$iv$iv = LoggingLevel.WARN;
            boolean $i$f$log$livekit_android_sdk_release = false;
            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                boolean bl = false;
                Throwable throwable = t$iv;
                boolean bl2 = false;
                Timber.w(throwable, (String)"couldn't reconnect, no url or no token", (Object[])new Object[0]);
            }
            return;
        }
        boolean forceFullReconnect = this.fullReconnectOnNext;
        this.fullReconnectOnNext = false;
        this.reconnectingJob = job2 = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, forceFullReconnect, url, token, null){
            long J$0;
            long J$1;
            int I$0;
            int I$1;
            Object L$0;
            int label;
            final /* synthetic */ RTCEngine this$0;
            final /* synthetic */ boolean $forceFullReconnect;
            final /* synthetic */ String $url;
            final /* synthetic */ String $token;
            {
                this.this$0 = $receiver;
                this.$forceFullReconnect = $forceFullReconnect;
                this.$url = $url;
                this.$token = $token;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block55: {
                    block53: {
                        block56: {
                            block59: {
                                block58: {
                                    block57: {
                                        block54: {
                                            var20_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            block4 : switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    this.this$0.setConnectionState$livekit_android_sdk_release(ConnectionState.RECONNECTING);
                                                    v0 = this.this$0.getListener$livekit_android_sdk_release();
                                                    if (v0 != null) {
                                                        v0.onEngineReconnecting();
                                                        v1 = Unit.INSTANCE;
                                                    } else {
                                                        v1 = null;
                                                    }
                                                    reconnectStartTime = SystemClock.elapsedRealtime();
                                                    retries = 0;
lbl14:
                                                    // 2 sources

                                                    while (retries < 10) {
                                                        startDelay = (long)100 + (long)retries * (long)retries * (long)500;
                                                        if (startDelay > 5000L) {
                                                            startDelay = 5000L;
                                                        }
                                                        $this$iv = LKLog.Companion;
                                                        t$iv = null;
                                                        $i$f$i = false;
                                                        loggingLevel$iv$iv = LoggingLevel.INFO;
                                                        $i$f$log$livekit_android_sdk_release = false;
                                                        if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                                            $i$a$-log$livekit_android_sdk_release-LKLog$Companion$i$1$iv = false;
                                                            var19_39 = t$iv;
                                                            $i$a$-i$default-RTCEngine$reconnect$job$1$1 = false;
                                                            Timber.i((Throwable)var19_39, (String)("Reconnecting to signal, attempt " + (retries + 1)), (Object[])new Object[0]);
                                                        }
                                                        this.L$0 = null;
                                                        this.J$0 = reconnectStartTime;
                                                        this.I$0 = retries;
                                                        this.label = 1;
                                                        v2 = DelayKt.delay((long)startDelay, (Continuation)((Continuation)this));
                                                        if (v2 == var20_2) {
                                                            return var20_2;
                                                        }
                                                        ** GOTO lbl44
                                                    }
                                                    break block55;
                                                }
                                                case 1: {
                                                    retries = this.I$0;
                                                    reconnectStartTime = this.J$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v2 = $result;
lbl44:
                                                    // 2 sources

                                                    switch (reconnect.job.WhenMappings.$EnumSwitchMapping$0[this.this$0.getReconnectType$livekit_android_sdk_release().ordinal()]) {
                                                        case 1: {
                                                            if (retries != 0 || this.$forceFullReconnect) {
                                                                v3 = 1;
                                                                break;
                                                            }
                                                            v3 = 0;
                                                            break;
                                                        }
                                                        case 2: {
                                                            v3 = 0;
                                                            break;
                                                        }
                                                        case 3: {
                                                            v3 = 1;
                                                            break;
                                                        }
                                                        default: {
                                                            throw new NoWhenBranchMatchedException();
                                                        }
                                                    }
                                                    isFullReconnect = v3;
                                                    v4 = RTCEngine.access$getConnectOptions$p(this.this$0);
                                                    if (v4 == null) {
                                                        v4 = connectOptions = new ConnectOptions(false, null, null, false, false, null, 63, null);
                                                    }
                                                    if (isFullReconnect == 0) break;
                                                    $this$iv = LKLog.Companion;
                                                    t$iv = null;
                                                    $i$f$v = false;
                                                    loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                                                    $i$f$log$livekit_android_sdk_release = false;
                                                    if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                                        $i$a$-log$livekit_android_sdk_release-LKLog$Companion$v$1$iv = false;
                                                        var19_39 = t$iv;
                                                        $i$a$-v$default-RTCEngine$reconnect$job$1$2 = false;
                                                        Timber.v((Throwable)var19_39, (String)"Attempting full reconnect.", (Object[])new Object[0]);
                                                    }
                                                    RTCEngine.access$closeResources(this.this$0, "Full Reconnecting");
                                                    v5 = this.this$0.getListener$livekit_android_sdk_release();
                                                    if (v5 != null) {
                                                        v5.onFullReconnecting();
                                                        v6 = Unit.INSTANCE;
                                                    } else {
                                                        v6 = null;
                                                    }
                                                    if ((v7 = RTCEngine.access$getLastRoomOptions$p(this.this$0)) == null) {
                                                        v7 = new RoomOptions(false, false, null, null, null, null, 63, null);
                                                    }
                                                    this.J$0 = reconnectStartTime;
                                                    this.I$0 = retries;
                                                    this.I$1 = isFullReconnect;
                                                    this.label = 2;
                                                    v8 = this.this$0.joinImpl(this.$url, this.$token, connectOptions, v7, (Continuation<? super LivekitRtc.JoinResponse>)((Continuation)this));
                                                    ** if (v8 != var20_2) goto lbl94
lbl93:
                                                    // 1 sources

                                                    return var20_2;
lbl94:
                                                    // 1 sources

                                                    ** GOTO lbl200
                                                }
                                                case 2: {
                                                    isFullReconnect = this.I$1;
                                                    retries = this.I$0;
                                                    reconnectStartTime = this.J$0;
                                                    try {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v8 = $result;
                                                        ** GOTO lbl200
                                                    }
                                                    catch (Exception e) {
                                                        this_$iv = LKLog.Companion;
                                                        $i$f$w = false;
                                                        loggingLevel$iv$iv = LoggingLevel.WARN;
                                                        $i$f$log$livekit_android_sdk_release = false;
                                                        if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                                            $i$a$-log$livekit_android_sdk_release-LKLog$Companion$w$1$iv = false;
                                                            var19_39 = e;
                                                            $i$a$-w-RTCEngine$reconnect$job$1$3 = false;
                                                            Timber.w((Throwable)var19_39, (String)"Error during reconnection.", (Object[])new Object[0]);
                                                        }
                                                        break block53;
                                                    }
                                                }
                                            }
                                            $this$iv = LKLog.Companion;
                                            t$iv = null;
                                            $i$f$v = false;
                                            loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                                            $i$f$log$livekit_android_sdk_release = false;
                                            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                                $i$a$-log$livekit_android_sdk_release-LKLog$Companion$v$1$iv = false;
                                                var19_39 = t$iv;
                                                $i$a$-v$default-RTCEngine$reconnect$job$1$4 = false;
                                                Timber.v((Throwable)var19_39, (String)"Attempting soft reconnect.", (Object[])new Object[0]);
                                            }
                                            this.this$0.getSubscriber$livekit_android_sdk_release().prepareForIceRestart();
                                            this.L$0 = connectOptions;
                                            this.J$0 = reconnectStartTime;
                                            this.I$0 = retries;
                                            this.I$1 = isFullReconnect;
                                            this.label = 3;
                                            v9 = this.this$0.getClient().reconnect(this.$url, this.$token, RTCEngine.access$getParticipantSid$p(this.this$0), (Continuation<? super Either<LivekitRtc.ReconnectResponse, Unit>>)((Continuation)this));
                                            ** if (v9 != var20_2) goto lbl140
lbl139:
                                            // 1 sources

                                            return var20_2;
lbl140:
                                            // 1 sources

                                            ** GOTO lbl150
                                            {
                                                case 3: {
                                                    isFullReconnect = this.I$1;
                                                    retries = this.I$0;
                                                    reconnectStartTime = this.J$0;
                                                    connectOptions = (ConnectOptions)this.L$0;
                                                    try {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v9 = $result;
lbl150:
                                                        // 2 sources

                                                        if ((response = (Either)v9) instanceof Either.Left) {
                                                            reconnectResponse = (LivekitRtc.ReconnectResponse)((Either.Left)response).getValue();
                                                            rtcConfig = RTCEngine.access$makeRTCConfig(this.this$0, new Either.Right<LivekitRtc.ReconnectResponse>(reconnectResponse), connectOptions);
                                                            v10 = RTCEngine.access$get_subscriber$p(this.this$0);
                                                            if (v10 != null) {
                                                                v10.updateRTCConfig(rtcConfig);
                                                                v11 = Unit.INSTANCE;
                                                            } else {
                                                                v11 = null;
                                                            }
                                                            v12 = RTCEngine.access$get_publisher$p(this.this$0);
                                                            if (v12 != null) {
                                                                v12.updateRTCConfig(rtcConfig);
                                                                v13 = Unit.INSTANCE;
                                                            } else {
                                                                v13 = null;
                                                            }
                                                        }
                                                        this.this$0.getClient().onReadyForResponses();
                                                        ** GOTO lbl180
                                                    }
                                                    catch (Exception e) {
                                                        this_$iv = LKLog.Companion;
                                                        $i$f$w = false;
                                                        loggingLevel$iv$iv = LoggingLevel.WARN;
                                                        $i$f$log$livekit_android_sdk_release = false;
                                                        if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) < 0 || Timber.treeCount() <= 0) ** GOTO lbl300
                                                        $i$a$-log$livekit_android_sdk_release-LKLog$Companion$w$1$iv = false;
                                                        var19_39 = e;
                                                        $i$a$-w-RTCEngine$reconnect$job$1$5 = false;
                                                        Timber.w((Throwable)var19_39, (String)"Error during reconnection.", (Object[])new Object[0]);
                                                    }
                                                    break block53;
lbl180:
                                                    // 1 sources

                                                    $this$iv = LKLog.Companion;
                                                    t$iv = null;
                                                    $i$f$v = false;
                                                    loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                                                    $i$f$log$livekit_android_sdk_release = false;
                                                    if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                                        $i$a$-log$livekit_android_sdk_release-LKLog$Companion$v$1$iv = false;
                                                        var19_39 = t$iv;
                                                        $i$a$-v$default-RTCEngine$reconnect$job$1$6 = false;
                                                        Timber.v((Throwable)var19_39, (String)"ws reconnected, restarting ICE", (Object[])new Object[0]);
                                                    }
                                                    v14 = this.this$0.getListener$livekit_android_sdk_release();
                                                    if (v14 != null) {
                                                        v14.onSignalConnected(isFullReconnect == 0);
                                                        v15 = Unit.INSTANCE;
                                                    } else {
                                                        v15 = null;
                                                    }
                                                    if (RTCEngine.access$getHasPublished$p(this.this$0)) {
                                                        this.this$0.negotiatePublisher$livekit_android_sdk_release();
                                                    }
lbl200:
                                                    // 5 sources

                                                    endTime = SystemClock.elapsedRealtime() + (long)20000;
                                                    if (!RTCEngine.access$getHasPublished$p(this.this$0)) break;
lbl202:
                                                    // 3 sources

                                                    while (SystemClock.elapsedRealtime() < endTime) {
                                                        v16 = this.this$0.getPublisher$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release().connectionState();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"publisher.peerConnection.connectionState()");
                                                        if (PeerConnectionExtKt.isConnected(v16)) {
                                                            $this$iv = LKLog.Companion;
                                                            t$iv = null;
                                                            $i$f$v = false;
                                                            loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                                                            $i$f$log$livekit_android_sdk_release = false;
                                                            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) < 0 || Timber.treeCount() <= 0) break block4;
                                                            $i$a$-log$livekit_android_sdk_release-LKLog$Companion$v$1$iv = false;
                                                            var19_39 = t$iv;
                                                            $i$a$-v$default-RTCEngine$reconnect$job$1$7 = false;
                                                            Timber.v((Throwable)var19_39, (String)"publisher reconnected to ICE", (Object[])new Object[0]);
                                                            break block4;
                                                        }
                                                        this.L$0 = null;
                                                        this.J$0 = reconnectStartTime;
                                                        this.I$0 = retries;
                                                        this.I$1 = isFullReconnect;
                                                        this.J$1 = endTime;
                                                        this.label = 4;
                                                        v17 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                                        if (v17 != var20_2) continue;
                                                        return var20_2;
                                                    }
                                                    break;
                                                }
                                                case 4: {
                                                    endTime = this.J$1;
                                                    isFullReconnect = this.I$1;
                                                    retries = this.I$0;
                                                    reconnectStartTime = this.J$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v17 = $result;
                                                    ** GOTO lbl202
                                                }
                                            }
                                            while (SystemClock.elapsedRealtime() < endTime) {
                                                v18 = this.this$0.getSubscriber$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release().connectionState();
                                                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"subscriber.peerConnection.connectionState()");
                                                if (PeerConnectionExtKt.isConnected(v18)) {
                                                    $this$iv = LKLog.Companion;
                                                    t$iv = null;
                                                    $i$f$v = false;
                                                    loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                                                    $i$f$log$livekit_android_sdk_release = false;
                                                    if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                                        $i$a$-log$livekit_android_sdk_release-LKLog$Companion$v$1$iv = false;
                                                        var19_39 = t$iv;
                                                        $i$a$-v$default-RTCEngine$reconnect$job$1$8 = false;
                                                        Timber.v((Throwable)var19_39, (String)"reconnected to ICE", (Object[])new Object[0]);
                                                    }
                                                    this.this$0.setConnectionState$livekit_android_sdk_release(ConnectionState.CONNECTED);
                                                    break block54;
                                                }
                                                this.L$0 = null;
                                                this.J$0 = reconnectStartTime;
                                                this.I$0 = retries;
                                                this.I$1 = isFullReconnect;
                                                this.J$1 = endTime;
                                                this.label = 5;
                                                v19 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                                if (v19 != var20_2) continue;
                                                return var20_2;
                                            }
                                            {
                                                break;
                                                case 5: {
                                                    endTime = this.J$1;
                                                    isFullReconnect = this.I$1;
                                                    retries = this.I$0;
                                                    reconnectStartTime = this.J$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v19 = $result;
                                                    break;
                                                }
                                            }
                                        }
                                        if (this.this$0.getConnectionState$livekit_android_sdk_release() != ConnectionState.CONNECTED) break block56;
                                        if (!RTCEngine.access$getHasPublished$p(this.this$0)) break block57;
                                        v20 = this.this$0.getPublisher$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release().connectionState();
                                        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"publisher.peerConnection.connectionState()");
                                        if (!PeerConnectionExtKt.isConnected(v20)) break block56;
                                    }
                                    this.this$0.getClient().onPCConnected();
                                    v21 = this.this$0.getListener$livekit_android_sdk_release();
                                    if (v21 == null) break block58;
                                    this.L$0 = null;
                                    this.label = 6;
                                    v22 = v21.onPostReconnect(isFullReconnect != 0, (Continuation<? super Unit>)((Continuation)this));
                                    if (v22 == var20_2) {
                                        return var20_2;
                                    }
                                    ** GOTO lbl292
                                    {
                                        case 6: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v22 = $result;
lbl292:
                                            // 2 sources

                                            v23 = Unit.INSTANCE;
                                            break block59;
                                        }
                                    }
                                }
                                v23 = null;
                            }
                            return Unit.INSTANCE;
                        }
                        if ((curReconnectTime = SystemClock.elapsedRealtime() - reconnectStartTime) > 60000L) break block55;
                    }
                    ++retries;
                    ** GOTO lbl14
                }
                this.this$0.close("Failed reconnecting");
                v24 = this.this$0.getListener$livekit_android_sdk_release();
                if (v24 != null) {
                    v24.onEngineDisconnected(DisconnectReason.UNKNOWN_REASON);
                    v25 = Unit.INSTANCE;
                } else {
                    v25 = null;
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        job2.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(this, job2){
            final /* synthetic */ RTCEngine this$0;
            final /* synthetic */ Job $job;
            {
                this.this$0 = $receiver;
                this.$job = $job;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                if (Intrinsics.areEqual((Object)RTCEngine.access$getReconnectingJob$p(this.this$0), (Object)this.$job)) {
                    RTCEngine.access$setReconnectingJob$p(this.this$0, null);
                }
                Mutex.DefaultImpls.unlock$default((Mutex)RTCEngine.access$getReconnectingLock$p(this.this$0), null, (int)1, null);
            }
        });
    }

    public final void negotiatePublisher$livekit_android_sdk_release() {
        if (!this.client.isConnected()) {
            return;
        }
        this.hasPublished = true;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RTCEngine this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.getPublisher$livekit_android_sdk_release().getNegotiate().invoke((Object)RTCEngine.access$getPublisherOfferConstraints(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object sendData$livekit_android_sdk_release(@NotNull LivekitModels.DataPacket var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof sendData.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RTCEngine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.sendData$livekit_android_sdk_release(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = dataPacket.getKind();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"dataPacket.kind");
                $continuation.L$0 = this;
                $continuation.L$1 = dataPacket;
                $continuation.label = 1;
                v1 = this.ensurePublisherConnected(v0, (Continuation<? super Unit>)$continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                dataPacket = (LivekitModels.DataPacket)$continuation.L$1;
                this = (RTCEngine)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl26:
                // 2 sources

                buf = new DataChannel.Buffer(ByteBuffer.wrap(dataPacket.toByteArray()), true);
                v2 = dataPacket.getKind();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"dataPacket.kind");
                v3 = this.dataChannelForKind(v2);
                if (v3 == null) {
                    throw new TrackException.PublishException("channel not established for " + dataPacket.getKind().name(), null, 2, null);
                }
                channel = v3;
                channel.send(buf);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object ensurePublisherConnected(LivekitModels.DataPacket.Kind var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof ensurePublisherConnected.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ RTCEngine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RTCEngine.access$ensurePublisherConnected(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.isSubscriberPrimary) {
                    return Unit.INSTANCE;
                }
                if (this._publisher == null) {
                    throw new RoomException.ConnectException("Publisher isn't setup yet! Is room not connected?!", null, 2, null);
                }
                if (!PeerConnectionExtKt.isConnected(this.getPublisher$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release()) && this.getPublisher$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release().iceConnectionState() != PeerConnection.IceConnectionState.CHECKING) {
                    this.negotiatePublisher$livekit_android_sdk_release();
                }
                v0 = this.dataChannelForKind((LivekitModels.DataPacket.Kind)kind);
                if (v0 == null) {
                    throw new IllegalArgumentException("Unknown data packet kind!");
                }
                targetChannel = v0;
                if (targetChannel.state() == DataChannel.State.OPEN) {
                    return Unit.INSTANCE;
                }
                endTime = SystemClock.elapsedRealtime() + (long)20000;
lbl25:
                // 3 sources

                while (SystemClock.elapsedRealtime() < endTime) {
                    if (PeerConnectionExtKt.isConnected(this.getPublisher$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release()) && targetChannel.state() == DataChannel.State.OPEN) {
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = targetChannel;
                    $continuation.J$0 = endTime;
                    $continuation.label = 1;
                    v1 = DelayKt.delay((long)50L, (Continuation)$continuation);
                    if (v1 != var8_5) continue;
                    return var8_5;
                }
                break;
            }
            case 1: {
                endTime = $continuation.J$0;
                targetChannel = (DataChannel)$continuation.L$1;
                this = (RTCEngine)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl25
            }
        }
        throw new ConnectException("could not establish publisher connection");
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final DataChannel dataChannelForKind(LivekitModels.DataPacket.Kind kind) {
        DataChannel dataChannel;
        switch (WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
            case 1: {
                dataChannel = this.reliableDataChannel;
                break;
            }
            case 2: {
                dataChannel = this.lossyDataChannel;
                break;
            }
            default: {
                dataChannel = null;
            }
        }
        return dataChannel;
    }

    private final MediaConstraints getPublisherOfferConstraints() {
        MediaConstraints mediaConstraints;
        MediaConstraints $this$getPublisherOfferConstraints_u24lambda_u2d6 = mediaConstraints = new MediaConstraints();
        boolean bl = false;
        List $this$getPublisherOfferConstraints_u24lambda_u2d6_u24lambda_u2d5 = $this$getPublisherOfferConstraints_u24lambda_u2d6.mandatory;
        boolean bl2 = false;
        $this$getPublisherOfferConstraints_u24lambda_u2d6_u24lambda_u2d5.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "false"));
        $this$getPublisherOfferConstraints_u24lambda_u2d6_u24lambda_u2d5.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "false"));
        if (this.connectionState == ConnectionState.RECONNECTING) {
            $this$getPublisherOfferConstraints_u24lambda_u2d6_u24lambda_u2d5.add(new MediaConstraints.KeyValuePair("IceRestart", "true"));
        }
        return mediaConstraints;
    }

    private final PeerConnection.RTCConfiguration makeRTCConfig(Either<LivekitRtc.JoinResponse, LivekitRtc.ReconnectResponse> serverResponse, ConnectOptions connectOptions) {
        LivekitModels.ClientConfiguration clientConfiguration;
        Either<LivekitRtc.JoinResponse, LivekitRtc.ReconnectResponse> either;
        List<LivekitRtc.ICEServer> list;
        RTCEngine $this$makeRTCConfig_u24lambda_u2d7 = this;
        boolean bl = false;
        List servers = new ArrayList();
        Either<LivekitRtc.JoinResponse, LivekitRtc.ReconnectResponse> either2 = serverResponse;
        if (either2 instanceof Either.Left) {
            list = ((LivekitRtc.JoinResponse)((Either.Left)serverResponse).getValue()).getIceServersList();
        } else if (either2 instanceof Either.Right) {
            list = ((LivekitRtc.ReconnectResponse)((Either.Right)serverResponse).getValue()).getIceServersList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List<LivekitRtc.ICEServer> responseServers = list;
        either2 = responseServers.iterator();
        while (either2.hasNext()) {
            LivekitRtc.ICEServer serverInfo = (LivekitRtc.ICEServer)either2.next();
            Intrinsics.checkNotNullExpressionValue((Object)serverInfo, (String)"serverInfo");
            PeerConnection.IceServer iceServer = RTCEngineKt.toWebrtc(serverInfo);
            Intrinsics.checkNotNullExpressionValue((Object)iceServer, (String)"serverInfo.toWebrtc()");
            servers.add(iceServer);
        }
        if (servers.isEmpty()) {
            servers.addAll((Collection)SignalClient.Companion.getDEFAULT_ICE_SERVERS());
        }
        List serverIceServers = servers;
        PeerConnection.RTCConfiguration rTCConfiguration = connectOptions.getRtcConfig();
        if (rTCConfiguration != null && (rTCConfiguration = PeerConnectionExtKt.copy(rTCConfiguration)) != null) {
            PeerConnection.IceServer server;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Either<LivekitRtc.JoinResponse, LivekitRtc.ReconnectResponse> $this$makeRTCConfig_u24lambda_u2d10 = either2 = rTCConfiguration;
            boolean bl2 = false;
            List list2 = ((PeerConnection.RTCConfiguration)$this$makeRTCConfig_u24lambda_u2d10).iceServers;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"iceServers");
            List mergedServers = CollectionsKt.toMutableList((Collection)list2);
            if (connectOptions.getIceServers() != null) {
                $this$forEach$iv = connectOptions.getIceServers();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    server = (PeerConnection.IceServer)element$iv;
                    boolean bl3 = false;
                    if (mergedServers.contains(server)) continue;
                    mergedServers.add(server);
                }
            }
            if (mergedServers.isEmpty()) {
                List list3 = ((PeerConnection.RTCConfiguration)$this$makeRTCConfig_u24lambda_u2d10).iceServers;
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"iceServers");
                $this$forEach$iv = list3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    server = (PeerConnection.IceServer)element$iv;
                    boolean bl4 = false;
                    if (mergedServers.contains(server)) continue;
                    mergedServers.add(server);
                }
            }
            ((PeerConnection.RTCConfiguration)$this$makeRTCConfig_u24lambda_u2d10).iceServers = mergedServers;
            either = either2;
        } else {
            Either<LivekitRtc.JoinResponse, LivekitRtc.ReconnectResponse> $this$makeRTCConfig_u24lambda_u2d11 = either2 = new PeerConnection.RTCConfiguration(serverIceServers);
            boolean bl5 = false;
            ((PeerConnection.RTCConfiguration)$this$makeRTCConfig_u24lambda_u2d11).sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
            ((PeerConnection.RTCConfiguration)$this$makeRTCConfig_u24lambda_u2d11).continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
            either = either2;
        }
        Either<LivekitRtc.JoinResponse, LivekitRtc.ReconnectResponse> rtcConfig = either;
        Either<LivekitRtc.JoinResponse, LivekitRtc.ReconnectResponse> either3 = serverResponse;
        if (either3 instanceof Either.Left) {
            clientConfiguration = ((LivekitRtc.JoinResponse)((Either.Left)serverResponse).getValue()).hasClientConfiguration() ? ((LivekitRtc.JoinResponse)((Either.Left)serverResponse).getValue()).getClientConfiguration() : (LivekitModels.ClientConfiguration)null;
        } else if (either3 instanceof Either.Right) {
            clientConfiguration = ((LivekitRtc.ReconnectResponse)((Either.Right)serverResponse).getValue()).hasClientConfiguration() ? ((LivekitRtc.ReconnectResponse)((Either.Right)serverResponse).getValue()).getClientConfiguration() : (LivekitModels.ClientConfiguration)null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        LivekitModels.ClientConfiguration clientConfig = clientConfiguration;
        if (clientConfig != null && clientConfig.getForceRelay() == LivekitModels.ClientConfigSetting.ENABLED) {
            ((PeerConnection.RTCConfiguration)rtcConfig).iceTransportsType = PeerConnection.IceTransportsType.RELAY;
        }
        return rtcConfig;
    }

    @Override
    public void onAnswer(@NotNull SessionDescription sessionDescription) {
        Intrinsics.checkNotNullParameter((Object)sessionDescription, (String)"sessionDescription");
        LKLog.Companion $this$iv = LKLog.Companion;
        Throwable t$iv = null;
        boolean $i$f$v = false;
        LKLog.Companion companion = $this$iv;
        LoggingLevel loggingLevel$iv$iv = LoggingLevel.VERBOSE;
        boolean $i$f$log$livekit_android_sdk_release = false;
        if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
            boolean bl = false;
            Throwable throwable = t$iv;
            boolean bl2 = false;
            Timber.v(throwable, (String)("received server answer: " + sessionDescription.type + ", " + this.getPublisher$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release().signalingState()), (Object[])new Object[0]);
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sessionDescription, null){
            int label;
            final /* synthetic */ RTCEngine this$0;
            final /* synthetic */ SessionDescription $sessionDescription;
            {
                this.this$0 = $receiver;
                this.$sessionDescription = $sessionDescription;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = LKLog.Companion;
                        var4_4 = this.$sessionDescription;
                        t$iv = null;
                        $i$f$i = false;
                        loggingLevel$iv$iv = LoggingLevel.INFO;
                        $i$f$log$livekit_android_sdk_release = false;
                        if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                            $i$a$-log$livekit_android_sdk_release-LKLog$Companion$i$1$iv = false;
                            var10_10 = t$iv;
                            $i$a$-i$default-RTCEngine$onAnswer$2$1 = false;
                            Timber.i(var10_10, (String)var4_4.toString(), (Object[])new Object[0]);
                        }
                        this.label = 1;
                        v0 = this.this$0.getPublisher$livekit_android_sdk_release().setRemoteDescription(this.$sessionDescription, (Continuation<? super Either<Unit, String>>)((Continuation)this));
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        if (!((outcome = (Either)v0) instanceof Either.Left) && outcome instanceof Either.Right) {
                            $this$iv = LKLog.Companion;
                            t$iv = null;
                            $i$f$e = false;
                            loggingLevel$iv$iv = LoggingLevel.ERROR;
                            $i$f$log$livekit_android_sdk_release = false;
                            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                $i$a$-log$livekit_android_sdk_release-LKLog$Companion$e$1$iv = false;
                                var10_10 = t$iv;
                                $i$a$-e$default-RTCEngine$onAnswer$2$2 = false;
                                Timber.e(var10_10, (String)("error setting remote description for answer: " + (String)((Either.Right)outcome).getValue() + ' '), (Object[])new Object[0]);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void onOffer(@NotNull SessionDescription sessionDescription) {
        Intrinsics.checkNotNullParameter((Object)sessionDescription, (String)"sessionDescription");
        LKLog.Companion $this$iv = LKLog.Companion;
        Throwable t$iv = null;
        boolean $i$f$v = false;
        LKLog.Companion companion = $this$iv;
        LoggingLevel loggingLevel$iv$iv = LoggingLevel.VERBOSE;
        boolean $i$f$log$livekit_android_sdk_release = false;
        if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
            boolean bl = false;
            Throwable throwable = t$iv;
            boolean bl2 = false;
            Timber.v(throwable, (String)("received server offer: " + sessionDescription.type + ", " + this.getSubscriber$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release().signalingState()), (Object[])new Object[0]);
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sessionDescription, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RTCEngine this$0;
            final /* synthetic */ SessionDescription $sessionDescription;
            {
                this.this$0 = $receiver;
                this.$sessionDescription = $sessionDescription;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        var3_4 = this.this$0;
                        var4_5 = this.$sessionDescription;
                        $i$a$-run-RTCEngine$onOffer$2$1 = false;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = var3_4.getSubscriber$livekit_android_sdk_release().setRemoteDescription((SessionDescription)var4_5, (Continuation<? super Either<Unit, String>>)this);
                        if (v0 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        $i$a$-run-RTCEngine$onOffer$2$1 = false;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        if ((outcome = (Either)v0) instanceof Either.Right) {
                            $this$iv = LKLog.Companion;
                            t$iv = null;
                            $i$f$e = false;
                            loggingLevel$iv$iv = LoggingLevel.ERROR;
                            $i$f$log$livekit_android_sdk_release = false;
                            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                $i$a$-log$livekit_android_sdk_release-LKLog$Companion$e$1$iv = false;
                                var14_28 = t$iv;
                                $i$a$-e$default-RTCEngine$onOffer$2$1$1 = false;
                                Timber.e(var14_28, (String)("error setting remote description for answer: " + (String)((Either.Right)outcome).getValue() + ' '), (Object[])new Object[0]);
                            }
                            return Unit.INSTANCE;
                        }
                        var4_5 = $this$launch;
                        $i$a$-run-RTCEngine$onOffer$2$1 = this.this$0;
                        $i$a$-run-RTCEngine$onOffer$2$answer$1 = false;
                        this.L$0 = null;
                        this.label = 2;
                        v1 = CoroutineSdpObserverKt.createAnswer($i$a$-run-RTCEngine$onOffer$2$1.getSubscriber$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release(), new MediaConstraints(), (Continuation<? super Either<? extends SessionDescription, String>>)this);
                        if (v1 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl47
                    }
                    case 2: {
                        $i$a$-run-RTCEngine$onOffer$2$answer$1 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl47:
                        // 2 sources

                        if (!((outcome = (Either)v1) instanceof Either.Left)) {
                            if (outcome instanceof Either.Right) {
                                $this$iv = LKLog.Companion;
                                t$iv = null;
                                $i$f$e = false;
                                loggingLevel$iv$iv = LoggingLevel.ERROR;
                                $i$f$log$livekit_android_sdk_release = false;
                                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                    $i$a$-log$livekit_android_sdk_release-LKLog$Companion$e$1$iv = false;
                                    var16_35 = t$iv;
                                    $i$a$-e$default-RTCEngine$onOffer$2$answer$1$1 = false;
                                    Timber.e(var16_35, (String)("error creating answer: " + (String)((Either.Right)outcome).getValue()), (Object[])new Object[0]);
                                }
                                return Unit.INSTANCE;
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        answer = (SessionDescription)((Either.Left)outcome).getValue();
                        var4_5 = this.this$0;
                        $i$a$-run-RTCEngine$onOffer$2$2 = false;
                        this.L$0 = answer;
                        this.label = 3;
                        v2 = CoroutineSdpObserverKt.setLocalDescription(var4_5.getSubscriber$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release(), answer, (Continuation<? super Either<Unit, String>>)this);
                        if (v2 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl77
                    }
                    case 3: {
                        $i$a$-run-RTCEngine$onOffer$2$2 = false;
                        answer = (SessionDescription)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl77:
                        // 2 sources

                        if ((outcome = (Either)v2) instanceof Either.Right) {
                            $this$iv = LKLog.Companion;
                            t$iv = null;
                            $i$f$e = false;
                            loggingLevel$iv$iv = LoggingLevel.ERROR;
                            $i$f$log$livekit_android_sdk_release = false;
                            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                                $i$a$-log$livekit_android_sdk_release-LKLog$Companion$e$1$iv = false;
                                var14_30 = t$iv;
                                $i$a$-e$default-RTCEngine$onOffer$2$2$1 = false;
                                Timber.e(var14_30, (String)("error setting local description for answer: " + (String)((Either.Right)outcome).getValue()), (Object[])new Object[0]);
                            }
                            return Unit.INSTANCE;
                        }
                        this.this$0.getClient().sendAnswer(answer);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void onTrickle(@NotNull IceCandidate candidate, @NotNull LivekitRtc.SignalTarget target) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        LKLog.Companion $this$iv = LKLog.Companion;
        Throwable t$iv = null;
        boolean $i$f$v = false;
        LKLog.Companion companion = $this$iv;
        LoggingLevel loggingLevel$iv$iv = LoggingLevel.VERBOSE;
        boolean $i$f$log$livekit_android_sdk_release2 = false;
        if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
            boolean bl = false;
            throwable = t$iv;
            boolean bl2 = false;
            Timber.v(throwable, (String)("received ice candidate from peer: " + candidate + ", " + (Object)((Object)target)), (Object[])new Object[0]);
        }
        switch (WhenMappings.$EnumSwitchMapping$2[target.ordinal()]) {
            case 1: {
                if (this._publisher != null) {
                    this.getPublisher$livekit_android_sdk_release().addIceCandidate(candidate);
                    break;
                }
                LKLog.Companion $this$iv2 = LKLog.Companion;
                Throwable t$iv2 = null;
                boolean $i$f$w = false;
                LKLog.Companion $i$f$log$livekit_android_sdk_release2 = $this$iv2;
                LoggingLevel loggingLevel$iv$iv2 = LoggingLevel.WARN;
                boolean $i$f$log$livekit_android_sdk_release3 = false;
                if (loggingLevel$iv$iv2.compareTo((Enum)LKLog.Companion.getLoggingLevel()) < 0 || Timber.treeCount() <= 0) break;
                boolean bl = false;
                throwable = t$iv2;
                boolean bl3 = false;
                Timber.w(throwable, (String)"received candidate for publisher when we don't have one. ignoring.", (Object[])new Object[0]);
                break;
            }
            case 2: {
                this.getSubscriber$livekit_android_sdk_release().addIceCandidate(candidate);
                break;
            }
            default: {
                LKLog.Companion $this$iv3 = LKLog.Companion;
                Throwable t$iv2 = null;
                boolean $i$f$i = false;
                LKLog.Companion this_$iv$iv = $this$iv3;
                LoggingLevel loggingLevel$iv$iv3 = LoggingLevel.INFO;
                boolean $i$f$log$livekit_android_sdk_release3 = false;
                if (loggingLevel$iv$iv3.compareTo((Enum)LKLog.Companion.getLoggingLevel()) < 0 || Timber.treeCount() <= 0) break;
                boolean bl = false;
                throwable = t$iv2;
                boolean bl4 = false;
                Timber.i(throwable, (String)"unknown ice candidate target?", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onLocalTrackPublished(@NotNull LivekitRtc.TrackPublishedResponse response) {
        Throwable throwable;
        boolean $i$f$log$livekit_android_sdk_release;
        Object loggingLevel$iv$iv;
        Throwable t$iv;
        LKLog.Companion $this$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = response.getCid();
        if (string == null) {
            RTCEngine $this$onLocalTrackPublished_u24lambda_u2d18 = this;
            boolean bl = false;
            LKLog.Companion $this$iv2 = LKLog.Companion;
            Throwable t$iv2 = null;
            boolean $i$f$e = false;
            LKLog.Companion companion = $this$iv2;
            LoggingLevel loggingLevel$iv$iv2 = LoggingLevel.ERROR;
            boolean $i$f$log$livekit_android_sdk_release2 = false;
            if (loggingLevel$iv$iv2.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                boolean bl2 = false;
                Throwable throwable2 = t$iv2;
                boolean bl3 = false;
                Timber.e(throwable2, (String)"local track published with null cid?", (Object[])new Object[0]);
            }
            return;
        }
        String cid = string;
        LivekitModels.TrackInfo track2 = response.getTrack();
        if (track2 == null) {
            $this$iv = LKLog.Companion;
            t$iv = null;
            boolean $i$f$d = false;
            LKLog.Companion $this$iv2 = $this$iv;
            loggingLevel$iv$iv = LoggingLevel.DEBUG;
            $i$f$log$livekit_android_sdk_release = false;
            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                boolean bl = false;
                throwable = t$iv;
                boolean bl4 = false;
                Timber.d(throwable, (String)"local track published with null track info?", (Object[])new Object[0]);
            }
        }
        $this$iv = LKLog.Companion;
        t$iv = null;
        boolean $i$f$v = false;
        LKLog.Companion this_$iv$iv = $this$iv;
        loggingLevel$iv$iv = LoggingLevel.VERBOSE;
        $i$f$log$livekit_android_sdk_release = false;
        if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
            boolean bl = false;
            throwable = t$iv;
            boolean bl5 = false;
            Timber.v(throwable, (String)("local track published " + cid), (Object[])new Object[0]);
        }
        Continuation<LivekitModels.TrackInfo> cont = this.pendingTrackResolvers.remove(cid);
        if (cont == null) {
            LKLog.Companion $this$iv3 = LKLog.Companion;
            Throwable t$iv3 = null;
            boolean $i$f$d = false;
            loggingLevel$iv$iv = $this$iv3;
            LoggingLevel loggingLevel$iv$iv3 = LoggingLevel.DEBUG;
            boolean $i$f$log$livekit_android_sdk_release3 = false;
            if (loggingLevel$iv$iv3.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                boolean bl = false;
                throwable = t$iv3;
                boolean bl6 = false;
                Timber.d(throwable, (String)("missing track resolver for: " + cid), (Object[])new Object[0]);
            }
            return;
        }
        cont.resumeWith(Result.constructor-impl((Object)response.getTrack()));
    }

    @Override
    public void onParticipantUpdate(@NotNull List<LivekitModels.ParticipantInfo> updates) {
        block0: {
            Intrinsics.checkNotNullParameter(updates, (String)"updates");
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onUpdateParticipants(updates);
        }
    }

    @Override
    public void onSpeakersChanged(@NotNull List<LivekitModels.SpeakerInfo> speakers) {
        block0: {
            Intrinsics.checkNotNullParameter(speakers, (String)"speakers");
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onSpeakersChanged(speakers);
        }
    }

    @Override
    public void onClose(@NotNull String reason, int code) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        LKLog.Companion $this$iv = LKLog.Companion;
        Throwable t$iv = null;
        boolean $i$f$i = false;
        LKLog.Companion companion = $this$iv;
        LoggingLevel loggingLevel$iv$iv = LoggingLevel.INFO;
        boolean $i$f$log$livekit_android_sdk_release = false;
        if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
            boolean bl = false;
            Throwable throwable = t$iv;
            boolean bl2 = false;
            Timber.i(throwable, (String)("received close event: " + reason + ", code: " + code), (Object[])new Object[0]);
        }
        this.reconnect$livekit_android_sdk_release();
    }

    @Override
    public void onRemoteMuteChanged(@NotNull String trackSid, boolean muted) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)trackSid, (String)"trackSid");
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onRemoteMuteChanged(trackSid, muted);
        }
    }

    @Override
    public void onRoomUpdate(@NotNull LivekitModels.Room update) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)update, (String)"update");
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onRoomUpdate(update);
        }
    }

    @Override
    public void onConnectionQuality(@NotNull List<LivekitRtc.ConnectionQualityInfo> updates) {
        block0: {
            Intrinsics.checkNotNullParameter(updates, (String)"updates");
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onConnectionQuality(updates);
        }
    }

    @Override
    public void onLeave(@NotNull LivekitRtc.LeaveRequest leave) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)leave, (String)"leave");
                if (!leave.getCanReconnect()) break block0;
                this.fullReconnectOnNext = true;
                break block1;
            }
            RTCEngine.close$default(this, null, 1, null);
            DisconnectReason disconnectReason = RoomEventKt.convert(leave.getReason());
            Listener listener = this.listener;
            if (listener == null) break block1;
            listener.onEngineDisconnected(disconnectReason);
        }
    }

    @Override
    public void onError(@NotNull Throwable error) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            if (this.connectionState != ConnectionState.CONNECTING) break block1;
            Listener listener = this.listener;
            if (listener != null) {
                listener.onFailToConnect(error);
            }
        }
    }

    @Override
    public void onStreamStateUpdate(@NotNull List<LivekitRtc.StreamStateInfo> streamStates) {
        block0: {
            Intrinsics.checkNotNullParameter(streamStates, (String)"streamStates");
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onStreamStateUpdate(streamStates);
        }
    }

    @Override
    public void onSubscribedQualityUpdate(@NotNull LivekitRtc.SubscribedQualityUpdate subscribedQualityUpdate) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)subscribedQualityUpdate, (String)"subscribedQualityUpdate");
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onSubscribedQualityUpdate(subscribedQualityUpdate);
        }
    }

    @Override
    public void onSubscriptionPermissionUpdate(@NotNull LivekitRtc.SubscriptionPermissionUpdate subscriptionPermissionUpdate) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)subscriptionPermissionUpdate, (String)"subscriptionPermissionUpdate");
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onSubscriptionPermissionUpdate(subscriptionPermissionUpdate);
        }
    }

    @Override
    public void onRefreshToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.sessionToken = token;
    }

    @Override
    public void onLocalTrackUnpublished(@NotNull LivekitRtc.TrackUnpublishedResponse trackUnpublished) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)trackUnpublished, (String)"trackUnpublished");
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onLocalTrackUnpublished(trackUnpublished);
        }
    }

    public void onBufferedAmountChange(long previousAmount) {
    }

    public void onStateChange() {
    }

    public void onMessage(@Nullable DataChannel.Buffer buffer) {
        if (buffer == null) {
            return;
        }
        LivekitModels.DataPacket dp = LivekitModels.DataPacket.parseFrom(ByteString.copyFrom((ByteBuffer)buffer.data));
        LivekitModels.DataPacket.ValueCase valueCase = dp.getValueCase();
        switch (valueCase == null ? -1 : WhenMappings.$EnumSwitchMapping$3[valueCase.ordinal()]) {
            case 1: {
                Listener listener = this.listener;
                if (listener != null) {
                    List<LivekitModels.SpeakerInfo> list = dp.getSpeaker().getSpeakersList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"dp.speaker.speakersList");
                    listener.onActiveSpeakersUpdate(list);
                }
                break;
            }
            case 2: {
                Listener listener = this.listener;
                if (listener != null) {
                    LivekitModels.UserPacket userPacket = dp.getUser();
                    Intrinsics.checkNotNullExpressionValue((Object)userPacket, (String)"dp.user");
                    LivekitModels.DataPacket.Kind kind = dp.getKind();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"dp.kind");
                    listener.onUserPacket(userPacket, kind);
                }
                break;
            }
            case -1: 
            case 3: {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$v = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.VERBOSE;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) < 0 || Timber.treeCount() <= 0) break;
                boolean bl = false;
                Throwable throwable = t$iv;
                boolean bl2 = false;
                Timber.v(throwable, (String)"invalid value for data packet", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendSyncState(@NotNull LivekitRtc.UpdateSubscription subscription, @NotNull List<LivekitRtc.TrackPublishedResponse> publishedTracks) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter(publishedTracks, (String)"publishedTracks");
        SessionDescription sessionDescription = this.getSubscriber$livekit_android_sdk_release().getPeerConnection$livekit_android_sdk_release().getLocalDescription();
        LivekitRtc.SessionDescription answer = sessionDescription != null ? SessionDescriptionExtKt.toProtoSessionDescription(sessionDescription) : null;
        Iterable iterable = ArraysKt.toList((Object[])LivekitModels.DataPacket.Kind.values());
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        DataChannel dataChannel = $this$forEach$iv$iv$iv.iterator();
        while (dataChannel.hasNext()) {
            DataChannel it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = dataChannel.next();
            boolean bl = false;
            LivekitModels.DataPacket.Kind kind = (LivekitModels.DataPacket.Kind)((Object)element$iv$iv);
            boolean bl2 = false;
            if (this.dataChannelForKind(kind) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void dataChannel2;
            dataChannel = (DataChannel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((LivekitRtc.DataChannelInfo)LivekitRtc.DataChannelInfo.newBuilder().setId(dataChannel2.id()).setLabel(dataChannel2.label()).build());
        }
        List dataChannelInfos = (List)destination$iv$iv;
        LivekitRtc.SyncState.Builder $this$sendSyncState_u24lambda_u2d26 = LivekitRtc.SyncState.newBuilder();
        boolean bl = false;
        if (answer != null) {
            $this$sendSyncState_u24lambda_u2d26.setAnswer(answer);
        }
        $this$sendSyncState_u24lambda_u2d26.setSubscription(subscription);
        $this$sendSyncState_u24lambda_u2d26.addAllPublishTracks((Iterable<? extends LivekitRtc.TrackPublishedResponse>)publishedTracks);
        $this$sendSyncState_u24lambda_u2d26.addAllDataChannels(dataChannelInfos);
        LivekitRtc.SyncState syncState = (LivekitRtc.SyncState)$this$sendSyncState_u24lambda_u2d26.build();
        Intrinsics.checkNotNullExpressionValue((Object)syncState, (String)"syncState");
        this.client.sendSyncState(syncState);
    }

    public final void getPublisherRTCStats(@NotNull RTCStatsCollectorCallback callback) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        PeerConnectionTransport peerConnectionTransport = this._publisher;
        if (peerConnectionTransport != null && (peerConnectionTransport = peerConnectionTransport.getPeerConnection$livekit_android_sdk_release()) != null) {
            peerConnectionTransport.getStats(callback);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            callback.onStatsDelivered(new RTCStatsReport(0L, MapsKt.emptyMap()));
        }
    }

    public final void getSubscriberRTCStats(@NotNull RTCStatsCollectorCallback callback) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        PeerConnectionTransport peerConnectionTransport = this._subscriber;
        if (peerConnectionTransport != null && (peerConnectionTransport = peerConnectionTransport.getPeerConnection$livekit_android_sdk_release()) != null) {
            peerConnectionTransport.getStats(callback);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            callback.onStatsDelivered(new RTCStatsReport(0L, MapsKt.emptyMap()));
        }
    }

    public static final /* synthetic */ void access$setReliableDataChannelSub$p(RTCEngine $this, DataChannel dataChannel) {
        $this.reliableDataChannelSub = dataChannel;
    }

    public static final /* synthetic */ void access$setLossyDataChannelSub$p(RTCEngine $this, DataChannel dataChannel) {
        $this.lossyDataChannelSub = dataChannel;
    }

    public static final /* synthetic */ ConnectOptions access$getConnectOptions$p(RTCEngine $this) {
        return $this.connectOptions;
    }

    public static final /* synthetic */ void access$closeResources(RTCEngine $this, String reason) {
        $this.closeResources(reason);
    }

    public static final /* synthetic */ RoomOptions access$getLastRoomOptions$p(RTCEngine $this) {
        return $this.lastRoomOptions;
    }

    public static final /* synthetic */ String access$getParticipantSid$p(RTCEngine $this) {
        return $this.participantSid;
    }

    public static final /* synthetic */ PeerConnection.RTCConfiguration access$makeRTCConfig(RTCEngine $this, Either serverResponse, ConnectOptions connectOptions) {
        return $this.makeRTCConfig(serverResponse, connectOptions);
    }

    public static final /* synthetic */ PeerConnectionTransport access$get_subscriber$p(RTCEngine $this) {
        return $this._subscriber;
    }

    public static final /* synthetic */ PeerConnectionTransport access$get_publisher$p(RTCEngine $this) {
        return $this._publisher;
    }

    public static final /* synthetic */ boolean access$getHasPublished$p(RTCEngine $this) {
        return $this.hasPublished;
    }

    public static final /* synthetic */ Job access$getReconnectingJob$p(RTCEngine $this) {
        return $this.reconnectingJob;
    }

    public static final /* synthetic */ void access$setReconnectingJob$p(RTCEngine $this, Job job2) {
        $this.reconnectingJob = job2;
    }

    public static final /* synthetic */ Mutex access$getReconnectingLock$p(RTCEngine $this) {
        return $this.reconnectingLock;
    }

    public static final /* synthetic */ MediaConstraints access$getPublisherOfferConstraints(RTCEngine $this) {
        return $this.getPublisherOfferConstraints();
    }

    public static final /* synthetic */ Object access$ensurePublisherConnected(RTCEngine $this, LivekitModels.DataPacket.Kind kind, Continuation $completion) {
        return $this.ensurePublisherConnected(kind, (Continuation<? super Unit>)$completion);
    }

    static {
        MediaConstraints mediaConstraints;
        Companion = new Companion(null);
        $stable = 8;
        MediaConstraints $this$CONN_CONSTRAINTS_u24lambda_u2d28 = mediaConstraints = new MediaConstraints();
        boolean bl = false;
        List $this$CONN_CONSTRAINTS_u24lambda_u2d28_u24lambda_u2d27 = $this$CONN_CONSTRAINTS_u24lambda_u2d28.optional;
        boolean bl2 = false;
        $this$CONN_CONSTRAINTS_u24lambda_u2d28_u24lambda_u2d27.add(new MediaConstraints.KeyValuePair("DtlsSrtpKeyAgreement", "true"));
        CONN_CONSTRAINTS = mediaConstraints;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J%\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH&\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H&J\b\u0010\u0011\u001a\u00020\u0003H&J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0003H&J\b\u0010\u0016\u001a\u00020\u0003H&J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u0003H&J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH&J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H&J\u0019\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#H&J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H&J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020#H&J\u0016\u0010.\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u0016\u0010/\u001a\u00020\u00032\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0005H&J\u0010\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u000204H&J\u0010\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u000207H&J\u0016\u00108\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002090\u0005H&J\u0018\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006?"}, d2={"Lio/livekit/android/room/RTCEngine$Listener;", "", "onActiveSpeakersUpdate", "", "speakers", "", "Llivekit/LivekitModels$SpeakerInfo;", "onAddTrack", "track", "Lorg/webrtc/MediaStreamTrack;", "streams", "", "Lorg/webrtc/MediaStream;", "(Lorg/webrtc/MediaStreamTrack;[Lorg/webrtc/MediaStream;)V", "onConnectionQuality", "updates", "Llivekit/LivekitRtc$ConnectionQualityInfo;", "onEngineConnected", "onEngineDisconnected", "reason", "Lio/livekit/android/events/DisconnectReason;", "onEngineReconnected", "onEngineReconnecting", "onFailToConnect", "error", "", "onFullReconnecting", "onJoinResponse", "response", "Llivekit/LivekitRtc$JoinResponse;", "onLocalTrackUnpublished", "trackUnpublished", "Llivekit/LivekitRtc$TrackUnpublishedResponse;", "onPostReconnect", "isFullReconnect", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onRemoteMuteChanged", "trackSid", "", "muted", "onRoomUpdate", "update", "Llivekit/LivekitModels$Room;", "onSignalConnected", "isResume", "onSpeakersChanged", "onStreamStateUpdate", "streamStates", "Llivekit/LivekitRtc$StreamStateInfo;", "onSubscribedQualityUpdate", "subscribedQualityUpdate", "Llivekit/LivekitRtc$SubscribedQualityUpdate;", "onSubscriptionPermissionUpdate", "subscriptionPermissionUpdate", "Llivekit/LivekitRtc$SubscriptionPermissionUpdate;", "onUpdateParticipants", "Llivekit/LivekitModels$ParticipantInfo;", "onUserPacket", "packet", "Llivekit/LivekitModels$UserPacket;", "kind", "Llivekit/LivekitModels$DataPacket$Kind;", "livekit-android-sdk_release"})
    public static interface Listener {
        public void onEngineConnected();

        public void onEngineReconnected();

        public void onEngineReconnecting();

        public void onEngineDisconnected(@NotNull DisconnectReason var1);

        public void onFailToConnect(@NotNull Throwable var1);

        public void onJoinResponse(@NotNull LivekitRtc.JoinResponse var1);

        public void onAddTrack(@NotNull MediaStreamTrack var1, @NotNull MediaStream[] var2);

        public void onUpdateParticipants(@NotNull List<LivekitModels.ParticipantInfo> var1);

        public void onActiveSpeakersUpdate(@NotNull List<LivekitModels.SpeakerInfo> var1);

        public void onRemoteMuteChanged(@NotNull String var1, boolean var2);

        public void onRoomUpdate(@NotNull LivekitModels.Room var1);

        public void onConnectionQuality(@NotNull List<LivekitRtc.ConnectionQualityInfo> var1);

        public void onSpeakersChanged(@NotNull List<LivekitModels.SpeakerInfo> var1);

        public void onUserPacket(@NotNull LivekitModels.UserPacket var1, @NotNull LivekitModels.DataPacket.Kind var2);

        public void onStreamStateUpdate(@NotNull List<LivekitRtc.StreamStateInfo> var1);

        public void onSubscribedQualityUpdate(@NotNull LivekitRtc.SubscribedQualityUpdate var1);

        public void onSubscriptionPermissionUpdate(@NotNull LivekitRtc.SubscriptionPermissionUpdate var1);

        public void onSignalConnected(boolean var1);

        public void onFullReconnecting();

        @Nullable
        public Object onPostReconnect(boolean var1, @NotNull Continuation<? super Unit> var2);

        public void onLocalTrackUnpublished(@NotNull LivekitRtc.TrackUnpublishedResponse var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/livekit/android/room/RTCEngine$Companion;", "", "()V", "CONN_CONSTRAINTS", "Lorg/webrtc/MediaConstraints;", "getCONN_CONSTRAINTS$livekit_android_sdk_release", "()Lorg/webrtc/MediaConstraints;", "LOSSY_DATA_CHANNEL_LABEL", "", "MAX_DATA_PACKET_SIZE", "", "MAX_ICE_CONNECT_TIMEOUT_MS", "MAX_RECONNECT_RETRIES", "MAX_RECONNECT_TIMEOUT", "RELIABLE_DATA_CHANNEL_LABEL", "livekit-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MediaConstraints getCONN_CONSTRAINTS$livekit_android_sdk_release() {
            return CONN_CONSTRAINTS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[ConnectionState.values().length];
            nArray[ConnectionState.CONNECTED.ordinal()] = 1;
            nArray[ConnectionState.DISCONNECTED.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LivekitModels.DataPacket.Kind.values().length];
            nArray[LivekitModels.DataPacket.Kind.RELIABLE.ordinal()] = 1;
            nArray[LivekitModels.DataPacket.Kind.LOSSY.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[LivekitRtc.SignalTarget.values().length];
            nArray[LivekitRtc.SignalTarget.PUBLISHER.ordinal()] = 1;
            nArray[LivekitRtc.SignalTarget.SUBSCRIBER.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[LivekitModels.DataPacket.ValueCase.values().length];
            nArray[LivekitModels.DataPacket.ValueCase.SPEAKER.ordinal()] = 1;
            nArray[LivekitModels.DataPacket.ValueCase.USER.ordinal()] = 2;
            nArray[LivekitModels.DataPacket.ValueCase.VALUE_NOT_SET.ordinal()] = 3;
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

