/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.room.participant;

import androidx.compose.runtime.internal.StabilityInferred;
import io.livekit.android.events.ParticipantEvent;
import io.livekit.android.room.SignalClient;
import io.livekit.android.room.participant.Participant;
import io.livekit.android.room.participant.ParticipantListener;
import io.livekit.android.room.track.AudioTrack;
import io.livekit.android.room.track.RemoteTrackPublication;
import io.livekit.android.room.track.RemoteVideoTrack;
import io.livekit.android.room.track.Track;
import io.livekit.android.room.track.TrackException;
import io.livekit.android.room.track.TrackPublication;
import io.livekit.android.util.CloseableCoroutineScope;
import io.livekit.android.util.LKLog;
import io.livekit.android.util.LoggingLevel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.SupervisorKt;
import livekit.LivekitModels;
import livekit.LivekitRtc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoTrack;
import timber.log.Timber;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB1\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0018\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u000b2\b\b\u0002\u0010&\u001a\u00020\u0017J\u0015\u0010'\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b(R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lio/livekit/android/room/participant/RemoteParticipant;", "Lio/livekit/android/room/participant/Participant;", "info", "Llivekit/LivekitModels$ParticipantInfo;", "signalClient", "Lio/livekit/android/room/SignalClient;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "defaultDispatcher", "(Llivekit/LivekitModels$ParticipantInfo;Lio/livekit/android/room/SignalClient;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlinx/coroutines/CoroutineDispatcher;)V", "sid", "", "identity", "(Ljava/lang/String;Ljava/lang/String;Lio/livekit/android/room/SignalClient;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlinx/coroutines/CoroutineDispatcher;)V", "coroutineScope", "Lio/livekit/android/util/CloseableCoroutineScope;", "getSignalClient", "()Lio/livekit/android/room/SignalClient;", "addSubscribedMediaTrack", "", "mediaTrack", "Lorg/webrtc/MediaStreamTrack;", "autoManageVideo", "", "triesLeft", "", "getTrackPublication", "Lio/livekit/android/room/track/RemoteTrackPublication;", "onDataReceived", "data", "", "onDataReceived$livekit_android_sdk_release", "onSubscriptionPermissionUpdate", "subscriptionPermissionUpdate", "Llivekit/LivekitRtc$SubscriptionPermissionUpdate;", "onSubscriptionPermissionUpdate$livekit_android_sdk_release", "unpublishTrack", "trackSid", "sendUnpublish", "updateFromInfo", "updateFromInfo$livekit_android_sdk_release", "Companion", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public final class RemoteParticipant
extends Participant {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignalClient signalClient;
    @NotNull
    private final CoroutineDispatcher ioDispatcher;
    @NotNull
    private final CloseableCoroutineScope coroutineScope;
    public static final int $stable = 8;
    @NotNull
    private static final String KIND_AUDIO = "audio";
    @NotNull
    private static final String KIND_VIDEO = "video";

    public RemoteParticipant(@NotNull String sid, @Nullable String identity, @NotNull SignalClient signalClient, @NotNull CoroutineDispatcher ioDispatcher, @NotNull CoroutineDispatcher defaultDispatcher) {
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        Intrinsics.checkNotNullParameter((Object)((Object)signalClient), (String)"signalClient");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        Intrinsics.checkNotNullParameter((Object)defaultDispatcher, (String)"defaultDispatcher");
        super(sid, identity, defaultDispatcher);
        this.signalClient = signalClient;
        this.ioDispatcher = ioDispatcher;
        this.coroutineScope = new CloseableCoroutineScope(defaultDispatcher.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
    }

    public /* synthetic */ RemoteParticipant(String string, String string2, SignalClient signalClient, CoroutineDispatcher coroutineDispatcher, CoroutineDispatcher coroutineDispatcher2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2, signalClient, coroutineDispatcher, coroutineDispatcher2);
    }

    @NotNull
    public final SignalClient getSignalClient() {
        return this.signalClient;
    }

    public RemoteParticipant(@NotNull LivekitModels.ParticipantInfo info, @NotNull SignalClient signalClient, @NotNull CoroutineDispatcher ioDispatcher, @NotNull CoroutineDispatcher defaultDispatcher) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)((Object)signalClient), (String)"signalClient");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        Intrinsics.checkNotNullParameter((Object)defaultDispatcher, (String)"defaultDispatcher");
        String string = info.getSid();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.sid");
        this(string, info.getIdentity(), signalClient, ioDispatcher, defaultDispatcher);
        super.updateFromInfo$livekit_android_sdk_release(info);
    }

    @Nullable
    public final RemoteTrackPublication getTrackPublication(@NotNull String sid) {
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        TrackPublication trackPublication = this.getTracks().get(sid);
        return trackPublication instanceof RemoteTrackPublication ? (RemoteTrackPublication)trackPublication : null;
    }

    @Override
    public void updateFromInfo$livekit_android_sdk_release(@NotNull LivekitModels.ParticipantInfo info) {
        TrackPublication publication;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super.updateFromInfo$livekit_android_sdk_release(info);
        Map validTrackPublication = new LinkedHashMap();
        Map newTrackPublications = new LinkedHashMap();
        for (LivekitModels.TrackInfo trackInfo : info.getTracksList()) {
            String trackSid = trackInfo.getSid();
            Intrinsics.checkNotNullExpressionValue((Object)trackSid, (String)"trackSid");
            publication = this.getTrackPublication(trackSid);
            if (publication == null) {
                Intrinsics.checkNotNullExpressionValue((Object)trackInfo, (String)"trackInfo");
                publication = new RemoteTrackPublication(trackInfo, null, this, this.ioDispatcher, 2, null);
                newTrackPublications.put(trackSid, publication);
                this.addTrackPublication(publication);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)trackInfo, (String)"trackInfo");
                publication.updateFromInfo(trackInfo);
            }
            validTrackPublication.put(trackSid, publication);
        }
        for (RemoteTrackPublication publication2 : newTrackPublications.values()) {
            ParticipantListener participantListener = this.getInternalListener$livekit_android_sdk_release();
            if (participantListener != null) {
                participantListener.onTrackPublished(publication2, this);
            }
            ParticipantListener participantListener2 = this.getListener();
            if (participantListener2 != null) {
                participantListener2.onTrackPublished(publication2, this);
            }
            this.getEventBus().postEvent((ParticipantEvent)new ParticipantEvent.TrackPublished(this, publication2), this.getScope());
        }
        Set invalidKeys = SetsKt.minus(this.getTracks().keySet(), (Iterable)validTrackPublication.keySet());
        for (String invalidKey : invalidKeys) {
            if (this.getTracks().get(invalidKey) == null) continue;
            this.unpublishTrack(publication.getSid(), true);
        }
    }

    public final void addSubscribedMediaTrack(@NotNull MediaStreamTrack mediaTrack, @NotNull String sid, boolean autoManageVideo, int triesLeft) {
        Track track2;
        org.webrtc.AudioTrack audioTrack;
        Intrinsics.checkNotNullParameter((Object)mediaTrack, (String)"mediaTrack");
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        RemoteTrackPublication publication = this.getTrackPublication(sid);
        if (publication == null) {
            if (triesLeft == 0) {
                String message = "Could not find published track with sid: " + sid;
                TrackException.InvalidTrackStateException exception = new TrackException.InvalidTrackStateException(message, null, 2, null);
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$e = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.ERROR;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.e(throwable, (String)("remote participant " + this.getSid() + " --- " + message), (Object[])new Object[0]);
                }
                ParticipantListener participantListener = this.getInternalListener$livekit_android_sdk_release();
                if (participantListener != null) {
                    participantListener.onTrackSubscriptionFailed(sid, exception, this);
                }
                ParticipantListener participantListener2 = this.getListener();
                if (participantListener2 != null) {
                    participantListener2.onTrackSubscriptionFailed(sid, exception, this);
                }
                this.getEventBus().postEvent((ParticipantEvent)new ParticipantEvent.TrackSubscriptionFailed(this, sid, exception), this.getScope());
            } else {
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, mediaTrack, sid, autoManageVideo, triesLeft, null){
                    int label;
                    final /* synthetic */ RemoteParticipant this$0;
                    final /* synthetic */ MediaStreamTrack $mediaTrack;
                    final /* synthetic */ String $sid;
                    final /* synthetic */ boolean $autoManageVideo;
                    final /* synthetic */ int $triesLeft;
                    {
                        this.this$0 = $receiver;
                        this.$mediaTrack = $mediaTrack;
                        this.$sid = $sid;
                        this.$autoManageVideo = $autoManageVideo;
                        this.$triesLeft = $triesLeft;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = DelayKt.delay((long)150L, (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.this$0.addSubscribedMediaTrack(this.$mediaTrack, this.$sid, this.$autoManageVideo, this.$triesLeft - 1);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
            return;
        }
        String kind = mediaTrack.kind();
        if (Intrinsics.areEqual((Object)kind, (Object)KIND_AUDIO)) {
            audioTrack = (org.webrtc.AudioTrack)mediaTrack;
            track2 = new AudioTrack("", audioTrack);
        } else if (Intrinsics.areEqual((Object)kind, (Object)KIND_VIDEO)) {
            audioTrack = (VideoTrack)mediaTrack;
            CoroutineDispatcher coroutineDispatcher = this.ioDispatcher;
            track2 = new RemoteVideoTrack("", (VideoTrack)audioTrack, autoManageVideo, coroutineDispatcher);
        } else {
            throw new TrackException.InvalidTrackTypeException("invalid track type: " + kind, null, 2, null);
        }
        Track track3 = track2;
        publication.setTrack$livekit_android_sdk_release(track3);
        publication.setSubscriptionAllowed$livekit_android_sdk_release(true);
        track3.setName$livekit_android_sdk_release(publication.getName());
        track3.setSid$livekit_android_sdk_release(publication.getSid());
        this.addTrackPublication(publication);
        track3.start();
        ParticipantListener participantListener = this.getInternalListener$livekit_android_sdk_release();
        if (participantListener != null) {
            participantListener.onTrackSubscribed(track3, publication, this);
        }
        ParticipantListener participantListener3 = this.getListener();
        if (participantListener3 != null) {
            participantListener3.onTrackSubscribed(track3, publication, this);
        }
        this.getEventBus().postEvent((ParticipantEvent)new ParticipantEvent.TrackSubscribed(this, track3, publication), this.getScope());
    }

    public static /* synthetic */ void addSubscribedMediaTrack$default(RemoteParticipant remoteParticipant, MediaStreamTrack mediaStreamTrack, String string, boolean bl, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            n = 20;
        }
        remoteParticipant.addSubscribedMediaTrack(mediaStreamTrack, string, bl, n);
    }

    /*
     * WARNING - void declaration
     */
    public final void unpublishTrack(@NotNull String trackSid, boolean sendUnpublish) {
        void $this$unpublishTrack_u24lambda_u2d1;
        Intrinsics.checkNotNullParameter((Object)trackSid, (String)"trackSid");
        Object object = this.getTracks().get(trackSid);
        RemoteTrackPublication remoteTrackPublication = object instanceof RemoteTrackPublication ? (RemoteTrackPublication)object : null;
        if (remoteTrackPublication == null) {
            return;
        }
        RemoteTrackPublication publication = remoteTrackPublication;
        Map map2 = MapsKt.toMutableMap(this.getTracks());
        object = map2;
        RemoteParticipant remoteParticipant = this;
        boolean bl = false;
        $this$unpublishTrack_u24lambda_u2d1.remove(trackSid);
        remoteParticipant.setTracks(map2);
        Track track2 = publication.getTrack();
        if (track2 != null) {
            track2.stop();
            ParticipantListener participantListener = this.getInternalListener$livekit_android_sdk_release();
            if (participantListener != null) {
                participantListener.onTrackUnsubscribed(track2, publication, this);
            }
            ParticipantListener participantListener2 = this.getListener();
            if (participantListener2 != null) {
                participantListener2.onTrackUnsubscribed(track2, publication, this);
            }
            this.getEventBus().postEvent((ParticipantEvent)new ParticipantEvent.TrackUnsubscribed(this, track2, publication), this.getScope());
        }
        if (sendUnpublish) {
            ParticipantListener participantListener = this.getInternalListener$livekit_android_sdk_release();
            if (participantListener != null) {
                participantListener.onTrackUnpublished(publication, this);
            }
            ParticipantListener participantListener3 = this.getListener();
            if (participantListener3 != null) {
                participantListener3.onTrackUnpublished(publication, this);
            }
            this.getEventBus().postEvent((ParticipantEvent)new ParticipantEvent.TrackUnpublished(this, publication), this.getScope());
        }
        Track track3 = track2;
        if (track3 != null) {
            track3.dispose();
        }
        publication.setTrack$livekit_android_sdk_release(null);
    }

    public static /* synthetic */ void unpublishTrack$default(RemoteParticipant remoteParticipant, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        remoteParticipant.unpublishTrack(string, bl);
    }

    public final void onSubscriptionPermissionUpdate$livekit_android_sdk_release(@NotNull LivekitRtc.SubscriptionPermissionUpdate subscriptionPermissionUpdate) {
        Intrinsics.checkNotNullParameter((Object)subscriptionPermissionUpdate, (String)"subscriptionPermissionUpdate");
        TrackPublication trackPublication = this.getTracks().get(subscriptionPermissionUpdate.getTrackSid());
        RemoteTrackPublication remoteTrackPublication = trackPublication instanceof RemoteTrackPublication ? (RemoteTrackPublication)trackPublication : null;
        if (remoteTrackPublication == null) {
            return;
        }
        RemoteTrackPublication pub = remoteTrackPublication;
        if (pub.getSubscriptionAllowed() != subscriptionPermissionUpdate.getAllowed()) {
            pub.setSubscriptionAllowed$livekit_android_sdk_release(subscriptionPermissionUpdate.getAllowed());
            this.getEventBus().postEvent((ParticipantEvent)new ParticipantEvent.TrackSubscriptionPermissionChanged(this, pub, pub.getSubscriptionAllowed()), this.coroutineScope);
        }
    }

    public final void onDataReceived$livekit_android_sdk_release(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ParticipantListener participantListener = this.getListener();
        if (participantListener != null) {
            participantListener.onDataReceived(data, this);
        }
        this.getEventBus().postEvent((ParticipantEvent)new ParticipantEvent.DataReceived(this, data), this.getScope());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/livekit/android/room/participant/RemoteParticipant$Companion;", "", "()V", "KIND_AUDIO", "", "KIND_VIDEO", "livekit-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

