/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.room.track;

import android.content.Context;
import android.hardware.camera2.CameraManager;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import io.livekit.android.memory.CloseableManager;
import io.livekit.android.memory.SurfaceTextureHelperCloser;
import io.livekit.android.room.DefaultsManager;
import io.livekit.android.room.track.CameraPosition;
import io.livekit.android.room.track.LocalVideoTrack;
import io.livekit.android.room.track.LocalVideoTrackOptions;
import io.livekit.android.room.track.Track;
import io.livekit.android.room.track.VideoTrack;
import io.livekit.android.room.track.video.Camera1CapturerWithSize;
import io.livekit.android.room.track.video.Camera2CapturerWithSize;
import io.livekit.android.room.track.video.VideoCapturerWithSize;
import io.livekit.android.util.LKLog;
import io.livekit.android.util.LoggingLevel;
import java.io.Closeable;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera1Capturer;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera1Helper;
import org.webrtc.Camera2Capturer;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoProcessor;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;
import timber.log.Timber;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 ;2\u00020\u0001:\u0002;<Ba\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002012\b\b\u0002\u0010\b\u001a\u00020\tJ\u000e\u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u0007J\b\u00105\u001a\u000201H\u0016J\b\u00106\u001a\u000201H\u0016J\b\u00107\u001a\u000201H\u0016J\u001e\u00108\u001a\u0002012\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u00109\u001a\u0004\u0018\u00010:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0016\u0010&\u001a\u0004\u0018\u00010'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006="}, d2={"Lio/livekit/android/room/track/LocalVideoTrack;", "Lio/livekit/android/room/track/VideoTrack;", "capturer", "Lorg/webrtc/VideoCapturer;", "source", "Lorg/webrtc/VideoSource;", "name", "", "options", "Lio/livekit/android/room/track/LocalVideoTrackOptions;", "rtcTrack", "Lorg/webrtc/VideoTrack;", "peerConnectionFactory", "Lorg/webrtc/PeerConnectionFactory;", "context", "Landroid/content/Context;", "eglBase", "Lorg/webrtc/EglBase;", "defaultsManager", "Lio/livekit/android/room/DefaultsManager;", "trackFactory", "Lio/livekit/android/room/track/LocalVideoTrack$Factory;", "(Lorg/webrtc/VideoCapturer;Lorg/webrtc/VideoSource;Ljava/lang/String;Lio/livekit/android/room/track/LocalVideoTrackOptions;Lorg/webrtc/VideoTrack;Lorg/webrtc/PeerConnectionFactory;Landroid/content/Context;Lorg/webrtc/EglBase;Lio/livekit/android/room/DefaultsManager;Lio/livekit/android/room/track/LocalVideoTrack$Factory;)V", "closeableManager", "Lio/livekit/android/memory/CloseableManager;", "dimensions", "Lio/livekit/android/room/track/Track$Dimensions;", "getDimensions", "()Lio/livekit/android/room/track/Track$Dimensions;", "getOptions", "()Lio/livekit/android/room/track/LocalVideoTrackOptions;", "setOptions", "(Lio/livekit/android/room/track/LocalVideoTrackOptions;)V", "<set-?>", "getRtcTrack", "()Lorg/webrtc/VideoTrack;", "setRtcTrack$livekit_android_sdk_release", "(Lorg/webrtc/VideoTrack;)V", "sender", "Lorg/webrtc/RtpSender;", "getSender", "()Lorg/webrtc/RtpSender;", "transceiver", "Lorg/webrtc/RtpTransceiver;", "getTransceiver$livekit_android_sdk_release", "()Lorg/webrtc/RtpTransceiver;", "setTransceiver$livekit_android_sdk_release", "(Lorg/webrtc/RtpTransceiver;)V", "dispose", "", "restartTrack", "setDeviceId", "deviceId", "startCapture", "stop", "stopCapture", "switchCamera", "position", "Lio/livekit/android/room/track/CameraPosition;", "Companion", "Factory", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public class LocalVideoTrack
extends VideoTrack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private VideoCapturer capturer;
    @NotNull
    private VideoSource source;
    @NotNull
    private LocalVideoTrackOptions options;
    @NotNull
    private final PeerConnectionFactory peerConnectionFactory;
    @NotNull
    private final Context context;
    @NotNull
    private final EglBase eglBase;
    @NotNull
    private final DefaultsManager defaultsManager;
    @NotNull
    private final Factory trackFactory;
    @NotNull
    private org.webrtc.VideoTrack rtcTrack;
    @Nullable
    private RtpTransceiver transceiver;
    @NotNull
    private final CloseableManager closeableManager;
    public static final int $stable = 8;

    @AssistedInject
    public LocalVideoTrack(@Assisted @NotNull VideoCapturer capturer, @Assisted @NotNull VideoSource source, @Assisted @NotNull String name, @Assisted @NotNull LocalVideoTrackOptions options, @Assisted @NotNull org.webrtc.VideoTrack rtcTrack, @NotNull PeerConnectionFactory peerConnectionFactory, @NotNull Context context, @NotNull EglBase eglBase, @NotNull DefaultsManager defaultsManager, @NotNull Factory trackFactory) {
        Intrinsics.checkNotNullParameter((Object)capturer, (String)"capturer");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)rtcTrack, (String)"rtcTrack");
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eglBase, (String)"eglBase");
        Intrinsics.checkNotNullParameter((Object)defaultsManager, (String)"defaultsManager");
        Intrinsics.checkNotNullParameter((Object)trackFactory, (String)"trackFactory");
        super(name, rtcTrack);
        this.capturer = capturer;
        this.source = source;
        this.options = options;
        this.peerConnectionFactory = peerConnectionFactory;
        this.context = context;
        this.eglBase = eglBase;
        this.defaultsManager = defaultsManager;
        this.trackFactory = trackFactory;
        this.rtcTrack = rtcTrack;
        this.closeableManager = new CloseableManager();
    }

    @NotNull
    public final LocalVideoTrackOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull LocalVideoTrackOptions localVideoTrackOptions) {
        Intrinsics.checkNotNullParameter((Object)localVideoTrackOptions, (String)"<set-?>");
        this.options = localVideoTrackOptions;
    }

    @Override
    @NotNull
    public org.webrtc.VideoTrack getRtcTrack() {
        return this.rtcTrack;
    }

    public void setRtcTrack$livekit_android_sdk_release(@NotNull org.webrtc.VideoTrack videoTrack) {
        Intrinsics.checkNotNullParameter((Object)videoTrack, (String)"<set-?>");
        this.rtcTrack = videoTrack;
    }

    @NotNull
    public final Track.Dimensions getDimensions() {
        VideoCapturerWithSize videoCapturerWithSize;
        VideoCapturer videoCapturer = this.capturer;
        VideoCapturerWithSize videoCapturerWithSize2 = videoCapturerWithSize = videoCapturer instanceof VideoCapturerWithSize ? (VideoCapturerWithSize)videoCapturer : null;
        if (videoCapturerWithSize != null) {
            VideoCapturerWithSize capturerWithSize = videoCapturerWithSize;
            boolean bl = false;
            Size size = capturerWithSize.findCaptureFormat(this.options.getCaptureParams().getWidth(), this.options.getCaptureParams().getHeight());
            return new Track.Dimensions(size.width, size.height);
        }
        return new Track.Dimensions(this.options.getCaptureParams().getWidth(), this.options.getCaptureParams().getHeight());
    }

    @Nullable
    public final RtpTransceiver getTransceiver$livekit_android_sdk_release() {
        return this.transceiver;
    }

    public final void setTransceiver$livekit_android_sdk_release(@Nullable RtpTransceiver rtpTransceiver) {
        this.transceiver = rtpTransceiver;
    }

    private final RtpSender getSender() {
        RtpTransceiver rtpTransceiver = this.transceiver;
        return rtpTransceiver != null ? rtpTransceiver.getSender() : null;
    }

    public void startCapture() {
        this.capturer.startCapture(this.options.getCaptureParams().getWidth(), this.options.getCaptureParams().getHeight(), this.options.getCaptureParams().getMaxFps());
    }

    public void stopCapture() {
        this.capturer.stopCapture();
    }

    @Override
    public void stop() {
        this.capturer.stopCapture();
        super.stop();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.capturer.dispose();
        this.closeableManager.close();
    }

    public final void setDeviceId(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        this.restartTrack(LocalVideoTrackOptions.copy$default(this.options, false, deviceId, null, null, 13, null));
    }

    public final void switchCamera(@Nullable String deviceId, @Nullable CameraPosition position) {
        VideoCapturer videoCapturer = this.capturer;
        CameraVideoCapturer cameraVideoCapturer = videoCapturer instanceof CameraVideoCapturer ? (CameraVideoCapturer)videoCapturer : null;
        if (cameraVideoCapturer == null) {
            LocalVideoTrack $this$switchCamera_u24lambda_u2d2 = this;
            boolean bl = false;
            LKLog.Companion $this$iv = LKLog.Companion;
            Throwable t$iv = null;
            boolean $i$f$w2 = false;
            LKLog.Companion companion = $this$iv;
            LoggingLevel loggingLevel$iv$iv = LoggingLevel.WARN;
            boolean $i$f$log$livekit_android_sdk_release = false;
            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                boolean bl2 = false;
                Throwable throwable = t$iv;
                boolean bl3 = false;
                Timber.w(throwable, (String)"Attempting to switch camera on a non-camera video track!", (Object[])new Object[0]);
            }
            return;
        }
        CameraVideoCapturer cameraCapturer = cameraVideoCapturer;
        Ref.ObjectRef targetDeviceId = new Ref.ObjectRef();
        CameraEnumerator enumerator = LocalVideoTrack.Companion.createCameraEnumerator(this.context);
        if (deviceId != null || position != null) {
            targetDeviceId.element = LocalVideoTrack.Companion.findCamera(enumerator, deviceId, position, false);
        }
        if (targetDeviceId.element == null) {
            Object[] deviceNames = enumerator.getDeviceNames();
            if (deviceNames.length < 2) {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$w = false;
                LKLog.Companion $i$f$w2 = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.WARN;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl4 = false;
                    Timber.w(throwable, (String)"No available cameras to switch to!", (Object[])new Object[0]);
                }
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)deviceNames, (String)"deviceNames");
            int currentIndex = ArraysKt.indexOf((Object[])deviceNames, (Object)this.options.getDeviceId());
            targetDeviceId.element = deviceNames[(currentIndex + 1) % deviceNames.length];
        }
        CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler2 = new CameraVideoCapturer.CameraSwitchHandler(this, (Ref.ObjectRef<String>)targetDeviceId, enumerator){
            final /* synthetic */ LocalVideoTrack this$0;
            final /* synthetic */ Ref.ObjectRef<String> $targetDeviceId;
            final /* synthetic */ CameraEnumerator $enumerator;
            {
                this.this$0 = $receiver;
                this.$targetDeviceId = $targetDeviceId;
                this.$enumerator = $enumerator;
            }

            public void onCameraSwitchDone(boolean isFrontFacing) {
                LocalVideoTrackOptions newOptions = LocalVideoTrackOptions.copy$default(this.this$0.getOptions(), false, (String)this.$targetDeviceId.element, io.livekit.android.room.track.LocalVideoTrack$Companion.access$getCameraPosition(LocalVideoTrack.Companion, this.$enumerator, (String)this.$targetDeviceId.element), null, 9, null);
                this.this$0.setOptions(newOptions);
            }

            public void onCameraSwitchError(@Nullable String errorDescription) {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$w = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.WARN;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.w(throwable, (String)("switching camera failed: " + errorDescription), (Object[])new Object[0]);
                }
            }
        };
        if (targetDeviceId.element == null) {
            LKLog.Companion $this$iv = LKLog.Companion;
            Throwable t$iv = null;
            boolean $i$f$w = false;
            LKLog.Companion this_$iv$iv = $this$iv;
            LoggingLevel loggingLevel$iv$iv = LoggingLevel.WARN;
            boolean $i$f$log$livekit_android_sdk_release = false;
            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                boolean bl = false;
                Throwable throwable = t$iv;
                boolean bl5 = false;
                Timber.w(throwable, (String)"No target camera found!", (Object[])new Object[0]);
            }
            return;
        }
        cameraCapturer.switchCamera(cameraSwitchHandler2, (String)targetDeviceId.element);
    }

    public static /* synthetic */ void switchCamera$default(LocalVideoTrack localVideoTrack, String string, CameraPosition cameraPosition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: switchCamera");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            cameraPosition = null;
        }
        localVideoTrack.switchCamera(string, cameraPosition);
    }

    public final void restartTrack(@NotNull LocalVideoTrackOptions options) {
        block2: {
            Closeable oldCloseable;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            VideoCapturer oldCapturer = this.capturer;
            VideoSource oldSource = this.source;
            org.webrtc.VideoTrack oldRtcTrack = this.getRtcTrack();
            oldCapturer.stopCapture();
            oldCapturer.dispose();
            oldSource.dispose();
            oldRtcTrack.setEnabled(false);
            Closeable closeable = oldCloseable = this.closeableManager.unregisterResource(oldRtcTrack);
            if (closeable != null) {
                closeable.close();
            }
            LocalVideoTrack newTrack = io.livekit.android.room.track.LocalVideoTrack$Companion.createTrack$livekit_android_sdk_release$default(Companion, this.peerConnectionFactory, this.context, this.getName(), options, this.eglBase, this.trackFactory, null, 64, null);
            for (VideoSink sink : this.getSinks()) {
                oldRtcTrack.removeSink(sink);
                newTrack.addRenderer(sink);
            }
            this.capturer = newTrack.capturer;
            this.source = newTrack.source;
            this.setRtcTrack$livekit_android_sdk_release(newTrack.getRtcTrack());
            this.options = options;
            this.startCapture();
            RtpSender rtpSender = this.getSender();
            if (rtpSender == null) break block2;
            rtpSender.setTrack((MediaStreamTrack)newTrack.getRtcTrack(), true);
        }
    }

    public static /* synthetic */ void restartTrack$default(LocalVideoTrack localVideoTrack, LocalVideoTrackOptions localVideoTrackOptions, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: restartTrack");
        }
        if ((n & 1) != 0) {
            localVideoTrackOptions = LocalVideoTrackOptions.copy$default(localVideoTrack.defaultsManager.getVideoTrackCaptureDefaults(), false, null, null, null, 15, null);
        }
        localVideoTrack.restartTrack(localVideoTrackOptions);
    }

    @AssistedFactory
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lio/livekit/android/room/track/LocalVideoTrack$Factory;", "", "create", "Lio/livekit/android/room/track/LocalVideoTrack;", "capturer", "Lorg/webrtc/VideoCapturer;", "source", "Lorg/webrtc/VideoSource;", "name", "", "options", "Lio/livekit/android/room/track/LocalVideoTrackOptions;", "rtcTrack", "Lorg/webrtc/VideoTrack;", "livekit-android-sdk_release"})
    public static interface Factory {
        @NotNull
        public LocalVideoTrack create(@NotNull VideoCapturer var1, @NotNull VideoSource var2, @NotNull String var3, @NotNull LocalVideoTrackOptions var4, @NotNull org.webrtc.VideoTrack var5);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002JI\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b\u0019JS\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b\u0019J&\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J1\u0010\u001c\u001a\u0004\u0018\u00010\u0012*\u00020\n2!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u001f\u0012\b\b\u0011\u0012\u0004\b\b( \u0012\u0004\u0012\u00020!0\u001eH\u0002J,\u0010\u001c\u001a\u0004\u0018\u00010\u0012*\u00020\n2\b\u0010\"\u001a\u0004\u0018\u00010\u00122\b\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020!H\u0002J\u0018\u0010&\u001a\u0004\u0018\u00010$*\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006'"}, d2={"Lio/livekit/android/room/track/LocalVideoTrack$Companion;", "", "()V", "createCameraCapturer", "Lkotlin/Pair;", "Lorg/webrtc/VideoCapturer;", "Lio/livekit/android/room/track/LocalVideoTrackOptions;", "context", "Landroid/content/Context;", "enumerator", "Lorg/webrtc/CameraEnumerator;", "options", "createCameraEnumerator", "createTrack", "Lio/livekit/android/room/track/LocalVideoTrack;", "peerConnectionFactory", "Lorg/webrtc/PeerConnectionFactory;", "name", "", "rootEglBase", "Lorg/webrtc/EglBase;", "trackFactory", "Lio/livekit/android/room/track/LocalVideoTrack$Factory;", "videoProcessor", "Lorg/webrtc/VideoProcessor;", "createTrack$livekit_android_sdk_release", "capturer", "createVideoCapturer", "findCamera", "predicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "deviceName", "", "deviceId", "position", "Lio/livekit/android/room/track/CameraPosition;", "fallback", "getCameraPosition", "livekit-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalVideoTrack createTrack$livekit_android_sdk_release(@NotNull PeerConnectionFactory peerConnectionFactory, @NotNull Context context, @NotNull String name, @NotNull VideoCapturer capturer, @NotNull LocalVideoTrackOptions options, @NotNull EglBase rootEglBase, @NotNull Factory trackFactory, @Nullable VideoProcessor videoProcessor) {
            Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)capturer, (String)"capturer");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)rootEglBase, (String)"rootEglBase");
            Intrinsics.checkNotNullParameter((Object)trackFactory, (String)"trackFactory");
            VideoSource source = peerConnectionFactory.createVideoSource(false);
            source.setVideoProcessor(videoProcessor);
            SurfaceTextureHelper surfaceTextureHelper = SurfaceTextureHelper.create((String)"VideoCaptureThread", (EglBase.Context)rootEglBase.getEglBaseContext());
            capturer.initialize(surfaceTextureHelper, context, source.getCapturerObserver());
            org.webrtc.VideoTrack rtcTrack = peerConnectionFactory.createVideoTrack(UUID.randomUUID().toString(), source);
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
            Intrinsics.checkNotNullExpressionValue((Object)rtcTrack, (String)"rtcTrack");
            LocalVideoTrack track2 = trackFactory.create(capturer, source, name, options, rtcTrack);
            CloseableManager closeableManager = track2.closeableManager;
            Intrinsics.checkNotNullExpressionValue((Object)surfaceTextureHelper, (String)"surfaceTextureHelper");
            closeableManager.registerResource(rtcTrack, new SurfaceTextureHelperCloser(surfaceTextureHelper));
            return track2;
        }

        public static /* synthetic */ LocalVideoTrack createTrack$livekit_android_sdk_release$default(Companion companion, PeerConnectionFactory peerConnectionFactory, Context context, String string, VideoCapturer videoCapturer, LocalVideoTrackOptions localVideoTrackOptions, EglBase eglBase, Factory factory, VideoProcessor videoProcessor, int n, Object object) {
            if ((n & 0x10) != 0) {
                localVideoTrackOptions = new LocalVideoTrackOptions(false, null, null, null, 15, null);
            }
            if ((n & 0x80) != 0) {
                videoProcessor = null;
            }
            return companion.createTrack$livekit_android_sdk_release(peerConnectionFactory, context, string, videoCapturer, localVideoTrackOptions, eglBase, factory, videoProcessor);
        }

        @NotNull
        public final LocalVideoTrack createTrack$livekit_android_sdk_release(@NotNull PeerConnectionFactory peerConnectionFactory, @NotNull Context context, @NotNull String name, @NotNull LocalVideoTrackOptions options, @NotNull EglBase rootEglBase, @NotNull Factory trackFactory, @Nullable VideoProcessor videoProcessor) {
            Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)rootEglBase, (String)"rootEglBase");
            Intrinsics.checkNotNullParameter((Object)trackFactory, (String)"trackFactory");
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") != 0) {
                throw new SecurityException("Camera permissions are required to create a camera video track.");
            }
            VideoSource source = peerConnectionFactory.createVideoSource(options.isScreencast());
            source.setVideoProcessor(videoProcessor);
            Pair<VideoCapturer, LocalVideoTrackOptions> pair = this.createVideoCapturer(context, options);
            if (pair == null) {
                throw new NotImplementedError(null, 1, null);
            }
            Pair<VideoCapturer, LocalVideoTrackOptions> pair2 = pair;
            VideoCapturer capturer = (VideoCapturer)pair2.component1();
            LocalVideoTrackOptions newOptions = (LocalVideoTrackOptions)pair2.component2();
            SurfaceTextureHelper surfaceTextureHelper = SurfaceTextureHelper.create((String)"VideoCaptureThread", (EglBase.Context)rootEglBase.getEglBaseContext());
            capturer.initialize(surfaceTextureHelper, context, source.getCapturerObserver());
            org.webrtc.VideoTrack rtcTrack = peerConnectionFactory.createVideoTrack(UUID.randomUUID().toString(), source);
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
            Intrinsics.checkNotNullExpressionValue((Object)rtcTrack, (String)"rtcTrack");
            LocalVideoTrack track2 = trackFactory.create(capturer, source, name, newOptions, rtcTrack);
            CloseableManager closeableManager = track2.closeableManager;
            Intrinsics.checkNotNullExpressionValue((Object)surfaceTextureHelper, (String)"surfaceTextureHelper");
            closeableManager.registerResource(rtcTrack, new SurfaceTextureHelperCloser(surfaceTextureHelper));
            return track2;
        }

        public static /* synthetic */ LocalVideoTrack createTrack$livekit_android_sdk_release$default(Companion companion, PeerConnectionFactory peerConnectionFactory, Context context, String string, LocalVideoTrackOptions localVideoTrackOptions, EglBase eglBase, Factory factory, VideoProcessor videoProcessor, int n, Object object) {
            if ((n & 0x40) != 0) {
                videoProcessor = null;
            }
            return companion.createTrack$livekit_android_sdk_release(peerConnectionFactory, context, string, localVideoTrackOptions, eglBase, factory, videoProcessor);
        }

        private final CameraEnumerator createCameraEnumerator(Context context) {
            return Camera2Enumerator.isSupported((Context)context) ? (CameraEnumerator)new Camera2Enumerator(context) : (CameraEnumerator)new Camera1Enumerator(true);
        }

        private final Pair<VideoCapturer, LocalVideoTrackOptions> createVideoCapturer(Context context, LocalVideoTrackOptions options) {
            CameraEnumerator cameraEnumerator = this.createCameraEnumerator(context);
            Pair<VideoCapturer, LocalVideoTrackOptions> pair = this.createCameraCapturer(context, cameraEnumerator, options);
            if (pair == null) {
                LKLog.Companion $this$iv = LKLog.Companion;
                Throwable t$iv = null;
                boolean $i$f$d = false;
                LKLog.Companion companion = $this$iv;
                LoggingLevel loggingLevel$iv$iv = LoggingLevel.DEBUG;
                boolean $i$f$log$livekit_android_sdk_release = false;
                if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Throwable throwable = t$iv;
                    boolean bl2 = false;
                    Timber.d(throwable, (String)"Failed to open camera", (Object[])new Object[0]);
                }
                return null;
            }
            return pair;
        }

        private final Pair<VideoCapturer, LocalVideoTrackOptions> createCameraCapturer(Context context, CameraEnumerator enumerator, LocalVideoTrackOptions options) {
            String string = io.livekit.android.room.track.LocalVideoTrack$Companion.findCamera$default(this, enumerator, options.getDeviceId(), options.getPosition(), false, 4, null);
            if (string == null) {
                return null;
            }
            String targetDeviceName = string;
            CameraVideoCapturer targetVideoCapturer = enumerator.createCapturer(targetDeviceName, null);
            LocalVideoTrackOptions newOptions = LocalVideoTrackOptions.copy$default(options, false, targetDeviceName, this.getCameraPosition(enumerator, targetDeviceName), null, 9, null);
            if (targetVideoCapturer instanceof Camera1Capturer) {
                Camera1Helper.Companion.getSupportedFormats(Camera1Helper.Companion.getCameraId(newOptions.getDeviceId()));
                return new Pair((Object)new Camera1CapturerWithSize((Camera1Capturer)targetVideoCapturer, targetDeviceName), (Object)newOptions);
            }
            if (targetVideoCapturer instanceof Camera2Capturer) {
                Camera2Capturer camera2Capturer = (Camera2Capturer)targetVideoCapturer;
                Object object = context.getSystemService("camera");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
                return new Pair((Object)new Camera2CapturerWithSize(camera2Capturer, (CameraManager)object, targetDeviceName), (Object)newOptions);
            }
            LKLog.Companion $this$iv = LKLog.Companion;
            Throwable t$iv = null;
            boolean $i$f$w = false;
            LKLog.Companion companion = $this$iv;
            LoggingLevel loggingLevel$iv$iv = LoggingLevel.WARN;
            boolean $i$f$log$livekit_android_sdk_release = false;
            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                boolean bl = false;
                Throwable throwable = t$iv;
                boolean bl2 = false;
                Timber.w(throwable, (String)("unknown CameraCapturer class: " + targetVideoCapturer.getClass().getCanonicalName() + ". Reported dimensions may be inaccurate."), (Object[])new Object[0]);
            }
            if (targetVideoCapturer != null) {
                return new Pair((Object)targetVideoCapturer, (Object)newOptions);
            }
            return null;
        }

        private final String findCamera(CameraEnumerator $this$findCamera, String deviceId, CameraPosition position, boolean fallback) {
            String targetDeviceName = null;
            if (deviceId != null) {
                targetDeviceName = this.findCamera($this$findCamera, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(deviceId){
                    final /* synthetic */ String $deviceId;
                    {
                        this.$deviceId = $deviceId;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String deviceName) {
                        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
                        return Intrinsics.areEqual((Object)deviceName, (Object)this.$deviceId);
                    }
                }));
            }
            if (targetDeviceName == null && position != null) {
                targetDeviceName = this.findCamera($this$findCamera, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>($this$findCamera, position){
                    final /* synthetic */ CameraEnumerator $this_findCamera;
                    final /* synthetic */ CameraPosition $position;
                    {
                        this.$this_findCamera = $receiver;
                        this.$position = $position;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String deviceName) {
                        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
                        return io.livekit.android.room.track.LocalVideoTrack$Companion.access$getCameraPosition(LocalVideoTrack.Companion, this.$this_findCamera, deviceName) == this.$position;
                    }
                }));
            }
            if (targetDeviceName == null && fallback) {
                targetDeviceName = this.findCamera($this$findCamera, (Function1<? super String, Boolean>)((Function1)findCamera.3.INSTANCE));
            }
            if (targetDeviceName == null) {
                return null;
            }
            return targetDeviceName;
        }

        static /* synthetic */ String findCamera$default(Companion companion, CameraEnumerator cameraEnumerator, String string, CameraPosition cameraPosition, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.findCamera(cameraEnumerator, string, cameraPosition, bl);
        }

        private final String findCamera(CameraEnumerator $this$findCamera, Function1<? super String, Boolean> predicate) {
            String[] stringArray = $this$findCamera.getDeviceNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"deviceNames");
            for (String deviceName : stringArray) {
                CameraVideoCapturer videoCapturer;
                Intrinsics.checkNotNullExpressionValue((Object)deviceName, (String)"deviceName");
                if (!((Boolean)predicate.invoke((Object)deviceName)).booleanValue() || (videoCapturer = $this$findCamera.createCapturer(deviceName, null)) == null) continue;
                return deviceName;
            }
            return null;
        }

        private final CameraPosition getCameraPosition(CameraEnumerator $this$getCameraPosition, String deviceName) {
            if (deviceName == null) {
                return null;
            }
            if ($this$getCameraPosition.isBackFacing(deviceName)) {
                return CameraPosition.BACK;
            }
            if ($this$getCameraPosition.isFrontFacing(deviceName)) {
                return CameraPosition.FRONT;
            }
            return null;
        }

        public static final /* synthetic */ CameraPosition access$getCameraPosition(Companion $this, CameraEnumerator $receiver, String deviceName) {
            return $this.getCameraPosition($receiver, deviceName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

