/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.room.track;

import android.view.View;
import androidx.compose.runtime.internal.StabilityInferred;
import io.livekit.android.events.TrackEvent;
import io.livekit.android.room.track.Track;
import io.livekit.android.room.track.VideoTrack;
import io.livekit.android.room.track.video.VideoSinkVisibility;
import io.livekit.android.room.track.video.ViewVisibility;
import io.livekit.android.util.LKLog;
import io.livekit.android.util.LoggingLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.VideoSink;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0019J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u0007H\u0002J\b\u0010\"\u001a\u00020\u0010H\u0002J\b\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/livekit/android/room/track/RemoteVideoTrack;", "Lio/livekit/android/room/track/VideoTrack;", "name", "", "rtcTrack", "Lorg/webrtc/VideoTrack;", "autoManageVideo", "", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Ljava/lang/String;Lorg/webrtc/VideoTrack;ZLkotlinx/coroutines/CoroutineDispatcher;)V", "getAutoManageVideo", "()Z", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<set-?>", "Lio/livekit/android/room/track/Track$Dimensions;", "lastDimensions", "getLastDimensions$livekit_android_sdk_release", "()Lio/livekit/android/room/track/Track$Dimensions;", "lastVisibility", "getLastVisibility$livekit_android_sdk_release", "sinkVisibilityMap", "", "Lorg/webrtc/VideoSink;", "Lio/livekit/android/room/track/video/VideoSinkVisibility;", "visibilities", "", "addRenderer", "", "renderer", "visibility", "dispose", "hasVisibleSinks", "largestVideoViewSize", "recalculateVisibility", "removeRenderer", "stop", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public final class RemoteVideoTrack
extends VideoTrack {
    private final boolean autoManageVideo;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private CoroutineScope coroutineScope;
    @NotNull
    private final Map<VideoSink, VideoSinkVisibility> sinkVisibilityMap;
    @NotNull
    private final Collection<VideoSinkVisibility> visibilities;
    private boolean lastVisibility;
    @NotNull
    private Track.Dimensions lastDimensions;
    public static final int $stable = 8;

    public RemoteVideoTrack(@NotNull String name, @NotNull org.webrtc.VideoTrack rtcTrack, boolean autoManageVideo, @Named(value="dispatcher_default") @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rtcTrack, (String)"rtcTrack");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        super(name, rtcTrack);
        this.autoManageVideo = autoManageVideo;
        this.dispatcher = dispatcher;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.dispatcher.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.sinkVisibilityMap = new LinkedHashMap();
        this.visibilities = this.sinkVisibilityMap.values();
        this.lastDimensions = new Track.Dimensions(0, 0);
    }

    public /* synthetic */ RemoteVideoTrack(String string, org.webrtc.VideoTrack videoTrack, boolean bl, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, videoTrack, bl, coroutineDispatcher);
    }

    public final boolean getAutoManageVideo() {
        return this.autoManageVideo;
    }

    public final boolean getLastVisibility$livekit_android_sdk_release() {
        return this.lastVisibility;
    }

    @NotNull
    public final Track.Dimensions getLastDimensions$livekit_android_sdk_release() {
        return this.lastDimensions;
    }

    @Override
    public void addRenderer(@NotNull VideoSink renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        if (this.autoManageVideo && renderer instanceof View) {
            this.addRenderer(renderer, new ViewVisibility((View)renderer));
        } else {
            super.addRenderer(renderer);
        }
    }

    public final void addRenderer(@NotNull VideoSink renderer, @NotNull VideoSinkVisibility visibility) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        super.addRenderer(renderer);
        if (this.autoManageVideo) {
            this.sinkVisibilityMap.put(renderer, visibility);
            visibility.addObserver((arg_0, arg_1) -> RemoteVideoTrack.addRenderer$lambda-0(this, arg_0, arg_1));
            this.recalculateVisibility();
        } else {
            LKLog.Companion $this$iv = LKLog.Companion;
            Throwable t$iv = null;
            boolean $i$f$w = false;
            LKLog.Companion companion = $this$iv;
            LoggingLevel loggingLevel$iv$iv = LoggingLevel.WARN;
            boolean $i$f$log$livekit_android_sdk_release = false;
            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                boolean bl = false;
                Throwable throwable = t$iv;
                boolean bl2 = false;
                Timber.w(throwable, (String)"attempted to tracking video sink visibility on an non auto managed video track.", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void removeRenderer(@NotNull VideoSink renderer) {
        VideoSinkVisibility visibility;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        super.removeRenderer(renderer);
        VideoSinkVisibility videoSinkVisibility = visibility = this.sinkVisibilityMap.remove(renderer);
        if (videoSinkVisibility != null) {
            videoSinkVisibility.close();
        }
        if (this.autoManageVideo && visibility != null) {
            this.recalculateVisibility();
        }
    }

    @Override
    public void stop() {
        super.stop();
        Iterable $this$forEach$iv = this.sinkVisibilityMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VideoSinkVisibility it = (VideoSinkVisibility)element$iv;
            boolean bl = false;
            it.close();
        }
        this.sinkVisibilityMap.clear();
    }

    private final boolean hasVisibleSinks() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.visibilities;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VideoSinkVisibility it = (VideoSinkVisibility)element$iv;
                    boolean bl2 = false;
                    if (!it.isVisible()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Track.Dimensions largestVideoViewSize() {
        int maxWidth = 0;
        int maxHeight = 0;
        Iterable $this$forEach$iv = this.visibilities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VideoSinkVisibility visibility = (VideoSinkVisibility)element$iv;
            boolean bl = false;
            Track.Dimensions size = visibility.size();
            maxWidth = Math.max(maxWidth, size.getWidth());
            maxHeight = Math.max(maxHeight, size.getHeight());
        }
        return new Track.Dimensions(maxWidth, maxHeight);
    }

    private final void recalculateVisibility() {
        boolean isVisible = this.hasVisibleSinks();
        Track.Dimensions newDimensions = this.largestVideoViewSize();
        List eventsToPost = new ArrayList();
        if (isVisible != this.lastVisibility) {
            this.lastVisibility = isVisible;
            eventsToPost.add(new TrackEvent.VisibilityChanged((Track)this, isVisible));
        }
        if (!Intrinsics.areEqual((Object)newDimensions, (Object)this.lastDimensions)) {
            this.lastDimensions = newDimensions;
            eventsToPost.add(new TrackEvent.VideoDimensionsChanged((Track)this, newDimensions));
        }
        if (CollectionsKt.any((Iterable)eventsToPost)) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (List<TrackEvent>)eventsToPost, null){
                int label;
                final /* synthetic */ RemoteVideoTrack this$0;
                final /* synthetic */ List<TrackEvent> $eventsToPost;
                {
                    this.this$0 = $receiver;
                    this.$eventsToPost = $eventsToPost;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.getEventBus().postEvents((Collection<TrackEvent>)this.$eventsToPost, (Continuation<Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    private static final void addRenderer$lambda-0(RemoteVideoTrack this$0, Observable observable, Object object) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.recalculateVisibility();
    }
}

